/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.optimize;

import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.math4.legacy.analysis.ParametricUnivariateFunction;
import org.apache.commons.math4.legacy.analysis.UnivariateFunction;
import org.apache.commons.math4.legacy.analysis.differentiation.DerivativeStructure;
import org.apache.commons.math4.legacy.analysis.differentiation.FiniteDifferencesDifferentiator;
import org.apache.commons.math4.legacy.analysis.differentiation.UnivariateDifferentiableFunction;
import org.apache.commons.math4.legacy.core.Pair;
import org.apache.commons.math4.legacy.fitting.SimpleCurveFitter;
import org.apache.commons.math4.legacy.fitting.WeightedObservedPoints;
import org.apache.commons.math4.legacy.fitting.leastsquares.MultivariateJacobianFunction;
import org.apache.commons.math4.legacy.linear.Array2DRowRealMatrix;
import org.apache.commons.math4.legacy.linear.ArrayRealVector;
import org.apache.commons.math4.legacy.linear.RealMatrix;
import org.apache.commons.math4.legacy.linear.RealVector;
import org.meteoinfo.math.optimize.MyParametricUnivariateFunction;
import org.meteoinfo.math.optimize.ParamUnivariateFunction;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;

public class OptimizeUtil {
    public static RealMatrix calJacobianMatrix(UnivariateFunction func, double[] x, int nbPoints, double stepSize) throws NoSuchMethodException {
        Class<?> cls = func.getClass();
        Method method = cls.getMethod("value", new Class[0]);
        int order = method.getParameterCount() - 1;
        FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, stepSize);
        UnivariateDifferentiableFunction diffFunc = differentiator.differentiate(func);
        Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(x.length, order);
        for (int i = 0; i < x.length; ++i) {
            DerivativeStructure xDS = new DerivativeStructure(1, order, 0, x[i]);
            DerivativeStructure yDS = diffFunc.value(xDS);
            for (int j = 0; j < order; ++j) {
                jacobian.setEntry(i, j, yDS.getPartialDerivative(new int[]{j}));
            }
        }
        return jacobian;
    }

    public static MultivariateJacobianFunction getJacobianFunction(final ParamUnivariateFunction func, final Array x, final int params, int nbPoints, double stepSize) throws NoSuchMethodException {
        final FiniteDifferencesDifferentiator differentiator = new FiniteDifferencesDifferentiator(nbPoints, stepSize);
        MultivariateJacobianFunction jacobianFunc = new MultivariateJacobianFunction(){

            public Pair<RealVector, RealMatrix> value(RealVector point) {
                func.setParameters(point.toArray());
                UnivariateDifferentiableFunction diffFunc = differentiator.differentiate((UnivariateFunction)func);
                int n = (int)x.getSize();
                ArrayRealVector value = new ArrayRealVector(n);
                Array2DRowRealMatrix jacobian = new Array2DRowRealMatrix(n, params);
                IndexIterator iter = x.getIndexIterator();
                for (int i = 0; i < n; ++i) {
                    double v = iter.getDoubleNext();
                    double modelI = func.value(v);
                    value.setEntry(i, modelI);
                    for (int j = 0; j < params; ++j) {
                        DerivativeStructure xDS = new DerivativeStructure(params, 1, j, point.getEntry(j));
                        DerivativeStructure yDS = diffFunc.value(xDS);
                        int[] idx = new int[params];
                        idx[j] = 1;
                        jacobian.setEntry(i, j, yDS.getPartialDerivative(idx));
                    }
                }
                return new Pair((Object)value, (Object)jacobian);
            }
        };
        return jacobianFunc;
    }

    public static double[] curveFit(ParamUnivariateFunction func, Array x, Array y, int nbPoints, double stepSize, double[] guess) {
        MyParametricUnivariateFunction function = new MyParametricUnivariateFunction(func, nbPoints, stepSize);
        SimpleCurveFitter curveFitter = SimpleCurveFitter.create((ParametricUnivariateFunction)function, (double[])guess);
        IndexIterator xIter = x.getIndexIterator();
        IndexIterator yIter = y.getIndexIterator();
        WeightedObservedPoints observedPoints = new WeightedObservedPoints();
        while (xIter.hasNext()) {
            observedPoints.add(xIter.getDoubleNext(), yIter.getDoubleNext());
        }
        double[] best = curveFitter.fit((Collection)observedPoints.toList());
        return best;
    }
}

