/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.math.integrate.lsoda;

import java.util.Arrays;
import org.meteoinfo.math.integrate.lsoda.ReturningValues;

public class Utility {
    public static double Dot(int n, double[] dx, int incx, double[] dy, int incy) {
        double dotProd = 0.0;
        int ix = 1;
        int iy = 1;
        if (n <= 0) {
            return dotProd;
        }
        if (incx != incy || incx < 1) {
            if (incx < 0) {
                ix = (-n + 1) * incx + 1;
            }
            if (incx < 0) {
                iy = (-n + 1) * incy + 1;
            }
            for (int i = 1; i <= n; ++i) {
                dotProd += dx[ix] * dy[iy];
                ix += incx;
                iy += incy;
            }
            return dotProd;
        }
        if (incx == 1) {
            int i;
            int m = n % 5;
            if (m != 0) {
                for (i = 1; i <= m; ++i) {
                    dotProd += dx[i] * dy[i];
                }
                if (n < 5) {
                    return dotProd;
                }
            }
            for (i = m + 1; i <= n; i += 5) {
                dotProd += dx[i] * dy[i] + dx[i + 1] * dy[i + 1] + dx[i + 2] * dy[i + 2] + dx[i + 3] * dy[i + 3] + dx[i + 4] * dy[i + 4];
            }
            return dotProd;
        }
        for (int i = 1; i <= n * incx; i += incx) {
            dotProd += dx[i] * dy[i];
        }
        return dotProd;
    }

    public static int findMaxMagnitude(int n, double[] dx, int incx) {
        int xindex = 0;
        if (n <= 0) {
            return xindex;
        }
        xindex = 1;
        if (n <= 1 || incx <= 0) {
            return xindex;
        }
        double maxValue = Math.abs(dx[1]);
        if (incx != 1) {
            int curIndex = 2;
            for (int i = 1 + incx; i <= n * incx; i += incx) {
                double curValue = Math.abs(dx[i]);
                if (curValue > maxValue) {
                    xindex = curIndex;
                    maxValue = curValue;
                }
                ++curIndex;
            }
            return xindex;
        }
        for (int i = 2; i <= n; ++i) {
            double curValue = Math.abs(dx[i]);
            if (!(curValue > maxValue)) continue;
            xindex = i;
            maxValue = curValue;
        }
        return xindex;
    }

    public static double[] calAX(int n, double da, double[] dx, int incx, int start) {
        int i;
        if (n <= 0 || incx * (n - 1) + start >= dx.length) {
            System.out.println("function calAX: illegal input");
            return dx;
        }
        if (incx != 1) {
            for (int i2 = start; i2 <= (n - 1) * incx + start; i2 += incx) {
                dx[i2] = da * dx[i2];
            }
            return dx;
        }
        int m = n % 5;
        if (m != 0) {
            for (i = start; i <= m + start - 1; ++i) {
                dx[i] = da * dx[i];
            }
            if (n < 5) {
                return dx;
            }
        }
        for (i = m + start; i <= n + start - 1; i += 5) {
            dx[i] = da * dx[i];
            dx[i + 1] = da * dx[i + 1];
            dx[i + 2] = da * dx[i + 2];
            dx[i + 3] = da * dx[i + 3];
            dx[i + 4] = da * dx[i + 4];
        }
        return dx;
    }

    public static double[] calAXPlusY(int n, double da, double[] dx, int incx, double[] dy, int incy, int xstart, int ystart) {
        if (incx * (n - 1) + xstart >= dx.length || incy * (n - 1) + ystart >= dy.length || n <= 0) {
            System.out.println("function calAXPlusY: illegal input");
            return dy;
        }
        if (da == 0.0) {
            return dy;
        }
        if (incx != incy || incx < 1) {
            int ix = xstart;
            int iy = ystart;
            if (incx < 0) {
                ix = (-n + 1) * incx + xstart;
            }
            if (incx < 0) {
                iy = (-n + 1) * incy + ystart;
            }
            for (int i = 1; i <= n; ++i) {
                int n2 = iy;
                dy[n2] = dy[n2] + da * dx[ix];
                ix += incx;
                iy += incy;
            }
            return dy;
        }
        if (incx == 1) {
            int i;
            int m = n % 4;
            if (m != 0) {
                for (i = 1; i <= m; ++i) {
                    int n3 = i + ystart - 1;
                    dy[n3] = dy[n3] + da * dx[i + xstart - 1];
                }
                if (n < 4) {
                    return dy;
                }
            }
            for (i = m + 1; i <= n; i += 4) {
                dy[i + ystart - 1] = dy[i + ystart - 1] + da * dx[i + xstart - 1];
                dy[i + ystart] = dy[i + ystart] + da * dx[i + xstart];
                dy[i + ystart + 1] = dy[i + ystart + 1] + da * dx[i + xstart + 1];
                dy[i + ystart + 2] = dy[i + ystart + 2] + da * dx[i + xstart + 2];
            }
            return dy;
        }
        for (int i = 1; i <= n * incx; i += incx) {
            int n4 = ystart + i - 1;
            dy[n4] = dy[n4] + da * dx[xstart + i - 1];
        }
        return dy;
    }

    public static ReturningValues LUDecomposition(double[][] a, int n) {
        int info = 0;
        int[] ipvt = new int[n + 1];
        for (int k = 1; k <= n - 1; ++k) {
            double t;
            int j;
            ipvt[k] = j = Utility.findMaxMagnitude(n - k + 1, Arrays.copyOfRange(a[k], k - 1, n + 1), 1) + k - 1;
            if (a[k][j] == 0.0) {
                info = k;
                continue;
            }
            if (j != k) {
                t = a[k][j];
                a[k][j] = a[k][k];
                a[k][k] = t;
            }
            t = -1.0 / a[k][k];
            a[k] = Utility.calAX(n - k, t, a[k], 1, k + 1);
            for (int i = k + 1; i <= n; ++i) {
                t = a[i][j];
                if (j != k) {
                    a[i][j] = a[i][k];
                    a[i][k] = t;
                }
                a[i] = Utility.calAXPlusY(n - k, t, a[k], 1, a[i], 1, k + 1, k + 1);
            }
        }
        ipvt[n] = n;
        if (a[n][n] == 0.0) {
            info = n;
        }
        return new ReturningValues(a, ipvt, info);
    }

    public static double[] solveLinearSys(double[][] a, int n, int[] ipvt, double[] b) {
        double t;
        int k;
        for (k = 1; k <= n; ++k) {
            t = Utility.Dot(k - 1, Arrays.copyOfRange(a[k], 0, k), 1, b, 1);
            b[k] = (b[k] - t) / a[k][k];
        }
        for (k = n - 1; k >= 1; --k) {
            b[k] = b[k] + Utility.Dot(n - k, Arrays.copyOfRange(a[k], k, n + 1), 1, Arrays.copyOfRange(b, k, n + 1), 1);
            int j = ipvt[k];
            if (j == k) continue;
            t = b[j];
            b[j] = b[k];
            b[k] = t;
        }
        return b;
    }

    public static Double[] transformYVec(double[] y) {
        int len = y.length - 1;
        Double[] yvec = new Double[len];
        for (int i = 0; i < len; ++i) {
            yvec[i] = y[i + 1];
        }
        return yvec;
    }
}

