/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.grib.grib1;

import java.io.EOFException;
import java.io.IOException;
import java.util.Formatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.nc2.grib.GribData;
import ucar.nc2.grib.GribNumbers;
import ucar.nc2.grib.grib1.Grib1RecordScanner;
import ucar.nc2.grib.grib1.Grib1SectionBinaryData;
import ucar.nc2.iosp.BitReader;
import ucar.unidata.io.RandomAccessFile;

public class Grib1DataReader {
    private static final Logger logger = LoggerFactory.getLogger(Grib1DataReader.class);
    private static final float staticMissingValue = Float.NaN;
    private final int decimalScale;
    private final int scanMode;
    private final int nxRaw;
    private final int nyRaw;
    private final int nPts;
    private final long startPos;

    Grib1DataReader(int decimalScale, int scanMode, int nxRaw, int nyRaw, int nPts, long startPos) {
        this.decimalScale = decimalScale;
        this.scanMode = scanMode;
        this.nxRaw = nxRaw;
        this.nyRaw = nyRaw;
        this.nPts = nPts;
        this.startPos = startPos;
    }

    public float[] getData(RandomAccessFile raf, byte[] bitmap) throws IOException {
        GribData.Info info = Grib1SectionBinaryData.getBinaryDataInfo(raf, this.startPos);
        if (!info.isGridPointData()) {
            logger.warn("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data for {}", (Object)raf.getLocation());
            throw new IllegalStateException("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data");
        }
        return info.isSimplePacking() ? this.readSimplePacking(raf, bitmap, info) : this.readExtendedComplexPacking(raf, bitmap, info);
    }

    private float[] readSimplePacking(RandomAccessFile raf, byte[] bitmap, GribData.Info info) throws IOException {
        float[] values;
        boolean isConstant = info.numberOfBits == 0;
        int unusedbits = info.flag & 0xF;
        double pow10 = Math.pow(10.0, -this.decimalScale);
        float ref = (float)(pow10 * (double)info.referenceValue);
        float scale = (float)(pow10 * Math.pow(2.0, info.binaryScaleFactor));
        if (bitmap != null) {
            if (8 * bitmap.length < this.nPts) {
                logger.error("Bitmap section length = {} != grid length {} ({},{}) for {}", new Object[]{bitmap.length, this.nPts, this.nxRaw, this.nyRaw, raf.getLocation()});
                throw new IllegalStateException("Bitmap section length!= grid length");
            }
            BitReader reader = new BitReader(raf, this.startPos + 11L);
            values = new float[this.nPts];
            for (int i = 0; i < this.nPts; ++i) {
                if (GribNumbers.testBitIsSet(bitmap[i / 8], i % 8)) {
                    if (!isConstant) {
                        values[i] = ref + scale * (float)reader.bits2UInt(info.numberOfBits);
                        continue;
                    }
                    values[i] = ref;
                    continue;
                }
                values[i] = Float.NaN;
            }
            this.scanningModeCheck(values, this.scanMode, this.nxRaw);
        } else if (!isConstant) {
            if (this.nxRaw > 0 && this.nyRaw > 0) {
                values = new float[this.nxRaw * this.nyRaw];
            } else {
                int nptsExpected = (int)((info.dataLength - 11L) * 8L - (long)unusedbits) / info.numberOfBits;
                if (!Grib1RecordScanner.allowBadDsLength && nptsExpected != this.nPts) {
                    logger.warn("nptsExpected {} != npts {}", (Object)nptsExpected, (Object)this.nPts);
                }
                values = new float[this.nPts];
            }
            BitReader reader = new BitReader(raf, this.startPos + 11L);
            for (int i = 0; i < values.length; ++i) {
                values[i] = ref + scale * (float)reader.bits2UInt(info.numberOfBits);
            }
            this.scanningModeCheck(values, this.scanMode, this.nxRaw);
        } else {
            values = new float[this.nxRaw * this.nyRaw];
            for (int i = 0; i < values.length; ++i) {
                values[i] = ref;
            }
        }
        return values;
    }

    private float[] readComplexPacking(RandomAccessFile raf, byte[] bitmap, GribData.Info info) throws IOException {
        int foWidth = info.numberOfBits;
        boolean isConstant = info.numberOfBits == 0;
        int unusedbits = info.flag & 0xF;
        int N1 = GribNumbers.uint2(raf);
        int flagExt = raf.read();
        int N2 = GribNumbers.uint2(raf);
        int P1 = GribNumbers.uint2(raf);
        int P2 = GribNumbers.uint2(raf);
        raf.read();
        boolean hasBitmap2 = GribNumbers.testGribBitIsSet(flagExt, 3);
        boolean hasDifferentWidths = GribNumbers.testGribBitIsSet(flagExt, 4);
        boolean useGeneralExtended = GribNumbers.testGribBitIsSet(flagExt, 5);
        boolean useBoustOrdering = GribNumbers.testGribBitIsSet(flagExt, 6);
        int constantWidth = -1;
        int bitmapStart = 21;
        if (!hasDifferentWidths) {
            constantWidth = info.numberOfBits;
        } else {
            int[] widths = new int[P1];
            for (int i = 0; i < P1; ++i) {
                widths[i] = raf.read();
            }
            bitmapStart = 21 + P1;
        }
        if (hasBitmap2) {
            int bitmapSize = N1 - bitmapStart - 1;
            byte[] bitmap2 = new byte[bitmapSize];
            raf.readFully(bitmap2);
            int n = GribNumbers.countBits(bitmap2);
        }
        long filePos = raf.getFilePointer();
        int offset = (int)(filePos - this.startPos);
        int nfo = N2 - N1;
        int np = this.nPts;
        return new float[1];
    }

    private float[] readExtendedComplexPacking(RandomAccessFile raf, byte[] bitmap, GribData.Info info) throws IOException {
        int N1 = GribNumbers.uint2(raf);
        int flagExt = raf.read();
        Formatter f = new Formatter();
        f.format("%n=====================%nGrib1DataReader.readExtendedComplexPacking flagExt=%s%n", Long.toBinaryString(flagExt));
        boolean hasBitmap2 = GribNumbers.testGribBitIsSet(flagExt, 3);
        boolean hasDifferentWidths = GribNumbers.testGribBitIsSet(flagExt, 4);
        boolean useGeneralExtended = GribNumbers.testGribBitIsSet(flagExt, 5);
        boolean useBoustOrdering = GribNumbers.testGribBitIsSet(flagExt, 6);
        f.format(" hasBitmap2=%s, hasDifferentWidths=%s, useGeneralExtended=%s, useBoustOrdering=%s%n%n", hasBitmap2, hasDifferentWidths, useGeneralExtended, useBoustOrdering);
        this.showOffset(f, "N2", raf, 14, 672);
        int N2 = GribNumbers.uint2(raf);
        int codedNumberOfGroups = GribNumbers.uint2(raf);
        int numberOfSecondOrderPackedValues = GribNumbers.uint2(raf);
        int extraValues = raf.read();
        int NG = codedNumberOfGroups + 65536 * extraValues;
        int widthOfWidths = raf.read();
        int widthOfLengths = raf.read();
        int NL = GribNumbers.uint2(raf);
        f.format("NG=%d NL=%d%n", NG, NL);
        int groupWidthsSizeBits = widthOfWidths * NG;
        int groupWidthsSizeBytes = (groupWidthsSizeBits + 7) / 8;
        int skipBytes = NL - groupWidthsSizeBytes - 26;
        f.format("groupWidthsSizeBytes=%d, skipBytes=%d%n", groupWidthsSizeBytes, skipBytes);
        raf.skipBytes(skipBytes);
        this.showOffset(f, "GroupWidth", raf, 31, 689);
        BitReader reader = new BitReader(raf, raf.getFilePointer());
        int[] groupWidth = new int[NG];
        for (int group = 0; group < NG; ++group) {
            groupWidth[group] = (int)reader.bits2UInt(widthOfWidths);
        }
        reader.incrByte();
        this.showOffset(f, "GroupLength", raf, NL - 1, 2723);
        int[] groupLength = new int[NG];
        for (int group = 0; group < NG; ++group) {
            groupLength[group] = (int)reader.bits2UInt(widthOfLengths);
        }
        this.showOffset(f, "FirstOrderValues", raf, N1 - 1, 5774);
        int countOfGroupLengths = 0;
        for (int group = 0; group < NG; ++group) {
            countOfGroupLengths += groupLength[group];
        }
        f.format("countOfGroupLengths = %d%n", countOfGroupLengths);
        f.format("nPts = %d%n%n", this.nPts);
        int foWidth = info.numberOfBits;
        reader.incrByte();
        int[] firstOrderValues = new int[NG];
        for (int group = 0; group < NG; ++group) {
            firstOrderValues[group] = (int)reader.bits2UInt(foWidth);
        }
        int offset3 = (int)(raf.getFilePointer() - this.startPos);
        f.format("nbytes=%d%n", (foWidth * NG + 7) / 8);
        this.showOffset(f, "SecondOrderValues", raf, N2 - 1, 11367);
        int total_nbits = 0;
        for (int group = 0; group < NG; ++group) {
            int nbits = groupLength[group] * groupWidth[group];
            total_nbits += nbits;
        }
        int data_bytes = (total_nbits + 7) / 8;
        f.format(" total_nbits=%d, nbytes=%d%n", total_nbits, data_bytes);
        f.format(" expect msgLen=%d, actual=%d%n", N2 - 1 + data_bytes, info.dataLength);
        int simplepackSizeInBits = this.nPts * info.numberOfBits;
        int simplepackSizeInBytes = (simplepackSizeInBits + 7) / 8;
        f.format(" simplepackSizeInBits=%d, simplepackSizeInBytes=%d%n", simplepackSizeInBits, simplepackSizeInBytes);
        reader.incrByte();
        int[] secondOrderValues = new int[countOfGroupLengths];
        int countGroups = 0;
        try {
            int val = 0;
            double log2 = Math.log(2.0);
            for (int group = 0; group < NG; ++group) {
                for (int i = 0; i < groupLength[group]; ++i) {
                    int secVal = (int)reader.bits2UInt(groupWidth[group]);
                    secondOrderValues[val++] = secVal;
                }
                ++countGroups;
            }
        }
        catch (EOFException ioe) {
            logger.warn("Only did {} groups out of {}", (Object)countGroups, (Object)NG);
        }
        int offset4 = (int)(raf.getFilePointer() - this.startPos);
        this.showOffset(f, "MessageEnd", raf, (int)info.dataLength, 82091);
        f.format("nbytes= %d%n", (total_nbits + 7) / 8);
        f.format("actual= %d%n", offset4 - offset3);
        double pow10 = Math.pow(10.0, -this.decimalScale);
        float ref = (float)(pow10 * (double)info.referenceValue);
        float scale = (float)(pow10 * Math.pow(2.0, info.binaryScaleFactor));
        float[] values = new float[this.nPts];
        int val = 0;
        int n = Math.min(countOfGroupLengths, this.nPts);
        for (int group = 0; group < NG; ++group) {
            for (int i = 0; i < groupLength[group]; ++i) {
                values[val] = ref + scale * (float)(firstOrderValues[group] + secondOrderValues[val]);
                ++val;
            }
        }
        for (int i = countOfGroupLengths; i < this.nPts; ++i) {
            values[val] = ref + scale * (float)firstOrderValues[NG - 1];
            ++val;
        }
        this.scanningModeCheck(values, this.scanMode, this.nxRaw);
        return values;
    }

    private void showOffset(Formatter f, String what, RandomAccessFile raf, int expectOffset, int expectDump) throws IOException {
        int offset = (int)(raf.getFilePointer() - this.startPos);
        f.format("%s: filePos=%d, expectDump=%d, offset=%d expect=%d%n", what, raf.getFilePointer(), expectDump, offset, expectOffset);
    }

    private static void showOffset(Formatter f, String what, RandomAccessFile raf, long startPos, int expectOffset) throws IOException {
        int offset = (int)(raf.getFilePointer() - startPos);
        f.format("%s: filePos=%d, offset=%d expect=%d%n", what, raf.getFilePointer(), offset, expectOffset);
    }

    public static void showComplexPackingInfo(Formatter f, RandomAccessFile raf, long startPos) throws IOException {
        GribData.Info info = Grib1SectionBinaryData.getBinaryDataInfo(raf, startPos);
        if (!info.isGridPointData() || info.isSimplePacking()) {
            return;
        }
        int N1 = GribNumbers.uint2(raf);
        int flagExt = raf.read();
        boolean hasBitmap2 = GribNumbers.testGribBitIsSet(flagExt, 3);
        boolean hasDifferentWidths = GribNumbers.testGribBitIsSet(flagExt, 4);
        boolean useGeneralExtended = GribNumbers.testGribBitIsSet(flagExt, 5);
        boolean useBoustOrdering = GribNumbers.testGribBitIsSet(flagExt, 6);
        int N2 = GribNumbers.uint2(raf);
        int codedNumberOfGroups = GribNumbers.uint2(raf);
        int numberOfSecondOrderPackedValues = GribNumbers.uint2(raf);
        int extraValues = raf.read();
        int NG = codedNumberOfGroups + 65536 * extraValues;
        int widthOfWidths = raf.read();
        int widthOfLengths = raf.read();
        int NL = GribNumbers.uint2(raf);
        f.format("%n", new Object[0]);
        f.format("       ----flagExt = %s%n", Long.toBinaryString(flagExt));
        f.format("        hasBitmap2 = %s%n", hasBitmap2);
        f.format("hasDifferentWidths = %s%n", hasDifferentWidths);
        f.format("useGeneralExtended = %s%n", useGeneralExtended);
        f.format("  useBoustOrdering = %s%n", useBoustOrdering);
        f.format("                NL = %d%n", NL);
        f.format("                N1 = %d%n", N1);
        f.format("                N2 = %d%n", N2);
        f.format("    numberOfGroups = %d%n", NG);
        f.format("     widthOfWidths = %d%n", widthOfWidths);
        f.format("    widthOfLengths = %d%n", widthOfLengths);
        f.format("%n", new Object[0]);
        int groupWidthsSizeBits = widthOfWidths * NG;
        int groupWidthsSizeBytes = (groupWidthsSizeBits + 7) / 8;
        int skipBytes = NL - groupWidthsSizeBytes - 26;
        raf.skipBytes(skipBytes);
        BitReader reader = new BitReader(raf, raf.getFilePointer());
        int[] groupWidth = new int[NG];
        for (int group = 0; group < NG; ++group) {
            groupWidth[group] = (int)reader.bits2UInt(widthOfWidths);
        }
        reader.incrByte();
        Grib1DataReader.showOffset(f, "GroupLength", raf, startPos, NL - 1);
        int[] groupLength = new int[NG];
        for (int group = 0; group < NG; ++group) {
            groupLength[group] = (int)reader.bits2UInt(widthOfLengths);
        }
        Grib1DataReader.showOffset(f, "FirstOrderValues", raf, startPos, N1 - 1);
        int countOfGroupLengths = 0;
        for (int group = 0; group < NG; ++group) {
            countOfGroupLengths += groupLength[group];
        }
        f.format("countOfGroupLengths = %d%n", countOfGroupLengths);
        int foWidth = info.numberOfBits;
        reader.incrByte();
        int[] firstOrderValues = new int[NG];
        for (int group = 0; group < NG; ++group) {
            firstOrderValues[group] = (int)reader.bits2UInt(foWidth);
        }
        Grib1DataReader.showOffset(f, "SecondOrderValues", raf, startPos, N2 - 1);
        int total_nbits = 0;
        for (int group = 0; group < NG; ++group) {
            int nbits = groupLength[group] * groupWidth[group];
            total_nbits += nbits;
        }
        int data_bytes = (total_nbits + 7) / 8;
        f.format(" total_nbits=%d, nbytes=%d%n", total_nbits, data_bytes);
        f.format(" expect msgLen=%d, actual=%d%n", N2 - 1 + data_bytes, info.dataLength);
        logger.debug("{}", (Object)f);
    }

    private void scanningModeCheck(float[] data, int scanMode, int Xlength) {
        if (Xlength <= 0) {
            return;
        }
        if (scanMode == 128 || scanMode == 192) {
            int mid = Xlength / 2;
            for (int index = 0; index < data.length; index += Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = data[index + idx];
                    data[index + idx] = data[index + Xlength - idx - 1];
                    data[index + Xlength - idx - 1] = tmp;
                }
            }
        }
    }

    int[] getDataRaw(RandomAccessFile raf, byte[] bitmap) throws IOException {
        raf.seek(this.startPos);
        int msgLength = GribNumbers.uint3(raf);
        int unusedbits = raf.read();
        if ((unusedbits & 0xC0) != 0) {
            logger.error("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing for {} len={}", (Object)raf.getLocation(), (Object)msgLength);
            throw new IllegalStateException("Grib1BinaryDataSection: (octet 4, 1st half) not grid point data and simple packing ");
        }
        GribNumbers.int2(raf);
        GribNumbers.float4(raf);
        int numbits = raf.read();
        BitReader reader = new BitReader(raf, this.startPos + 11L);
        int[] ivals = new int[this.nPts];
        for (int i = 0; i < this.nPts; ++i) {
            ivals[i] = (int)reader.bits2UInt(numbits);
        }
        return ivals;
    }
}

