/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.verification;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meteothink.imep.verification.DataRange;
import org.meteothink.imep.verification.MethodType;
import org.meteothink.imep.verification.VerifyTable;

public class ScoreTable
extends VerifyTable {
    List<DataRange> obsRanges;
    List<List<Integer>> scores;

    public ScoreTable(List<DataRange> obsRanges) {
        this.obsRanges = obsRanges;
        this.scores = new ArrayList<List<Integer>>();
        for (int i = 0; i < obsRanges.size(); ++i) {
            this.scores.add(new ArrayList());
        }
    }

    public List<List<Integer>> getScores() {
        return this.scores;
    }

    public void setScores(List<List<Integer>> value) {
        this.scores = value;
    }

    public void addScore(int idx, int score) {
        this.scores.get(idx).add(score);
    }

    public float getMeanScore(int idx) {
        float ms = 0.0f;
        for (int score : this.scores.get(idx)) {
            ms += (float)score;
        }
        return ms /= (float)this.scores.get(idx).size();
    }

    public float getMeanScore() {
        float ms = 0.0f;
        int n = 0;
        for (List<Integer> score : this.scores) {
            for (int s : score) {
                ms += (float)s;
                ++n;
            }
        }
        return ms /= (float)n;
    }

    @Override
    public Map getVerifyResult() {
        HashMap<String, Number> map = new HashMap<String, Number>();
        map.put("Summary", Float.valueOf(this.getMeanScore()));
        int i = 0;
        for (DataRange dr : this.obsRanges) {
            map.put(dr.toString(), Float.valueOf(this.getMeanScore(i)));
            map.put(dr.toString() + "_n", this.scores.get(i).size());
            ++i;
        }
        return map;
    }

    @Override
    public MethodType getMethodType() {
        return MethodType.SCORE;
    }

    @Override
    public String getScoreNames() {
        StringBuilder names = new StringBuilder();
        names.append("Summary");
        for (DataRange dr : this.obsRanges) {
            names.append(",");
            names.append(dr.toString());
            names.append(",");
            names.append(dr.toString() + "_n");
        }
        return names.toString();
    }
}

