/*
 * Decompiled with CFR 0.152.
 */
package org.meteothink.imep.forms;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteothink.imep.global.Globals;
import org.meteothink.imep.verification.Dataset;

public class FrmDataset
extends JDialog {
    private Dataset _dataset;
    private JButton jButton_Cancel;
    private JButton jButton_FileName;
    private JButton jButton_OK;
    private JCheckBox jCheckBox_BigEndian;
    private JComboBox jComboBox_DataType;
    private JComboBox jComboBox_TimeZone;
    private JLabel jLabel13;
    private JLabel jLabel14;
    private JLabel jLabel15;
    private JLabel jLabel16;
    private JLabel jLabel_LevelIndex;
    private JTextField jTextField_FileName;
    private JTextField jTextField_LevelIndex;
    private JTextField jTextField_Variable;

    public FrmDataset(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jCheckBox_BigEndian.setVisible(false);
    }

    private void initComponents() {
        this.jButton_OK = new JButton();
        this.jButton_Cancel = new JButton();
        this.jLabel13 = new JLabel();
        this.jComboBox_DataType = new JComboBox();
        this.jLabel14 = new JLabel();
        this.jTextField_FileName = new JTextField();
        this.jLabel15 = new JLabel();
        this.jLabel16 = new JLabel();
        this.jTextField_Variable = new JTextField();
        this.jComboBox_TimeZone = new JComboBox();
        this.jButton_FileName = new JButton();
        this.jLabel_LevelIndex = new JLabel();
        this.jTextField_LevelIndex = new JTextField();
        this.jCheckBox_BigEndian = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.jButton_OK.setText("OK");
        this.jButton_OK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmDataset.this.jButton_OKActionPerformed(evt);
            }
        });
        this.jButton_Cancel.setText("Cancel");
        this.jButton_Cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmDataset.this.jButton_CancelActionPerformed(evt);
            }
        });
        this.jLabel13.setText("DataType:");
        this.jComboBox_DataType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jComboBox_DataType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmDataset.this.jComboBox_DataTypeActionPerformed(evt);
            }
        });
        this.jLabel14.setText("File:");
        this.jLabel15.setText("TimeZone:");
        this.jLabel16.setText("Variable:");
        this.jComboBox_TimeZone.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jButton_FileName.setIcon(new ImageIcon(this.getClass().getResource("/images/Folder_1_16x16x8.png")));
        this.jButton_FileName.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmDataset.this.jButton_FileNameActionPerformed(evt);
            }
        });
        this.jLabel_LevelIndex.setText("LevelIndex:");
        this.jTextField_LevelIndex.setText("0");
        this.jCheckBox_BigEndian.setText("Big_Endian");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel14).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_FileName).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton_FileName)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 114, Short.MAX_VALUE).addComponent(this.jButton_OK, -2, 82, -2).addGap(79, 79, 79).addComponent(this.jButton_Cancel, -2, 82, -2).addGap(111, 111, 111)).addGroup(layout.createSequentialGroup().addComponent(this.jLabel13).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_DataType, -2, 139, -2).addGap(41, 41, 41).addComponent(this.jCheckBox_BigEndian).addGap(0, 0, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addGroup(layout.createSequentialGroup().addComponent(this.jLabel15).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jComboBox_TimeZone, 0, -1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel16).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_Variable, -2, 142, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel_LevelIndex).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_LevelIndex, -2, 28, -2).addGap(38, 38, 38))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel13).addComponent(this.jComboBox_DataType, -2, -1, -2).addComponent(this.jCheckBox_BigEndian)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel14).addComponent(this.jTextField_FileName, -2, -1, -2)).addComponent(this.jButton_FileName)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel16).addComponent(this.jTextField_Variable, -2, -1, -2).addComponent(this.jLabel_LevelIndex).addComponent(this.jTextField_LevelIndex, -2, -1, -2)).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel15).addComponent(this.jComboBox_TimeZone, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 28, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_OK).addComponent(this.jButton_Cancel)).addContainerGap()));
        this.pack();
    }

    private void jButton_FileNameActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_FileName.setText(aFile.getAbsolutePath());
        }
    }

    private void jButton_OKActionPerformed(ActionEvent evt) {
        this._dataset.setMeteoDataType((MeteoDataType)this.jComboBox_DataType.getSelectedItem());
        this._dataset.setFileName(this.jTextField_FileName.getText());
        this._dataset.setTimeZone(Globals.getTimeZone(this.jComboBox_TimeZone.getSelectedItem().toString()));
        this._dataset.setVariableName(this.jTextField_Variable.getText());
        this._dataset.setLevelIndex(Integer.parseInt(this.jTextField_LevelIndex.getText()));
        this._dataset.setBigEndian(this.jCheckBox_BigEndian.isSelected());
        this.dispose();
    }

    private void jButton_CancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jComboBox_DataTypeActionPerformed(ActionEvent evt) {
        if (this.jComboBox_DataType.getItemCount() > 0) {
            MeteoDataType mdt = (MeteoDataType)this.jComboBox_DataType.getSelectedItem();
            this.updateMeteoDataType(mdt);
        }
    }

    private void updateMeteoDataType(MeteoDataType mdt) {
        switch (mdt) {
            case GRADS_GRID: 
            case GRADS_STATION: {
                this.jCheckBox_BigEndian.setVisible(true);
                break;
            }
            default: {
                this.jCheckBox_BigEndian.setVisible(false);
            }
        }
    }

    public void setDataset(Dataset dataset) {
        this._dataset = dataset;
        this.jComboBox_DataType.removeAllItems();
        for (MeteoDataType dataType : MeteoDataType.values()) {
            this.jComboBox_DataType.addItem(dataType);
        }
        this.jComboBox_DataType.setSelectedItem(dataset.getMeteoDataType());
        this.jCheckBox_BigEndian.setSelected(dataset.isBigEndian());
        this.jTextField_FileName.setText(dataset.getFileName());
        this.jComboBox_TimeZone.removeAllItems();
        for (int i = -12; i <= 12; ++i) {
            this.jComboBox_TimeZone.addItem(Globals.getTimeZoneString(i));
        }
        this.jComboBox_TimeZone.setSelectedItem(Globals.getTimeZoneString(dataset.getTimeZone()));
        this.jTextField_Variable.setText(dataset.getVariableName());
        this.jTextField_LevelIndex.setText(String.valueOf(dataset.getLevelIndex()));
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmDataset.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmDataset.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmDataset.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmDataset.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmDataset dialog = new FrmDataset((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

