/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.util;

import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.lang.ref.WeakReference;

public class BarycentricGradientPaint
implements Paint {
    protected Point2D.Float p1;
    protected Point2D.Float p2;
    protected Point2D.Float p3;
    protected Color color1;
    protected Color color2;
    protected Color color3;

    public BarycentricGradientPaint(Point2D p1, Point2D p2, Point2D p3, Color color1, Color color2, Color color3) {
        this.p1 = new Point2D.Float((float)p1.getX(), (float)p1.getY());
        this.p2 = new Point2D.Float((float)p2.getX(), (float)p2.getY());
        this.p3 = new Point2D.Float((float)p3.getX(), (float)p3.getY());
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
    }

    public BarycentricGradientPaint(float[] x, float[] y, Color color1, Color color2, Color color3) {
        this(x[0], y[0], x[1], y[1], x[2], y[2], color1, color2, color3);
    }

    public BarycentricGradientPaint(double x1, double y1, double x2, double y2, double x3, double y3, Color color1, Color color2, Color color3) {
        this((float)x1, (float)y1, (float)x2, (float)y2, (float)x3, (float)y3, color1, color2, color3);
    }

    public BarycentricGradientPaint(float x1, float y1, float x2, float y2, float x3, float y3, Color color1, Color color2, Color color3) {
        this.p1 = new Point2D.Float(x1, y1);
        this.p2 = new Point2D.Float(x2, y2);
        this.p3 = new Point2D.Float(x3, y3);
        this.color1 = color1;
        this.color2 = color2;
        this.color3 = color3;
    }

    @Override
    public int getTransparency() {
        int a3;
        int a2;
        int a1 = this.color1.getAlpha();
        return (a1 & (a2 = this.color2.getAlpha()) & (a3 = this.color3.getAlpha())) == 255 ? 1 : 3;
    }

    @Override
    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new BarycentricGradientPaintContext(this.p1, this.p2, this.p3, this.color1, this.color2, this.color3, xform, hints.get(RenderingHints.KEY_ANTIALIASING) == RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public static class BarycentricGradientPaintContext
    implements PaintContext {
        protected static final float[] MSAA_SAMPLES = new float[8];
        protected final float x1;
        protected final float x2;
        protected final float x3;
        protected final float y1;
        protected final float y2;
        protected final float y3;
        protected final float x23;
        protected final float x13;
        protected final float y23;
        protected final float y13;
        protected final float denom;
        protected final int c1;
        protected final int c2;
        protected final int c3;
        protected final DirectColorModel cm = new DirectColorModel(32, 0xFF0000, 65280, 255, -16777216);
        protected final boolean antialiasing;
        protected WritableRaster saved;
        protected WeakReference<int[]> cache;

        public BarycentricGradientPaintContext(Point2D.Float p1, Point2D.Float p2, Point2D.Float p3, Color color1, Color color2, Color color3, AffineTransform xform, boolean antialiasing) {
            this.c1 = color1.getRGB();
            this.c2 = color2.getRGB();
            this.c3 = color3.getRGB();
            p1 = (Point2D.Float)xform.transform(p1, new Point2D.Float());
            p2 = (Point2D.Float)xform.transform(p2, new Point2D.Float());
            p3 = (Point2D.Float)xform.transform(p3, new Point2D.Float());
            this.x1 = p1.x;
            this.x2 = p2.x;
            this.x3 = p3.x;
            this.y1 = p1.y;
            this.y2 = p2.y;
            this.y3 = p3.y;
            this.x23 = this.x2 - this.x3;
            this.x13 = this.x1 - this.x3;
            this.y23 = this.y2 - this.y3;
            this.y13 = this.y1 - this.y3;
            this.denom = 1.0f / (this.y23 * this.x13 - this.x23 * this.y13);
            this.antialiasing = antialiasing;
        }

        @Override
        public void dispose() {
            if (this.saved != null) {
                this.cacheRaster(this.saved);
            }
            this.saved = null;
        }

        @Override
        public ColorModel getColorModel() {
            return this.cm;
        }

        @Override
        public Raster getRaster(int xA, int yA, int w, int h) {
            int[] data;
            WritableRaster rast = this.saved;
            if (rast == null) {
                this.saved = rast = this.getCachedOrCreateRaster(w, h);
            } else if (rast.getWidth() != w || rast.getHeight() != h) {
                data = BarycentricGradientPaintContext.dataFromRaster(rast);
                if (data.length < w * h) {
                    data = new int[w * h];
                }
                this.saved = rast = this.createRaster(w, h, data);
            }
            data = BarycentricGradientPaintContext.dataFromRaster(rast);
            if (this.antialiasing) {
                this.fillRasterMSAA(xA, yA, w, h, data);
            } else {
                this.fillRaster(xA, yA, w, h, data);
            }
            return rast;
        }

        protected void fillRaster(int xA, int yA, int w, int h, int[] data) {
            if (this.c1 == this.c2 && this.c2 == this.c3) {
                for (int i = 0; i < h; ++i) {
                    float y = (float)(yA + i) + 0.5f;
                    float ypart11 = -this.x23 * (y - this.y3);
                    float ypart21 = this.x13 * (y - this.y3);
                    for (int j = 0; j < w; ++j) {
                        float x = (float)(xA + j) + 0.5f;
                        float l1 = (this.y23 * (x - this.x3) + ypart11) * this.denom;
                        float l2 = (-this.y13 * (x - this.x3) + ypart21) * this.denom;
                        float l3 = 1.0f - l1 - l2;
                        int mix1 = l1 < 0.0f || l2 < 0.0f || l3 < 0.0f ? 0 : this.c1;
                        data[i * w + j] = mix1;
                    }
                }
            } else {
                for (int i = 0; i < h; ++i) {
                    float y = (float)(yA + i) + 0.5f;
                    float ypart11 = -this.x23 * (y - this.y3);
                    float ypart21 = this.x13 * (y - this.y3);
                    for (int j = 0; j < w; ++j) {
                        float x = (float)(xA + j) + 0.5f;
                        float l1 = (this.y23 * (x - this.x3) + ypart11) * this.denom;
                        float l2 = (-this.y13 * (x - this.x3) + ypart21) * this.denom;
                        float l3 = 1.0f - l1 - l2;
                        int mix1 = l1 < 0.0f || l2 < 0.0f || l3 < 0.0f ? 0 : BarycentricGradientPaintContext.mixColor3(this.c1, this.c2, this.c3, l1, l2, l3);
                        data[i * w + j] = mix1;
                    }
                }
            }
        }

        protected void fillRasterMSAA(int xA, int yA, int w, int h, int[] data) {
            boolean monochrome = this.c1 == this.c2 && this.c2 == this.c3;
            for (int i = 0; i < h; ++i) {
                float y = (float)(yA + i) + MSAA_SAMPLES[1];
                float ypart11 = -this.x23 * (y - this.y3);
                float ypart21 = this.x13 * (y - this.y3);
                y = (float)(yA + i) + MSAA_SAMPLES[3];
                float ypart12 = -this.x23 * (y - this.y3);
                float ypart22 = this.x13 * (y - this.y3);
                y = (float)(yA + i) + MSAA_SAMPLES[5];
                float ypart13 = -this.x23 * (y - this.y3);
                float ypart23 = this.x13 * (y - this.y3);
                y = (float)(yA + i) + MSAA_SAMPLES[7];
                float ypart14 = -this.x23 * (y - this.y3);
                float ypart24 = this.x13 * (y - this.y3);
                for (int j = 0; j < w; ++j) {
                    float w4;
                    int mix4;
                    float w3;
                    int mix3;
                    float w2;
                    int mix2;
                    float w1;
                    int mix1;
                    float x = (float)(xA + j) + MSAA_SAMPLES[0];
                    float xpart11 = this.y23 * (x - this.x3);
                    float xpart21 = -this.y13 * (x - this.x3);
                    x = (float)(xA + j) + MSAA_SAMPLES[2];
                    float xpart12 = this.y23 * (x - this.x3);
                    float xpart22 = -this.y13 * (x - this.x3);
                    x = (float)(xA + j) + MSAA_SAMPLES[4];
                    float xpart13 = this.y23 * (x - this.x3);
                    float xpart23 = -this.y13 * (x - this.x3);
                    x = (float)(xA + j) + MSAA_SAMPLES[6];
                    float xpart14 = this.y23 * (x - this.x3);
                    float xpart24 = -this.y13 * (x - this.x3);
                    float l11 = (xpart11 + ypart11) * this.denom;
                    float l21 = (xpart21 + ypart21) * this.denom;
                    float l31 = 1.0f - l11 - l21;
                    float l12 = (xpart12 + ypart12) * this.denom;
                    float l22 = (xpart22 + ypart22) * this.denom;
                    float l32 = 1.0f - l12 - l22;
                    float l13 = (xpart13 + ypart13) * this.denom;
                    float l23 = (xpart23 + ypart23) * this.denom;
                    float l33 = 1.0f - l13 - l23;
                    float l14 = (xpart14 + ypart14) * this.denom;
                    float l24 = (xpart24 + ypart24) * this.denom;
                    float l34 = 1.0f - l14 - l24;
                    if (l11 < 0.0f || l21 < 0.0f || l31 < 0.0f) {
                        mix1 = 0;
                        w1 = 0.0f;
                    } else {
                        mix1 = monochrome ? this.c1 : BarycentricGradientPaintContext.mixColor3(this.c1, this.c2, this.c3, l11, l21, l31);
                        w1 = 1.0f;
                    }
                    if (l12 < 0.0f || l22 < 0.0f || l32 < 0.0f) {
                        mix2 = 0;
                        w2 = 0.0f;
                    } else {
                        mix2 = monochrome ? this.c1 : BarycentricGradientPaintContext.mixColor3(this.c1, this.c2, this.c3, l12, l22, l32);
                        w2 = 1.0f;
                    }
                    if (l13 < 0.0f || l23 < 0.0f || l33 < 0.0f) {
                        mix3 = 0;
                        w3 = 0.0f;
                    } else {
                        mix3 = monochrome ? this.c1 : BarycentricGradientPaintContext.mixColor3(this.c1, this.c2, this.c3, l13, l23, l33);
                        w3 = 1.0f;
                    }
                    if (l14 < 0.0f || l24 < 0.0f || l34 < 0.0f) {
                        mix4 = 0;
                        w4 = 0.0f;
                    } else {
                        mix4 = monochrome ? this.c1 : BarycentricGradientPaintContext.mixColor3(this.c1, this.c2, this.c3, l14, l24, l34);
                        w4 = 1.0f;
                    }
                    int color = BarycentricGradientPaintContext.mixColor4(mix1, mix2, mix3, mix4, w1, w2, w3, w4);
                    data[i * w + j] = BarycentricGradientPaintContext.scaleColorAlpha(color, (w1 + w2 + w3 + w4) * 0.25f);
                }
            }
        }

        protected WritableRaster getCachedOrCreateRaster(int w, int h) {
            int[] data;
            if (this.cache != null && (data = (int[])this.cache.get()) != null && data.length >= w * h) {
                this.cache = null;
                return this.createRaster(w, h, data);
            }
            return this.createRaster(w, h, new int[w * h]);
        }

        protected void cacheRaster(WritableRaster ras) {
            int[] data;
            int[] toCache = BarycentricGradientPaintContext.dataFromRaster(ras);
            if (this.cache != null && (data = (int[])this.cache.get()) != null && toCache.length < data.length) {
                return;
            }
            this.cache = new WeakReference<int[]>(toCache);
        }

        protected WritableRaster createRaster(int w, int h, int[] data) {
            DataBufferInt buffer = new DataBufferInt(data, w * h);
            WritableRaster raster = Raster.createPackedRaster(buffer, w, h, w, this.cm.getMasks(), null);
            return raster;
        }

        private static int[] dataFromRaster(WritableRaster wr) {
            return ((DataBufferInt)wr.getDataBuffer()).getData();
        }

        private static int mixColor3(int c1, int c2, int c3, float m1, float m2, float m3) {
            float normalize = 1.0f / (m1 + m2 + m3);
            float a = ((float)BarycentricGradientPaintContext.a(c1) * m1 + (float)BarycentricGradientPaintContext.a(c2) * m2 + (float)BarycentricGradientPaintContext.a(c3) * m3) * normalize;
            float r = ((float)BarycentricGradientPaintContext.r(c1) * m1 + (float)BarycentricGradientPaintContext.r(c2) * m2 + (float)BarycentricGradientPaintContext.r(c3) * m3) * normalize;
            float g = ((float)BarycentricGradientPaintContext.g(c1) * m1 + (float)BarycentricGradientPaintContext.g(c2) * m2 + (float)BarycentricGradientPaintContext.g(c3) * m3) * normalize;
            float b = ((float)BarycentricGradientPaintContext.b(c1) * m1 + (float)BarycentricGradientPaintContext.b(c2) * m2 + (float)BarycentricGradientPaintContext.b(c3) * m3) * normalize;
            return BarycentricGradientPaintContext.argb((int)a, (int)r, (int)g, (int)b);
        }

        private static int mixColor4(int c1, int c2, int c3, int c4, float m1, float m2, float m3, float m4) {
            float normalize = 1.0f / (m1 + m2 + m3 + m4);
            float a = ((float)BarycentricGradientPaintContext.a(c1) * m1 + (float)BarycentricGradientPaintContext.a(c2) * m2 + (float)BarycentricGradientPaintContext.a(c3) * m3 + (float)BarycentricGradientPaintContext.a(c4) * m4) * normalize;
            float r = ((float)BarycentricGradientPaintContext.r(c1) * m1 + (float)BarycentricGradientPaintContext.r(c2) * m2 + (float)BarycentricGradientPaintContext.r(c3) * m3 + (float)BarycentricGradientPaintContext.r(c4) * m4) * normalize;
            float g = ((float)BarycentricGradientPaintContext.g(c1) * m1 + (float)BarycentricGradientPaintContext.g(c2) * m2 + (float)BarycentricGradientPaintContext.g(c3) * m3 + (float)BarycentricGradientPaintContext.g(c4) * m4) * normalize;
            float b = ((float)BarycentricGradientPaintContext.b(c1) * m1 + (float)BarycentricGradientPaintContext.b(c2) * m2 + (float)BarycentricGradientPaintContext.b(c3) * m3 + (float)BarycentricGradientPaintContext.b(c4) * m4) * normalize;
            return BarycentricGradientPaintContext.argb((int)a, (int)r, (int)g, (int)b);
        }

        private static int a(int argb) {
            return argb >> 24 & 0xFF;
        }

        private static int r(int argb) {
            return argb >> 16 & 0xFF;
        }

        private static int g(int argb) {
            return argb >> 8 & 0xFF;
        }

        private static int b(int argb) {
            return argb & 0xFF;
        }

        private static int argb(int a, int r, int g, int b) {
            return a << 24 | r << 16 | g << 8 | b;
        }

        private static int scaleColorAlpha(int color, float m) {
            float normalize = 0.003921569f;
            float af = (float)BarycentricGradientPaintContext.a(color) * normalize * m;
            int a = ((int)(af * 255.0f) & 0xFF) << 24;
            return color & 0xFFFFFF | a;
        }

        static {
            AffineTransform xform = new AffineTransform();
            xform.translate(0.5, 0.5);
            xform.rotate(0.3141592653589793);
            xform.scale(0.5, 0.5);
            xform.translate(-0.5, -0.5);
            xform.transform(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f}, 0, MSAA_SAMPLES, 0, 4);
        }
    }
}

