/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.IntBuffer;
import org.meteoinfo.chart.graphic.VolumeGraphic;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.chart.render.jogl.RayCastingType;

public class VolumeRender
extends JOGLGraphicRender {
    private VolumeGraphic volume;
    private int colorTexture;
    private int volumeTexture;
    private int normalsTexture;
    private Program program;
    private IntBuffer vbo;

    public VolumeRender(GL2 gl) {
        super(gl);
        this.useShader = true;
        this.initVertexBuffer();
    }

    public VolumeRender(GL2 gl, VolumeGraphic graphic) {
        this(gl);
        this.setVolume(graphic);
    }

    public VolumeRender(GL2 gl, VolumeGraphic graphic, Transform transform) {
        this(gl, graphic);
        this.setTransform(transform);
    }

    public VolumeGraphic getVolume() {
        return this.volume;
    }

    public void setVolume(VolumeGraphic value) {
        this.volume = value;
        this.setBufferData();
        this.bindingTextures();
        try {
            this.compileShaders();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public RayCastingType getRayCastingType() {
        return this.volume == null ? RayCastingType.MAX_VALUE : this.volume.getRayCastingType();
    }

    public float getBrightness() {
        return this.volume == null ? 1.0f : this.volume.getBrightness();
    }

    private void initVertexBuffer() {
        this.vbo = GLBuffers.newDirectIntBuffer((int)1);
    }

    private void setBufferData() {
        float[] vertexBufferData = this.volume.getVertexBufferData();
        this.gl.glGenBuffers(1, this.vbo);
        this.gl.glBindBuffer(34962, this.vbo.get(0));
        this.gl.glBufferData(34962, (long)(vertexBufferData.length * 4), (Buffer)Buffers.newDirectFloatBuffer((float[])vertexBufferData), 35044);
        this.gl.glBindBuffer(34962, 0);
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (alwaysUpdateBuffers) {
            this.setBufferData();
            this.bindingTextures();
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void bindingTextures() {
        this.colorTexture = this.getTextureID();
        this.gl.glActiveTexture(33985);
        this.gl.glBindTexture(3553, this.colorTexture);
        this.gl.glTexParameteri(3553, 10241, 9729);
        this.gl.glTexParameteri(3553, 10240, 9729);
        this.gl.glTexParameteri(3553, 10242, 33071);
        this.gl.glTexParameteri(3553, 10243, 33071);
        this.gl.glTexImage2D(3553, 0, 6408, this.volume.getColorNum(), 1, 0, 6408, 5121, ((Buffer)Buffers.newDirectByteBuffer((byte[])this.volume.getColors())).rewind());
        this.volumeTexture = this.getTextureID();
        this.gl.glActiveTexture(33984);
        this.gl.glBindTexture(32879, this.volumeTexture);
        this.gl.glTexParameteri(32879, 33084, 0);
        this.gl.glTexParameteri(32879, 10241, 9729);
        this.gl.glTexParameteri(32879, 10240, 9729);
        this.gl.glTexParameteri(32879, 10242, 33071);
        this.gl.glTexParameteri(32879, 10243, 33071);
        this.gl.glTexParameteri(32879, 32882, 33071);
        this.gl.glPixelStorei(3317, 1);
        this.gl.glTexImage3D(32879, 0, 6409, this.volume.getWidth(), this.volume.getHeight(), this.volume.getDepth(), 0, 6409, 5121, ((Buffer)Buffers.newDirectByteBuffer((byte[])this.volume.getByteData())).rewind());
        switch (this.getRayCastingType()) {
            case SPECULAR: {
                this.normalsTexture = this.getTextureID();
                this.gl.glActiveTexture(33986);
                this.gl.glBindTexture(32879, this.normalsTexture);
                this.gl.glTexParameteri(32879, 33084, 0);
                this.gl.glTexParameteri(32879, 10241, 9729);
                this.gl.glTexParameteri(32879, 10240, 9729);
                this.gl.glTexParameteri(32879, 10242, 33071);
                this.gl.glTexParameteri(32879, 10243, 33071);
                this.gl.glTexParameteri(32879, 32882, 33071);
                this.gl.glPixelStorei(3317, 1);
                this.gl.glTexImage3D(32879, 0, 6407, this.volume.getWidth(), this.volume.getHeight(), this.volume.getDepth(), 0, 6407, 5121, ((Buffer)Buffers.newDirectByteBuffer((byte[])this.volume.getNormals())).rewind());
            }
        }
        this.gl.glBindTexture(3553, 0);
        this.gl.glBindTexture(32879, 0);
    }

    void compileShaders() throws Exception {
        String fragmentShaderCode;
        String vertexShaderCode = Utils.loadResource("/shaders/volume/vertex.vert");
        switch (this.getRayCastingType()) {
            case BASIC: {
                fragmentShaderCode = Utils.loadResource("/shaders/volume/basic.frag");
                break;
            }
            case SPECULAR: {
                fragmentShaderCode = Utils.loadResource("/shaders/volume/specular.frag");
                break;
            }
            default: {
                fragmentShaderCode = Utils.loadResource("/shaders/volume/maxValue.frag");
            }
        }
        this.program = new Program("volume", vertexShaderCode, fragmentShaderCode);
    }

    public void updateShaders() {
        if (this.program == null) {
            this.bindingTextures();
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.program.getProgramId() == null) {
            this.bindingTextures();
        }
    }

    void setUniforms() {
        this.program.allocateUniform(this.gl, "orthographic", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), this.orthographic ? 1 : 0));
        this.program.allocateUniform(this.gl, "MVP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.viewProjMatrix.get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "iV", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.mvmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "iP", (gl2, loc) -> gl2.glUniformMatrix4fv(loc.intValue(), 1, false, this.toMatrix(this.projmatrix).invert().get(Buffers.newDirectFloatBuffer((int)16))));
        this.program.allocateUniform(this.gl, "viewSize", (gl2, loc) -> gl2.glUniform2f(loc.intValue(), (float)this.getWidth(), (float)this.getHeight()));
        this.program.allocateUniform(this.gl, "viewShift", (gl2, loc) -> gl2.glUniform2f(loc.intValue(), (float)this.viewport[0], (float)this.viewport[1]));
        int sampleCount = 512;
        this.program.allocateUniform(this.gl, "depthSampleCount", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), sampleCount));
        this.program.allocateUniform(this.gl, "tex", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 0));
        this.program.allocateUniform(this.gl, "colorMap", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 1));
        this.program.allocateUniform(this.gl, "normals", (gl2, loc) -> gl2.glUniform1i(loc.intValue(), 2));
        this.program.allocateUniform(this.gl, "brightness", (gl2, loc) -> gl2.glUniform1f(loc.intValue(), this.getBrightness()));
        float[] aabbMin = this.volume.getAabbMin();
        float[] aabbMax = this.volume.getAabbMax();
        this.program.allocateUniform(this.gl, "aabbMin", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMin[0], aabbMin[1], aabbMin[2]));
        this.program.allocateUniform(this.gl, "aabbMax", (gl2, loc) -> gl2.glUniform3f(loc.intValue(), aabbMax[0], aabbMax[1], aabbMax[2]));
        this.program.setUniforms(this.gl);
    }

    @Override
    public void draw() {
        try {
            this.program.use(this.gl);
            this.setUniforms();
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableVertexAttribArray(0);
            this.gl.glVertexAttribPointer(0, 3, 5126, false, 12, 0L);
            this.gl.glActiveTexture(33985);
            this.gl.glBindTexture(3553, this.colorTexture);
            this.gl.glActiveTexture(33984);
            this.gl.glBindTexture(32879, this.volumeTexture);
            if (this.getRayCastingType() == RayCastingType.SPECULAR) {
                this.gl.glActiveTexture(33986);
                this.gl.glBindTexture(32879, this.normalsTexture);
            }
            this.gl.glDrawArrays(4, 0, this.volume.getVertexNumber());
            this.gl.glDisableVertexAttribArray(0);
            this.gl.glBindBuffer(34962, 0);
            this.gl.glActiveTexture(33984);
            this.gl.glBindTexture(3553, 0);
            this.gl.glBindTexture(32879, 0);
            this.gl.glUseProgram(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void dispose() {
        this.gl.glDeleteTextures(2, new int[]{this.volumeTexture, this.colorTexture}, 0);
        if (this.volume.getRayCastingType() == RayCastingType.SPECULAR) {
            this.gl.glActiveTexture(33986);
            this.gl.glBindTexture(32879, 0);
            this.gl.glDeleteTextures(1, new int[]{this.normalsTexture}, 0);
        }
    }
}

