/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.render.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.util.GLBuffers;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.List;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.meteoinfo.chart.graphic.cylinder.Cylinder;
import org.meteoinfo.chart.jogl.Program;
import org.meteoinfo.chart.jogl.Transform;
import org.meteoinfo.chart.jogl.Utils;
import org.meteoinfo.chart.render.jogl.JOGLGraphicRender;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.legend.StreamlineBreak;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.Polyline;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.math.Matrix4f;

public class LineRender
extends JOGLGraphicRender {
    private GraphicCollection3D graphics;
    private IntBuffer vbo;
    private Program program;
    private int vertexNum;
    private int sizePosition;
    private int sizeColor;
    private int sizeNormal;
    private float[] vertexPosition;
    private float[] vertexColor;
    private float lineWidth = 1.0f;
    private List<Integer> linePointNumbers;
    private boolean streamline = false;
    private IntBuffer vboCone;
    private float[] coneVertexPosition;
    private float[] coneVertexNormal;
    private float[] coneVertexColor;
    private int[] coneVertexIndices;
    private int sizeConePosition;
    private int sizeConeNormal;
    private int sizeConeColor;

    public LineRender(GL2 gl) {
        super(gl);
        if (this.useShader) {
            try {
                this.compileShaders();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.initVertexBuffer();
    }

    public LineRender(GL2 gl, GraphicCollection3D graphics) {
        this(gl);
        this.graphics = graphics;
        ColorBreak cb = graphics.getGraphicN(0).getLegend();
        PolylineBreak lineBreak = cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION ? (PolylineBreak)((ColorBreakCollection)cb).get(0) : (PolylineBreak)cb;
        this.streamline = lineBreak instanceof StreamlineBreak;
        this.updateVertexColor();
    }

    void compileShaders() throws Exception {
        String vertexShaderCode = Utils.loadResource("/shaders/surface/vertex.vert");
        String fragmentShaderCode = Utils.loadResource("/shaders/surface/surface.frag");
        this.program = new Program("surface", vertexShaderCode, fragmentShaderCode);
    }

    private void initVertexBuffer() {
        this.vbo = GLBuffers.newDirectIntBuffer((int)1);
    }

    private void updateVertexColor() {
        this.vertexNum = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            this.vertexNum += graphic.getShape().getPointNum();
        }
        this.vertexColor = new float[this.vertexNum * 4];
        int i = 0;
        for (Graphic graphic : this.graphics.getGraphics()) {
            float[] color;
            int n = graphic.getShape().getPointNum();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                for (int j = 0; j < n; ++j) {
                    PolylineBreak lineBreak = (PolylineBreak)((ColorBreakCollection)cb).get(j);
                    this.lineWidth = lineBreak.getWidth();
                    color = lineBreak.getColor().getRGBComponents(null);
                    System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                    ++i;
                }
                continue;
            }
            this.lineWidth = ((PolylineBreak)cb).getWidth();
            color = cb.getColor().getRGBComponents(null);
            for (int j = 0; j < n; ++j) {
                System.arraycopy(color, 0, this.vertexColor, i * 4, 4);
                ++i;
            }
        }
    }

    private float[] getVertexPosition() {
        this.vertexPosition = new float[this.vertexNum * 3];
        int i = 0;
        this.linePointNumbers = new ArrayList<Integer>();
        for (Graphic graphic : this.graphics.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            for (Polyline line : shape.getPolylines()) {
                List ps = line.getPointList();
                this.linePointNumbers.add(ps.size());
                for (PointZ p : ps) {
                    this.vertexPosition[i] = (float)p.X;
                    this.vertexPosition[i + 1] = (float)p.Y;
                    this.vertexPosition[i + 2] = (float)p.Z;
                    i += 3;
                }
            }
        }
        return this.vertexPosition;
    }

    private void updateVertexPosition() {
        this.vertexPosition = new float[this.vertexNum * 3];
        int i = 0;
        this.linePointNumbers = new ArrayList<Integer>();
        for (Graphic graphic : this.graphics.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            for (Polyline line : shape.getPolylines()) {
                List ps = line.getPointList();
                this.linePointNumbers.add(ps.size());
                for (PointZ p : ps) {
                    this.vertexPosition[i] = this.transform.transform_x((float)p.X);
                    this.vertexPosition[i + 1] = this.transform.transform_y((float)p.Y);
                    this.vertexPosition[i + 2] = this.transform.transform_z((float)p.Z);
                    i += 3;
                }
            }
        }
    }

    private void updateConeVertex() {
        ArrayList<Vector3f> vertexPositionList = new ArrayList<Vector3f>();
        ArrayList<Vector3f> vertexNormalList = new ArrayList<Vector3f>();
        ArrayList<Vector4f> vertexColorList = new ArrayList<Vector4f>();
        ArrayList<Integer> vertexIndices = new ArrayList<Integer>();
        Cylinder cylinder = null;
        for (Graphic graphic : this.graphics.getGraphics()) {
            PolylineZShape shape = (PolylineZShape)graphic.getShape();
            int pointNum = shape.getPointNum();
            List ps = shape.getPoints();
            ColorBreak cb = graphic.getLegend();
            if (cb.getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
                ColorBreakCollection cbc = (ColorBreakCollection)cb;
                StreamlineBreak slb = (StreamlineBreak)cbc.get(0);
                int interval = slb.getInterval();
                for (int i = 1; i < pointNum; ++i) {
                    if (i % interval != 0) continue;
                    PointZ p2 = (PointZ)ps.get(i);
                    PointZ p1 = (PointZ)ps.get(i - 1);
                    Vector3f v1 = this.transform.transform((float)p1.X, (float)p1.Y, (float)p1.Z);
                    Vector3f v2 = this.transform.transform((float)p2.X, (float)p2.Y, (float)p2.Z);
                    slb = (StreamlineBreak)cbc.get(i);
                    if (cylinder == null) {
                        cylinder = new Cylinder(slb.getArrowHeadWidth() * 0.02f, 0.0f, slb.getArrowHeadLength() * 0.02f, 8, 1, true);
                    }
                    Matrix4f matrix = new Matrix4f();
                    matrix.lookAt(v2.sub((Vector3fc)v1, new Vector3f()));
                    matrix.translate(v2);
                    List<Vector3f> vertices = cylinder.getVertices();
                    int n = vertices.size();
                    int nAdded = vertexPositionList.size();
                    for (Vector3f v : vertices) {
                        vertexPositionList.add(matrix.mul(v));
                    }
                    List<Vector3f> normals = cylinder.getNormals();
                    vertexNormalList.addAll(normals);
                    float[] color = slb.getColor().getRGBComponents(null);
                    for (int j = 0; j < n; ++j) {
                        vertexColorList.add(new Vector4f(color));
                    }
                    if (nAdded == 0) {
                        vertexIndices.addAll(cylinder.getIndices());
                        continue;
                    }
                    for (int idx : cylinder.getIndices()) {
                        vertexIndices.add(idx + nAdded);
                    }
                }
                continue;
            }
            StreamlineBreak slb = (StreamlineBreak)cb;
            int interval = slb.getInterval();
            for (int i = 1; i < pointNum; ++i) {
                if (i % interval != 0) continue;
                PointZ p2 = (PointZ)ps.get(i);
                PointZ p1 = (PointZ)ps.get(i - 1);
                Vector3f v1 = this.transform.transform((float)p1.X, (float)p1.Y, (float)p1.Z);
                Vector3f v2 = this.transform.transform((float)p2.X, (float)p2.Y, (float)p2.Z);
                if (cylinder == null) {
                    cylinder = new Cylinder(slb.getArrowHeadWidth() * 0.02f, 0.0f, slb.getArrowHeadLength() * 0.02f, 8, 1, true);
                }
                Matrix4f matrix = new Matrix4f();
                matrix.lookAt(v2.sub((Vector3fc)v1, new Vector3f()));
                matrix.translate(v2);
                List<Vector3f> vertices = cylinder.getVertices();
                int n = vertices.size();
                int nAdded = vertexPositionList.size();
                for (Vector3f v : vertices) {
                    vertexPositionList.add(matrix.mul(v));
                }
                List<Vector3f> normals = cylinder.getNormals();
                vertexNormalList.addAll(normals);
                float[] color = slb.getColor().getRGBComponents(null);
                for (int j = 0; j < n; ++j) {
                    vertexColorList.add(new Vector4f(color));
                }
                if (nAdded == 0) {
                    vertexIndices.addAll(cylinder.getIndices());
                    continue;
                }
                for (int idx : cylinder.getIndices()) {
                    vertexIndices.add(idx + nAdded);
                }
            }
        }
        int n = vertexPositionList.size();
        this.coneVertexPosition = new float[n * 3];
        this.coneVertexNormal = new float[n * 3];
        this.coneVertexColor = new float[n * 4];
        int i = 0;
        int j = 0;
        int k = 0;
        while (i < n) {
            Vector3f v = (Vector3f)vertexPositionList.get(i);
            this.coneVertexPosition[j] = v.x;
            this.coneVertexPosition[j + 1] = v.y;
            this.coneVertexPosition[j + 2] = v.z;
            v = (Vector3f)vertexNormalList.get(i);
            this.coneVertexNormal[j] = v.x;
            this.coneVertexNormal[j + 1] = v.y;
            this.coneVertexNormal[j + 2] = v.z;
            Vector4f v4 = (Vector4f)vertexColorList.get(i);
            this.coneVertexColor[k] = v4.x;
            this.coneVertexColor[k + 1] = v4.y;
            this.coneVertexColor[k + 2] = v4.z;
            this.coneVertexColor[k + 3] = v4.w;
            ++i;
            j += 3;
            k += 4;
        }
        this.coneVertexIndices = vertexIndices.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public void setTransform(Transform transform, boolean alwaysUpdateBuffers) {
        boolean updateBuffer = true;
        if (!alwaysUpdateBuffers && this.transform != null && this.transform.equals(transform)) {
            updateBuffer = false;
        }
        super.setTransform((Transform)transform.clone());
        if (updateBuffer) {
            if (this.vertexPosition == null) {
                this.getVertexPosition();
            }
            FloatBuffer vertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexPosition);
            this.sizePosition = vertexBuffer.capacity() * 4;
            FloatBuffer colorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.vertexColor);
            this.sizeColor = colorBuffer.capacity() * 4;
            int totalSize = this.sizePosition + this.sizeColor;
            this.gl.glGenBuffers(1, this.vbo);
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glBufferData(34962, (long)totalSize, null, 35044);
            this.gl.glBufferSubData(34962, 0L, (long)this.sizePosition, (Buffer)vertexBuffer);
            this.gl.glBufferSubData(34962, (long)this.sizePosition, (long)this.sizeColor, (Buffer)colorBuffer);
            this.gl.glBindBuffer(34962, 0);
            if (this.streamline) {
                this.updateConeVertex();
                FloatBuffer coneVertexBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexPosition);
                this.sizeConePosition = coneVertexBuffer.capacity() * 4;
                FloatBuffer coneNormalBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexNormal);
                this.sizeConeNormal = coneNormalBuffer.capacity() * 4;
                FloatBuffer coneColorBuffer = GLBuffers.newDirectFloatBuffer((float[])this.coneVertexColor);
                this.sizeConeColor = coneColorBuffer.capacity() * 4;
                this.vboCone = GLBuffers.newDirectIntBuffer((int)2);
                this.gl.glGenBuffers(2, this.vboCone);
                this.gl.glBindBuffer(34962, this.vboCone.get(0));
                this.gl.glBufferData(34962, (long)(this.sizeConePosition + this.sizeConeNormal + this.sizeConeColor), null, 35044);
                this.gl.glBufferSubData(34962, 0L, (long)this.sizeConePosition, (Buffer)coneVertexBuffer);
                this.gl.glBufferSubData(34962, (long)this.sizeConePosition, (long)this.sizeConeNormal, (Buffer)coneNormalBuffer);
                this.gl.glBufferSubData(34962, (long)(this.sizeConePosition + this.sizeConeNormal), (long)this.sizeConeColor, (Buffer)coneColorBuffer);
                this.gl.glBindBuffer(34962, 0);
                IntBuffer coneIndexBuffer = GLBuffers.newDirectIntBuffer((int[])this.coneVertexIndices);
                this.gl.glBindBuffer(34963, this.vboCone.get(1));
                this.gl.glBufferData(34963, (long)coneIndexBuffer.capacity() * 4L, (Buffer)coneIndexBuffer, 35044);
                this.gl.glBindBuffer(34963, 0);
            }
        }
    }

    void setUniforms() {
    }

    @Override
    public void draw() {
        if (this.useShader) {
            this.program.use(this.gl);
            this.setUniforms();
            this.gl.glUseProgram(0);
        } else {
            this.gl.glBindBuffer(34962, this.vbo.get(0));
            this.gl.glEnableClientState(32884);
            this.gl.glVertexPointer(3, 5126, 0, 0L);
            this.gl.glEnableClientState(32886);
            this.gl.glColorPointer(4, 5126, 0, (long)this.sizePosition);
            boolean lightEnabled = this.lighting.isEnable();
            if (lightEnabled) {
                this.lighting.stop(this.gl);
            }
            this.gl.glLineWidth(this.lineWidth * this.dpiScale);
            int sIdx = 0;
            for (int np : this.linePointNumbers) {
                this.gl.glDrawArrays(3, sIdx, np);
                sIdx += np;
            }
            if (lightEnabled) {
                this.lighting.start(this.gl);
            }
            this.gl.glDisableClientState(32884);
            this.gl.glDisableClientState(32886);
            this.gl.glBindBuffer(34962, 0);
            if (this.streamline) {
                this.gl.glPushMatrix();
                FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
                this.gl.glLoadMatrixf(this.modelViewMatrixR.get(fb));
                this.gl.glBindBuffer(34962, this.vboCone.get(0));
                this.gl.glBindBuffer(34963, this.vboCone.get(1));
                this.gl.glEnableClientState(32884);
                this.gl.glVertexPointer(3, 5126, 0, 0L);
                this.gl.glEnableClientState(32885);
                this.gl.glNormalPointer(5126, 0, (long)this.sizeConePosition);
                this.gl.glEnableClientState(32886);
                this.gl.glColorPointer(4, 5126, 0, (long)(this.sizeConePosition + this.sizeConeNormal));
                this.gl.glDrawElements(4, this.coneVertexIndices.length, 5125, 0L);
                this.gl.glDisableClientState(32884);
                this.gl.glDisableClientState(32885);
                this.gl.glDisableClientState(32886);
                this.gl.glBindBuffer(34962, 0);
                this.gl.glBindBuffer(34963, 0);
                this.gl.glPopMatrix();
            }
        }
    }
}

