/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.plot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.meteoinfo.chart.AspectType;
import org.meteoinfo.chart.plot.Plot2D;
import org.meteoinfo.common.PointF;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.shape.ArcShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.render.java2d.Draw;

public class PiePlot
extends Plot2D {
    public PiePlot() {
        this.aspectType = AspectType.EQUAL;
    }

    @Override
    protected void drawGraph(Graphics2D g, Rectangle2D area) {
        AffineTransform oldMatrix = g.getTransform();
        g.translate(area.getX(), area.getY());
        if (this.background != null) {
            g.setColor(this.getBackground());
            g.fill(new Rectangle2D.Double(0.0, 0.0, area.getWidth(), area.getHeight()));
        }
        for (int m = 0; m < this.getGraphics().getNumGraphics(); ++m) {
            Graphic graphic = this.getGraphics().get(m);
            ColorBreak cb = graphic.getLegend();
            float dist = 5.0f;
            float ex = this.getExplode();
            Font labelFont = ((GraphicCollection)graphic).getLabelSet().getLabelFont();
            Color labelColor = ((GraphicCollection)graphic).getLabelSet().getLabelColor();
            for (int i = 0; i < graphic.getNumGraphics(); ++i) {
                Graphic gg = graphic.getGraphicN(i);
                if (!graphic.isSingleLegend()) {
                    cb = gg.getLegend();
                }
                Shape shape = gg.getShape();
                this.drawArc(g, (ArcShape)shape, (PolygonBreak)cb, area, dist, ex, labelFont, labelColor);
            }
        }
        g.setTransform(oldMatrix);
    }

    private float getExplode() {
        Graphic graphic = this.getGraphics().get(0);
        float ex = 0.0f;
        for (int i = 0; i < graphic.getNumGraphics(); ++i) {
            Graphic gg = graphic.getGraphicN(i);
            ArcShape shape = (ArcShape)gg.getShape();
            if (!(shape.getExplode() > 0.0f)) continue;
            ex = 10.0f;
            break;
        }
        return ex;
    }

    @Override
    void drawArc(Graphics2D g, ArcShape aShape, PolygonBreak aPGB, Rectangle2D area, float dist, float ex, Font labelFont, Color labelColor) {
        float startAngle = aShape.getStartAngle();
        float sweepAngle = aShape.getSweepAngle();
        float angle = startAngle + sweepAngle / 2.0f;
        float space = 20.0f;
        Rectangle2D.Double rect = new Rectangle2D.Double(area.getX() + (double)ex + (double)space, area.getY() + (double)ex + (double)space, area.getWidth() - (double)ex - (double)space, area.getHeight() - (double)ex - (double)space);
        double dx = 0.0;
        double dy = 0.0;
        if (aShape.getExplode() > 0.0f) {
            dx = (double)ex * Math.cos((double)(360.0f - angle) * Math.PI / 180.0);
            dy = (double)ex * Math.sin((double)(360.0f - angle) * Math.PI / 180.0);
            ((Rectangle2D)rect).setRect(((RectangularShape)rect).getX() + dx, ((RectangularShape)rect).getY() + dy, ((RectangularShape)rect).getWidth(), ((RectangularShape)rect).getHeight());
        }
        float sx = (float)(((RectangularShape)rect).getX() - area.getX());
        float sy = (float)(((RectangularShape)rect).getY() - area.getY());
        Draw.drawPie((PointF)new PointF(sx, sy), (float)((float)((RectangularShape)rect).getWidth()), (float)((float)((RectangularShape)rect).getHeight()), (float)startAngle, (float)sweepAngle, (PolygonBreak)aPGB, (Graphics2D)g);
        PointF sPoint = new PointF((float)(((RectangularShape)rect).getWidth() * 0.5 + (double)sx), (float)(((RectangularShape)rect).getHeight() * 0.5 + (double)sy));
        String label = aPGB.getCaption();
        if (angle > 360.0f) {
            angle -= 360.0f;
        }
        float r = (float)(((RectangularShape)rect).getWidth() * 0.5) + dist;
        PointF lPoint = Draw.getPieLabelPoint((PointF)sPoint, (float)r, (float)angle);
        float x = lPoint.X;
        float y = lPoint.Y;
        Dimension dim = Draw.getStringDimension((String)label, (Graphics2D)g);
        float h = dim.height;
        float w = dim.width;
        if (angle >= 0.0f && angle < 45.0f) {
            y -= h;
        } else if (!(angle >= 45.0f) || !(angle < 90.0f)) {
            if (angle >= 90.0f && angle < 135.0f) {
                x -= w;
            } else if (angle >= 135.0f && angle < 225.0f) {
                x = x - w - 3.0f;
                y += h / 2.0f;
            } else if (angle >= 225.0f && angle < 270.0f) {
                x -= w / 2.0f;
                y += h;
            } else {
                y = angle >= 270.0f && angle < 315.0f ? (y += h) : (y += h / 2.0f);
            }
        }
        g.setFont(labelFont);
        g.setColor(labelColor);
        g.drawString(label, x, y);
    }
}

