/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl.mc;

import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import org.meteoinfo.chart.jogl.mc.CallbackMC;
import org.meteoinfo.chart.jogl.mc.MarchingCubes;
import org.meteoinfo.chart.jogl.mc.VolumeGenerator;

public class BenchmarkHandler {
    public static void benchmarkChar(File inputFile, File outFile, final int[] size, final float[] voxSize, final char isoValue, int nThreadsMin, int nThreadsMax, int iterations) {
        char[] scalarField;
        block17: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new char[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = (char)in.readByte();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldChar(size);
        }
        final char[] finalScalarField = scalarField;
        System.out.println("PROGRESS: Performing benchmark.");
        StringBuilder benchmarkResults = new StringBuilder();
        for (int nThreads = nThreadsMin; nThreads <= nThreadsMax; ++nThreads) {
            ArrayList<Double> times = new ArrayList<Double>();
            for (int it = 0; it < iterations; ++it) {
                int i;
                long start = System.currentTimeMillis();
                ArrayList<2> threads = new ArrayList<2>();
                final ArrayList results = new ArrayList();
                int remainder = size[2] % nThreads;
                int segment = size[2] / nThreads;
                int zAxisOffset = 0;
                for (i = 0; i < nThreads; ++i) {
                    int segmentSize = remainder-- > 0 ? segment + 1 : segment;
                    final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
                    final CallbackMC callback = new CallbackMC(){

                        @Override
                        public void run() {
                            results.add(this.getVertices());
                        }
                    };
                    final int finalZAxisOffset = zAxisOffset;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            MarchingCubes.marchingCubesChar(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                        }
                    };
                    threads.add(t);
                    t.start();
                    zAxisOffset += segmentSize;
                }
                for (i = 0; i < threads.size(); ++i) {
                    try {
                        ((Thread)threads.get(i)).join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long end = System.currentTimeMillis();
                times.add((double)(end - start) / 1000.0);
            }
            double sumTime = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sumTime += ((Double)times.get(i)).doubleValue();
            }
            double avgTime = sumTime / (double)iterations;
            double sd = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sd += Math.pow((Double)times.get(i) - avgTime, 2.0);
            }
            sd = Math.sqrt(sd / (double)iterations);
            System.out.println("Threads: " + nThreads);
            System.out.println("Iterations: " + iterations);
            System.out.println("Average time: " + avgTime + "s");
            System.out.println("Standard deviation: " + sd);
            System.out.println("-------------------------------------------------------------");
            benchmarkResults.append("Threads: " + nThreads);
            benchmarkResults.append("Iterations: " + iterations);
            benchmarkResults.append("Average time: " + avgTime + "s");
            benchmarkResults.append("Standard deviation: " + sd);
            benchmarkResults.append("-------------------------------------------------------------");
        }
        System.out.println("PROGRESS: Writing results to output file.");
        if (outFile != null) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outFile));
                osw.write(benchmarkResults.toString());
            }
            catch (Exception e) {
                System.out.println("Something went wrong while writing the results to file.");
                return;
            }
        }
    }

    public static void benchmarkShort(File inputFile, File outFile, final int[] size, final float[] voxSize, final short isoValue, int nThreadsMin, int nThreadsMax, int iterations) {
        short[] scalarField;
        block17: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new short[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readShort();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldShort(size);
        }
        final short[] finalScalarField = scalarField;
        System.out.println("PROGRESS: Performing benchmark.");
        StringBuilder benchmarkResults = new StringBuilder();
        for (int nThreads = nThreadsMin; nThreads <= nThreadsMax; ++nThreads) {
            ArrayList<Double> times = new ArrayList<Double>();
            for (int it = 0; it < iterations; ++it) {
                int i;
                long start = System.currentTimeMillis();
                ArrayList<4> threads = new ArrayList<4>();
                final ArrayList results = new ArrayList();
                int remainder = size[2] % nThreads;
                int segment = size[2] / nThreads;
                int zAxisOffset = 0;
                for (i = 0; i < nThreads; ++i) {
                    int segmentSize = remainder-- > 0 ? segment + 1 : segment;
                    final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
                    final CallbackMC callback = new CallbackMC(){

                        @Override
                        public void run() {
                            results.add(this.getVertices());
                        }
                    };
                    final int finalZAxisOffset = zAxisOffset;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            MarchingCubes.marchingCubesShort(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                        }
                    };
                    threads.add(t);
                    t.start();
                    zAxisOffset += segmentSize;
                }
                for (i = 0; i < threads.size(); ++i) {
                    try {
                        ((Thread)threads.get(i)).join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long end = System.currentTimeMillis();
                times.add((double)(end - start) / 1000.0);
            }
            double sumTime = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sumTime += ((Double)times.get(i)).doubleValue();
            }
            double avgTime = sumTime / (double)iterations;
            double sd = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sd += Math.pow((Double)times.get(i) - avgTime, 2.0);
            }
            sd = Math.sqrt(sd / (double)iterations);
            System.out.println("Threads: " + nThreads);
            System.out.println("Iterations: " + iterations);
            System.out.println("Average time: " + avgTime + "s");
            System.out.println("Standard deviation: " + sd);
            System.out.println("-------------------------------------------------------------");
            benchmarkResults.append("Threads: " + nThreads);
            benchmarkResults.append("Iterations: " + iterations);
            benchmarkResults.append("Average time: " + avgTime + "s");
            benchmarkResults.append("Standard deviation: " + sd);
            benchmarkResults.append("-------------------------------------------------------------");
        }
        System.out.println("PROGRESS: Writing results to output file.");
        if (outFile != null) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outFile));
                osw.write(benchmarkResults.toString());
            }
            catch (Exception e) {
                System.out.println("Something went wrong while writing the results to file.");
                return;
            }
        }
    }

    public static void benchmarkInt(File inputFile, File outFile, final int[] size, final float[] voxSize, final int isoValue, int nThreadsMin, int nThreadsMax, int iterations) {
        int[] scalarField;
        block17: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new int[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readInt();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldInt(size);
        }
        final int[] finalScalarField = scalarField;
        System.out.println("PROGRESS: Performing benchmark.");
        StringBuilder benchmarkResults = new StringBuilder();
        for (int nThreads = nThreadsMin; nThreads <= nThreadsMax; ++nThreads) {
            ArrayList<Double> times = new ArrayList<Double>();
            for (int it = 0; it < iterations; ++it) {
                int i;
                long start = System.currentTimeMillis();
                ArrayList<6> threads = new ArrayList<6>();
                final ArrayList results = new ArrayList();
                int remainder = size[2] % nThreads;
                int segment = size[2] / nThreads;
                int zAxisOffset = 0;
                for (i = 0; i < nThreads; ++i) {
                    int segmentSize = remainder-- > 0 ? segment + 1 : segment;
                    final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
                    final CallbackMC callback = new CallbackMC(){

                        @Override
                        public void run() {
                            results.add(this.getVertices());
                        }
                    };
                    final int finalZAxisOffset = zAxisOffset;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            MarchingCubes.marchingCubesInt(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                        }
                    };
                    threads.add(t);
                    t.start();
                    zAxisOffset += segmentSize;
                }
                for (i = 0; i < threads.size(); ++i) {
                    try {
                        ((Thread)threads.get(i)).join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long end = System.currentTimeMillis();
                times.add((double)(end - start) / 1000.0);
            }
            double sumTime = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sumTime += ((Double)times.get(i)).doubleValue();
            }
            double avgTime = sumTime / (double)iterations;
            double sd = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sd += Math.pow((Double)times.get(i) - avgTime, 2.0);
            }
            sd = Math.sqrt(sd / (double)iterations);
            System.out.println("Threads: " + nThreads);
            System.out.println("Iterations: " + iterations);
            System.out.println("Average time: " + avgTime + "s");
            System.out.println("Standard deviation: " + sd);
            System.out.println("-------------------------------------------------------------");
            benchmarkResults.append("Threads: " + nThreads);
            benchmarkResults.append("Iterations: " + iterations);
            benchmarkResults.append("Average time: " + avgTime + "s");
            benchmarkResults.append("Standard deviation: " + sd);
            benchmarkResults.append("-------------------------------------------------------------");
        }
        System.out.println("PROGRESS: Writing results to output file.");
        if (outFile != null) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outFile));
                osw.write(benchmarkResults.toString());
            }
            catch (Exception e) {
                System.out.println("Something went wrong while writing the results to file.");
                return;
            }
        }
    }

    public static void benchmarkFloat(File inputFile, File outFile, final int[] size, final float[] voxSize, final float isoValue, int nThreadsMin, int nThreadsMax, int iterations) {
        float[] scalarField;
        block17: {
            if (inputFile != null) {
                System.out.println("PROGRESS: Reading input data.");
                try {
                    int idx = 0;
                    scalarField = new float[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readFloat();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldFloat(size);
        }
        final float[] finalScalarField = scalarField;
        System.out.println("PROGRESS: Performing benchmark.");
        StringBuilder benchmarkResults = new StringBuilder();
        for (int nThreads = nThreadsMin; nThreads <= nThreadsMax; ++nThreads) {
            ArrayList<Double> times = new ArrayList<Double>();
            for (int it = 0; it < iterations; ++it) {
                int i;
                long start = System.currentTimeMillis();
                ArrayList<8> threads = new ArrayList<8>();
                final ArrayList results = new ArrayList();
                int remainder = size[2] % nThreads;
                int segment = size[2] / nThreads;
                int zAxisOffset = 0;
                for (i = 0; i < nThreads; ++i) {
                    int segmentSize = remainder-- > 0 ? segment + 1 : segment;
                    final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
                    final CallbackMC callback = new CallbackMC(){

                        @Override
                        public void run() {
                            results.add(this.getVertices());
                        }
                    };
                    final int finalZAxisOffset = zAxisOffset;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            MarchingCubes.marchingCubesFloat(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                        }
                    };
                    threads.add(t);
                    t.start();
                    zAxisOffset += segmentSize;
                }
                for (i = 0; i < threads.size(); ++i) {
                    try {
                        ((Thread)threads.get(i)).join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long end = System.currentTimeMillis();
                times.add((double)(end - start) / 1000.0);
            }
            double sumTime = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sumTime += ((Double)times.get(i)).doubleValue();
            }
            double avgTime = sumTime / (double)iterations;
            double sd = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sd += Math.pow((Double)times.get(i) - avgTime, 2.0);
            }
            sd = Math.sqrt(sd / (double)iterations);
            System.out.println("Threads: " + nThreads);
            System.out.println("Iterations: " + iterations);
            System.out.println("Average time: " + avgTime + "s");
            System.out.println("Standard deviation: " + sd);
            System.out.println("-------------------------------------------------------------");
            benchmarkResults.append("Threads: " + nThreads);
            benchmarkResults.append("Iterations: " + iterations);
            benchmarkResults.append("Average time: " + avgTime + "s");
            benchmarkResults.append("Standard deviation: " + sd);
            benchmarkResults.append("-------------------------------------------------------------");
        }
        System.out.println("PROGRESS: Writing results to output file.");
        if (outFile != null) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outFile));
                osw.write(benchmarkResults.toString());
            }
            catch (Exception e) {
                System.out.println("Something went wrong while writing the results to file.");
                return;
            }
        }
    }

    public static void benchmarkDouble(File inputFile, File outFile, final int[] size, final float[] voxSize, final double isoValue, int nThreadsMin, int nThreadsMax, int iterations) {
        double[] scalarField;
        block17: {
            if (inputFile != null) {
                try {
                    int idx = 0;
                    scalarField = new double[size[0] * size[1] * size[2]];
                    DataInputStream in = new DataInputStream(new FileInputStream(inputFile));
                    while (in.available() > 0) {
                        if (idx >= scalarField.length) {
                            in.close();
                            System.out.println("Invalid volume size was specified.");
                            return;
                        }
                        scalarField[idx++] = in.readDouble();
                    }
                    in.close();
                    if (idx != scalarField.length) {
                        System.out.println("Invalid volume size was specified.");
                        return;
                    }
                    break block17;
                }
                catch (Exception e) {
                    System.out.println("Something went wrong while reading the volume");
                    return;
                }
            }
            System.out.println("PROGRESS: Generating volume data.");
            scalarField = VolumeGenerator.generateScalarFieldDouble(size);
        }
        final double[] finalScalarField = scalarField;
        System.out.println("PROGRESS: Performing benchmark.");
        StringBuilder benchmarkResults = new StringBuilder();
        for (int nThreads = nThreadsMin; nThreads <= nThreadsMax; ++nThreads) {
            ArrayList<Double> times = new ArrayList<Double>();
            for (int it = 0; it < iterations; ++it) {
                int i;
                long start = System.currentTimeMillis();
                ArrayList<10> threads = new ArrayList<10>();
                final ArrayList results = new ArrayList();
                int remainder = size[2] % nThreads;
                int segment = size[2] / nThreads;
                int zAxisOffset = 0;
                for (i = 0; i < nThreads; ++i) {
                    int segmentSize = remainder-- > 0 ? segment + 1 : segment;
                    final int paddedSegmentSize = i != nThreads - 1 ? segmentSize + 1 : segmentSize;
                    final CallbackMC callback = new CallbackMC(){

                        @Override
                        public void run() {
                            results.add(this.getVertices());
                        }
                    };
                    final int finalZAxisOffset = zAxisOffset;
                    Thread t = new Thread(){

                        @Override
                        public void run() {
                            MarchingCubes.marchingCubesDouble(finalScalarField, new int[]{size[0], size[1], paddedSegmentSize}, size[2], voxSize, isoValue, finalZAxisOffset, callback);
                        }
                    };
                    threads.add(t);
                    t.start();
                    zAxisOffset += segmentSize;
                }
                for (i = 0; i < threads.size(); ++i) {
                    try {
                        ((Thread)threads.get(i)).join();
                        continue;
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
                long end = System.currentTimeMillis();
                times.add((double)(end - start) / 1000.0);
            }
            double sumTime = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sumTime += ((Double)times.get(i)).doubleValue();
            }
            double avgTime = sumTime / (double)iterations;
            double sd = 0.0;
            for (int i = 0; i < times.size(); ++i) {
                sd += Math.pow((Double)times.get(i) - avgTime, 2.0);
            }
            sd = Math.sqrt(sd / (double)iterations);
            System.out.println("Threads: " + nThreads);
            System.out.println("Iterations: " + iterations);
            System.out.println("Average time: " + avgTime + "s");
            System.out.println("Standard deviation: " + sd);
            System.out.println("-------------------------------------------------------------");
            benchmarkResults.append("Threads: " + nThreads);
            benchmarkResults.append("Iterations: " + iterations);
            benchmarkResults.append("Average time: " + avgTime + "s");
            benchmarkResults.append("Standard deviation: " + sd);
            benchmarkResults.append("-------------------------------------------------------------");
        }
        System.out.println("PROGRESS: Writing results to output file.");
        if (outFile != null) {
            try {
                OutputStreamWriter osw = new OutputStreamWriter(new FileOutputStream(outFile));
                osw.write(benchmarkResults.toString());
            }
            catch (Exception e) {
                System.out.println("Something went wrong while writing the results to file.");
                return;
            }
        }
    }
}

