/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.jogl;

import com.jogamp.common.nio.Buffers;
import com.jogamp.opengl.GL2;
import com.jogamp.opengl.GLAutoDrawable;
import java.awt.Color;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.nio.FloatBuffer;
import java.util.List;
import java.util.Objects;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.meteoinfo.chart.ChartColorBar;
import org.meteoinfo.chart.ChartText;
import org.meteoinfo.chart.graphic.GraphicFactory;
import org.meteoinfo.chart.graphic.MeshGraphic;
import org.meteoinfo.chart.jogl.GLPlot;
import org.meteoinfo.chart.jogl.SphericalTransform;
import org.meteoinfo.chart.jogl.ZAxisOption;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.XAlign;
import org.meteoinfo.common.YAlign;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.legend.LegendManage;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.image.ImageUtil;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayUtil;
import org.meteoinfo.projection.KnownCoordinateSystems;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.projection.ProjectionUtil;

public class EarthGLPlot
extends GLPlot {
    private float radius = 6371.0f;
    private MeshGraphic surface;
    private Extent3D dataExtent;

    public EarthGLPlot() {
        this.projInfo = KnownCoordinateSystems.geographic.world.WGS1984;
    }

    @Override
    public void initAngles() {
        this.angleX = -45.0f;
        this.angleY = 160.0f;
        this.headAngle = 0.0f;
        this.pitchAngle = 0.0f;
    }

    public float getRadius() {
        return this.radius;
    }

    public void setRadius(float value) {
        this.radius = value;
    }

    @Override
    public void setDrawExtent(Extent value) {
        this.drawExtent = (Extent3D)value;
        this.transform.setExtent(this.drawExtent);
    }

    void updateDataExtent() {
        this.xAxis.setMinMaxValue(this.dataExtent.minX, this.dataExtent.maxX);
        this.yAxis.setMinMaxValue(this.dataExtent.minY, this.dataExtent.maxY);
        this.zAxis.setMinMaxValue(this.dataExtent.minZ, this.dataExtent.maxZ);
    }

    @Override
    public void addGraphic(Graphic graphic) {
        this.dataExtent = this.dataExtent == null ? (Extent3D)graphic.getExtent() : this.dataExtent.union((Extent3D)graphic.getExtent());
        this.updateDataExtent();
        this.graphics.add(SphericalTransform.transform(graphic));
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        this.graphicExtent = (Extent3D)ex;
        this.setDrawExtent((Extent)((Extent3D)this.graphicExtent.clone()));
    }

    @Override
    public void addGraphic(int index, Graphic graphic) {
        this.dataExtent = this.dataExtent == null ? (Extent3D)graphic.getExtent() : this.dataExtent.union((Extent3D)graphic.getExtent());
        this.updateDataExtent();
        this.graphics.add(index, SphericalTransform.transform(graphic));
        Extent ex = this.graphics.getExtent();
        if (!ex.is3D()) {
            ex = ex.to3D();
        }
        this.graphicExtent = (Extent3D)ex;
        this.setDrawExtent((Extent)((Extent3D)this.graphicExtent.clone()));
    }

    @Override
    public void addGraphic(Graphic graphic, ProjectionInfo proj) {
        if (!proj.equals(this.projInfo)) {
            Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphic, (ProjectionInfo)proj, (ProjectionInfo)this.projInfo);
            this.addGraphic(nGraphic);
        } else {
            this.addGraphic(graphic);
        }
    }

    @Override
    public void addGraphic(int index, Graphic graphic, ProjectionInfo proj) {
        if (!proj.equals(this.projInfo)) {
            Graphic nGraphic = ProjectionUtil.projectGraphic((Graphic)graphic, (ProjectionInfo)proj, (ProjectionInfo)this.projInfo);
            this.addGraphic(index, nGraphic);
        } else {
            this.addGraphic(index, graphic);
        }
    }

    public MeshGraphic earthSurface(int n) {
        Array lon = ArrayUtil.lineSpace((Number)Float.valueOf(-180.0f), (Number)Float.valueOf(180.0f), (int)(n + 1), (boolean)true);
        Array lat = ArrayUtil.lineSpace((Number)Float.valueOf(-90.0f), (Number)Float.valueOf(90.0f), (int)(n + 1), (boolean)true);
        lat = lat.flip(0).copy();
        Array[] lonlat = ArrayUtil.meshgrid((Array)lon, (Array)lat);
        lon = lonlat[0];
        lat = lonlat[1];
        Array alt = ArrayUtil.zeros((int[])lon.getShape(), (DataType)DataType.FLOAT);
        LegendScheme ls = LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POLYGON, (Color)Color.cyan, (float)1.0f);
        ((PolygonBreak)ls.getLegendBreak(0)).setDrawOutline(false);
        ((PolygonBreak)ls.getLegendBreak(0)).setOutlineColor(Color.white);
        this.surface = GraphicFactory.surface(lon, lat, alt, ls);
        this.surface.setFaceInterp(true);
        return this.surface;
    }

    public void earthImage(String imageFile) throws IOException {
        BufferedImage image = ImageUtil.imageLoad((String)imageFile);
        if (this.surface == null) {
            this.earthSurface(50);
            this.addGraphic((Graphic)this.surface);
        }
        this.surface.setImage(image);
    }

    @Override
    public void display(GLAutoDrawable drawable) {
        GL2 gl = drawable.getGL().getGL2();
        gl.glLoadIdentity();
        this.updateTextRender(this.xAxis.getTickLabelFont());
        this.lighting.setPosition(gl);
        gl.glPushMatrix();
        this.modelViewMatrix = new Matrix4f();
        if (this.pitchAngle != 0.0f) {
            float ss = this.getScale();
            this.modelViewMatrix.translate(0.0f, 0.0f, ss);
            this.modelViewMatrix.rotate((float)Math.toRadians(70.0f * (this.pitchAngle / 90.0f)), 1.0f, 0.0f, 0.0f);
            this.modelViewMatrix.translate(0.0f, 0.0f, -ss);
        }
        this.modelViewMatrix.rotate((float)Math.toRadians(this.angleX), 1.0f, 0.0f, 0.0f);
        this.modelViewMatrix.rotate((float)Math.toRadians(this.angleY), 0.0f, 0.0f, 1.0f);
        if (this.headAngle != 0.0f) {
            this.modelViewMatrix.rotate((float)Math.toRadians(this.headAngle), 0.0f, 1.0f, 0.0f);
        }
        this.modelViewMatrixR = new Matrix4f((Matrix4fc)this.modelViewMatrix);
        Vector3f center = this.transform.getCenter();
        Vector3f scale = this.transform.getScale();
        this.modelViewMatrix.scale((Vector3fc)scale);
        this.modelViewMatrix.translate((Vector3fc)center.negate());
        FloatBuffer fb = Buffers.newDirectFloatBuffer((int)16);
        gl.glLoadMatrixf(this.modelViewMatrix.get(fb));
        this.updateMatrix(gl);
        this.setLight(gl);
        for (int m = 0; m < this.graphics.getNumGraphics(); ++m) {
            Graphic graphic = this.graphics.get(m);
            this.drawGraphics(gl, graphic);
        }
        if (this.lighting.isEnable()) {
            this.lighting.stop(gl);
        }
        this.drawAllZAxis(gl);
        gl.glPopMatrix();
        this.updateMatrix(gl);
        if (!this.legends.isEmpty()) {
            ChartColorBar legend = (ChartColorBar)((Object)this.legends.get(0));
            if (legend.getLegendScheme().getColorMap() == null) {
                this.drawLegend(gl, legend);
            } else {
                this.drawColorbar(gl, legend);
            }
        }
        this.drawTitle();
        this.textRenderer.dispose();
        this.textRenderer = null;
        gl.glFlush();
        if (this.alwaysUpdateBuffers) {
            this.alwaysUpdateBuffers = false;
        }
    }

    @Override
    protected void drawZAxis(GL2 gl, PointF loc) {
        ChartText label;
        float v;
        int skip = 1;
        float[] rgba = this.zAxis.getLineColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
        gl.glBegin(1);
        Vector3f xyz = SphericalTransform.transform(loc.X, loc.Y, (float)this.dataExtent.minZ);
        float x = xyz.x;
        float y = xyz.y;
        float z = xyz.z;
        gl.glVertex3f(x, y, z);
        xyz = SphericalTransform.transform(loc.X, loc.Y, (float)this.dataExtent.maxZ);
        x = xyz.x;
        y = xyz.y;
        z = xyz.z;
        gl.glVertex3f(x, y, z);
        gl.glEnd();
        this.zAxis.updateTickLabels();
        List<ChartText> tlabs = this.zAxis.getTickLabels();
        float x1 = x;
        float y1 = y;
        float f = this.zAxis.getTickLength();
        Objects.requireNonNull(this);
        float tickLen = f * 0.01f;
        XAlign xAlign = XAlign.RIGHT;
        YAlign yAlign = YAlign.CENTER;
        Vector3f center = this.transform.getCenter();
        float strWidth = 0.0f;
        for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
            v = (float)this.zAxis.getTickValues()[i];
            if ((double)v < this.dataExtent.minZ || (double)v > this.dataExtent.maxZ) continue;
            xyz = SphericalTransform.transform(loc.X, loc.Y, v);
            x = xyz.x;
            y = xyz.y;
            z = xyz.z;
            x1 = x;
            y1 = y;
            if (x < center.x) {
                if (y > center.y) {
                    y1 += tickLen;
                } else {
                    x1 -= tickLen;
                }
            } else if (y > center.y) {
                x1 += tickLen;
            } else {
                y1 -= tickLen;
            }
            if (i == tlabs.size()) break;
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(x, y, z);
            gl.glVertex3f(x1, y1, z);
            gl.glEnd();
            Rectangle2D rect = this.drawString(gl, tlabs.get(i), x1, y1, z, xAlign, yAlign, -this.tickSpace, 0.0f);
            if (!((double)strWidth < rect.getWidth())) continue;
            strWidth = (float)rect.getWidth();
        }
        if ((label = this.zAxis.getLabel()) != null) {
            v = (float)(this.dataExtent.minZ + this.dataExtent.maxZ) / 2.0f;
            xyz = SphericalTransform.transform(loc.X, loc.Y, v);
            x = xyz.x;
            y = xyz.y;
            z = xyz.z;
            x1 = x;
            y1 = y;
            if (x < center.x) {
                if (y > center.y) {
                    y1 += tickLen;
                } else {
                    x1 -= tickLen;
                }
            } else if (y > center.y) {
                x1 += tickLen;
            } else {
                y1 -= tickLen;
            }
            float yShift = strWidth + this.tickSpace * 3.0f;
            this.drawString(gl, label, x1, y1, z, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
        }
    }

    @Override
    protected void drawZAxis(GL2 gl, ZAxisOption zAxisOption) {
        ChartText label;
        float v;
        Matrix4f mvMatrix = this.toMatrix(this.mvmatrix);
        gl.glPushMatrix();
        int skip = 1;
        PointF loc = zAxisOption.getLocation();
        boolean left = zAxisOption.isLeft();
        float[] rgba = this.zAxis.getLineColor().getRGBComponents(null);
        gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
        gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
        gl.glBegin(1);
        Vector3f xyz = SphericalTransform.transform(loc.X, loc.Y, (float)this.dataExtent.minZ);
        gl.glVertex3f(xyz.x, xyz.y, xyz.z);
        Vector3f xyz1 = SphericalTransform.transform(loc.X, loc.Y, (float)this.dataExtent.maxZ);
        gl.glVertex3f(xyz1.x, xyz1.y, xyz1.z);
        gl.glEnd();
        gl.glLoadIdentity();
        this.updateMatrix(gl);
        this.zAxis.updateTickLabels();
        List<ChartText> tlabs = this.zAxis.getTickLabels();
        float f = this.zAxis.getTickLength();
        Objects.requireNonNull(this);
        float tickLen = f * 0.01f;
        XAlign xAlign = XAlign.RIGHT;
        YAlign yAlign = YAlign.CENTER;
        float strWidth = 0.0f;
        for (int i = 0; i < this.zAxis.getTickValues().length; i += skip) {
            float xShift;
            v = (float)this.zAxis.getTickValues()[i];
            if ((double)v < this.dataExtent.minZ || (double)v > this.dataExtent.maxZ) continue;
            xyz = SphericalTransform.transform(loc.X, loc.Y, v);
            mvMatrix.transformPosition(xyz);
            xyz1 = new Vector3f(xyz.x, xyz.y, xyz.z);
            if (left) {
                xyz1.x -= tickLen;
                xAlign = XAlign.RIGHT;
                xShift = -this.tickSpace;
            } else {
                xyz1.x += tickLen;
                xAlign = XAlign.LEFT;
                xShift = this.tickSpace;
            }
            if (i == tlabs.size()) break;
            rgba = this.zAxis.getLineColor().getRGBComponents(null);
            gl.glColor4f(rgba[0], rgba[1], rgba[2], rgba[3]);
            gl.glLineWidth(this.zAxis.getLineWidth() * this.dpiScale);
            gl.glBegin(1);
            gl.glVertex3f(xyz.x, xyz.y, xyz.z);
            gl.glVertex3f(xyz1.x, xyz1.y, xyz1.z);
            gl.glEnd();
            Rectangle2D rect = this.drawString(gl, tlabs.get(i), xyz1.x, xyz1.y, xyz1.z, xAlign, yAlign, xShift, 0.0f);
            if (!((double)strWidth < rect.getWidth())) continue;
            strWidth = (float)rect.getWidth();
        }
        if ((label = this.zAxis.getLabel()) != null) {
            float yShift;
            v = (float)(this.dataExtent.minZ + this.dataExtent.maxZ) / 2.0f;
            xyz = SphericalTransform.transform(loc.X, loc.Y, v);
            mvMatrix.transformPosition(xyz);
            if (left) {
                xyz.x -= tickLen;
                yShift = strWidth + this.tickSpace * 3.0f;
                this.drawString(gl, label, xyz.x, xyz.y, xyz.z, XAlign.CENTER, YAlign.BOTTOM, 90.0f, 0.0f, yShift);
            } else {
                xyz.x += tickLen;
                yShift = -(strWidth + this.tickSpace * 3.0f);
                this.drawString(gl, label, xyz.x, xyz.y, xyz.z, XAlign.CENTER, YAlign.TOP, 90.0f, 0.0f, yShift);
            }
        }
        gl.glPopMatrix();
        this.updateMatrix(gl);
    }

    @Override
    protected void drawPolygonShape(GL2 gl, Graphic graphic) {
        super.drawPolygonShape(gl, graphic);
    }
}

