/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.chart.graphic;

import java.util.ArrayList;
import java.util.List;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.graphic.GraphicCollection3D;
import org.meteoinfo.geometry.shape.PointZ;

public class IsosurfaceGraphics
extends GraphicCollection3D {
    private List<PointZ[]> triangles = new ArrayList<PointZ[]>();

    public IsosurfaceGraphics() {
        this.allTriangle = true;
    }

    public List<PointZ[]> getTriangles() {
        return this.triangles;
    }

    public void setTriangles(List<PointZ[]> value) {
        this.triangles = value;
        this.updateExtent();
    }

    public void addTriangle(PointZ[] triangle) {
        this.triangles.add(triangle);
        Extent3D extent = GeometryUtil.getExtent((PointZ[])triangle);
        if (this.triangles.size() == 1) {
            this.setExtent((Extent)extent);
        } else {
            this.setExtent(MIMath.getLagerExtent((Extent)extent, (Extent)this.getExtent()));
        }
    }

    public void updateExtent() {
        for (int i = 0; i < this.triangles.size(); ++i) {
            Extent3D extent = GeometryUtil.getExtent((PointZ[])this.triangles.get(i));
            if (i == 0) {
                this.setExtent((Extent)extent);
                continue;
            }
            this.setExtent(MIMath.getLagerExtent((Extent)extent, (Extent)this.getExtent()));
        }
    }
}

