/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.io.zarr;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.inventory.CollectionConfig;
import thredds.inventory.MController;
import thredds.inventory.MControllers;
import thredds.inventory.MFile;
import thredds.inventory.MFiles;
import ucar.nc2.util.cache.FileCacheable;
import ucar.unidata.io.RandomAccessFile;
import ucar.unidata.io.spi.RandomAccessFileProvider;
import ucar.unidata.io.zarr.RandomAccessDirectoryItem;
import ucar.unidata.io.zarr.VirtualRandomAccessFile;

public class RandomAccessDirectory
extends RandomAccessFile
implements FileCacheable,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(RandomAccessDirectory.class);
    protected List<RandomAccessDirectoryItem> children;
    private RandomAccessFile currentFile;
    private long currentFileStartPos = -1L;
    private static final String DELIMITER = "/";
    protected int bufferSize;
    private static final String WRITES_NOT_IMPLEMENTED_MESSAGE = "Method not implemented: writes are not implemented in RandomAccessDirectory";

    public RandomAccessDirectory(String location) throws IOException {
        this(location, 8092);
    }

    public RandomAccessDirectory(String location, int bufferSize) throws IOException {
        super(bufferSize);
        this.bufferSize = bufferSize;
        this.location = location.replace("\\", DELIMITER);
        this.readonly = true;
        this.children = new ArrayList<RandomAccessDirectoryItem>();
        MController controller = MControllers.create((String)location);
        CollectionConfig cc = new CollectionConfig("children", location, false, null, null);
        List<MFile> files = RandomAccessDirectory.sortIterator(controller.getInventoryAll(cc, false));
        if (files == null) {
            return;
        }
        long index = 0L;
        for (MFile mfile : files) {
            long length = mfile.getLength();
            this.children.add(new VirtualRandomAccessFile(mfile.getPath().replace("\\", DELIMITER), index, length, mfile.getLastModified(), this.bufferSize));
            index += length;
        }
    }

    private static List<MFile> sortIterator(Iterator<MFile> mfiles) {
        ArrayList<MFile> list = new ArrayList<MFile>();
        while (mfiles.hasNext()) {
            list.add(mfiles.next());
        }
        Collections.sort(list);
        return list;
    }

    public RandomAccessDirectoryItem getFileAtPos(int pos) {
        long tempPos = 0L;
        for (RandomAccessDirectoryItem item : this.children) {
            long rafLength = item.length();
            if (tempPos + rafLength > (long)pos) {
                return item;
            }
            tempPos += rafLength;
        }
        return null;
    }

    public List<RandomAccessDirectoryItem> getFilesInPath(String path) throws IOException {
        path = path.replace("\\", DELIMITER);
        ArrayList<RandomAccessDirectoryItem> files = new ArrayList<RandomAccessDirectoryItem>();
        for (RandomAccessDirectoryItem item : this.children) {
            String location = item.getLocation();
            if (!location.contains(path)) continue;
            files.add(item);
        }
        return files;
    }

    protected void setFileToPos(long pos) throws IOException {
        long tempPos = 0L;
        for (RandomAccessDirectoryItem item : this.children) {
            long rafLength = item.length();
            if (tempPos + rafLength > pos) {
                this.currentFile = item.getOrOpenRaf();
                this.currentFileStartPos = tempPos;
                return;
            }
            tempPos += rafLength;
        }
        this.currentFile = null;
        this.currentFileStartPos = -1L;
    }

    @Override
    public synchronized void close() throws IOException {
        for (RandomAccessDirectoryItem item : this.children) {
            RandomAccessFile raf = item.getRaf();
            if (raf == null) continue;
            raf.close();
        }
    }

    public long getLastModified() {
        return this.children.stream().mapToLong(RandomAccessDirectoryItem::getLastModified).max().orElse(-1L);
    }

    public boolean isDirectory() {
        return true;
    }

    public long length() {
        return this.children.stream().mapToLong(RandomAccessDirectoryItem::length).sum();
    }

    public long readToByteChannel(WritableByteChannel dest, long offset, long nbytes) throws IOException {
        long n;
        long count;
        for (n = 0L; n < nbytes; n += count) {
            if (this.currentFile == null || offset + n < this.currentFileStartPos || offset + n >= this.currentFileStartPos + this.currentFile.length()) {
                this.setFileToPos(offset + n);
                if (this.currentFile == null) break;
            }
            count = this.currentFile.readToByteChannel(dest, offset + n - this.currentFileStartPos, nbytes - n);
        }
        return n;
    }

    protected int read_(long pos, byte[] b, int offset, int len) throws IOException {
        int n = 0;
        while (n < len) {
            if (this.currentFile == null || pos < this.currentFileStartPos || pos >= this.currentFileStartPos + this.currentFile.length()) {
                this.setFileToPos(pos);
                if (this.currentFile == null) break;
            }
            this.currentFile.seek(pos - this.currentFileStartPos);
            int count = this.currentFile.read(b, offset + n, len - n);
            if (count < 0) break;
            n += count;
            pos += (long)count;
        }
        return n;
    }

    public void write(int b) {
        logger.error(WRITES_NOT_IMPLEMENTED_MESSAGE);
    }

    public void writeBytes(byte[] b, int off, int len) {
        logger.error(WRITES_NOT_IMPLEMENTED_MESSAGE);
    }

    public static class Provider
    implements RandomAccessFileProvider {
        public boolean isOwnerOf(String location) {
            try {
                return MFiles.create((String)location).isDirectory();
            }
            catch (Exception e) {
                return false;
            }
        }

        public RandomAccessFile open(String location) throws IOException {
            return new RandomAccessDirectory(location);
        }

        public RandomAccessFile open(String location, int bufferSize) throws IOException {
            return new RandomAccessDirectory(location, bufferSize);
        }
    }
}

