/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.zarr;

import java.nio.file.Paths;

public class ZarrUtils {
    public static int subscriptsToIndex(int[] subs, int[] nChunks) {
        int num = 0;
        int sz = 1;
        for (int i = subs.length - 1; i >= 0; --i) {
            num += sz * subs[i];
            sz *= nChunks[i];
        }
        return num;
    }

    public static String getDataFileName(String filePath) {
        String delim_key = "#delimiter=";
        int index = filePath.indexOf(delim_key);
        String delimiter = index < 0 ? "/" : filePath.substring(index + delim_key.length(), index + delim_key.length() + 1);
        String[] path = ZarrUtils.trimLocation(filePath).split(delimiter);
        String fileName = path[path.length - 1];
        for (int i = path.length - 2; i >= 0; --i) {
            try {
                Double.parseDouble(path[i]);
            }
            catch (NumberFormatException nfe) {
                break;
            }
            fileName = path[i] + delimiter + fileName;
        }
        return fileName;
    }

    public static String getObjectNameFromPath(String filePath) {
        try {
            return Paths.get(filePath, new String[0]).getParent().getFileName().toString();
        }
        catch (NullPointerException ex) {
            return "";
        }
    }

    public static String getParentGroupNameFromPath(String filePath, String rootPath) {
        try {
            return Paths.get(rootPath, new String[0]).relativize(Paths.get(filePath, new String[0]).getParent().getParent()).toString().replace("\\", "/");
        }
        catch (NullPointerException ex) {
            return "/";
        }
    }

    public static String trimLocation(String location) {
        if (location.contains(":")) {
            location = location.substring(location.indexOf(":") + 1);
        }
        if (location.contains("?")) {
            location = location.substring(location.indexOf("?") + 1);
        }
        if (location.contains("#")) {
            location = location.substring(0, location.lastIndexOf("#"));
        }
        if (location.endsWith("/")) {
            location = location.substring(0, location.length() - 1);
        }
        return location;
    }
}

