/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.operation.polygonize.Polygonizer;
import org.locationtech.jts.operation.union.CascadedPolygonUnion;
import org.locationtech.jts.operation.union.UnaryUnionOp;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.geoprocess.GeometryUtil;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public abstract class Shape
implements Cloneable {
    protected List<? extends PointD> points;
    protected boolean visible;
    protected boolean selected;
    private boolean editing;
    protected Extent extent = new Extent();
    protected int legendIndex = 0;
    protected double value;

    public Shape() {
        this.visible = true;
        this.editing = false;
        this.selected = false;
    }

    public Shape(Geometry geometry) {
    }

    public static Shape factory(ShapeTypes shapeType) {
        switch (shapeType) {
            case POINT: {
                return new PointShape();
            }
            case POINT_Z: {
                return new PointZShape();
            }
            case POLYLINE: {
                return new PolylineShape();
            }
            case POLYLINE_Z: {
                return new PolylineZShape();
            }
            case POLYGON: {
                return new PolygonShape();
            }
            case POLYGON_Z: {
                return new PolygonZShape();
            }
        }
        throw new IllegalArgumentException("Shape type not supported");
    }

    public abstract ShapeTypes getShapeType();

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean isTrue) {
        this.visible = isTrue;
    }

    public List<? extends PointD> getPoints() {
        return this.points;
    }

    public void setPoints(List<? extends PointD> points) {
        this.points = points;
        this.updateExtent();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean isTrue) {
        this.selected = isTrue;
    }

    public boolean isEditing() {
        return this.editing;
    }

    public void setEditing(boolean value) {
        this.editing = value;
    }

    public Extent getExtent() {
        return this.extent;
    }

    public void setExtent(Extent aExtent) {
        this.extent = aExtent;
    }

    public int getLegendIndex() {
        return this.legendIndex;
    }

    public void setLegendIndex(int value) {
        this.legendIndex = value;
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public void updateExtent() {
        if (this.points != null) {
            this.extent = GeometryUtil.getPointsExtent(this.points);
        }
    }

    public int getPointNum() {
        return 1;
    }

    public int getPartNum() {
        return 1;
    }

    public void addVertice(int vIdx, PointD vertice) {
    }

    public void removeVertice(int vIdx) {
    }

    public void moveVertice(int vIdx, double newX, double newY) {
        List<? extends PointD> points = this.getPoints();
        if (this.getShapeType().isPolygon()) {
            int last = points.size() - 1;
            if (vIdx == 0) {
                if (points.get((int)0).X == points.get((int)last).X && points.get((int)0).Y == points.get((int)last).Y) {
                    points.get((int)last).X = newX;
                    points.get((int)last).Y = newY;
                }
            } else if (vIdx == last && points.get((int)0).X == points.get((int)last).X && points.get((int)0).Y == points.get((int)last).Y) {
                points.get((int)0).X = newX;
                points.get((int)0).Y = newY;
            }
        }
        PointD aP = points.get(vIdx);
        aP.X = newX;
        aP.Y = newY;
        this.setPoints(points);
    }

    public void move(double xShift, double yShift) {
        List<? extends PointD> points = this.getPoints();
        for (PointD pointD : points) {
            pointD.X += xShift;
            pointD.Y += yShift;
        }
        this.setPoints(points);
    }

    public void reverse() {
    }

    public abstract Geometry toGeometry(GeometryFactory var1);

    public Geometry toGeometry() {
        return this.toGeometry(new GeometryFactory());
    }

    public static Shape geometry2Shape(Geometry geo) {
        switch (geo.getGeometryType()) {
            case "Point": 
            case "MultiPoint": {
                if (geo.getNumPoints() < 1) {
                    return null;
                }
                return new PointShape(geo);
            }
            case "LineString": 
            case "MultiLineString": {
                if (geo.getNumPoints() < 2) {
                    return null;
                }
                return new PolylineShape(geo);
            }
            case "Polygon": 
            case "MultiPolygon": {
                if (geo.getNumPoints() < 3) {
                    return null;
                }
                return new PolygonShape(geo);
            }
        }
        return null;
    }

    public Shape intersection(Shape b) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = b.toGeometry();
        Geometry g3 = g1.intersection(g2);
        return Shape.geometry2Shape(g3);
    }

    public Shape union(Shape b) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = b.toGeometry();
        Geometry g3 = g1.union(g2);
        return Shape.geometry2Shape(g3);
    }

    public Shape difference(Shape b) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = b.toGeometry();
        Geometry g3 = g1.difference(g2);
        return Shape.geometry2Shape(g3);
    }

    public Shape symDifference(Shape b) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = b.toGeometry();
        Geometry g3 = g1.symDifference(g2);
        return Shape.geometry2Shape(g3);
    }

    public Shape buffer(double distance) {
        Geometry g1 = this.toGeometry();
        Geometry g3 = g1.buffer(distance);
        return Shape.geometry2Shape(g3);
    }

    public Shape convexHull() {
        Geometry g1 = this.toGeometry();
        Geometry g3 = g1.convexHull();
        return Shape.geometry2Shape(g3);
    }

    public List<Shape> split(Shape line) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = line.toGeometry();
        if (this.getShapeType().isPolygon()) {
            Polygonizer polygonizer = new Polygonizer();
            Geometry polygons = g1.getBoundary().union(g2);
            polygonizer.add(polygons);
            List polys = (List)polygonizer.getPolygons();
            ArrayList<Shape> polyShapes = new ArrayList<Shape>();
            for (int i = 0; i < polys.size(); ++i) {
                Polygon poly = (Polygon)polys.get(i);
                if (!poly.getInteriorPoint().within(g1)) continue;
                polyShapes.add(new PolygonShape((Geometry)poly));
            }
            return polyShapes;
        }
        if (this.getShapeType().isLine()) {
            Geometry ugeo = g1.union(g2);
            ArrayList<Shape> lineShapes = new ArrayList<Shape>();
            for (int i = 0; i < ugeo.getNumGeometries(); ++i) {
                Geometry geo = ugeo.getGeometryN(i);
                if (!geo.buffer(0.001).within(g1.buffer(0.0011))) continue;
                lineShapes.add(new PolylineShape(geo));
            }
            return lineShapes;
        }
        return null;
    }

    public Shape reform(Shape line) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = line.toGeometry();
        if (this.getShapeType().isPolygon()) {
            Geometry mbgeo;
            Polygonizer polygonizer = new Polygonizer();
            Geometry polygons = g1.getBoundary().union(g2);
            polygonizer.add(polygons);
            List polys = (List)polygonizer.getPolygons();
            Polygon poly1 = (Polygon)g1;
            if (poly1.getNumInteriorRing() == 0) {
                mbgeo = CascadedPolygonUnion.union((Collection)polys);
            } else {
                GeometryFactory factory = new GeometryFactory();
                Polygon shell = factory.createPolygon(poly1.getExteriorRing());
                ArrayList<Polygon> npolys = new ArrayList<Polygon>();
                for (int i = 0; i < polys.size(); ++i) {
                    Polygon poly = (Polygon)polys.get(i);
                    if (poly.getInteriorPoint().within(g1)) {
                        npolys.add(poly);
                        continue;
                    }
                    if (poly.getInteriorPoint().within((Geometry)shell)) continue;
                    npolys.add(poly);
                }
                mbgeo = CascadedPolygonUnion.union(npolys);
            }
            PolygonShape r = new PolygonShape(mbgeo);
            return r;
        }
        if (this.getShapeType().isLine()) {
            Geometry ugeo = g1.union(g2);
            ArrayList<Geometry> geos = new ArrayList<Geometry>();
            for (int i = 0; i < ugeo.getNumGeometries(); ++i) {
                Geometry geo = ugeo.getGeometryN(i);
                Coordinate c1 = geo.getCoordinates()[0];
                Coordinate c2 = geo.getCoordinates()[geo.getNumPoints() - 1];
                if (c1.equals2D(g1.getCoordinates()[0]) || c1.equals2D(g1.getCoordinates()[g1.getNumPoints() - 1]) || c2.equals2D(g1.getCoordinates()[0]) || c2.equals2D(g1.getCoordinates()[g1.getNumPoints() - 1])) {
                    geos.add(geo);
                    continue;
                }
                GeometryFactory factory = new GeometryFactory();
                Point p1 = factory.createPoint(c1);
                Point p2 = factory.createPoint(c2);
                Geometry buffer = g1.buffer(0.001);
                if (!p1.within(buffer) || !p2.within(buffer) || geo.buffer(0.001).within(g1.buffer(0.0011))) continue;
                geos.add(geo);
            }
            Geometry geo = UnaryUnionOp.union(geos);
            return new PolylineShape(geo);
        }
        return null;
    }

    public boolean crosses(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.crosses(g2);
    }

    public boolean contains(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.contains(g2);
    }

    public boolean coveredBy(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.coveredBy(g2);
    }

    public boolean covers(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.covers(g2);
    }

    public boolean disjoint(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.disjoint(g2);
    }

    public boolean equals(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.equals(g2);
    }

    public boolean intersects(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.intersects(g2);
    }

    public boolean overlaps(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.overlaps(g2);
    }

    public boolean touches(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.touches(g2);
    }

    public boolean within(Shape other) {
        Geometry g1 = this.toGeometry();
        Geometry g2 = other.toGeometry();
        return g1.within(g2);
    }

    public Object clone() {
        Shape o = null;
        try {
            o = (Shape)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return o;
    }

    public void cloneValue(Shape other) {
    }
}

