/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.shape;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.ShapeTypes;

public class PolylineZShape
extends PolylineShape {
    public PolylineZShape() {
    }

    public PolylineZShape(List<PointZ> points) {
        this.setPoints(points);
    }

    public PolylineZShape(Geometry geometry) {
        Coordinate[] cs = geometry.getCoordinates();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (Coordinate c1 : cs) {
            CoordinateXYZM c = (CoordinateXYZM)c1;
            points.add(new PointZ(c.x, c.y, c.getZ(), c.getM()));
        }
        this.setPoints(points);
    }

    @Override
    public ShapeTypes getShapeType() {
        return ShapeTypes.POLYLINE_Z;
    }

    public double[] getZArray() {
        double[] zArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            zArray[i] = ((PointZ)this.getPoints().get((int)i)).Z;
        }
        return zArray;
    }

    public double[] getMArray() {
        double[] mArray = new double[this.getPoints().size()];
        for (int i = 0; i < this.getPoints().size(); ++i) {
            mArray[i] = ((PointZ)this.getPoints().get((int)i)).M;
        }
        return mArray;
    }

    public double[] getZRange() {
        return MIMath.arrayMinMax((double[])this.getZArray());
    }

    public double[] getMRange() {
        return MIMath.arrayMinMax((double[])this.getMArray());
    }

    @Override
    public Object clone() {
        PolylineZShape aPLS = new PolylineZShape();
        aPLS.setValue(this.getValue());
        aPLS.setExtent((Extent)this.getExtent().clone());
        aPLS.setPartNum(this.getPartNum());
        aPLS.parts = (int[])this.parts.clone();
        ArrayList<PointZ> points = new ArrayList<PointZ>();
        for (PointZ pointZ : this.getPoints()) {
            points.add((PointZ)pointZ.clone());
        }
        aPLS.setPoints(points);
        aPLS.setVisible(this.isVisible());
        aPLS.setSelected(this.isSelected());
        aPLS.setLegendIndex(this.getLegendIndex());
        return aPLS;
    }

    @Override
    public Object valueClone() {
        PolylineZShape aPLS = new PolylineZShape();
        aPLS.setValue(this.getValue());
        aPLS.setVisible(this.isVisible());
        aPLS.setSelected(this.isSelected());
        aPLS.setLegendIndex(this.getLegendIndex());
        return aPLS;
    }
}

