/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.graphic;

import java.awt.Color;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointD;
import org.meteoinfo.geometry.graphic.Graphic;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.legend.BreakTypes;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.ColorBreakCollection;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PolygonZ;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.Shape;

public class GraphicCollection3D
extends GraphicCollection {
    private boolean fixZ = false;
    private double zValue;
    private String zdir = "z";
    private List<Number> sePoint = null;
    protected boolean allQuads = false;
    protected boolean allTriangle = false;
    protected boolean allConvexPolygon = false;
    protected boolean usingLight = true;
    protected boolean sphere = false;

    @Override
    public void setLegendScheme(LegendScheme value) {
        super.setLegendScheme(value);
    }

    @Override
    public boolean is3D() {
        return true;
    }

    public boolean isFixZ() {
        return this.fixZ;
    }

    public void setFixZ(boolean value) {
        this.fixZ = value;
    }

    public double getZValue() {
        return this.zValue;
    }

    public void setZValue(double value) {
        this.zValue = value;
    }

    public String getZDir() {
        return this.zdir;
    }

    public void setZDir(String value) {
        this.zdir = value;
    }

    public List<Number> getSEPoint() {
        return this.sePoint;
    }

    public void setSEPoint(List<Number> value) {
        this.sePoint = value;
    }

    public boolean isAllQuads() {
        return this.allQuads;
    }

    public void setAllQuads(boolean value) {
        this.allQuads = value;
    }

    public boolean isAllTriangle() {
        return this.allTriangle;
    }

    public void setAllTriangle(boolean value) {
        this.allTriangle = value;
    }

    public boolean isAllConvexPolygon() {
        if (this.allConvexPolygon) {
            return true;
        }
        return this.allQuads || this.allTriangle;
    }

    public void setAllConvexPolygon(boolean value) {
        this.allConvexPolygon = value;
    }

    public boolean isUsingLight() {
        return this.usingLight;
    }

    public void setUsingLight(boolean value) {
        this.usingLight = value;
    }

    public boolean isSphere() {
        return this.sphere;
    }

    public void setSphere(boolean value) {
        this.sphere = value;
    }

    public void updateLegendScheme(LegendScheme value) {
        this.setLegendScheme(value);
        if (!this.graphics.isEmpty() && this.getGraphicN(0).getLegend().getBreakType() == BreakTypes.COLOR_BREAK_COLLECTION) {
            for (Graphic graphic : this.graphics) {
                ColorBreakCollection cbs = new ColorBreakCollection();
                Shape shape = graphic.getShape();
                for (PointZ pointZ : shape.getPoints()) {
                    ColorBreak cb = this.legendScheme.findLegendBreak(pointZ.M);
                    cbs.add(cb);
                }
                graphic.setLegend(cbs);
            }
        }
    }

    @Override
    public GraphicCollection3D xShift(double xs) {
        for (Graphic g : this.graphics) {
            for (PointD pointD : g.getShape().getPoints()) {
                pointD.X += xs;
            }
            g.setExtent((Extent)((Extent3D)g.getExtent()).shift(xs, 0.0, 0.0));
        }
        this.extent.shift(xs, 0.0);
        return this;
    }

    public GraphicCollection3D xRandomShift(int exponent) {
        Random r = new Random();
        for (Graphic g : this.graphics) {
            for (PointD pointD : g.getShape().getPoints()) {
                pointD.X += (1.0 - r.nextDouble()) * Math.pow(10.0, exponent);
            }
        }
        return this;
    }

    public GraphicCollection3D yRandomShift(int exponent) {
        Random r = new Random();
        for (Graphic g : this.graphics) {
            for (PointD pointD : g.getShape().getPoints()) {
                pointD.Y += (1.0 - r.nextDouble()) * Math.pow(10.0, exponent);
            }
        }
        return this;
    }

    public GraphicCollection3D randomShift(int exponent) {
        if (this.zdir.equals("x")) {
            return this.xRandomShift(exponent);
        }
        return this.yRandomShift(exponent);
    }

    public void saveFile(String fileName) throws IOException {
        File file = new File(fileName);
        BufferedWriter sw = new BufferedWriter(new FileWriter(file));
        sw.write("Polygons");
        sw.newLine();
        sw.write(String.valueOf(this.graphics.size()));
        sw.newLine();
        for (Graphic g : this.graphics) {
            Shape shape = g.getShape();
            switch (shape.getShapeType()) {
                case POLYGON_Z: {
                    sw.write("Polygon");
                    sw.newLine();
                    PolygonZShape polygonZShape = (PolygonZShape)shape;
                    PolygonZ polygonZ = (PolygonZ)polygonZShape.getPolygons().get(0);
                    sw.write("Color");
                    sw.newLine();
                    Color color = g.getLegend().getColor();
                    sw.write(String.valueOf(color.getRGB()));
                    sw.newLine();
                    sw.write("Outline");
                    sw.newLine();
                    sw.write(String.valueOf(polygonZ.getOutLine().size()));
                    sw.newLine();
                    for (PointZ pointZ : polygonZ.getOutLine()) {
                        sw.write(String.valueOf(pointZ.X) + "," + String.valueOf(pointZ.Y) + "," + String.valueOf(pointZ.Z));
                        sw.newLine();
                    }
                    sw.write(String.valueOf(polygonZ.getHoleLineNumber()));
                    sw.newLine();
                    if (!polygonZ.hasHole()) break;
                    for (int i = 0; i < polygonZ.getHoleLineNumber(); ++i) {
                        List<? extends PointD> list = polygonZ.getHoleLine(i);
                        sw.write("Hole");
                        sw.newLine();
                        sw.write(String.valueOf(list.size()));
                        sw.newLine();
                        for (PointZ pointZ : list) {
                            sw.write(String.valueOf(pointZ.X) + "," + String.valueOf(pointZ.Y) + "," + String.valueOf(pointZ.Z));
                            sw.newLine();
                        }
                    }
                    break;
                }
            }
        }
        sw.flush();
        sw.close();
    }
}

