/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geometry.colors;

import java.awt.Color;
import java.util.List;
import org.meteoinfo.geometry.colors.Normalize;

public class OpacityTransferFunction {
    private float[] opacityLevels;
    private float[] opacityNodes;

    public OpacityTransferFunction() {
        this.opacityLevels = new float[]{0.0f, 1.0f};
        this.opacityNodes = new float[]{0.0f, 1.0f};
    }

    public OpacityTransferFunction(List<Number> opacityNodes, List<Number> opacityLevels) {
        this.opacityNodes = new float[opacityNodes.size()];
        this.opacityLevels = new float[opacityLevels.size()];
        for (int i = 0; i < this.opacityNodes.length; ++i) {
            this.opacityNodes[i] = opacityNodes.get(i).floatValue();
            this.opacityLevels[i] = opacityLevels.get(i).floatValue();
        }
    }

    public OpacityTransferFunction(List<Number> opacityNodes, List<Number> opacityLevels, Normalize normalize) {
        int n = opacityLevels.size();
        this.opacityNodes = new float[n];
        this.opacityLevels = new float[n];
        if (opacityNodes == null) {
            for (int i = 0; i < n; ++i) {
                this.opacityNodes[i] = (float)i / (float)(n - 1);
                this.opacityLevels[i] = opacityLevels.get(i).floatValue();
            }
        } else {
            for (int i = 0; i < n; ++i) {
                this.opacityNodes[i] = normalize.apply(opacityNodes.get(i).doubleValue()).floatValue();
                this.opacityLevels[i] = opacityLevels.get(i).floatValue();
            }
        }
    }

    public float[] getOpacityNodes() {
        return this.opacityNodes;
    }

    public void setOpacityNodes(float[] opacityNodes) {
        this.opacityNodes = opacityNodes;
    }

    public float[] getOpacityLevels() {
        return this.opacityLevels;
    }

    public void setOpacityLevels(float[] opacityLevels) {
        this.opacityLevels = opacityLevels;
    }

    public int getNodeIndex(float node) {
        int idx = -1;
        for (int i = 0; i < this.opacityNodes.length; ++i) {
            if (!(node < this.opacityNodes[i])) continue;
            idx = i;
            break;
        }
        if (idx == -1) {
            idx = this.opacityNodes.length;
        }
        return idx;
    }

    public float getNode(int i) {
        return this.opacityNodes[i];
    }

    public float getLevel(int i) {
        return this.opacityLevels[i];
    }

    public int size() {
        return this.opacityLevels.length;
    }

    public float getOpacity(float nodeValue) {
        int idx = this.getNodeIndex(nodeValue);
        int n = this.size();
        if (idx == 0) {
            return this.opacityLevels[idx];
        }
        if (idx == n) {
            return this.opacityLevels[n - 1];
        }
        float node1 = this.opacityNodes[idx - 1];
        float node2 = this.opacityNodes[idx];
        float level1 = this.opacityLevels[idx - 1];
        float level2 = this.opacityLevels[idx];
        float level = level1 + (nodeValue - node1) / (node2 - node1) * (level2 - level1);
        return level;
    }

    public byte[] getColors(Color[] colors) {
        int n = colors.length;
        byte[] nColors = new byte[n * 4];
        for (int i = 0; i < n; ++i) {
            float node = (float)i / (float)(n - 1);
            float a = this.getOpacity(node);
            Color color = colors[i];
            int r = color.getRed();
            int g = color.getGreen();
            int b = color.getBlue();
            nColors[i * 4 + 0] = (byte)r;
            nColors[i * 4 + 1] = (byte)g;
            nColors[i * 4 + 2] = (byte)b;
            nColors[i * 4 + 3] = (byte)Math.round(a * 255.0f);
        }
        return nColors;
    }

    public byte[] getColors(byte[] colors) {
        int n = colors.length / 3;
        byte[] nColors = new byte[n * 4];
        for (int i = 0; i < n; ++i) {
            float node = (float)i / (float)n;
            float a = this.getOpacity(node);
            float r = (float)Byte.toUnsignedInt(colors[i * 3 + 0]) / 255.0f;
            float g = (float)Byte.toUnsignedInt(colors[i * 3 + 1]) / 255.0f;
            float b = (float)Byte.toUnsignedInt(colors[i * 3 + 2]) / 255.0f;
            r = r * r * a;
            g = g * g * a;
            b = b * b * a;
            nColors[i * 4 + 0] = (byte)Math.round(r * 255.0f);
            nColors[i * 4 + 1] = (byte)Math.round(g * 255.0f);
            nColors[i * 4 + 2] = (byte)Math.round(b * 255.0f);
            nColors[i * 4 + 3] = (byte)Math.round(a * 255.0f);
        }
        return nColors;
    }
}

