/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.image.ndimage;

import java.util.ArrayList;
import org.meteoinfo.image.ndimage.Correlate1D;
import org.meteoinfo.image.ndimage.ExtendMode;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.Index;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;

public class UniformFilter {
    int size = 3;
    ExtendMode mode;
    double cValue = 0.0;

    public UniformFilter(int size, ExtendMode mode) {
        this.size = size;
        this.mode = mode;
    }

    public UniformFilter(int size) {
        this(size, ExtendMode.REFLECT);
    }

    public ExtendMode getMode() {
        return this.mode;
    }

    public void setMode(ExtendMode value) {
        this.mode = value;
    }

    public double getCValue() {
        return this.cValue;
    }

    public void setCValue(double value) {
        this.cValue = value;
    }

    private double[] getWeights() {
        int i;
        double[] weights = new double[this.size];
        double sum = 0.0;
        for (i = 0; i < this.size; ++i) {
            double g = 1.0;
            sum += g;
            weights[i] = g;
        }
        i = 0;
        while (i < this.size) {
            int n = i++;
            weights[n] = weights[n] / sum;
        }
        return weights;
    }

    public Array filter(Array data) throws InvalidRangeException {
        double[] weights = this.getWeights();
        Array aWeights = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{weights.length}, (Object)weights);
        Correlate1D correlate1D = new Correlate1D(aWeights, this.mode);
        int ndim = data.getRank();
        int[] shape = data.getShape();
        Array r = Array.factory((DataType)data.getDataType(), (int[])shape);
        Index rindex = r.getIndex();
        int[] rcurrent = new int[ndim];
        for (int axis = 0; axis < ndim; ++axis) {
            int[] nshape = new int[ndim - 1];
            for (int i = 0; i < ndim; ++i) {
                if (i < axis) {
                    nshape[i] = shape[i];
                    continue;
                }
                if (i <= axis) continue;
                nshape[i - 1] = shape[i];
            }
            Index index = Index.factory((int[])nshape);
            int i = 0;
            while ((long)i < index.getSize()) {
                int[] current = index.getCurrentCounter();
                ArrayList<Range> ranges = new ArrayList<Range>();
                for (int j = 0; j < ndim; ++j) {
                    if (j == axis) {
                        ranges.add(new Range(0, shape[j] - 1, 1));
                        rcurrent[j] = 0;
                        continue;
                    }
                    int idx = j;
                    if (idx > axis) {
                        --idx;
                    }
                    ranges.add(new Range(current[idx], current[idx], 1));
                    rcurrent[j] = current[idx];
                }
                Array temp = data.section(ranges);
                temp = correlate1D.correlate(temp);
                for (int j = 0; j < shape[axis]; ++j) {
                    rcurrent[axis] = j;
                    rindex.set(rcurrent);
                    r.setDouble(rindex, temp.getDouble(j));
                }
                index.incr();
                ++i;
            }
        }
        return r;
    }
}

