/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.table;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.DataColumn;

public class DataColumnCollection
extends ArrayList<DataColumn> {
    Map nameMap = new HashMap();

    public DataColumnCollection() {
    }

    public DataColumnCollection(List<DataColumn> dcs) {
        for (DataColumn dc : dcs) {
            this.add(dc);
        }
    }

    @Override
    public boolean add(DataColumn aCol) {
        boolean isTrue = super.add(aCol);
        this.nameMap.put(aCol.getColumnName(), aCol);
        return isTrue;
    }

    @Override
    public void add(int index, DataColumn aCol) {
        super.add(index, aCol);
        this.nameMap.put(aCol.getColumnName(), aCol);
    }

    public DataColumn add(String colName, DataType dataType) {
        DataColumn aCol = new DataColumn(colName, dataType);
        this.add(aCol);
        this.nameMap.put(aCol.getColumnName(), aCol);
        return aCol;
    }

    public DataColumn get(String colName) {
        return (DataColumn)this.nameMap.get(colName);
    }

    public void renameColumn(DataColumn column, String name) {
        String oldName = column.getColumnName();
        column.setColumnName(name);
        this.nameMap.remove(oldName);
        this.nameMap.put(name, column);
    }

    public List<String> getColumnNames() {
        ArrayList<String> colNames = new ArrayList<String>();
        for (DataColumn col : this) {
            colNames.add(col.getColumnName());
        }
        return colNames;
    }
}

