/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.title;

import bibliothek.gui.DockController;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.themes.basic.action.BasicTitleViewItem;
import bibliothek.gui.dock.themes.basic.action.buttons.ButtonPanel;
import bibliothek.gui.dock.title.AbstractMultiDockTitle;
import bibliothek.gui.dock.title.ActionsDockTitleEvent;
import bibliothek.gui.dock.title.DockTitle;
import bibliothek.gui.dock.title.DockTitleEvent;
import bibliothek.gui.dock.title.DockTitleVersion;
import bibliothek.gui.dock.util.swing.OrientedLabel;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JComponent;

public class AbstractDockTitle
extends AbstractMultiDockTitle {
    private ButtonPanel itemPanel;
    private DockActionSource suggestedSource;

    public AbstractDockTitle(Dockable dockable, DockTitleVersion origin) {
        this.init(dockable, origin, true);
    }

    public AbstractDockTitle(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        this.init(dockable, origin, showMiniButtons);
    }

    protected AbstractDockTitle() {
    }

    protected void init(Dockable dockable, DockTitleVersion origin, boolean showMiniButtons) {
        super.init(dockable, origin);
        this.setShowMiniButtons(showMiniButtons);
    }

    public boolean isShowMiniButtons() {
        return this.itemPanel != null;
    }

    public void setShowMiniButtons(boolean showMiniButtons) {
        if (showMiniButtons) {
            if (this.itemPanel == null) {
                this.itemPanel = new ButtonPanel(true){

                    @Override
                    protected BasicTitleViewItem<JComponent> createItemFor(DockAction action, Dockable dockable) {
                        return AbstractDockTitle.this.createItemFor(action, dockable);
                    }
                };
                this.itemPanel.setOpaque(false);
                this.itemPanel.setOrientation(this.getOrientation());
                this.itemPanel.setToolTipText(this.getToolTipText());
                this.add(this.itemPanel);
                if (this.isBound()) {
                    this.itemPanel.setController(this.getDockable().getController());
                    this.itemPanel.set(this.getDockable(), this.getActionSourceFor(this.getDockable()));
                }
            }
        } else if (this.itemPanel != null) {
            this.itemPanel.set(null);
            this.remove(this.itemPanel);
        }
    }

    @Override
    protected void setTooltip(String text) {
        super.setToolTipText(text);
        if (this.itemPanel != null) {
            this.itemPanel.setToolTipText(text);
        }
    }

    @Override
    public void setOrientation(DockTitle.Orientation orientation) {
        if (this.itemPanel != null) {
            this.itemPanel.setOrientation(orientation);
        }
        super.setOrientation(orientation);
    }

    @Override
    protected void doTitleLayout() {
        Insets insets = this.titleInsets();
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        OrientedLabel label = this.getLabel();
        DockTitle.Orientation orientation = this.getOrientation();
        Icon icon = this.getIcon();
        int iconTextGap = this.getIconTextGap();
        String text = this.getText();
        Dimension labelPreferred = text == null || text.length() == 0 ? new Dimension(5, 5) : label.getPreferredSize();
        if (orientation.isHorizontal()) {
            if (icon != null) {
                x += icon.getIconWidth() + iconTextGap;
                width -= icon.getIconWidth() + iconTextGap;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                int count;
                Dimension[] buttonPreferred = this.itemPanel.getPreferredSizes();
                int remaining = width - labelPreferred.width;
                for (count = buttonPreferred.length - 1; count > 0 && buttonPreferred[count].width > remaining; --count) {
                }
                this.itemPanel.setVisibleActions(count);
                int buttonWidth = buttonPreferred[count].width;
                int buttonX = width - buttonWidth;
                label.setBounds(x, y, buttonX, height);
                this.itemPanel.setBounds(x + buttonX, y, width - buttonX, height);
            } else {
                label.setBounds(x, y, width, height);
            }
        } else {
            if (icon != null) {
                y += icon.getIconWidth() + iconTextGap;
                height -= icon.getIconWidth() + iconTextGap;
            }
            if (this.itemPanel != null && this.itemPanel.getItemCount() > 0) {
                int count;
                Dimension[] buttonPreferred = this.itemPanel.getPreferredSizes();
                int remaining = height - labelPreferred.height;
                for (count = buttonPreferred.length - 1; count > 0 && buttonPreferred[count].height > remaining; --count) {
                }
                this.itemPanel.setVisibleActions(count);
                int buttonHeight = buttonPreferred[count].height;
                int buttonY = height - buttonHeight;
                label.setBounds(x, y, width, buttonY);
                this.itemPanel.setBounds(x, y + buttonY, width, height - buttonY);
            } else {
                label.setBounds(x, y, width, height);
            }
        }
    }

    @Override
    public Point getPopupLocation(Point click, boolean popupTrigger) {
        if (popupTrigger) {
            return click;
        }
        boolean restrained = this.getText() == null || this.getText().length() == 0;
        Rectangle icon = this.getIconBounds();
        if (icon != null && icon.contains(click)) {
            if (restrained) {
                int size = this.getWidth() * this.getHeight();
                if (this.itemPanel != null) {
                    size -= this.itemPanel.getWidth() * this.itemPanel.getHeight();
                }
                if (size <= 2 * icon.width * icon.height) {
                    return null;
                }
            }
            if (this.getOrientation().isHorizontal()) {
                return new Point(icon.x, icon.y + icon.height);
            }
            return new Point(icon.x + icon.width, icon.y);
        }
        return null;
    }

    @Override
    public void changed(DockTitleEvent event) {
        super.changed(event);
        if (event instanceof ActionsDockTitleEvent) {
            this.suggestActions(((ActionsDockTitleEvent)event).getSuggestions());
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension size = super.getPreferredSize();
        if (this.itemPanel != null) {
            Dimension items = this.itemPanel.getPreferredSize();
            Insets insets = this.titleInsets();
            if (this.getOrientation().isHorizontal()) {
                size.width += items.width;
                size.height = Math.max(size.height, items.height + insets.top + insets.bottom);
            } else {
                size.height += items.height;
                size.width = Math.max(size.width, items.width + insets.left + insets.right);
            }
        }
        if (size.width < 10) {
            size.width = 10;
        }
        if (size.height < 10) {
            size.height = 10;
        }
        return size;
    }

    protected DockActionSource getActionSourceFor(Dockable dockable) {
        if (this.suggestedSource != null) {
            return this.suggestedSource;
        }
        return dockable.getGlobalActionOffers();
    }

    protected void suggestActions(DockActionSource actions) {
        if (this.suggestedSource != actions) {
            this.suggestedSource = actions;
            if (this.isShowMiniButtons()) {
                Dockable dockable = this.getDockable();
                this.itemPanel.set(dockable, this.getActionSourceFor(dockable));
            }
        }
    }

    protected DockActionSource getSuggestedSource() {
        return this.suggestedSource;
    }

    @Override
    public void bind() {
        DockController controller = this.getDockable().getController();
        if (this.itemPanel != null) {
            Dockable dockable = this.getDockable();
            this.itemPanel.set(dockable, this.getActionSourceFor(dockable));
            this.itemPanel.setController(controller);
        }
        super.bind();
    }

    @Override
    public void unbind() {
        if (this.itemPanel != null) {
            this.itemPanel.set(null);
            this.itemPanel.setController(null);
        }
        super.unbind();
    }
}

