/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.themes.basic;

import bibliothek.gui.dock.station.DockableDisplayer;
import bibliothek.gui.dock.util.ConfiguredBackgroundPanel;
import bibliothek.gui.dock.util.Transparency;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;

public class DisplayerContentPane
extends ConfiguredBackgroundPanel {
    private Component title;
    private Component dockable;
    private DockableDisplayer.Location location;

    public DisplayerContentPane() {
        super(null, Transparency.DEFAULT);
    }

    public void setTitleLocation(DockableDisplayer.Location location) {
        this.location = location;
        this.revalidate();
    }

    public void setDockable(Component dockable) {
        if (this.dockable != null) {
            this.remove(this.dockable);
        }
        this.dockable = dockable;
        if (this.dockable != null) {
            this.add(this.dockable);
        }
    }

    public void setTitle(Component title) {
        if (this.title != null) {
            this.remove(this.title);
        }
        this.title = title;
        if (this.title != null) {
            this.add(this.title);
        }
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension titleSize;
        Dimension base;
        if (this.title == null && this.dockable != null) {
            base = this.dockable.getPreferredSize();
        } else if (this.dockable == null && this.title != null) {
            base = this.title.getPreferredSize();
        } else if (this.dockable == null && this.title == null) {
            base = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            titleSize = this.title.getPreferredSize();
            base = this.dockable.getPreferredSize();
            base = new Dimension(base.width + titleSize.width, Math.max(base.height, titleSize.height));
        } else {
            titleSize = this.title.getPreferredSize();
            base = this.dockable.getPreferredSize();
            base = new Dimension(Math.max(titleSize.width, base.width), titleSize.height + base.height);
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension titleSize;
        Dimension base;
        if (this.title == null && this.dockable != null) {
            base = this.dockable.getMaximumSize();
        } else if (this.dockable == null && this.title != null) {
            base = this.title.getMaximumSize();
        } else if (this.dockable == null && this.title == null) {
            base = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            titleSize = this.title.getMaximumSize();
            base = this.dockable.getMaximumSize();
            base = new Dimension(base.width + titleSize.width, Math.max(base.height, titleSize.height));
        } else {
            titleSize = this.title.getMaximumSize();
            base = this.dockable.getMaximumSize();
            base = new Dimension(Math.max(titleSize.width, base.width), titleSize.height + base.height);
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension titleSize;
        Dimension base;
        if (this.title == null && this.dockable != null) {
            base = this.dockable.getMinimumSize();
        } else if (this.dockable == null && this.title != null) {
            base = this.title.getMinimumSize();
        } else if (this.dockable == null && this.title == null) {
            base = new Dimension(0, 0);
        } else if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
            titleSize = this.title.getMinimumSize();
            base = this.dockable.getMinimumSize();
            base = new Dimension(base.width + titleSize.width, Math.max(base.height, titleSize.height));
        } else {
            titleSize = this.title.getMinimumSize();
            base = this.dockable.getMinimumSize();
            base = new Dimension(Math.max(titleSize.width, base.width), titleSize.height + base.height);
        }
        Insets insets = this.getInsets();
        if (insets != null) {
            base = new Dimension(base.width + insets.left + insets.right, base.height + insets.top + insets.bottom);
        }
        return base;
    }

    @Override
    public void doLayout() {
        Insets insets = this.getInsets();
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        int x = insets.left;
        int y = insets.top;
        int width = this.getWidth() - insets.left - insets.right;
        int height = this.getHeight() - insets.top - insets.bottom;
        if (this.title == null && this.dockable == null) {
            return;
        }
        width = Math.max(0, width);
        height = Math.max(0, height);
        if (this.title == null) {
            this.dockable.setBounds(x, y, width, height);
        } else if (this.dockable == null) {
            this.title.setBounds(x, y, width, height);
        } else {
            Dimension preferred = this.title.getPreferredSize();
            int preferredWidth = preferred.width;
            int preferredHeight = preferred.height;
            if (this.location == DockableDisplayer.Location.LEFT || this.location == DockableDisplayer.Location.RIGHT) {
                preferredWidth = Math.min(preferredWidth, width);
                preferredHeight = height;
            } else {
                preferredWidth = width;
                preferredHeight = Math.min(preferredHeight, height);
            }
            if (this.location == DockableDisplayer.Location.LEFT) {
                this.title.setBounds(x, y, preferredWidth, preferredHeight);
                this.dockable.setBounds(x + preferredWidth, y, width - preferredWidth, height);
            } else if (this.location == DockableDisplayer.Location.RIGHT) {
                this.title.setBounds(x + width - preferredWidth, y, preferredWidth, preferredHeight);
                this.dockable.setBounds(x, y, width - preferredWidth, preferredHeight);
            } else if (this.location == DockableDisplayer.Location.BOTTOM) {
                this.title.setBounds(x, y + height - preferredHeight, preferredWidth, preferredHeight);
                this.dockable.setBounds(x, y, preferredWidth, height - preferredHeight);
            } else {
                this.title.setBounds(x, y, preferredWidth, preferredHeight);
                this.dockable.setBounds(x, y + preferredHeight, preferredWidth, height - preferredHeight);
            }
        }
    }
}

