/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.span;

import bibliothek.gui.dock.station.span.Span;
import bibliothek.gui.dock.station.span.SpanCallback;
import bibliothek.gui.dock.station.span.SpanFactory;
import bibliothek.gui.dock.station.span.SpanMode;
import java.util.HashMap;
import java.util.Map;

public class DefaultSpanFactory
implements SpanFactory {
    @Override
    public Span create(SpanCallback callback) {
        return new DefaultSpan(callback);
    }

    private static class DefaultSpan
    implements Span {
        private SpanCallback callback;
        private Map<SpanMode, Integer> sizes = new HashMap<SpanMode, Integer>(2);
        private int size = 0;

        public DefaultSpan(SpanCallback callback) {
            this.callback = callback;
        }

        @Override
        public void mutate(SpanMode mode) {
            this.set(mode);
        }

        @Override
        public void set(SpanMode mode) {
            Integer next = this.sizes.get(mode);
            this.size = next == null ? mode.getSize() : next.intValue();
            this.callback.resized();
        }

        @Override
        public void configureSize(SpanMode mode, int size) {
            this.sizes.put(mode, size);
        }

        @Override
        public int getSize() {
            return this.size;
        }
    }
}

