/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.magnet;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.ScreenDockStation;
import bibliothek.gui.dock.station.screen.magnet.AttractorStrategy;
import java.util.ArrayList;
import java.util.List;

public class MultiAttractorStrategy
implements AttractorStrategy {
    private List<AttractorStrategy> strategies = new ArrayList<AttractorStrategy>();

    public void add(AttractorStrategy strategy) {
        if (strategy == null) {
            throw new IllegalArgumentException("strategy must not be null");
        }
        this.strategies.add(strategy);
    }

    public void remove(AttractorStrategy strategy) {
        this.strategies.remove(strategy);
    }

    @Override
    public AttractorStrategy.Attraction attract(ScreenDockStation parent, Dockable moved, Dockable fixed) {
        AttractorStrategy.Attraction attraction = AttractorStrategy.Attraction.NEUTRAL;
        for (AttractorStrategy strategy : this.strategies) {
            AttractorStrategy.Attraction next = strategy.attract(parent, moved, fixed);
            attraction = attraction.stronger(next);
        }
        return attraction;
    }

    @Override
    public AttractorStrategy.Attraction stick(ScreenDockStation parent, Dockable moved, Dockable fixed) {
        AttractorStrategy.Attraction attraction = AttractorStrategy.Attraction.NEUTRAL;
        for (AttractorStrategy strategy : this.strategies) {
            AttractorStrategy.Attraction next = strategy.stick(parent, moved, fixed);
            attraction = attraction.stronger(next);
        }
        return attraction;
    }
}

