/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.station.screen.magnet;

import bibliothek.gui.dock.station.screen.ScreenDockWindow;
import bibliothek.gui.dock.station.screen.magnet.MagnetController;
import bibliothek.gui.dock.station.screen.magnet.MagnetOperation;
import bibliothek.gui.dock.station.screen.magnet.MagnetRequest;
import bibliothek.gui.dock.station.screen.magnet.StickMagnetGraph;
import java.util.ArrayList;
import java.util.List;

public class DefaultMagnetOperation
implements MagnetOperation {
    private int threshold;
    private StickMagnetGraph graph;

    public DefaultMagnetOperation(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public void attract(MagnetController controller, MagnetRequest request) {
        if (this.graph == null) {
            this.graph = new StickMagnetGraph(controller, request);
        }
        if (request.isMoved()) {
            this.moved(controller, request);
        } else if (request.isResized()) {
            this.resized(controller, request);
        }
    }

    @Override
    public void destroy() {
    }

    protected void moved(MagnetController controller, MagnetRequest request) {
        ScreenDockWindow[] partners = controller.getAttracted(request.getWindow());
        int nearest = this.threshold;
        ScreenDockWindow nearestWindow = null;
        ArrayList<ScreenDockWindow> windows = new ArrayList<ScreenDockWindow>();
        MagnetRequest.Side nearestSide = null;
        for (ScreenDockWindow partner : partners) {
            if (this.graph.getRoot().getNeighbor(partner) != null) continue;
            for (MagnetRequest.Side side : MagnetRequest.Side.values()) {
                int distance = controller.distance(request.getWindow(), side, partner, side.opposite(), false);
                if (distance > this.threshold) continue;
                boolean neighbors = false;
                switch (side) {
                    case NORTH: 
                    case SOUTH: {
                        neighbors = controller.intersectVertically(request.getWindow(), partner, false);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        neighbors = controller.intersectHorizontally(request.getWindow(), partner, false);
                    }
                }
                if (!neighbors) continue;
                if (distance < nearest) {
                    nearest = distance;
                    nearestWindow = partner;
                    nearestSide = side;
                }
                windows.add(partner);
            }
        }
        if (nearestWindow != null) {
            request.movingAttraction(nearestWindow, nearestSide, nearestSide.opposite());
            this.neighborMoved(controller, request, windows, nearestSide);
        }
        this.graph.moveNeighbors();
    }

    private void neighborMoved(MagnetController controller, MagnetRequest request, List<ScreenDockWindow> neighbors, MagnetRequest.Side side) {
        MagnetRequest.Side checkA = side == MagnetRequest.Side.NORTH || side == MagnetRequest.Side.SOUTH ? MagnetRequest.Side.EAST : MagnetRequest.Side.NORTH;
        MagnetRequest.Side checkB = checkA.opposite();
        ScreenDockWindow neighborA = null;
        int distA = this.threshold + 1;
        for (ScreenDockWindow neighbor : neighbors) {
            int dist = controller.distance(neighbor, checkA, request.getWindow(), checkA, false);
            if (dist >= distA) continue;
            distA = dist;
            neighborA = neighbor;
        }
        ScreenDockWindow neighborB = null;
        int distB = this.threshold + 1;
        for (ScreenDockWindow neighbor : neighbors) {
            int dist = controller.distance(neighbor, checkB, request.getWindow(), checkB, false);
            if (dist >= distB) continue;
            distB = dist;
            neighborB = neighbor;
        }
        if (distA <= distB && distA <= this.threshold) {
            request.movingAttraction(neighborA, checkA, checkA);
        } else if (distB <= distA && distB <= this.threshold) {
            request.movingAttraction(neighborB, checkB, checkB);
        }
    }

    protected void resized(MagnetController controller, MagnetRequest request) {
        ScreenDockWindow[] partners = controller.getAttracted(request.getWindow());
        List[] neighbors = new List[4];
        for (MagnetRequest.Side side : MagnetRequest.Side.values()) {
            ArrayList<ScreenDockWindow> windows;
            int nearest = this.threshold + 1;
            ScreenDockWindow window = null;
            neighbors[side.ordinal()] = windows = new ArrayList<ScreenDockWindow>();
            for (ScreenDockWindow partner : partners) {
                int distance;
                if (request.is(side) && this.graph.getRoot().getNeighbor(partner) != null || (distance = controller.distance(request.getWindow(), side, partner, side.opposite(), false)) > this.threshold && window != null) continue;
                boolean neighbor = false;
                switch (side) {
                    case NORTH: 
                    case SOUTH: {
                        neighbor = controller.intersectVertically(request.getWindow(), partner, false);
                        break;
                    }
                    case EAST: 
                    case WEST: {
                        neighbor = controller.intersectHorizontally(request.getWindow(), partner, false);
                    }
                }
                if (!neighbor) continue;
                if (distance <= nearest || window == null) {
                    nearest = distance;
                    window = partner;
                }
                if (distance > this.threshold) continue;
                windows.add(partner);
            }
            if (window == null) continue;
            if (request.is(side) && nearest <= this.threshold) {
                request.resizingAttraction(window, side, side.opposite());
                neighbors[side.ordinal()] = windows;
                continue;
            }
            if (nearest != 1) continue;
            neighbors[side.ordinal()] = windows;
        }
        for (MagnetRequest.Side side : MagnetRequest.Side.values()) {
            if (!request.is(side)) continue;
            this.neighborResized(controller, request, side, neighbors);
        }
        this.graph.moveAndResizeNeighbors();
    }

    private void neighborResized(MagnetController controller, MagnetRequest request, MagnetRequest.Side side, List<ScreenDockWindow>[] neighbors) {
        MagnetRequest.Side checkA = null;
        switch (side) {
            case NORTH: 
            case SOUTH: {
                checkA = MagnetRequest.Side.EAST;
                break;
            }
            case EAST: 
            case WEST: {
                checkA = MagnetRequest.Side.NORTH;
            }
        }
        MagnetRequest.Side checkB = checkA.opposite();
        ScreenDockWindow neighborA = null;
        int distanceA = this.threshold + 1;
        if (neighbors[checkA.ordinal()] != null) {
            for (ScreenDockWindow neighbor : neighbors[checkA.ordinal()]) {
                int distance;
                if (this.graph.depends(neighbor, side) || (distance = controller.distance(request.getWindow(), side, neighbor, side, false)) >= distanceA) continue;
                distanceA = distance;
                neighborA = neighbor;
            }
        }
        ScreenDockWindow neighborB = null;
        int distanceB = this.threshold + 1;
        if (neighbors[checkB.ordinal()] != null) {
            for (ScreenDockWindow neighbor : neighbors[checkB.ordinal()]) {
                int distance;
                if (this.graph.depends(neighbor, side) || (distance = controller.distance(request.getWindow(), side, neighbor, side, false)) >= distanceB) continue;
                distanceB = distance;
                neighborB = neighbor;
            }
        } else {
            distanceB = this.threshold + 1;
        }
        if (distanceA <= distanceB && distanceA <= this.threshold) {
            request.resizingAttraction(neighborA, side, side);
        } else if (distanceB <= distanceA && distanceB <= this.threshold) {
            request.resizingAttraction(neighborB, side, side);
        }
    }
}

