/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.action;

import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.ActionOffer;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.action.MultiDockActionSource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;

public class DefaultActionOffer
implements ActionOffer {
    private boolean separators = false;
    private LocationHint.Origin[] origins;
    private LocationHint.Hint[] hints = new LocationHint.Hint[]{LocationHint.LEFT_OF_ALL, LocationHint.VERY_LEFT, LocationHint.LEFT, LocationHint.LITTLE_LEFT, LocationHint.MIDDLE, LocationHint.LITTLE_RIGHT, LocationHint.RIGHT, LocationHint.VERY_RIGHT, LocationHint.RIGHT_OF_ALL};

    public DefaultActionOffer() {
        this(LocationHint.INDIRECT_ACTION, LocationHint.DIRECT_ACTION, LocationHint.ACTION_GUARD, LocationHint.DOCKABLE);
    }

    public DefaultActionOffer(LocationHint.Origin ... origins) {
        if (origins == null) {
            throw new IllegalArgumentException("Elements must not be null.");
        }
        this.origins = origins;
    }

    public void setOrigins(LocationHint.Origin[] origins) {
        if (origins == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.origins = origins;
    }

    public void setHints(LocationHint.Hint[] hints) {
        if (hints == null) {
            throw new IllegalArgumentException("value must not be null");
        }
        this.hints = hints;
    }

    public void setSeparators(boolean separators) {
        this.separators = separators;
    }

    public boolean isSeparators() {
        return this.separators;
    }

    @Override
    public boolean interested(Dockable dockable) {
        return true;
    }

    @Override
    public DockActionSource getSource(Dockable dockable, DockActionSource source, DockActionSource[] guards, DockActionSource parent, DockActionSource[] parents) {
        MultiDockActionSource multiSource = new MultiDockActionSource(new DockActionSource[0]);
        multiSource.setHint(new LocationHint(LocationHint.ACTION_OFFER, LocationHint.MIDDLE));
        multiSource.setSeparateSources(this.isSeparators());
        ArrayList<Object> sources = new ArrayList<Object>();
        if (source != null) {
            sources.add(source);
        }
        if (guards != null) {
            for (DockActionSource guard : guards) {
                if (guard == null) continue;
                sources.add(guard);
            }
        }
        if (parent != null) {
            sources.add(parent);
        }
        if (parents != null) {
            for (DockActionSource action : parents) {
                if (action == null) continue;
                sources.add(action);
            }
        }
        Collections.sort(sources, new Comparator<DockActionSource>(){

            @Override
            public int compare(DockActionSource a, DockActionSource b) {
                int indexB;
                int indexA = this.indexOf(DefaultActionOffer.this.hints, a.getLocationHint().getHint());
                if (indexA == (indexB = this.indexOf(DefaultActionOffer.this.hints, b.getLocationHint().getHint()))) {
                    indexA = this.indexOf(DefaultActionOffer.this.origins, a.getLocationHint().getOrigin());
                    indexB = this.indexOf(DefaultActionOffer.this.origins, b.getLocationHint().getOrigin());
                }
                if (indexA < indexB) {
                    return -1;
                }
                if (indexA > indexB) {
                    return 1;
                }
                return 0;
            }

            private <A> int indexOf(A[] array, A element) {
                for (int i = 0; i < array.length; ++i) {
                    if (!element.equals(array[i])) continue;
                    return i;
                }
                return -1;
            }
        });
        for (DockActionSource dockActionSource : sources) {
            multiSource.add(dockActionSource);
        }
        return multiSource;
    }
}

