/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.extension.gui.dock.theme.eclipse;

import bibliothek.extension.gui.dock.theme.EclipseTheme;
import bibliothek.extension.gui.dock.theme.eclipse.EclipseThemeConnector;
import bibliothek.gui.dock.title.DockTitleFactory;
import bibliothek.gui.dock.title.DockTitleRequest;

public class EclipseDockTitleFactory
implements DockTitleFactory {
    private EclipseTheme theme;
    private DockTitleFactory factory;

    public EclipseDockTitleFactory(EclipseTheme theme, DockTitleFactory factory) {
        if (theme == null) {
            throw new IllegalArgumentException("theme must not be null");
        }
        if (factory == null) {
            throw new IllegalArgumentException("factory must not be null");
        }
        this.theme = theme;
        this.factory = factory;
    }

    @Override
    public void install(DockTitleRequest request) {
        this.factory.install(request);
    }

    @Override
    public void uninstall(DockTitleRequest request) {
        this.factory.uninstall(request);
    }

    @Override
    public void request(DockTitleRequest request) {
        EclipseThemeConnector.TitleBar bar = this.theme.getThemeConnector(request.getVersion().getController()).getTitleBarKind(request.getParent(), request.getTarget());
        if (bar == EclipseThemeConnector.TitleBar.BASIC || bar == EclipseThemeConnector.TitleBar.BASIC_BORDERED) {
            this.factory.request(request);
        } else {
            request.answer(null);
        }
    }
}

