/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.mapdata;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.chart.graphic.GeoGraphicCollection;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.io.EndianDataOutputStream;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.graphic.GraphicCollection;
import org.meteoinfo.geometry.shape.PointM;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PointZ;
import org.meteoinfo.geometry.shape.PointZShape;
import org.meteoinfo.geometry.shape.PolygonMShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolygonZShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.PolylineZShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.projection.ProjectionInfo;
import org.meteoinfo.table.AttributeTable;

public class ShapeFileManage {
    private static final String ENCODING = "UTF-8";

    public static VectorLayer loadShapeFile(String shpfilepath) throws IOException, FileNotFoundException, Exception {
        String cpgfilepath = shpfilepath.replaceFirst(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".cpg");
        File cpgFile = new File(cpgfilepath);
        String encoding = ENCODING;
        if (cpgFile.exists()) {
            BufferedReader sr = new BufferedReader(new FileReader(cpgFile));
            String ec = sr.readLine().trim();
            sr.close();
            encoding = ec;
        }
        return ShapeFileManage.loadShapeFile(shpfilepath, encoding);
    }

    public static VectorLayer loadShapeFile(String shpfilepath, String encoding) throws IOException, FileNotFoundException, Exception {
        VectorLayer aLayer;
        String shxfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".shx");
        String dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf");
        String projfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".prj");
        File shpFile = new File(shpfilepath);
        File dbfFile = new File(dbffilepath);
        File shxFile = new File(shxfilepath);
        File prjFile = new File(projfilepath);
        if (!shxFile.exists()) {
            shxfilepath = shxfilepath.replace(".shx", ".SHX");
            shxFile = new File(shxfilepath);
        }
        if (!dbfFile.exists()) {
            dbffilepath = dbffilepath.replace(".dbf", ".DBF");
            dbfFile = new File(dbffilepath);
        }
        if (!prjFile.exists()) {
            projfilepath = projfilepath.replace(".prj", ".PRJ");
            prjFile = new File(projfilepath);
        }
        if ("".equals(shxfilepath)) {
            return null;
        }
        long BytesSum = shxFile.length();
        int shapeNum = (int)(BytesSum - 100L) / 8;
        ShapeFileManage.loadShxFile(shxFile);
        DataInputStream br = new DataInputStream(new BufferedInputStream(Files.newInputStream(shpFile.toPath(), new OpenOption[0])));
        byte[] arr = new byte[100];
        br.read(arr);
        ByteBuffer buffer = ByteBuffer.wrap(arr);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        ((Buffer)buffer).position(32);
        int aShapeType = buffer.getInt();
        ShapeTypes aST = ShapeTypes.valueOf((int)aShapeType);
        Extent aExtent = new Extent();
        aExtent.minX = buffer.getDouble();
        aExtent.minY = buffer.getDouble();
        aExtent.maxX = buffer.getDouble();
        aExtent.maxY = buffer.getDouble();
        switch (aST) {
            case POINT: {
                aLayer = ShapeFileManage.readPointShapes(br, shapeNum);
                break;
            }
            case POINT_Z: {
                aLayer = ShapeFileManage.readPointZShapes(br, shapeNum);
                break;
            }
            case POLYLINE: {
                aLayer = ShapeFileManage.readPolylineShapes(br, shapeNum);
                break;
            }
            case POLYLINE_Z: {
                aLayer = ShapeFileManage.readPolylineZShapes(br, shapeNum);
                break;
            }
            case POLYGON: {
                aLayer = ShapeFileManage.readPolygonShapes(br, shapeNum);
                break;
            }
            case POLYGON_M: {
                aLayer = ShapeFileManage.readPolygonMShapes(br, shapeNum);
                break;
            }
            case POLYGON_Z: {
                aLayer = ShapeFileManage.readPolygonZShapes(br, shapeNum);
                break;
            }
            default: {
                System.out.println("The shape type is not supported: " + aST.toString());
                return null;
            }
        }
        br.close();
        if (aLayer != null) {
            aLayer.setExtent(aExtent);
            aLayer.setLayerDrawType(LayerDrawType.MAP);
            aLayer.setFileName(shpfilepath);
            aLayer.setLayerName(shpFile.getName());
            aLayer.setVisible(true);
            AttributeTable attrTable = ShapeFileManage.loadDbfFile(shpfilepath, encoding);
            aLayer.setAttributeTable(attrTable);
            if (prjFile.exists()) {
                aLayer.setProjInfo(ShapeFileManage.loadProjFile(prjFile));
            }
        }
        return aLayer;
    }

    private static void readHeader(DataInputStream br) throws IOException {
        int i;
        int FileCode = ShapeFileManage.swapByteOrder(br.readInt());
        for (i = 0; i < 5; ++i) {
            br.readInt();
        }
        int FileLength = ShapeFileManage.swapByteOrder(br.readInt());
        int Version = br.readInt();
        int aShapeType = br.readInt();
        Extent aExtent = new Extent();
        aExtent.minX = br.readDouble();
        aExtent.minY = br.readDouble();
        aExtent.maxX = br.readDouble();
        aExtent.maxY = br.readDouble();
        for (i = 0; i < 4; ++i) {
            br.readDouble();
        }
    }

    private static VectorLayer readPointShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
        byte[] bytes = new byte[28 * shapeNum];
        br.read(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < shapeNum; ++i) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            PointShape aP = new PointShape();
            PointD aPoint = new PointD();
            aPoint.X = x;
            aPoint.Y = y;
            aP.setPoint(aPoint);
            aLayer.addShape((Shape)aP);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.black, 5.0f));
        return aLayer;
    }

    private static VectorLayer readPointZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT_Z);
        byte[] bytes = new byte[44 * shapeNum];
        br.read(bytes);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        for (int i = 0; i < shapeNum; ++i) {
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            double x = buffer.getDouble();
            double y = buffer.getDouble();
            double z = buffer.getDouble();
            double m = buffer.getDouble();
            PointZShape aP = new PointZShape();
            PointZ aPoint = new PointZ();
            aPoint.X = x;
            aPoint.Y = y;
            aPoint.Z = z;
            aPoint.M = m;
            aP.setPoint((PointD)aPoint);
            aLayer.addShape((Shape)aP);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POINT, Color.black, 5.0f));
        return aLayer;
    }

    private static VectorLayer readPolylineShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolylineShape aPL = new PolylineShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aPL.setExtent(extent);
            aPL.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aPL.parts = new int[aPL.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aPL.getPartNum(); ++j) {
                aPL.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            aPL.setPoints(points);
            aLayer.addShape((Shape)aPL);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.darkGray, 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolylineZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYLINE_Z);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolylineZShape aPL = new PolylineZShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aPL.setExtent(extent);
            aPL.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aPL.parts = new int[aPL.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aPL.getPartNum(); ++j) {
                aPL.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double zmin = buffer.getDouble();
            double zmax = buffer.getDouble();
            double[] zArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                zArray[j2] = buffer.getDouble();
            }
            double[] mArray = new double[numPoints];
            if (buffer.position() < buffer.capacity()) {
                double mmin = buffer.getDouble();
                double mmax = buffer.getDouble();
                for (int j3 = 0; j3 < numPoints; ++j3) {
                    mArray[j3] = buffer.getDouble();
                }
            }
            ArrayList<PointZ> pointZs = new ArrayList<PointZ>();
            for (int j4 = 0; j4 < numPoints; ++j4) {
                pointZs.add(new PointZ(((PointD)points.get((int)j4)).X, ((PointD)points.get((int)j4)).Y, zArray[j4], mArray[j4]));
            }
            aPL.setPoints(pointZs);
            aLayer.addShape((Shape)aPL);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYLINE, Color.darkGray, 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            if (ContentLength < 40) {
                System.out.println(String.format("Too short content length of %d at shape %d", ContentLength, i + 1));
                continue;
            }
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonShape aSPG = new PolygonShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            aSPG.setPoints(points);
            aLayer.addShape((Shape)aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYGON, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonMShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON_M);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonMShape aSPG = new PolygonMShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double mmin = buffer.getDouble();
            double mmax = buffer.getDouble();
            double[] mArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                mArray[j2] = buffer.getDouble();
            }
            ArrayList<PointM> pointMs = new ArrayList<PointM>();
            for (int j3 = 0; j3 < numPoints; ++j3) {
                pointMs.add(new PointM(((PointD)points.get((int)j3)).X, ((PointD)points.get((int)j3)).Y, mArray[j3]));
            }
            aSPG.setPoints(pointMs);
            aLayer.addShape((Shape)aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYGON, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static VectorLayer readPolygonZShapes(DataInputStream br, int shapeNum) throws IOException {
        VectorLayer aLayer = new VectorLayer(ShapeTypes.POLYGON_Z);
        for (int i = 0; i < shapeNum; ++i) {
            int j;
            byte[] bytes = new byte[8];
            br.read(bytes);
            ByteBuffer buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.BIG_ENDIAN);
            int RecordNum = buffer.getInt();
            int ContentLength = buffer.getInt();
            bytes = new byte[ContentLength * 2];
            br.read(bytes);
            buffer = ByteBuffer.wrap(bytes);
            buffer.order(ByteOrder.LITTLE_ENDIAN);
            int aShapeType = buffer.getInt();
            PolygonZShape aSPG = new PolygonZShape();
            Extent extent = new Extent();
            extent.minX = buffer.getDouble();
            extent.minY = buffer.getDouble();
            extent.maxX = buffer.getDouble();
            extent.maxY = buffer.getDouble();
            aSPG.setExtent(extent);
            aSPG.setPartNum(buffer.getInt());
            int numPoints = buffer.getInt();
            aSPG.parts = new int[aSPG.getPartNum()];
            ArrayList<PointD> points = new ArrayList<PointD>();
            for (j = 0; j < aSPG.getPartNum(); ++j) {
                aSPG.parts[j] = buffer.getInt();
            }
            for (j = 0; j < numPoints; ++j) {
                double x = buffer.getDouble();
                double y = buffer.getDouble();
                PointD aPoint = new PointD();
                aPoint.X = x;
                aPoint.Y = y;
                points.add(aPoint);
            }
            double zmin = buffer.getDouble();
            double zmax = buffer.getDouble();
            double[] zArray = new double[numPoints];
            for (int j2 = 0; j2 < numPoints; ++j2) {
                zArray[j2] = buffer.getDouble();
            }
            double mmin = buffer.getDouble();
            double mmax = buffer.getDouble();
            double[] mArray = new double[numPoints];
            for (int j3 = 0; j3 < numPoints; ++j3) {
                mArray[j3] = buffer.getDouble();
            }
            ArrayList<PointZ> pointZs = new ArrayList<PointZ>();
            for (int j4 = 0; j4 < numPoints; ++j4) {
                pointZs.add(new PointZ(((PointD)points.get((int)j4)).X, ((PointD)points.get((int)j4)).Y, zArray[j4], mArray[j4]));
            }
            aSPG.setPoints(pointZs);
            aLayer.addShape((Shape)aSPG);
        }
        aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme(ShapeTypes.POLYGON, new Color(255, 251, 195), 1.0f));
        return aLayer;
    }

    private static void loadShxFile(File shxFile) throws FileNotFoundException, IOException {
        DataInputStream bridx = new DataInputStream(new BufferedInputStream(new FileInputStream(shxFile)));
        long BytesSum = shxFile.length();
        int shapeNum = (int)(BytesSum - 100L) / 8;
        ShapeFileManage.readHeader(bridx);
        int OffSet = 0;
        int ContentLength = 0;
        for (int i = 0; i < shapeNum; ++i) {
            OffSet = ShapeFileManage.swapByteOrder(bridx.readInt());
            ContentLength = ShapeFileManage.swapByteOrder(bridx.readInt());
        }
        bridx.close();
    }

    public static AttributeTable loadDbfFile(String shpFileName, String encoding) throws Exception {
        AttributeTable attrTable = new AttributeTable();
        attrTable.setEncoding(encoding);
        attrTable.open(shpFileName);
        attrTable.fill(attrTable.getNumRecords());
        return attrTable;
    }

    public static ProjectionInfo loadProjFile(File projFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader sr = new BufferedReader(new FileReader(projFile));
        StringBuilder buffer = new StringBuilder();
        while ((line = sr.readLine()) != null) {
            buffer.append(line);
        }
        String esriString = buffer.toString();
        sr.close();
        ProjectionInfo projInfo = ProjectionInfo.factoryESRI((String)esriString);
        return projInfo;
    }

    public static boolean saveShapeFile(String shpfilepath, VectorLayer aLayer) throws IOException {
        return ShapeFileManage.saveShapeFile(shpfilepath, aLayer, null);
    }

    public static boolean saveShapeFile(String shpfilepath, VectorLayer aLayer, String encoding) throws IOException {
        String shxfilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".shx");
        String dbffilepath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".dbf");
        String projFilePath = shpfilepath.replace(shpfilepath.substring(shpfilepath.lastIndexOf(".")), ".prj");
        switch (aLayer.getShapeType()) {
            case POINT: 
            case POINT_Z: 
            case POLYLINE: 
            case POLYLINE_Z: 
            case POLYGON: 
            case POLYGON_Z: {
                ShapeFileManage.writeShxFile(shxfilepath, aLayer);
                ShapeFileManage.writeShpFile(shpfilepath, aLayer);
                if (encoding == null) {
                    ShapeFileManage.writeDbfFile(dbffilepath, aLayer);
                } else {
                    ShapeFileManage.writeDbfFile(dbffilepath, aLayer, encoding);
                }
                ShapeFileManage.writeProjFile(projFilePath, aLayer);
                return true;
            }
        }
        return false;
    }

    public static boolean saveShapeFile(String shpFilePath, GraphicCollection graphics) throws IOException {
        return ShapeFileManage.saveShapeFile(shpFilePath, GeoGraphicCollection.factory((GraphicCollection)graphics), null);
    }

    public static boolean saveShapeFile(String shpFilePath, GraphicCollection graphics, String encoding) throws IOException {
        return ShapeFileManage.saveShapeFile(shpFilePath, GeoGraphicCollection.factory((GraphicCollection)graphics), encoding);
    }

    public static boolean saveShapeFile(String shpFilePath, GeoGraphicCollection geoGraphics) throws IOException {
        return ShapeFileManage.saveShapeFile(shpFilePath, geoGraphics, null);
    }

    public static boolean saveShapeFile(String shpFilePath, GeoGraphicCollection geoGraphics, String encoding) throws IOException {
        String shxFilePath = shpFilePath.replace(shpFilePath.substring(shpFilePath.lastIndexOf(".")), ".shx");
        String dbfFilePath = shpFilePath.replace(shpFilePath.substring(shpFilePath.lastIndexOf(".")), ".dbf");
        String projFilePath = shpFilePath.replace(shpFilePath.substring(shpFilePath.lastIndexOf(".")), ".prj");
        switch (geoGraphics.getShapeType()) {
            case POINT: 
            case POINT_Z: 
            case POLYLINE: 
            case POLYLINE_Z: 
            case POLYGON: 
            case POLYGON_Z: {
                ShapeFileManage.writeShxFile(shxFilePath, (GraphicCollection)geoGraphics);
                ShapeFileManage.writeShpFile(shpFilePath, (GraphicCollection)geoGraphics);
                if (encoding == null) {
                    ShapeFileManage.writeDbfFile(dbfFilePath, geoGraphics.getAttributeTable());
                } else {
                    ShapeFileManage.writeDbfFile(dbfFilePath, geoGraphics.getAttributeTable(), encoding);
                }
                ShapeFileManage.writeProjFile(projFilePath, geoGraphics.getProjInfo());
                return true;
            }
        }
        return false;
    }

    private static void writeShpFile(String shpfilepath, VectorLayer aLayer) throws FileNotFoundException, IOException {
        File shpFile = new File(shpfilepath);
        EndianDataOutputStream bw = new EndianDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(shpFile)));
        int FileLength = ShapeFileManage.getShpFileLength(aLayer);
        ShapeFileManage.writeHeader(bw, aLayer, FileLength);
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int RecordNumber = i + 1;
            ShapeFileManage.writeRecord(bw, RecordNumber, aShape, aLayer.getShapeType());
        }
        bw.close();
    }

    private static void writeShpFile(String shpFilePath, GraphicCollection graphics) throws FileNotFoundException, IOException {
        File shpFile = new File(shpFilePath);
        EndianDataOutputStream bw = new EndianDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(shpFile)));
        int FileLength = ShapeFileManage.getShpFileLength(graphics);
        ShapeFileManage.writeHeader(bw, graphics, FileLength);
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            Shape aShape = (Shape)graphics.getShapes().get(i);
            int RecordNumber = i + 1;
            ShapeFileManage.writeRecord(bw, RecordNumber, aShape, graphics.getShapeType());
        }
        bw.close();
    }

    private static int getShpFileLength(VectorLayer aLayer) {
        int fileLength = 50;
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int cLen = ShapeFileManage.getContentLength(aShape, aLayer.getShapeType());
            fileLength += 4 + cLen;
        }
        return fileLength;
    }

    private static int getShpFileLength(GraphicCollection graphics) {
        int fileLength = 50;
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            Shape aShape = (Shape)graphics.getShapes().get(i);
            int cLen = ShapeFileManage.getContentLength(aShape, graphics.getShapeType());
            fileLength += 4 + cLen;
        }
        return fileLength;
    }

    private static int getContentLength(Shape aShape, ShapeTypes aST) {
        int contentLength = 0;
        switch (aST) {
            case POINT: {
                contentLength = 10;
                break;
            }
            case POINT_Z: {
                contentLength = 18;
                break;
            }
            case POLYLINE: {
                PolylineShape aPLS = (PolylineShape)aShape;
                contentLength = 22 + 2 * aPLS.getPartNum() + 8 * aPLS.getPointNum();
                break;
            }
            case POLYLINE_Z: {
                PolylineZShape aPLZS = (PolylineZShape)aShape;
                contentLength = 22 + 2 * aPLZS.getPartNum() + 8 * aPLZS.getPointNum() + 4 + 4 + 4 * aPLZS.getPointNum() + 4 + 4 + 4 * aPLZS.getPointNum();
                break;
            }
            case POLYGON: {
                PolygonShape aPGS = (PolygonShape)aShape;
                contentLength = 22 + 2 * aPGS.getPartNum() + 8 * aPGS.getPointNum();
                break;
            }
            case POLYGON_Z: {
                PolygonZShape aPGZS = (PolygonZShape)aShape;
                contentLength = 22 + 2 * aPGZS.getPartNum() + 8 * aPGZS.getPointNum() + 4 + 4 + 4 * aPGZS.getPointNum() + 4 + 4 + 4 * aPGZS.getPointNum();
            }
        }
        return contentLength;
    }

    private static void writeRecord(EndianDataOutputStream bw, int RecordNumber, Shape aShape, ShapeTypes aST) throws IOException {
        int ContentLength = ShapeFileManage.getContentLength(aShape, aST);
        bw.writeIntBE(RecordNumber);
        bw.writeIntBE(ContentLength);
        bw.writeIntLE(aST.getValue());
        switch (aST) {
            case POINT: {
                PointShape aPS = (PointShape)aShape;
                bw.writeDoubleLE(aPS.getPoint().X);
                bw.writeDoubleLE(aPS.getPoint().Y);
                break;
            }
            case POLYLINE: {
                int i;
                PolylineShape aPLS = (PolylineShape)aShape;
                bw.writeDoubleLE(aPLS.getExtent().minX);
                bw.writeDoubleLE(aPLS.getExtent().minY);
                bw.writeDoubleLE(aPLS.getExtent().maxX);
                bw.writeDoubleLE(aPLS.getExtent().maxY);
                bw.writeIntLE(aPLS.getPartNum());
                bw.writeIntLE(aPLS.getPointNum());
                for (i = 0; i < aPLS.getPartNum(); ++i) {
                    bw.writeIntLE(aPLS.parts[i]);
                }
                for (i = 0; i < aPLS.getPointNum(); ++i) {
                    bw.writeDoubleLE(((PointD)aPLS.getPoints().get((int)i)).X);
                    bw.writeDoubleLE(((PointD)aPLS.getPoints().get((int)i)).Y);
                }
                break;
            }
            case POLYLINE_Z: {
                int i;
                PolylineZShape aPLZS = (PolylineZShape)aShape;
                bw.writeDoubleLE(aPLZS.getExtent().minX);
                bw.writeDoubleLE(aPLZS.getExtent().minY);
                bw.writeDoubleLE(aPLZS.getExtent().maxX);
                bw.writeDoubleLE(aPLZS.getExtent().maxY);
                bw.writeIntLE(aPLZS.getPartNum());
                bw.writeIntLE(aPLZS.getPointNum());
                for (i = 0; i < aPLZS.getPartNum(); ++i) {
                    bw.writeIntLE(aPLZS.parts[i]);
                }
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(((PointD)aPLZS.getPoints().get((int)i)).X);
                    bw.writeDoubleLE(((PointD)aPLZS.getPoints().get((int)i)).Y);
                }
                bw.writeDoubleLE(aPLZS.getZRange()[0]);
                bw.writeDoubleLE(aPLZS.getZRange()[1]);
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLZS.getZArray()[i]);
                }
                bw.writeDoubleLE(aPLZS.getMRange()[0]);
                bw.writeDoubleLE(aPLZS.getMRange()[1]);
                for (i = 0; i < aPLZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPLZS.getMArray()[i]);
                }
                break;
            }
            case POLYGON: {
                int i;
                PolygonShape aPGS = (PolygonShape)aShape;
                bw.writeDoubleLE(aPGS.getExtent().minX);
                bw.writeDoubleLE(aPGS.getExtent().minY);
                bw.writeDoubleLE(aPGS.getExtent().maxX);
                bw.writeDoubleLE(aPGS.getExtent().maxY);
                bw.writeIntLE(aPGS.getPartNum());
                bw.writeIntLE(aPGS.getPointNum());
                for (i = 0; i < aPGS.getPartNum(); ++i) {
                    bw.writeIntLE(aPGS.parts[i]);
                }
                for (i = 0; i < aPGS.getPointNum(); ++i) {
                    bw.writeDoubleLE(((PointD)aPGS.getPoints().get((int)i)).X);
                    bw.writeDoubleLE(((PointD)aPGS.getPoints().get((int)i)).Y);
                }
                break;
            }
            case POLYGON_Z: {
                int i;
                PolygonZShape aPGZS = (PolygonZShape)aShape;
                bw.writeDoubleLE(aPGZS.getExtent().minX);
                bw.writeDoubleLE(aPGZS.getExtent().minY);
                bw.writeDoubleLE(aPGZS.getExtent().maxX);
                bw.writeDoubleLE(aPGZS.getExtent().maxY);
                bw.writeIntLE(aPGZS.getPartNum());
                bw.writeIntLE(aPGZS.getPointNum());
                for (i = 0; i < aPGZS.getPartNum(); ++i) {
                    bw.writeIntLE(aPGZS.parts[i]);
                }
                for (i = 0; i < aPGZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(((PointD)aPGZS.getPoints().get((int)i)).X);
                    bw.writeDoubleLE(((PointD)aPGZS.getPoints().get((int)i)).Y);
                }
                bw.writeDoubleLE(aPGZS.getZRange()[0]);
                bw.writeDoubleLE(aPGZS.getZRange()[1]);
                for (i = 0; i < aPGZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPGZS.getZArray()[i]);
                }
                bw.writeDoubleLE(aPGZS.getMRange()[0]);
                bw.writeDoubleLE(aPGZS.getMRange()[1]);
                for (i = 0; i < aPGZS.getPointNum(); ++i) {
                    bw.writeDoubleLE(aPGZS.getMArray()[i]);
                }
                break;
            }
        }
    }

    private static void writeHeader(EndianDataOutputStream bw, VectorLayer aLayer, int fileLength) throws IOException {
        ShapeFileManage.writeHeader(bw, aLayer.getShapeType(), aLayer.getExtent(), fileLength);
    }

    private static void writeHeader(EndianDataOutputStream bw, GraphicCollection graphics, int fileLength) throws IOException {
        ShapeFileManage.writeHeader(bw, graphics.getShapeType(), graphics.getExtent(), fileLength);
    }

    private static void writeHeader(EndianDataOutputStream bw, ShapeTypes shapeType, Extent extent, int fileLength) throws IOException {
        int i;
        int FileCode = 9994;
        int Unused = 0;
        int Version = 1000;
        int aShapeType = shapeType.getValue();
        bw.writeIntBE(FileCode);
        for (i = 0; i < 5; ++i) {
            bw.writeIntBE(Unused);
        }
        bw.writeIntBE(fileLength);
        bw.writeIntLE(Version);
        bw.writeIntLE(aShapeType);
        bw.writeDoubleLE(extent.minX);
        bw.writeDoubleLE(extent.minY);
        bw.writeDoubleLE(extent.maxX);
        bw.writeDoubleLE(extent.maxY);
        for (i = 0; i < 4; ++i) {
            bw.writeDoubleLE(0.0);
        }
    }

    private static void writeShxFile(String shxfilepath, VectorLayer aLayer) throws IOException {
        File shxFile = new File(shxfilepath);
        EndianDataOutputStream bw = new EndianDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(shxFile)));
        int FileLength = aLayer.getShapeNum() * 4 + 50;
        ShapeFileManage.writeHeader(bw, aLayer, FileLength);
        int OffSet = 50;
        for (int i = 0; i < aLayer.getShapeNum(); ++i) {
            Shape aShape = aLayer.getShapes().get(i);
            int ContentLength = ShapeFileManage.getContentLength(aShape, aLayer.getShapeType());
            bw.writeIntBE(OffSet);
            bw.writeIntBE(ContentLength);
            OffSet = OffSet + 4 + ContentLength;
        }
        bw.close();
    }

    private static void writeShxFile(String shxFilePath, GraphicCollection graphics) throws IOException {
        File shxFile = new File(shxFilePath);
        EndianDataOutputStream bw = new EndianDataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(shxFile)));
        int FileLength = graphics.getNumGraphics() * 4 + 50;
        ShapeFileManage.writeHeader(bw, graphics, FileLength);
        int OffSet = 50;
        for (int i = 0; i < graphics.getNumGraphics(); ++i) {
            Shape aShape = (Shape)graphics.getShapes().get(i);
            int ContentLength = ShapeFileManage.getContentLength(aShape, graphics.getShapeType());
            bw.writeIntBE(OffSet);
            bw.writeIntBE(ContentLength);
            OffSet = OffSet + 4 + ContentLength;
        }
        bw.close();
    }

    private static void writeDbfFile(String dbfFilePath, VectorLayer aLayer) {
        ShapeFileManage.writeDbfFile(dbfFilePath, aLayer.getAttributeTable());
    }

    private static void writeDbfFile(String dbfFilePath, VectorLayer aLayer, String encoding) {
        ShapeFileManage.writeDbfFile(dbfFilePath, aLayer.getAttributeTable(), encoding);
    }

    private static void writeDbfFile(String dbfFilePath, AttributeTable attrTable) {
        attrTable.saveAs(dbfFilePath, true);
    }

    private static void writeDbfFile(String dbfFilePath, AttributeTable attrTable, String encoding) {
        attrTable.setEncoding(encoding);
        attrTable.saveAs(dbfFilePath, true);
    }

    private static void writeProjFile(String projFilePath, VectorLayer layer) {
        ShapeFileManage.writeProjFile(projFilePath, layer.getProjInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeProjFile(String projFilePath, ProjectionInfo projectionInfo) {
        BufferedWriter sw = null;
        try {
            String esriString = projectionInfo.toEsriString();
            sw = new BufferedWriter(new FileWriter(new File(projFilePath)));
            sw.write(esriString);
            sw.flush();
            sw.close();
        }
        catch (IOException ex) {
            Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sw.close();
            }
            catch (IOException ex) {
                Logger.getLogger(ShapeFileManage.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private static int swapByteOrder(int i) {
        byte[] buffer = ShapeFileManage.intToBytes(i);
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }

    private static byte[] intToBytes(int i) {
        byte[] result = new byte[]{(byte)(i >> 24 & 0xFF), (byte)(i >> 16 & 0xFF), (byte)(i >> 8 & 0xFF), (byte)(i & 0xFF)};
        return result;
    }

    private static int bytesToInt(byte[] buffer) {
        return (buffer[3] & 0xFF) << 24 | (buffer[2] & 0xFF) << 16 | (buffer[1] & 0xFF) << 8 | buffer[0] & 0xFF;
    }
}

