/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.geo.legend;

import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.meteoinfo.common.DataConvert;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.colors.ColorMap;
import org.meteoinfo.data.GridArray;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geometry.colors.Normalize;
import org.meteoinfo.geometry.colors.TransferFunction;
import org.meteoinfo.geometry.legend.ColorBreak;
import org.meteoinfo.geometry.legend.LegendScheme;
import org.meteoinfo.geometry.legend.LegendType;
import org.meteoinfo.geometry.legend.LineStyles;
import org.meteoinfo.geometry.legend.PointBreak;
import org.meteoinfo.geometry.legend.PointStyle;
import org.meteoinfo.geometry.legend.PolygonBreak;
import org.meteoinfo.geometry.legend.PolylineBreak;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.PolygonShape;
import org.meteoinfo.geometry.shape.PolylineShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.ndarray.util.BigDecimalUtil;
import org.meteoinfo.render.java2d.ContourDraw;

public class LegendManage {
    public static LegendScheme createLegendSchemeFromGridData(GridData aGridData, LegendType aLT, ShapeTypes aST) {
        double[] maxmin = new double[2];
        boolean hasUndef = aGridData.getMaxMinValue(maxmin);
        double MinData = maxmin[1];
        double MaxData = maxmin[0];
        double[] CValues = LegendManage.createContourValues(MinData, MaxData);
        Color[] colors = LegendManage.createRainBowColors(CValues.length + 1);
        LegendScheme aLS = aLT == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(CValues, colors, aST, MinData, MaxData, (Boolean)hasUndef, aGridData.getDoubleMissingValue()) : LegendManage.createGraduatedLegendScheme(CValues, colors, aST, MinData, MaxData, hasUndef, aGridData.getDoubleMissingValue());
        return aLS;
    }

    public static LegendScheme createLegendSchemeFromGridData(GridArray aGridData, LegendType aLT, ShapeTypes aST) {
        double[] maxmin = new double[2];
        boolean hasUndef = aGridData.getMaxMinValue(maxmin);
        double MinData = maxmin[1];
        double MaxData = maxmin[0];
        double[] CValues = LegendManage.createContourValues(MinData, MaxData);
        Color[] colors = LegendManage.createRainBowColors(CValues.length + 1);
        LegendScheme aLS = aLT == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(CValues, colors, aST, MinData, MaxData, (Boolean)hasUndef, aGridData.missingValue) : LegendManage.createGraduatedLegendScheme(CValues, colors, aST, MinData, MaxData, hasUndef, aGridData.missingValue);
        return aLS;
    }

    public static LegendScheme createLegendSchemeFromStationData(StationData stationData, LegendType aLT, ShapeTypes aST) {
        double[] minmax = new double[2];
        boolean hasNoData = ContourDraw.getMinMaxValueFDiscreteData((double[][])stationData.data, (double)stationData.missingValue, (double[])minmax);
        double MinData = minmax[0];
        double MaxData = minmax[1];
        double[] CValues = LegendManage.createContourValues(MinData, MaxData);
        Color[] colors = LegendManage.createRainBowColors(CValues.length + 1);
        LegendScheme aLS = aLT == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(CValues, colors, aST, MinData, MaxData, (Boolean)hasNoData, stationData.missingValue) : LegendManage.createGraduatedLegendScheme(CValues, colors, aST, MinData, MaxData, hasNoData, stationData.missingValue);
        return aLS;
    }

    public static LegendScheme createSingleSymbolLegendScheme(ShapeTypes shapeType) {
        if (shapeType.isPoint()) {
            return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.green, 8.0f);
        }
        if (shapeType.isLine()) {
            return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.blue, 1.0f);
        }
        return LegendManage.createSingleSymbolLegendScheme(shapeType, Color.cyan, 1.0f);
    }

    public static LegendScheme createSingleSymbolLegendScheme(ShapeTypes aST, Color aColor, float size) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.SINGLE_SYMBOL);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(0.0);
        legendScheme.setMaxValue(0.0);
        legendScheme.setUndefValue(-9999.0);
        legendScheme.setLegendBreaks(new ArrayList());
        if (aST.isPoint()) {
            PointBreak aPB = new PointBreak();
            aPB.setColor(aColor);
            aPB.setOutlineColor(Color.black);
            aPB.setSize(size);
            aPB.setNoData(false);
            aPB.setDrawFill(true);
            aPB.setDrawOutline(true);
            aPB.setDrawShape(true);
            aPB.setStyle(PointStyle.CIRCLE);
            aPB.setStartValue((Object)0);
            aPB.setEndValue((Object)0);
            aPB.setCaption("");
            legendScheme.getLegendBreaks().add(aPB);
        } else if (aST.isLine()) {
            PolylineBreak aPLB = new PolylineBreak();
            aPLB.setColor(aColor);
            aPLB.setDrawPolyline(true);
            aPLB.setWidth(size);
            aPLB.setStyle(LineStyles.SOLID);
            aPLB.setStartValue((Object)0);
            aPLB.setEndValue((Object)0);
            aPLB.setCaption("");
            aPLB.setSymbolColor(aColor);
            legendScheme.getLegendBreaks().add(aPLB);
        } else if (aST.isPolygon()) {
            PolygonBreak aPGB = new PolygonBreak();
            aPGB.setColor(aColor);
            aPGB.setDrawFill(true);
            aPGB.setDrawOutline(true);
            aPGB.setDrawShape(true);
            aPGB.setOutlineColor(Color.gray);
            aPGB.setOutlineSize(size);
            aPGB.setStartValue((Object)0);
            aPGB.setEndValue((Object)0);
            aPGB.setCaption("");
            legendScheme.getLegendBreaks().add(aPGB);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, List<String> captions, Color[] colors, ShapeTypes aST, double min, double max, boolean hasNodata, double unDef) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        legendScheme.setUndefValue(unDef);
        if (aST.isPoint()) {
            for (int i = 1; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue((Object)CValues.get(i - 1));
                aPB.setEndValue(aPB.getStartValue());
                if (colors.length <= 13) {
                    aPB.setSize((float)i / 2.0f + 2.0f);
                } else {
                    aPB.setSize(5.0f);
                }
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            for (int i = 1; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue((Object)CValues.get(i - 1));
                aPLB.setEndValue(aPLB.getStartValue());
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(captions.get(i - 1));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.CIRCLE);
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 1; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue((Object)CValues.get(i - 1));
                aPGB.setEndValue(aPGB.getStartValue());
                aPGB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, List<String> captions, Color[] colors, ShapeTypes aST, double min, double max) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        if (aST.isPoint()) {
            for (int i = 1; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue((Object)CValues.get(i - 1));
                aPB.setEndValue(aPB.getStartValue());
                if (colors.length <= 13) {
                    aPB.setSize((float)i / 2.0f + 2.0f);
                } else {
                    aPB.setSize(5.0f);
                }
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            for (int i = 1; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue((Object)CValues.get(i - 1));
                aPLB.setEndValue(aPLB.getStartValue());
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(captions.get(i - 1));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.CIRCLE);
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 1; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue((Object)CValues.get(i - 1));
                aPGB.setEndValue(aPGB.getStartValue());
                aPGB.setCaption(captions.get(i - 1));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(int n, ShapeTypes aST) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        Color[] colors = n <= 13 ? LegendManage.createRainBowColors(n) : LegendManage.createRandomColors(n);
        if (aST.isPoint()) {
            for (int i = 0; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue((Object)i);
                aPB.setEndValue((Object)i);
                aPB.setSize(6.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(String.valueOf(i));
                legendScheme.getLegendBreaks().add(aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            int ii = 0;
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue((Object)i);
                aPLB.setEndValue((Object)i);
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(String.valueOf(i));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.values()[ii]);
                if (++ii == PointStyle.values().length) {
                    ii = 0;
                }
                legendScheme.getLegendBreaks().add(aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue((Object)i);
                aPGB.setEndValue((Object)i);
                aPGB.setCaption(String.valueOf(i));
                legendScheme.getLegendBreaks().add(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, ShapeTypes aST) {
        int n = values.size();
        Color[] colors = n <= 13 ? LegendManage.createRainBowColors(n) : LegendManage.createRandomColors(n);
        return LegendManage.createUniqValueLegendScheme(values, colors, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, ColorMap cmap, ShapeTypes aST) {
        int n = values.size();
        Color[] colors = cmap.getColors(n);
        return LegendManage.createUniqValueLegendScheme(values, colors, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, Color[] colors, ShapeTypes aST) {
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.UNIQUE_VALUE);
        legendScheme.setShapeType(aST);
        if (aST.isPoint()) {
            for (int i = 0; i < colors.length; ++i) {
                PointBreak aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setStartValue((Object)values.get(i));
                aPB.setEndValue((Object)values.get(i));
                aPB.setSize(6.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                aPB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak((ColorBreak)aPB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isLine()) {
            int ii = 0;
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setStartValue((Object)values.get(i));
                aPLB.setEndValue((Object)values.get(i));
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                aPLB.setCaption(String.valueOf(values.get(i)));
                aPLB.setSymbolColor(aPLB.getColor());
                aPLB.setSymbolStyle(PointStyle.values()[ii]);
                if (++ii == PointStyle.values().length) {
                    ii = 0;
                }
                legendScheme.addLegendBreak((ColorBreak)aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(true);
                aPGB.setDrawShape(true);
                aPGB.setStartValue((Object)values.get(i));
                aPGB.setEndValue((Object)values.get(i));
                aPGB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak((ColorBreak)aPGB);
            }
            legendScheme.setHasNoData(false);
        } else {
            for (int i = 0; i < colors.length; ++i) {
                ColorBreak aPGB = new ColorBreak();
                aPGB.setColor(colors[i]);
                aPGB.setDrawShape(true);
                aPGB.setStartValue((Object)values.get(i));
                aPGB.setEndValue((Object)values.get(i));
                aPGB.setCaption(String.valueOf(values.get(i)));
                legendScheme.addLegendBreak(aPGB);
            }
            legendScheme.setHasNoData(false);
        }
        return legendScheme;
    }

    public static LegendScheme createUniqValueLegendScheme(List<Number> values, List<Color> colors, ShapeTypes aST) {
        Color[] cols = colors.toArray(new Color[0]);
        return LegendManage.createUniqValueLegendScheme(values, cols, aST);
    }

    public static LegendScheme createUniqValueLegendScheme(List<String> CValues, Color[] colors, ShapeTypes aST, double min, double max, boolean hasNodata, double unDef) {
        return LegendManage.createUniqValueLegendScheme(CValues, CValues, colors, aST, min, max, hasNodata, unDef);
    }

    public static LegendScheme createUniqValueLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max, Boolean hasNodata, double unDef) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> captions = new ArrayList<String>();
        String dFormat = "%1$." + String.valueOf(MIMath.getDecimalNum((double)CValues[0])) + "f";
        for (double v : CValues) {
            captions.add(String.format(dFormat, v));
            values.add(String.valueOf(v));
        }
        return LegendManage.createUniqValueLegendScheme(values, captions, colors, aST, min, max, hasNodata, unDef);
    }

    public static LegendScheme createUniqValueLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max) {
        ArrayList<String> values = new ArrayList<String>();
        ArrayList<String> captions = new ArrayList<String>();
        String dFormat = "%1$." + String.valueOf(MIMath.getDecimalNum((double)CValues[0])) + "f";
        for (double v : CValues) {
            captions.add(String.format(dFormat, v));
            values.add(String.valueOf(v));
        }
        return LegendManage.createUniqValueLegendScheme(values, captions, colors, aST, min, max);
    }

    /*
     * WARNING - void declaration
     */
    public static LegendScheme createUniqValueLegendScheme(VectorLayer aLayer, double min, double max) {
        void var9_12;
        ArrayList<Double> valueList = new ArrayList<Double>();
        switch (aLayer.getShapeType()) {
            case POINT: {
                for (Shape shape : aLayer.getShapes()) {
                    if (valueList.contains(((PointShape)shape).getValue())) continue;
                    valueList.add(((PointShape)shape).getValue());
                }
                break;
            }
            case POLYLINE: 
            case POLYLINE_Z: {
                for (Shape shape : aLayer.getShapes()) {
                    if (valueList.contains(((PolylineShape)shape).getValue())) continue;
                    valueList.add(((PolylineShape)shape).getValue());
                }
                break;
            }
            default: {
                for (Shape shape : aLayer.getShapes()) {
                    if (valueList.contains(((PolygonShape)shape).lowValue)) continue;
                    valueList.add(((PolygonShape)shape).lowValue);
                }
            }
        }
        double[] CValues = new double[valueList.size()];
        for (int i = 0; i < valueList.size(); ++i) {
            CValues[i] = (Double)valueList.get(i);
        }
        Color[] colors = CValues.length <= 13 ? LegendManage.createRainBowColors(CValues.length) : LegendManage.createRandomColors(CValues.length);
        Color[] newcolors = new Color[colors.length + 1];
        newcolors[0] = Color.white;
        boolean bl = true;
        while (var9_12 < newcolors.length) {
            newcolors[var9_12] = colors[var9_12 - true];
            ++var9_12;
        }
        LegendScheme legendScheme = LegendManage.createUniqValueLegendScheme(CValues, newcolors, aLayer.getShapeType(), min, max, (Boolean)false, -9999.0);
        return legendScheme;
    }

    public static LegendScheme createGraduatedLegendScheme(double[] CValues, Color[] colors, ShapeTypes aST, double min, double max, Boolean hasNodata, double unDef) {
        if (CValues.length > 1) {
            if (min >= CValues[0]) {
                min = CValues[0] - (CValues[1] - CValues[0]);
            }
            if (max <= CValues[CValues.length - 1]) {
                max = CValues[CValues.length - 1] + (CValues[CValues.length - 1] - CValues[CValues.length - 2]);
            }
        }
        LegendScheme legendScheme = new LegendScheme(aST);
        legendScheme.setLegendType(LegendType.GRADUATED_COLOR);
        legendScheme.setShapeType(aST);
        legendScheme.setMinValue(min);
        legendScheme.setMaxValue(max);
        legendScheme.setUndefValue(unDef);
        if (aST.isPoint()) {
            PointBreak aPB;
            for (int i = 0; i < colors.length; ++i) {
                aPB = new PointBreak();
                aPB.setColor(colors[i]);
                aPB.setOutlineColor(Color.black);
                aPB.setNoData(false);
                aPB.setDrawOutline(true);
                aPB.setDrawFill(true);
                aPB.setDrawShape(true);
                if (i == 0) {
                    aPB.setStartValue((Object)min);
                } else {
                    aPB.setStartValue((Object)CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPB.setEndValue((Object)max);
                } else {
                    aPB.setEndValue((Object)CValues[i]);
                }
                aPB.setSize(8.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                if (aPB.getStartValue() == aPB.getEndValue()) {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else if (i == 0) {
                    aPB.setCaption("< " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPB.setCaption("> " + DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()));
                } else {
                    aPB.setCaption(DataConvert.removeTailingZeros((String)aPB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak((ColorBreak)aPB);
            }
            legendScheme.setHasNoData(false);
            if (hasNodata.booleanValue()) {
                aPB = new PointBreak();
                aPB.setColor(Color.gray);
                aPB.setOutlineColor(Color.black);
                aPB.setStartValue((Object)unDef);
                aPB.setEndValue(aPB.getStartValue());
                aPB.setSize(1.0f);
                aPB.setStyle(PointStyle.CIRCLE);
                aPB.setCaption("NoData");
                aPB.setNoData(true);
                aPB.setDrawShape(true);
                aPB.setDrawOutline(true);
                legendScheme.addLegendBreak((ColorBreak)aPB);
                legendScheme.setHasNoData(true);
            }
        } else if (aST.isLine()) {
            for (int i = 0; i < colors.length; ++i) {
                PolylineBreak aPLB = new PolylineBreak();
                aPLB.setColor(colors[i]);
                aPLB.setWidth(1.0f);
                aPLB.setStyle(LineStyles.SOLID);
                aPLB.setDrawPolyline(true);
                if (i == 0) {
                    aPLB.setStartValue((Object)min);
                } else {
                    aPLB.setStartValue((Object)CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPLB.setEndValue((Object)max);
                } else {
                    aPLB.setEndValue((Object)CValues[i]);
                }
                if (aPLB.getStartValue() == aPLB.getEndValue()) {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else if (i == 0) {
                    aPLB.setCaption("< " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPLB.setCaption("> " + DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()));
                } else {
                    aPLB.setCaption(DataConvert.removeTailingZeros((String)aPLB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPLB.getEndValue().toString()));
                }
                aPLB.setSymbolColor(aPLB.getColor());
                if (i < PointStyle.values().length) {
                    aPLB.setSymbolStyle(PointStyle.values()[i]);
                }
                legendScheme.addLegendBreak((ColorBreak)aPLB);
            }
            legendScheme.setHasNoData(false);
        } else if (aST.isPolygon()) {
            for (int i = 0; i < colors.length; ++i) {
                PolygonBreak aPGB = new PolygonBreak();
                aPGB.setColor(colors[i]);
                aPGB.setOutlineColor(Color.gray);
                aPGB.setOutlineSize(1.0f);
                aPGB.setDrawFill(true);
                aPGB.setDrawOutline(false);
                aPGB.setDrawShape(true);
                if (i == 0) {
                    aPGB.setStartValue((Object)min);
                } else {
                    aPGB.setStartValue((Object)CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aPGB.setEndValue((Object)max);
                } else {
                    aPGB.setEndValue((Object)CValues[i]);
                }
                if (aPGB.getStartValue() == aPGB.getEndValue()) {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else if (i == 0) {
                    aPGB.setCaption("< " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aPGB.setCaption("> " + DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()));
                } else {
                    aPGB.setCaption(DataConvert.removeTailingZeros((String)aPGB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aPGB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak((ColorBreak)aPGB);
            }
            legendScheme.setHasNoData(false);
        } else {
            ColorBreak aCB;
            for (int i = 0; i < colors.length; ++i) {
                aCB = new ColorBreak();
                aCB.setColor(colors[i]);
                if (i == 0) {
                    aCB.setStartValue((Object)min);
                } else {
                    aCB.setStartValue((Object)CValues[i - 1]);
                }
                if (i == colors.length - 1) {
                    aCB.setEndValue((Object)max);
                } else {
                    aCB.setEndValue((Object)CValues[i]);
                }
                if (aCB.getStartValue() == aCB.getEndValue()) {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else if (i == 0) {
                    aCB.setCaption("< " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                } else if (i == colors.length - 1) {
                    aCB.setCaption("> " + DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()));
                } else {
                    aCB.setCaption(DataConvert.removeTailingZeros((String)aCB.getStartValue().toString()) + " - " + DataConvert.removeTailingZeros((String)aCB.getEndValue().toString()));
                }
                legendScheme.addLegendBreak(aCB);
            }
            legendScheme.setHasNoData(false);
            if (hasNodata.booleanValue()) {
                aCB = new ColorBreak();
                aCB.setColor(new Color(230, 230, 230, 0));
                aCB.setStartValue((Object)unDef);
                aCB.setEndValue(aCB.getStartValue());
                aCB.setCaption("NoData");
                aCB.setNoData(true);
                legendScheme.addLegendBreak(aCB);
                legendScheme.setHasNoData(true);
            }
        }
        return legendScheme;
    }

    public static LegendScheme createLegendScheme(List<Number> values, List<Color> colors) {
        if (values.size() == colors.size()) {
            return LegendManage.createUniqValueLegendScheme(values, colors, ShapeTypes.IMAGE);
        }
        double[] vs = new double[values.size()];
        for (int i = 0; i < vs.length; ++i) {
            vs[i] = values.get(i).doubleValue();
        }
        Color[] cs = new Color[values.size()];
        for (int i = 0; i < cs.length; ++i) {
            cs[i] = colors.get(i);
        }
        return LegendManage.createGraduatedLegendScheme(vs, cs, ShapeTypes.IMAGE, -1.7976931348623157E308, Double.MIN_VALUE);
    }

    public static LegendScheme createGraduatedLegendScheme(double[] values, Color[] colors, ShapeTypes aST, double min, double max) {
        double unDef = -9999.0;
        boolean hasNodata = false;
        return LegendManage.createGraduatedLegendScheme(values, colors, aST, min, max, hasNodata, unDef);
    }

    public static Color[] createColors(Color sColor, Color eColor, int cNum) {
        Color[] colors = new Color[cNum];
        int sR = sColor.getRed();
        int sG = sColor.getGreen();
        int sB = sColor.getBlue();
        int eR = eColor.getRed();
        int eG = eColor.getGreen();
        int eB = eColor.getBlue();
        int rStep = (eR - sR) / cNum;
        int gStep = (eG - sG) / cNum;
        int bStep = (eB - sB) / cNum;
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = new Color(sR + i * rStep, sG + i * gStep, sB + i * bStep);
        }
        return colors;
    }

    public static double[] createContourValuesInterval(double min, double max, double interval) {
        int cNum = (int)((max - min) / interval) + 1;
        double[] cValues = new double[cNum];
        for (int i = 0; i < cNum; ++i) {
            cValues[i] = BigDecimalUtil.add((double)min, (double)BigDecimalUtil.mul((double)i, (double)interval));
        }
        return cValues;
    }

    public static LegendScheme createLegendScheme(ShapeTypes shapeType, List<Number> values, List<Color> colors) {
        LegendScheme ls;
        Color[] cols = new Color[colors.size()];
        for (int i = 0; i < colors.size(); ++i) {
            cols[i] = colors.get(i);
        }
        if (values.size() == colors.size()) {
            ls = LegendManage.createUniqValueLegendScheme(values, cols, shapeType);
        } else {
            int n = values.size();
            double[] vals = new double[n];
            for (int i = 0; i < n; ++i) {
                vals[i] = values.get(i).doubleValue();
            }
            double min = values.get(0).doubleValue() - (values.get(1).doubleValue() - values.get(0).doubleValue());
            double max = values.get(n - 1).doubleValue() + (values.get(n - 1).doubleValue() - values.get(n - 2).doubleValue());
            ls = LegendManage.createGraduatedLegendScheme(vals, cols, shapeType, min, max);
        }
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max) {
        double[] values = LegendManage.createContourValues(min, max);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, ColorMap ct) {
        double[] values = LegendManage.createContourValues(min, max);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, ColorMap ct, double missingValue) {
        double[] values = LegendManage.createContourValues(min, max);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, missingValue);
    }

    public static LegendScheme createLegendScheme(double min, double max, double interval, LegendType legendType, ShapeTypes shapeType) {
        return LegendManage.createLegendScheme(min, max, interval, legendType, shapeType, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, double interval, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (double)interval);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        LegendScheme ls = legendType == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(values, colors, shapeType, min, max, (Boolean)hasNodata, unDef) : LegendManage.createGraduatedLegendScheme(values, colors, shapeType, min, max, hasNodata, unDef);
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max, int n) {
        return LegendManage.createLegendScheme(min, max, n, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, LegendType legendType, ShapeTypes shapeType) {
        return LegendManage.createLegendScheme(min, max, n, legendType, shapeType, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, double[] values, Color[] colors, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        LegendScheme ls = legendType == LegendType.UNIQUE_VALUE ? LegendManage.createUniqValueLegendScheme(values, colors, shapeType, min, max, (Boolean)hasNodata, unDef) : LegendManage.createGraduatedLegendScheme(values, colors, shapeType, min, max, hasNodata, unDef);
        return ls;
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = LegendManage.createRainBowColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, ColorMap ct, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, List<Number> levs, ColorMap ct, LegendType legendType, ShapeTypes shapeType, boolean hasNodata, double unDef) {
        double[] values = new double[levs.size()];
        for (int i = 0; i < levs.size(); ++i) {
            values[i] = levs.get(i).doubleValue();
        }
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, legendType, shapeType, hasNodata, unDef);
    }

    public static LegendScheme createLegendScheme(double min, double max, List<Number> levs, ColorMap ct) {
        if (levs.size() == ct.getColorCount()) {
            return LegendManage.createUniqValueLegendScheme(levs, ct.getColors(), ShapeTypes.IMAGE);
        }
        double[] values = new double[levs.size()];
        for (int i = 0; i < levs.size(); ++i) {
            values[i] = levs.get(i).doubleValue();
        }
        Color[] colors = ct.getColors(levs.size() + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(double min, double max, int n, ColorMap ct) {
        double[] values = MIMath.getIntervalValues((double)min, (double)max, (int)n);
        Color[] colors = ct.getColors(values.length + 1);
        return LegendManage.createLegendScheme(min, max, values, colors, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, -9999.0);
    }

    public static LegendScheme createLegendScheme(GridData gdata, double interval, LegendType legendType, ShapeTypes shapeType) {
        double[] maxmin = new double[2];
        boolean hasUndef = gdata.getMaxMinValue(maxmin);
        double min = maxmin[1];
        double max = maxmin[0];
        return LegendManage.createLegendScheme(min, max, interval, legendType, shapeType, hasUndef, gdata.getDoubleMissingValue());
    }

    public static LegendScheme createLegendScheme(GridData gdata, int n, LegendType legendType, ShapeTypes shapeType) {
        double[] maxmin = new double[2];
        boolean hasUndef = gdata.getMaxMinValue(maxmin);
        double min = maxmin[1];
        double max = maxmin[0];
        return LegendManage.createLegendScheme(min, max, n, legendType, shapeType, hasUndef, gdata.getDoubleMissingValue());
    }

    public static LegendScheme createLegendScheme(GridData gdata, int n, ColorMap ct, LegendType legendType, ShapeTypes shapeType) {
        double[] maxmin = new double[2];
        boolean hasUndef = gdata.getMaxMinValue(maxmin);
        double min = maxmin[1];
        double max = maxmin[0];
        return LegendManage.createLegendScheme(min, max, n, ct, legendType, shapeType, hasUndef, gdata.getDoubleMissingValue());
    }

    public static LegendScheme createLegendScheme(GridData gdata, int n, ColorMap ct) throws IOException {
        if (ct != null) {
            return LegendManage.createLegendScheme(gdata, n, ct, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE);
        }
        return LegendManage.createLegendScheme(gdata, n, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE);
    }

    public static LegendScheme createLegendScheme(StationData stdata, int n, ColorMap ct, LegendType legendType, ShapeTypes shapeType) throws IOException {
        double[] maxmin = new double[2];
        boolean hasMissingValue = stdata.getMaxMinValue(maxmin);
        double max = maxmin[0];
        double min = maxmin[1];
        if (ct != null) {
            return LegendManage.createLegendScheme(min, max, n, ct, legendType, shapeType, hasMissingValue, stdata.missingValue);
        }
        return LegendManage.createLegendScheme(min, max, n, legendType, shapeType, hasMissingValue, stdata.missingValue);
    }

    public static LegendScheme createLegendScheme(TransferFunction transferFunction) {
        ColorMap colorMap = transferFunction.getColorMap();
        Color[] colors = colorMap.getColors();
        int n = colors.length;
        Normalize norm = transferFunction.getNormalize();
        double[] values = MIMath.getIntervalValues((double)norm.getMinValue(), (double)norm.getMaxValue(), (int)(n - 1));
        LegendScheme ls = LegendManage.createGraduatedLegendScheme(values, colors, ShapeTypes.POLYGON, norm.getMinValue(), norm.getMaxValue());
        ls.setColorMap(colorMap);
        ls.setNormalize(norm);
        return ls;
    }

    public static LegendScheme createImageLegend(GridData gdata, ColorMap cmap) {
        LegendScheme ls;
        boolean isUnique = gdata.testUniqueValues();
        if (isUnique) {
            List values = gdata.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme((List<Number>)values, cmap, ShapeTypes.POLYGON);
        } else {
            ls = gdata.hasMissing() ? LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), cmap, Double.NaN) : LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), cmap);
        }
        return ls;
    }

    public static LegendScheme createImageLegend(GridArray gdata, ColorMap cmap) {
        LegendScheme ls;
        boolean isUnique = gdata.testUniqueValues();
        if (isUnique) {
            List values = gdata.getUniqueValues();
            ls = LegendManage.createUniqValueLegendScheme((List<Number>)values, cmap, ShapeTypes.POLYGON);
        } else {
            ls = gdata.hasNaN() ? LegendManage.createLegendScheme(gdata.min(), gdata.max(), cmap, Double.NaN) : LegendManage.createLegendScheme(gdata.min(), gdata.max(), cmap);
        }
        return ls;
    }

    public static LegendScheme createImageLegend(GridData gdata, int n, ColorMap cmap) {
        LegendScheme ls = gdata.hasMissing() ? LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), n, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), n, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN);
        return ls;
    }

    public static LegendScheme createImageLegend(GridArray gdata, int n, ColorMap cmap) {
        LegendScheme ls = gdata.hasNaN() ? LegendManage.createLegendScheme(gdata.min(), gdata.max(), n, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(gdata.min(), gdata.max(), n, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN);
        return ls;
    }

    public static LegendScheme createImageLegend(GridData gdata, List<Number> levs, ColorMap cmap) {
        LegendScheme ls = cmap.getColorCount() == levs.size() ? LegendManage.createUniqValueLegendScheme(levs, cmap, ShapeTypes.IMAGE) : (gdata.hasMissing() ? LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), levs, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(gdata.getMinValue(), gdata.getMaxValue(), levs, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN));
        return ls;
    }

    public static LegendScheme createImageLegend(GridArray gdata, List<Number> levs, ColorMap cmap) {
        LegendScheme ls = cmap.getColorCount() == levs.size() ? LegendManage.createUniqValueLegendScheme(levs, cmap, ShapeTypes.IMAGE) : (gdata.hasNaN() ? LegendManage.createLegendScheme(gdata.min(), gdata.max(), levs, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, true, Double.NaN) : LegendManage.createLegendScheme(gdata.min(), gdata.max(), levs, cmap, LegendType.GRADUATED_COLOR, ShapeTypes.IMAGE, false, Double.NaN));
        return ls;
    }

    public static Color[] createRandomColors(int cNum) {
        Color[] colors = new Color[cNum];
        Random randomColor = new Random();
        for (int i = 0; i < cNum; ++i) {
            colors[i] = new Color(randomColor.nextInt(256), randomColor.nextInt(256), randomColor.nextInt(256));
        }
        return colors;
    }

    public static Color[] createRainBowColors(int cNum) {
        if (cNum > 13) {
            return LegendManage.getRainBowColors_HSV(cNum);
        }
        ArrayList<Color> colorList = new ArrayList<Color>();
        colorList.add(new Color(160, 0, 200));
        colorList.add(new Color(110, 0, 220));
        colorList.add(new Color(30, 60, 255));
        colorList.add(new Color(0, 160, 255));
        colorList.add(new Color(0, 200, 200));
        colorList.add(new Color(0, 210, 140));
        colorList.add(new Color(0, 220, 0));
        colorList.add(new Color(160, 230, 50));
        colorList.add(new Color(230, 220, 50));
        colorList.add(new Color(230, 175, 45));
        colorList.add(new Color(240, 130, 40));
        colorList.add(new Color(250, 60, 60));
        colorList.add(new Color(240, 0, 130));
        switch (cNum) {
            case 12: {
                colorList.remove(new Color(0, 210, 140));
                break;
            }
            case 11: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                break;
            }
            case 10: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                break;
            }
            case 9: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                break;
            }
            case 8: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                break;
            }
            case 7: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                break;
            }
            case 6: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                break;
            }
            case 5: {
                colorList.remove(new Color(0, 210, 140));
                colorList.remove(new Color(30, 60, 255));
                colorList.remove(new Color(230, 175, 45));
                colorList.remove(new Color(160, 230, 50));
                colorList.remove(new Color(110, 0, 220));
                colorList.remove(new Color(0, 200, 200));
                colorList.remove(new Color(240, 130, 40));
                colorList.remove(new Color(160, 0, 200));
            }
        }
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[i] = (Color)colorList.get(i);
        }
        return colors;
    }

    public static Color[] getRainBowColors_HSV(int cNum) {
        double p = 360.0 / (double)cNum;
        Color[] colors = new Color[cNum];
        for (int i = 0; i < cNum; ++i) {
            colors[cNum - i - 1] = Color.getHSBColor((float)((double)i * p), 1.0f, 1.0f);
        }
        return colors;
    }

    public static double[] createContourValues(double min, double max) {
        double newMin;
        int cNum;
        double cDelt;
        double range = BigDecimalUtil.sub((double)max, (double)min);
        if (range == 0.0) {
            double[] cValues = new double[]{min};
            return cValues;
        }
        DecimalFormat formatter = new DecimalFormat("#.####E0");
        String eStr = formatter.format(range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        if (aD > 5) {
            cDelt = Math.pow(10.0, aE);
            cNum = aD;
            newMin = BigDecimalUtil.mul((double)((int)(min / cDelt + 1.0)), (double)cDelt);
        } else if (aD == 5) {
            cDelt = BigDecimalUtil.mul((double)aD, (double)Math.pow(10.0, aE - 1));
            cNum = 10;
            newMin = BigDecimalUtil.mul((double)((int)(min / cDelt + 1.0)), (double)cDelt);
            ++cNum;
        } else {
            cDelt = BigDecimalUtil.pow((double)10.0, (int)(aE - 1));
            cDelt = BigDecimalUtil.mul((double)aD, (double)cDelt);
            cNum = 10;
            int newDelta = (int)(min / cDelt + 1.0);
            newMin = BigDecimalUtil.mul((double)newDelta, (double)cDelt);
        }
        if (newMin + (double)(cNum - 1) * cDelt > max) {
            --cNum;
        }
        double[] cValues = new double[cNum];
        for (int i = 0; i < cNum; ++i) {
            cValues[i] = BigDecimalUtil.add((double)newMin, (double)BigDecimalUtil.mul((double)i, (double)cDelt));
        }
        return cValues;
    }

    public static Object[] getContoursAndColors(LegendScheme aLS) {
        Color[] colors;
        double[] cValues;
        block9: {
            ShapeTypes st;
            block10: {
                block8: {
                    if (aLS.getHasNoData()) {
                        cValues = new double[aLS.getBreakNum() - 2];
                        colors = new Color[aLS.getBreakNum() - 1];
                    } else {
                        cValues = new double[aLS.getBreakNum() - 1];
                        colors = new Color[aLS.getBreakNum()];
                    }
                    st = aLS.getShapeType();
                    if (!st.isPoint()) break block8;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                        if (aPB.isNoData()) continue;
                        colors[i] = aPB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPB.getStartValue().toString());
                    }
                    break block9;
                }
                if (!st.isLine()) break block10;
                if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                    cValues = new double[aLS.getBreakNum()];
                    colors = new Color[aLS.getBreakNum() + 1];
                    colors[0] = Color.white;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i + 1] = aPLB.getColor();
                        cValues[i] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                } else {
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i] = aPLB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                }
                break block9;
            }
            if (!st.isPolygon()) break block9;
            for (int i = 0; i < aLS.getBreakNum(); ++i) {
                PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                colors[i] = aPGB.getColor();
                if (i <= 0) continue;
                cValues[i - 1] = Double.parseDouble(aPGB.getStartValue().toString());
            }
        }
        return new Object[]{cValues, colors};
    }

    public static void setContoursAndColors(LegendScheme aLS, double[] cValues, Color[] colors) {
        block9: {
            ShapeTypes st;
            block10: {
                block8: {
                    if (aLS.getHasNoData()) {
                        cValues = new double[aLS.getBreakNum() - 2];
                        colors = new Color[aLS.getBreakNum() - 1];
                    } else {
                        cValues = new double[aLS.getBreakNum() - 1];
                        colors = new Color[aLS.getBreakNum()];
                    }
                    st = aLS.getShapeType();
                    if (!st.isPoint()) break block8;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PointBreak aPB = (PointBreak)aLS.getLegendBreaks().get(i);
                        if (aPB.isNoData()) continue;
                        colors[i] = aPB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPB.getStartValue().toString());
                    }
                    break block9;
                }
                if (!st.isLine()) break block10;
                if (aLS.getLegendType() == LegendType.UNIQUE_VALUE) {
                    cValues = new double[aLS.getBreakNum()];
                    colors = new Color[aLS.getBreakNum() + 1];
                    colors[0] = Color.white;
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i + 1] = aPLB.getColor();
                        cValues[i] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                } else {
                    for (int i = 0; i < aLS.getBreakNum(); ++i) {
                        PolylineBreak aPLB = (PolylineBreak)aLS.getLegendBreaks().get(i);
                        colors[i] = aPLB.getColor();
                        if (i <= 0) continue;
                        cValues[i - 1] = Double.parseDouble(aPLB.getStartValue().toString());
                    }
                }
                break block9;
            }
            if (!st.isPolygon()) break block9;
            for (int i = 0; i < aLS.getBreakNum(); ++i) {
                PolygonBreak aPGB = (PolygonBreak)aLS.getLegendBreaks().get(i);
                colors[i] = aPGB.getColor();
                if (i <= 0) continue;
                cValues[i - 1] = Double.parseDouble(aPGB.getStartValue().toString());
            }
        }
    }
}

