/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.common;

import java.awt.Point;
import java.awt.Rectangle;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.meteoinfo.common.Extent;
import org.meteoinfo.common.Extent3D;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.PointF;
import org.meteoinfo.common.util.BigDecimalUtil;

public class MIMath {
    public static boolean doubleEquals(double a, double b) {
        return MIMath.doubleEquals(a, b, 1.0E-7);
    }

    public static boolean doubleEquals(double a, double b, double epsilon) {
        double diff = Math.abs(a - b);
        return diff < epsilon || Double.isNaN(diff) && a == b;
    }

    public static boolean doubleEquals_Abs(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    public static double[] getMinMaxValue(double[] S, double unDef) {
        double min = unDef;
        double max = unDef;
        int validNum = 0;
        for (int i = 0; i < S.length; ++i) {
            if (MIMath.doubleEquals(S[i], unDef)) continue;
            if (++validNum == 1) {
                max = min = S[i];
                continue;
            }
            if (S[i] < min) {
                min = S[i];
            }
            if (!(S[i] > max)) continue;
            max = S[i];
        }
        return new double[]{min, max};
    }

    public static double[] getMinMaxValue(List<Double> S, double unDef) {
        double min = unDef;
        double max = unDef;
        int validNum = 0;
        for (int i = 0; i < S.size(); ++i) {
            if (MIMath.doubleEquals(S.get(i), unDef)) continue;
            if (++validNum == 1) {
                max = min = S.get(i).doubleValue();
                continue;
            }
            if (S.get(i) < min) {
                min = S.get(i);
            }
            if (!(S.get(i) > max)) continue;
            max = S.get(i);
        }
        return new double[]{min, max};
    }

    public static double[] getMinMaxValue(List S) {
        double min = 0.0;
        double max = 0.0;
        for (int i = 0; i < S.size(); ++i) {
            double v = (Double)S.get(i);
            if (i == 0) {
                min = v;
                max = v;
                continue;
            }
            if (min > v) {
                min = v;
            }
            if (!(max < v)) continue;
            max = v;
        }
        return new double[]{min, max};
    }

    public static int[] getMinMaxInt(List S) {
        int min = 0;
        int max = 0;
        for (int i = 0; i < S.size(); ++i) {
            int v = (Integer)S.get(i);
            if (i == 0) {
                min = v;
                max = v;
                continue;
            }
            if (min > v) {
                min = v;
            }
            if (max >= v) continue;
            max = v;
        }
        return new int[]{min, max};
    }

    public static boolean isNumeric(String strNumber) {
        try {
            Double.parseDouble(strNumber);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    public static boolean isNaN(Object o) {
        if (o instanceof Double) {
            return Double.isNaN((Double)o);
        }
        if (o instanceof Float) {
            return Float.isNaN(((Float)o).floatValue());
        }
        return false;
    }

    public static boolean isNullOrNaN(Object o) {
        if (o == null) {
            return true;
        }
        return MIMath.isNaN(o);
    }

    public static Extent getPointFsExtent(PointF[] PList) {
        Extent cET = new Extent();
        for (int i = 0; i < PList.length; ++i) {
            PointF aP = PList[i];
            if (i == 0) {
                cET.minX = aP.X;
                cET.maxX = aP.X;
                cET.minY = aP.Y;
                cET.maxY = aP.Y;
                continue;
            }
            if (cET.minX > (double)aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < (double)aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > (double)aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < (double)aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static Extent getPointFsExtent(List<PointF> PList) {
        Extent cET = new Extent();
        for (int i = 0; i < PList.size(); ++i) {
            PointF aP = PList.get(i);
            if (i == 0) {
                cET.minX = aP.X;
                cET.maxX = aP.X;
                cET.minY = aP.Y;
                cET.maxY = aP.Y;
                continue;
            }
            if (cET.minX > (double)aP.X) {
                cET.minX = aP.X;
            } else if (cET.maxX < (double)aP.X) {
                cET.maxX = aP.X;
            }
            if (cET.minY > (double)aP.Y) {
                cET.minY = aP.Y;
                continue;
            }
            if (!(cET.maxY < (double)aP.Y)) continue;
            cET.maxY = aP.Y;
        }
        return cET;
    }

    public static double mean(List<Double> aDataList) {
        double aSum = 0.0;
        for (Double v : aDataList) {
            aSum += v.doubleValue();
        }
        return aSum / (double)aDataList.size();
    }

    public static void arrayReverse(PointD[] points) {
        int left = 0;
        for (int right = points.length - 1; left < right; ++left, --right) {
            PointD temp = points[left];
            points[left] = points[right];
            points[right] = temp;
        }
    }

    public static void arrayReverse(double[] values) {
        int left = 0;
        for (int right = values.length - 1; left < right; ++left, --right) {
            double temp = values[left];
            values[left] = values[right];
            values[right] = temp;
        }
    }

    public static void arrayReverse(Object[] values) {
        int left = 0;
        for (int right = values.length - 1; left < right; ++left, --right) {
            Object temp = values[left];
            values[left] = values[right];
            values[right] = temp;
        }
    }

    public static double[] arrayMinMax(double[] values) {
        double min = values[0];
        double max = values[0];
        for (double value : values) {
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new double[]{min, max};
    }

    public static double[] arrayMinMax(Double[] values) {
        double min = values[0];
        double max = values[0];
        Double[] doubleArray = values;
        int n = doubleArray.length;
        for (int i = 0; i < n; ++i) {
            double value = doubleArray[i];
            min = Math.min(value, min);
            max = Math.max(value, max);
        }
        return new double[]{min, max};
    }

    public static PointF getCrossPoint(PointF aP1, PointF aP2, PointF bP1, PointF bP2) {
        PointF IPoint = new PointF(0.0f, 0.0f);
        double XP1 = (bP1.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP1.Y - aP1.Y);
        double XP2 = (bP2.X - aP1.X) * (aP2.Y - aP1.Y) - (aP2.X - aP1.X) * (bP2.Y - aP1.Y);
        if (XP1 == 0.0) {
            IPoint = bP1;
        } else if (XP2 == 0.0) {
            IPoint = bP2;
        } else {
            PointF p1 = aP1;
            PointF p2 = aP2;
            PointF q1 = bP1;
            PointF q2 = bP2;
            double tempLeft = (q2.X - q1.X) * (p1.Y - p2.Y) - (p2.X - p1.X) * (q1.Y - q2.Y);
            double tempRight = (p1.Y - q1.Y) * (p2.X - p1.X) * (q2.X - q1.X) + q1.X * (q2.Y - q1.Y) * (p2.X - p1.X) - p1.X * (p2.Y - p1.Y) * (q2.X - q1.X);
            IPoint.X = (float)(tempRight / tempLeft);
            tempLeft = (p1.X - p2.X) * (q2.Y - q1.Y) - (p2.Y - p1.Y) * (q1.X - q2.X);
            tempRight = p2.Y * (p1.X - p2.X) * (q2.Y - q1.Y) + (q2.X - p2.X) * (q2.Y - q1.Y) * (p1.Y - p2.Y) - q2.Y * (q1.X - q2.X) * (p2.Y - p1.Y);
            IPoint.Y = (float)(tempRight / tempLeft);
        }
        return IPoint;
    }

    public static Extent shiftExtentLon(Extent aET, double lonShift) {
        Extent cET = new Extent();
        cET.minX = aET.minX + lonShift;
        cET.maxX = aET.maxX + lonShift;
        cET.minY = aET.minY;
        cET.maxY = aET.maxY;
        return cET;
    }

    public static Extent getLagerExtent(Extent aET, Extent bET) {
        if (aET.is3D() && bET.is3D()) {
            Extent3D cET = new Extent3D();
            if (aET.isNaN()) {
                return bET;
            }
            if (bET.isNaN()) {
                return aET;
            }
            cET.minX = Math.min(aET.minX, bET.minX);
            cET.minY = Math.min(aET.minY, bET.minY);
            cET.maxX = Math.max(aET.maxX, bET.maxX);
            cET.maxY = Math.max(aET.maxY, bET.maxY);
            cET.minZ = Math.min(((Extent3D)aET).minZ, ((Extent3D)bET).minZ);
            cET.maxZ = Math.max(((Extent3D)aET).maxZ, ((Extent3D)bET).maxZ);
            return cET;
        }
        Extent cET = new Extent();
        if (aET.isNaN()) {
            return bET;
        }
        if (bET.isNaN()) {
            return aET;
        }
        cET.minX = Math.min(aET.minX, bET.minX);
        cET.minY = Math.min(aET.minY, bET.minY);
        cET.maxX = Math.max(aET.maxX, bET.maxX);
        cET.maxY = Math.max(aET.maxY, bET.maxY);
        return cET;
    }

    public static Extent getSmallerExtent(Extent aET, Extent bET) {
        Extent cET = new Extent();
        cET.minX = Math.max(aET.minX, bET.minX);
        cET.minY = Math.max(aET.minY, bET.minY);
        cET.maxX = Math.min(aET.maxX, bET.maxX);
        cET.maxY = Math.min(aET.maxY, bET.maxY);
        return cET;
    }

    public static Boolean isExtentCross(Extent aET, Extent bET) {
        if (aET.maxX < bET.minX || aET.maxY < bET.minY || bET.maxX < aET.minX || bET.maxY < aET.minY) {
            return false;
        }
        return true;
    }

    public static boolean pointInExtent(PointD aP, Extent aET) {
        return aP.X >= aET.minX && aP.X <= aET.maxX && aP.Y >= aET.minY && aP.Y <= aET.maxY;
    }

    public static boolean pointInExtent(PointF aP, Extent aET) {
        return (double)aP.X >= aET.minX && (double)aP.X <= aET.maxX && (double)aP.Y >= aET.minY && (double)aP.Y <= aET.maxY;
    }

    public static boolean pointInRectangle(PointF aP, Rectangle aRect) {
        return aP.X > (float)aRect.x && aP.X < (float)(aRect.x + aRect.width) && aP.Y > (float)aRect.y && aP.Y < (float)(aRect.y + aRect.height);
    }

    public static boolean pointInRectangle(Point aP, Rectangle aRect) {
        return aP.x > aRect.x && aP.x < aRect.x + aRect.width && aP.y > aRect.y && aP.y < aRect.y + aRect.height;
    }

    public static boolean pointInRectangle(PointD aP, Rectangle aRect) {
        return aP.X > (double)aRect.x && aP.X < (double)(aRect.x + aRect.width) && aP.Y > (double)aRect.y && aP.Y < (double)(aRect.y + aRect.height);
    }

    public static boolean isInclude(Rectangle aRect, Rectangle bRect) {
        if (aRect.width >= bRect.width && aRect.height >= bRect.height) {
            return aRect.x <= bRect.x && aRect.x + aRect.width >= bRect.x + bRect.width && aRect.y <= bRect.y && aRect.y + aRect.height >= bRect.y + bRect.height;
        }
        return false;
    }

    public static PointF calEllipseCoordByAngle(double x0, double y0, double a, double b, double angle) {
        double y;
        double x;
        double dx = Math.sqrt(a * a * b * b / (b * b + a * a * Math.tan(angle) * Math.tan(angle)));
        double dy = dx * Math.tan(angle);
        if (angle <= 1.5707963267948966) {
            x = x0 + dx;
            y = y0 + dy;
        } else if (angle <= Math.PI) {
            x = x0 - dx;
            y = y0 - dy;
        } else if (angle <= 4.71238898038469) {
            x = x0 - dx;
            y = y0 - dy;
        } else {
            x = x0 + dx;
            y = y0 + dy;
        }
        PointF aP = new PointF((float)x, (float)y);
        return aP;
    }

    public static int getDecimalNum(double aData) {
        int dNum;
        if (aData - (double)((int)aData) == 0.0) {
            return 0;
        }
        double v = aData * 10.0;
        for (dNum = 1; v - (double)((int)v) != 0.0 && dNum <= 5; ++dNum) {
            v *= 10.0;
        }
        return dNum;
    }

    public static int getDecimalNum_back(double aData) {
        if (aData - (double)((int)aData) == 0.0) {
            return 0;
        }
        int aE = (int)Math.floor(Math.log10(aData));
        int dNum = aE >= 0 ? 2 : Math.abs(aE);
        return dNum;
    }

    public static float lonDistance(float lon1, float lon2) {
        if (Math.abs(lon1 - lon2) > 180.0f) {
            if (lon1 > lon2) {
                lon2 += 360.0f;
            } else {
                lon1 += 360.0f;
            }
        }
        return Math.abs(lon1 - lon2);
    }

    public static float lonAdd(float lon1, float delta) {
        float lon = lon1 + delta;
        if (lon > 180.0f) {
            lon -= 360.0f;
        }
        if (lon < -180.0f) {
            lon += 360.0f;
        }
        return lon;
    }

    public static double getValue(double[] data, float idx) {
        double v = data[0];
        if (idx == 0.0f) {
            return v;
        }
        for (int i = 1; i < data.length; ++i) {
            if (idx == (float)i) {
                v = data[i];
                break;
            }
            if (!(idx < (float)i)) continue;
            v = data[i - 1] + (data[i] - data[i - 1]) * (double)(idx - (float)(i - 1));
            break;
        }
        return v;
    }

    public static double[] getIntervalValues(double min, double max, double interval) {
        min = BigDecimalUtil.add(min, interval);
        double mod = BigDecimalUtil.mod(min, interval);
        min = BigDecimalUtil.sub(min, mod);
        int cNum = (int)((max - min) / interval) + 1;
        double[] cValues = new double[cNum];
        for (int i = 0; i < cNum; ++i) {
            cValues[i] = BigDecimalUtil.add(min, BigDecimalUtil.mul((double)i, interval));
        }
        return cValues;
    }

    public static double[] getIntervalValues(double min, double max, double interval, int n) {
        return MIMath.getIntervalValues(min, max, interval, n, false);
    }

    public static double[] getIntervalValues(double min, double max, double interval, int n, boolean isExtend) {
        double minV = BigDecimalUtil.add(min, interval);
        double mod = BigDecimalUtil.mod(minV, interval);
        minV = BigDecimalUtil.sub(minV, mod);
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            values.add(BigDecimalUtil.add(minV, BigDecimalUtil.mul((double)i, interval)));
        }
        if (isExtend) {
            while ((Double)values.get(0) > min) {
                values.add(0, BigDecimalUtil.sub((Double)values.get(0), interval));
            }
            while ((Double)values.get(values.size() - 1) < max) {
                values.add(BigDecimalUtil.add((Double)values.get(values.size() - 1), interval));
            }
        }
        double[] cValues = values.stream().mapToDouble(Double::doubleValue).toArray();
        return cValues;
    }

    public static double[] getIntervalValues(double min, double max, int n) {
        return MIMath.getIntervalValues(min, max, n, true);
    }

    public static double[] getIntervalValues(double min, double max, int n, boolean isExtend) {
        double range = BigDecimalUtil.sub(max, min);
        if (range == 0.0) {
            return new double[]{min};
        }
        String eStr = String.format("%1$E", range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        int ln = -1;
        while (n > aD) {
            aD *= 10;
            --aE;
            ++ln;
        }
        if (ln == -1) {
            ln = 0;
        }
        BigDecimal b = new BigDecimal(range / Math.pow(10.0, aE) / (double)n);
        double bb = b.setScale(ln, RoundingMode.HALF_UP).doubleValue();
        double interval = BigDecimalUtil.mul(bb, Math.pow(10.0, aE));
        return MIMath.getIntervalValues(min, max, interval, n, isExtend);
    }

    public static double[] getIntervalValues(double min, double max) {
        return (double[])MIMath.getIntervalValues(min, max, false).get(0);
    }

    public static List<Object> getIntervalValues1(double min, double max) {
        return MIMath.getIntervalValues(min, max, false);
    }

    public static List<Object> getIntervalValuesAxis(double min, double max) {
        return MIMath.getIntervalValuesAxis(min, max, false);
    }

    public static List<Object> getIntervalValuesAxis(double min, double max, boolean isExtend) {
        int i;
        int cNum;
        double cDelt;
        ArrayList<Object> r = new ArrayList<Object>();
        double range = BigDecimalUtil.sub(max, min);
        if (range == 0.0) {
            r.add(new double[]{min});
            r.add(0.0);
            return r;
        }
        if (range < 0.0) {
            range = -range;
            double temp = min;
            min = max;
            max = temp;
        }
        String eStr = String.format("%1$E", range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        int nMin = 4;
        if (aD >= nMin) {
            cDelt = BigDecimalUtil.pow(10.0, aE);
            cNum = aD;
        } else {
            double cd = BigDecimalUtil.pow(10.0, aE - 1);
            i = 5;
            cDelt = BigDecimalUtil.mul((double)i, cd);
            cNum = (int)(range / cDelt);
            while (cNum < nMin && i > 1) {
                cDelt = BigDecimalUtil.mul((double)(--i), cd);
                cNum = (int)(range / cDelt);
            }
        }
        int temp = (int)(min / cDelt + 1.0);
        double newMin = BigDecimalUtil.mul((double)temp, cDelt);
        if (newMin - min >= cDelt) {
            newMin = BigDecimalUtil.sub(newMin, cDelt);
            ++cNum;
        }
        if (newMin + (double)(cNum - 1) * cDelt > max) {
            --cNum;
        } else if (newMin + (double)(cNum - 1) * cDelt + cDelt < max) {
            ++cNum;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (i = 0; i < cNum; ++i) {
            double v = BigDecimalUtil.add(newMin, BigDecimalUtil.mul((double)i, cDelt));
            if (!(v >= min) || !(v <= max)) continue;
            values.add(v);
        }
        if (isExtend) {
            if ((Double)values.get(0) > min) {
                values.add(0, BigDecimalUtil.sub(newMin, cDelt));
            }
            if ((Double)values.get(values.size() - 1) < max) {
                values.add(BigDecimalUtil.add((Double)values.get(values.size() - 1), cDelt));
            }
        }
        double[] cValues = new double[values.size()];
        for (i = 0; i < values.size(); ++i) {
            cValues[i] = (Double)values.get(i);
        }
        r.add(cValues);
        r.add(cDelt);
        return r;
    }

    public static List<Object> getIntervalValues(double min, double max, boolean isExtend) {
        int cNum;
        double cDelt;
        ArrayList<Object> r = new ArrayList<Object>();
        double range = BigDecimalUtil.sub(max, min);
        if (range == 0.0) {
            r.add(new double[]{min});
            r.add(0.0);
            return r;
        }
        if (range < 0.0) {
            range = -range;
            double temp = min;
            min = max;
            max = temp;
        }
        String eStr = String.format("%1$E", range);
        int aD = Integer.parseInt(eStr.substring(0, 1));
        int aE = (int)Math.floor(Math.log10(range));
        if (aD > 5) {
            cDelt = BigDecimalUtil.pow(10.0, aE);
            cNum = aD;
        } else if (aD == 5) {
            cDelt = (double)aD * BigDecimalUtil.pow(10.0, aE - 1);
            cNum = 10;
            ++cNum;
        } else {
            double cd = BigDecimalUtil.pow(10.0, aE - 1);
            cDelt = BigDecimalUtil.mul(5.0, cd);
            cNum = (int)(range / cDelt);
            if (cNum < 5 && (cNum = (int)(range / (cDelt = BigDecimalUtil.mul(2.0, cd)))) < 5) {
                cDelt = BigDecimalUtil.mul(1.0, cd);
                cNum = (int)(range / cDelt);
            }
        }
        int temp = (int)(min / cDelt + 1.0);
        double newMin = BigDecimalUtil.mul((double)temp, cDelt);
        if (newMin - min >= cDelt) {
            newMin = BigDecimalUtil.sub(newMin, cDelt);
            ++cNum;
        }
        if (newMin + (double)(cNum - 1) * cDelt > max) {
            --cNum;
        } else if (newMin + (double)(cNum - 1) * cDelt + cDelt < max) {
            ++cNum;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i = 0; i < cNum; ++i) {
            double v = BigDecimalUtil.add(newMin, BigDecimalUtil.mul((double)i, cDelt));
            if (!(v >= min) || !(v <= max)) continue;
            values.add(v);
        }
        if (isExtend) {
            if ((Double)values.get(0) > min) {
                values.add(0, BigDecimalUtil.sub(newMin, cDelt));
            }
            if ((Double)values.get(values.size() - 1) < max) {
                values.add(BigDecimalUtil.add((Double)values.get(values.size() - 1), cDelt));
            }
        }
        double[] cValues = values.stream().mapToDouble(Double::doubleValue).toArray();
        r.add(cValues);
        r.add(cDelt);
        return r;
    }

    public static double[] getIntervalValues_Log(double min, double max) {
        int minE = (int)Math.floor(Math.log10(min));
        int maxE = (int)Math.ceil(Math.log10(max));
        if (min == 0.0) {
            minE = maxE - 2;
        }
        if (max == 0.0) {
            maxE = minE + 2;
        }
        if (maxE == minE) {
            maxE = minE + 1;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int i2 = minE; i2 <= maxE; ++i2) {
            double v = Math.pow(10.0, i2);
            if (v < min) continue;
            if (v > max && values.size() > 1) break;
            values.add(v);
        }
        return values.stream().mapToDouble(i -> i).toArray();
    }

    public static double[] getIntervalValues_Log_bak(double min, double max) {
        int minE = (int)Math.floor(Math.log10(min));
        int maxE = (int)Math.ceil(Math.log10(max));
        if (min == 0.0) {
            minE = maxE - 2;
        }
        if (max == 0.0) {
            maxE = minE + 2;
        }
        ArrayList<Double> values = new ArrayList<Double>();
        for (int v = minE; v <= maxE; ++v) {
            double vv = Math.pow(10.0, v);
            if (!(vv >= min) || !(vv <= max)) continue;
            values.add(vv);
        }
        double[] cValues = new double[values.size()];
        for (int i = 0; i < values.size(); ++i) {
            cValues[i] = (Double)values.get(i);
        }
        return cValues;
    }

    public static double[] cartesianToPolar(double x, double y) {
        double r = Math.hypot(x, y);
        double B = Math.atan2(y, x);
        return new double[]{B, r};
    }

    public static double[] polarToCartesian(double B, double r) {
        double x = Math.cos(B) * r;
        double y = Math.sin(B) * r;
        return new double[]{x, y};
    }

    public static double[] getDSFromUV(double U, double V) {
        double windDir;
        double windSpeed = Math.sqrt(U * U + V * V);
        if (windSpeed == 0.0) {
            windDir = 0.0;
        } else {
            windDir = Math.asin(U / windSpeed) * 180.0 / Math.PI;
            if (U < 0.0 && V < 0.0) {
                windDir = 180.0 - windDir;
            } else if (U > 0.0 && V < 0.0) {
                windDir = 180.0 - windDir;
            } else if (U < 0.0 && V > 0.0) {
                windDir = 360.0 + windDir;
            }
            windDir += 180.0;
            if (windDir >= 360.0) {
                windDir -= 360.0;
            }
        }
        return new double[]{windDir, windSpeed};
    }

    public static double[] getUVFromDS(double windDir, double windSpeed) {
        double dir = windDir + 180.0;
        if (dir > 360.0) {
            dir -= 360.0;
        }
        dir = dir * Math.PI / 180.0;
        double U = windSpeed * Math.sin(dir);
        double V = windSpeed * Math.cos(dir);
        return new double[]{U, V};
    }

    public static double[] getEndPoint(double x, double y, double angle, double len) {
        double[] r = MIMath.getUVFromDS(angle, len);
        r[0] = r[0] + x;
        r[1] = r[1] + y;
        return r;
    }

    public static double[] uv2ds(double u, double v) {
        double wd;
        double ws = Math.sqrt(u * u + v * v);
        if (ws == 0.0) {
            wd = 0.0;
        } else {
            wd = Math.asin(u / ws) * 180.0 / Math.PI;
            if (u <= 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u > 0.0 && v < 0.0) {
                wd = 180.0 - wd;
            } else if (u < 0.0 && v > 0.0) {
                wd = 360.0 + wd;
            }
            wd += 180.0;
            if (wd >= 360.0) {
                wd -= 360.0;
            }
        }
        return new double[]{wd, ws};
    }

    public static double[] ds2uv(double windDir, double windSpeed) {
        double dir = windDir + 180.0;
        if (dir > 360.0) {
            dir -= 360.0;
        }
        dir = dir * Math.PI / 180.0;
        double u = windSpeed * Math.sin(dir);
        double v = windSpeed * Math.cos(dir);
        return new double[]{u, v};
    }

    public static <T extends Comparable<T>, U> void sortAndRearrange(List<T> listA, List<U> listB) {
        if (listA.size() != listB.size()) {
            throw new IllegalArgumentException("The two lists must be of the same size");
        }
        ArrayList<AbstractMap.SimpleEntry<Comparable, Integer>> entries = new ArrayList<AbstractMap.SimpleEntry<Comparable, Integer>>();
        for (int i = 0; i < listA.size(); ++i) {
            entries.add(new AbstractMap.SimpleEntry<Comparable, Integer>((Comparable)listA.get(i), i));
        }
        Collections.sort(entries, Map.Entry.comparingByKey());
        ArrayList<Comparable> sortedA = new ArrayList<Comparable>();
        ArrayList<U> sortedB = new ArrayList<U>();
        for (Map.Entry entry : entries) {
            sortedA.add((Comparable)entry.getKey());
            sortedB.add(listB.get((Integer)entry.getValue()));
        }
        listA.clear();
        listA.addAll(sortedA);
        listB.clear();
        listB.addAll(sortedB);
    }

    public static <T extends Comparable<T>> List<Integer> sort(List<T> list) {
        ArrayList<AbstractMap.SimpleEntry<Comparable, Integer>> entries = new ArrayList<AbstractMap.SimpleEntry<Comparable, Integer>>();
        for (int i = 0; i < list.size(); ++i) {
            entries.add(new AbstractMap.SimpleEntry<Comparable, Integer>((Comparable)list.get(i), i));
        }
        Collections.sort(entries, Map.Entry.comparingByKey());
        ArrayList<Comparable> sorted = new ArrayList<Comparable>();
        ArrayList<Integer> sortIndex = new ArrayList<Integer>();
        for (Map.Entry entry : entries) {
            sorted.add((Comparable)entry.getKey());
            sortIndex.add((Integer)entry.getValue());
        }
        list.clear();
        list.addAll(sorted);
        return sortIndex;
    }
}

