/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import com.google.re2j.Matcher;
import com.google.re2j.Pattern;
import java.io.IOException;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.iosp.bufr.BitCounterUncompressed;
import ucar.nc2.iosp.bufr.BufrDataDescriptionSection;
import ucar.nc2.iosp.bufr.BufrDataSection;
import ucar.nc2.iosp.bufr.BufrIdentificationSection;
import ucar.nc2.iosp.bufr.BufrIndicatorSection;
import ucar.nc2.iosp.bufr.BufrTableLookup;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.DataDescriptorTreeConstructor;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.nc2.time.CalendarDate;
import ucar.unidata.io.RandomAccessFile;

public class Message {
    private static final Pattern wmoPattern = Pattern.compile((String)".*([IJ]..... ....) .*");
    public BufrIndicatorSection is;
    public BufrIdentificationSection ids;
    public BufrDataDescriptionSection dds;
    public BufrDataSection dataSection;
    private RandomAccessFile raf;
    private BufrTableLookup lookup;
    private DataDescriptor root;
    private String header;
    private long startPos;
    private byte[] raw;
    BitCounterUncompressed[] counterDatasets;
    int msg_nbits;

    public Message(RandomAccessFile raf, BufrIndicatorSection is, BufrIdentificationSection ids, BufrDataDescriptionSection dds, BufrDataSection dataSection) throws IOException {
        this.raf = raf;
        this.is = is;
        this.ids = ids;
        this.dds = dds;
        this.dataSection = dataSection;
        this.lookup = BufrTableLookup.factory(this);
    }

    void setTableLookup(TableLookup lookup) {
        this.lookup.setTableLookup(lookup);
    }

    public void close() throws IOException {
        if (this.raf != null) {
            this.raf.close();
        }
    }

    public int getNumberDatasets() {
        return this.dds.getNumberDatasets();
    }

    public CalendarDate getReferenceTime() {
        return this.ids.getReferenceTime();
    }

    public void setHeader(String header) {
        this.header = header;
    }

    public String getHeader() {
        return this.header;
    }

    public void setStartPos(long startPos) {
        this.startPos = startPos;
    }

    public long getStartPos() {
        return this.startPos;
    }

    public void setRawBytes(byte[] raw) {
        this.raw = raw;
    }

    public byte[] getRawBytes() {
        return this.raw;
    }

    public String extractWMO() {
        Matcher matcher = wmoPattern.matcher((CharSequence)this.header);
        if (!matcher.matches()) {
            return "";
        }
        return matcher.group(1);
    }

    public long getMessageSize() {
        return this.is.getBufrLength();
    }

    public DataDescriptor getRootDataDescriptor() {
        if (this.root == null) {
            this.root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        }
        return this.root;
    }

    public boolean usesLocalTable() throws IOException {
        DataDescriptor root = this.getRootDataDescriptor();
        return this.usesLocalTable(root);
    }

    private boolean usesLocalTable(DataDescriptor dds) {
        for (DataDescriptor key : dds.getSubKeys()) {
            if (key.isLocal()) {
                return true;
            }
            if (key.getSubKeys() == null || !this.usesLocalTable(key)) continue;
            return true;
        }
        return false;
    }

    public boolean containsBufrTable() {
        for (Short key : this.dds.getDataDescriptors()) {
            if (!Descriptor.isBufrTable(key)) continue;
            return true;
        }
        return false;
    }

    public boolean isTablesComplete() {
        DataDescriptor root = this.getRootDataDescriptor();
        return !root.isBad;
    }

    public BufrTableLookup getLookup() {
        return this.lookup;
    }

    public boolean isBitCountOk() {
        this.getRootDataDescriptor();
        this.getTotalBits();
        int nbytesCounted = this.getCountedDataBytes();
        int nbytesGiven = this.dataSection.getDataLength();
        return Math.abs(nbytesCounted - nbytesGiven) <= 1;
    }

    public int getCountedDataBytes() {
        int msg_nbytes = this.msg_nbits / 8;
        if (this.msg_nbits % 8 != 0) {
            ++msg_nbytes;
        }
        if ((msg_nbytes += 4) % 2 != 0) {
            ++msg_nbytes;
        }
        return msg_nbytes;
    }

    public int getCountedDataBits() {
        return this.msg_nbits;
    }

    public BitCounterUncompressed getBitCounterUncompressed(int obsOffsetInMessage) {
        if (this.dds.isCompressed()) {
            throw new IllegalArgumentException("cant call BufrMessage.getBitOffset() on compressed message");
        }
        this.calcTotalBits(null);
        return this.counterDatasets[obsOffsetInMessage];
    }

    public int getTotalBits() {
        if (this.msg_nbits == 0) {
            this.calcTotalBits(null);
        }
        return this.msg_nbits;
    }

    public int calcTotalBits(Formatter out) {
        try {
            if (!this.dds.isCompressed()) {
                MessageUncompressedDataReader reader = new MessageUncompressedDataReader();
                reader.readData(null, this, this.raf, null, false, out);
            } else {
                MessageCompressedDataReader reader = new MessageCompressedDataReader();
                reader.readData(null, this, this.raf, null, out);
            }
        }
        catch (IOException ioe) {
            return 0;
        }
        return this.msg_nbits;
    }

    public int hashCode() {
        int result = 17;
        result += 37 * result + this.getDDShashcode();
        result += 37 * result + this.ids.getCategory();
        result += 37 * result + this.ids.getSubCategory();
        return result;
    }

    public int getDDShashcode() {
        this.root = this.getRootDataDescriptor();
        return this.root.hashCode2();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Message)) {
            return false;
        }
        Message o = (Message)obj;
        if (!this.dds.getDataDescriptors().equals(o.dds.getDataDescriptors())) {
            return false;
        }
        if (this.ids.getCenterId() != o.ids.getCenterId()) {
            return false;
        }
        if (this.ids.getCategory() != o.ids.getCategory()) {
            return false;
        }
        return this.ids.getSubCategory() == o.ids.getSubCategory();
    }

    public void showMissingFields(Formatter out) throws IOException {
        this.lookup.showMissingFields(this.dds.getDataDescriptors(), out);
    }

    public void dump(Formatter out) {
        int listHash = this.dds.getDataDescriptors().hashCode();
        out.format(" BUFR edition %d time= %s wmoHeader=%s hash=[0x%x] listHash=[0x%x] (%d) %n", this.is.getBufrEdition(), this.getReferenceTime(), this.getHeader(), this.hashCode(), listHash, listHash);
        out.format("   Category= %s %n", this.lookup.getCategoryFullName());
        out.format("   Center= %s %n", this.lookup.getCenterName());
        out.format("   Table= %s %n", this.lookup.getTableName());
        out.format("    Table B= wmoTable= %s localTable= %s mode=%s%n", new Object[]{this.lookup.getWmoTableBName(), this.lookup.getLocalTableBName(), this.lookup.getMode()});
        out.format("    Table D= wmoTable= %s localTable= %s%n", this.lookup.getWmoTableDName(), this.lookup.getLocalTableDName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b%n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
        long startPos = this.is.getStartPos();
        long startData = this.dataSection.getDataPos();
        out.format("  startPos=%d len=%d endPos=%d dataStart=%d dataLen=%d dataEnd=%d %n", startPos, this.is.getBufrLength(), startPos + (long)this.is.getBufrLength(), startData, this.dataSection.getDataLength(), startData + (long)this.dataSection.getDataLength());
        this.dumpDesc(out, this.dds.getDataDescriptors(), this.lookup, 4);
        out.format("%n  CDM Nested Table=%n", new Object[0]);
        DataDescriptor root = new DataDescriptorTreeConstructor().factory(this.lookup, this.dds);
        this.dumpKeys(out, root, 4);
    }

    private void dumpDesc(Formatter out, List<Short> desc, BufrTableLookup table, int indent) {
        if (desc == null) {
            return;
        }
        for (Short fxy : desc) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            Descriptor.show(out, fxy, table);
            out.format("%n", new Object[0]);
            int f = (fxy & 0xC000) >> 14;
            if (f != 3) continue;
            List<Short> sublist = table.getDescriptorListTableD(fxy);
            this.dumpDesc(out, sublist, table, indent + 2);
        }
    }

    private void dumpKeys(Formatter out, DataDescriptor tree, int indent) {
        for (DataDescriptor key : tree.subKeys) {
            for (int i = 0; i < indent; ++i) {
                out.format(" ", new Object[0]);
            }
            out.format("%s%n", key);
            if (key.getSubKeys() == null) continue;
            this.dumpKeys(out, key, indent + 2);
        }
    }

    public void dumpHeader(Formatter out) {
        out.format(" BUFR edition %d time= %s wmoHeader=%s %n", this.is.getBufrEdition(), this.getReferenceTime(), this.getHeader());
        out.format("   Category= %d %s %s %n", this.lookup.getCategory(), this.lookup.getCategoryName(), this.lookup.getCategoryNo());
        out.format("   Center= %s %s %n", this.lookup.getCenterName(), this.lookup.getCenterNo());
        out.format("   Table= %d.%d local= %d wmoTables= %s,%s localTables= %s,%s %n", this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion(), this.lookup.getWmoTableBName(), this.lookup.getWmoTableDName(), this.lookup.getLocalTableBName(), this.lookup.getLocalTableDName());
        out.format("  DDS nsubsets=%d type=0x%x isObs=%b isCompressed=%b%n", this.dds.getNumberDatasets(), this.dds.getDataType(), this.dds.isObserved(), this.dds.isCompressed());
    }

    public void dumpHeaderShort(Formatter out) {
        out.format(" %s, Cat= %s, Center= %s (%s), Table= %d.%d.%d %n", this.getHeader(), this.lookup.getCategoryName(), this.lookup.getCenterName(), this.lookup.getCenterNo(), this.ids.getMasterTableId(), this.ids.getMasterTableVersion(), this.ids.getLocalTableVersion());
    }
}

