/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.ndarray.io.npy;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.io.npy.ArrayReader;
import org.meteoinfo.ndarray.io.npy.NpyFormatException;
import org.meteoinfo.ndarray.io.npy.NpyHeader;

class ArrayChannelReader {
    private static final int MAX_BUFFER_SIZE = 8192;
    private final ReadableByteChannel channel;
    private final NpyHeader header;

    private ArrayChannelReader(ReadableByteChannel channel, NpyHeader header) {
        this.channel = channel;
        this.header = header;
    }

    static Array read(ReadableByteChannel channel, NpyHeader header) throws IOException, NpyFormatException {
        return new ArrayChannelReader(channel, header).read();
    }

    private Array read() throws IOException, NpyFormatException {
        int n;
        long totalBytes = this.header.dict().dataSize();
        int bufferSize = totalBytes > 0L && totalBytes < 8192L ? (int)totalBytes : 8192;
        ArrayReader builder = ArrayReader.of(this.header.dict());
        ByteBuffer buffer = ByteBuffer.allocate(bufferSize);
        buffer.order(this.header.byteOrder());
        for (long readBytes = 0L; readBytes < totalBytes && (n = this.channel.read(buffer)) > 0; readBytes += (long)n) {
            buffer.flip();
            builder.readAllFrom(buffer);
            buffer.clear();
        }
        return builder.finish();
    }
}

