/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.sampling;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.sampling.ObjectSampler;
import org.apache.commons.rng.sampling.SharedStateObjectSampler;
import org.apache.commons.rng.sampling.SharedStateSampler;
import org.apache.commons.rng.sampling.distribution.AliasMethodDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.ContinuousSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteSampler;
import org.apache.commons.rng.sampling.distribution.DiscreteUniformSampler;
import org.apache.commons.rng.sampling.distribution.GuideTableDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.LongSampler;
import org.apache.commons.rng.sampling.distribution.MarsagliaTsangWangDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateContinuousSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateDiscreteSampler;
import org.apache.commons.rng.sampling.distribution.SharedStateLongSampler;

public final class CompositeSamplers {
    private CompositeSamplers() {
    }

    public static <T> Builder<ObjectSampler<T>> newObjectSamplerBuilder() {
        ObjectSamplerFactory factory = ObjectSamplerFactory.instance();
        return new SamplerBuilder<ObjectSampler<T>>(SamplerBuilder.Specialisation.NONE, factory);
    }

    public static <T> Builder<SharedStateObjectSampler<T>> newSharedStateObjectSamplerBuilder() {
        SharedStateObjectSamplerFactory factory = SharedStateObjectSamplerFactory.instance();
        return new SamplerBuilder<SharedStateObjectSampler<T>>(SamplerBuilder.Specialisation.SHARED_STATE_SAMPLER, factory);
    }

    public static Builder<DiscreteSampler> newDiscreteSamplerBuilder() {
        return new SamplerBuilder<DiscreteSampler>(SamplerBuilder.Specialisation.NONE, DiscreteSamplerFactory.INSTANCE);
    }

    public static Builder<SharedStateDiscreteSampler> newSharedStateDiscreteSamplerBuilder() {
        return new SamplerBuilder<SharedStateDiscreteSampler>(SamplerBuilder.Specialisation.SHARED_STATE_SAMPLER, SharedStateDiscreteSamplerFactory.INSTANCE);
    }

    public static Builder<ContinuousSampler> newContinuousSamplerBuilder() {
        return new SamplerBuilder<ContinuousSampler>(SamplerBuilder.Specialisation.NONE, ContinuousSamplerFactory.INSTANCE);
    }

    public static Builder<SharedStateContinuousSampler> newSharedStateContinuousSamplerBuilder() {
        return new SamplerBuilder<SharedStateContinuousSampler>(SamplerBuilder.Specialisation.SHARED_STATE_SAMPLER, SharedStateContinuousSamplerFactory.INSTANCE);
    }

    public static Builder<LongSampler> newLongSamplerBuilder() {
        return new SamplerBuilder<LongSampler>(SamplerBuilder.Specialisation.NONE, LongSamplerFactory.INSTANCE);
    }

    public static Builder<SharedStateLongSampler> newSharedStateLongSamplerBuilder() {
        return new SamplerBuilder<SharedStateLongSampler>(SamplerBuilder.Specialisation.SHARED_STATE_SAMPLER, SharedStateLongSamplerFactory.INSTANCE);
    }

    private static <T extends SharedStateSampler<T>> List<T> copy(List<T> samplers, UniformRandomProvider rng) {
        ArrayList newSamplers = new ArrayList(samplers.size());
        for (SharedStateSampler s : samplers) {
            newSamplers.add(s.withUniformRandomProvider(rng));
        }
        return newSamplers;
    }

    private static class SharedStateLongSamplerFactory
    implements SamplerBuilder.SamplerFactory<SharedStateLongSampler> {
        static final SharedStateLongSamplerFactory INSTANCE = new SharedStateLongSamplerFactory();

        private SharedStateLongSamplerFactory() {
        }

        @Override
        public SharedStateLongSampler createSampler(DiscreteSampler discreteSampler, List<SharedStateLongSampler> samplers) {
            return new CompositeSharedStateLongSampler((SharedStateDiscreteSampler)discreteSampler, samplers);
        }

        private static class CompositeSharedStateLongSampler
        extends CompositeSampler<SharedStateLongSampler>
        implements SharedStateLongSampler {
            CompositeSharedStateLongSampler(SharedStateDiscreteSampler discreteSampler, List<SharedStateLongSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public long sample() {
                return ((SharedStateLongSampler)this.nextSampler()).sample();
            }

            @Override
            public CompositeSharedStateLongSampler withUniformRandomProvider(UniformRandomProvider rng) {
                return new CompositeSharedStateLongSampler((SharedStateDiscreteSampler)((SharedStateDiscreteSampler)this.discreteSampler).withUniformRandomProvider(rng), CompositeSamplers.copy(this.samplers, rng));
            }
        }
    }

    private static class LongSamplerFactory
    implements SamplerBuilder.SamplerFactory<LongSampler> {
        static final LongSamplerFactory INSTANCE = new LongSamplerFactory();

        private LongSamplerFactory() {
        }

        @Override
        public LongSampler createSampler(DiscreteSampler discreteSampler, List<LongSampler> samplers) {
            return new CompositeLongSampler(discreteSampler, samplers);
        }

        private static class CompositeLongSampler
        extends CompositeSampler<LongSampler>
        implements LongSampler {
            CompositeLongSampler(DiscreteSampler discreteSampler, List<LongSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public long sample() {
                return ((LongSampler)this.nextSampler()).sample();
            }
        }
    }

    private static class SharedStateContinuousSamplerFactory
    implements SamplerBuilder.SamplerFactory<SharedStateContinuousSampler> {
        static final SharedStateContinuousSamplerFactory INSTANCE = new SharedStateContinuousSamplerFactory();

        private SharedStateContinuousSamplerFactory() {
        }

        @Override
        public SharedStateContinuousSampler createSampler(DiscreteSampler discreteSampler, List<SharedStateContinuousSampler> samplers) {
            return new CompositeSharedStateContinuousSampler((SharedStateDiscreteSampler)discreteSampler, samplers);
        }

        private static class CompositeSharedStateContinuousSampler
        extends CompositeSampler<SharedStateContinuousSampler>
        implements SharedStateContinuousSampler {
            CompositeSharedStateContinuousSampler(SharedStateDiscreteSampler discreteSampler, List<SharedStateContinuousSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public double sample() {
                return ((SharedStateContinuousSampler)this.nextSampler()).sample();
            }

            @Override
            public CompositeSharedStateContinuousSampler withUniformRandomProvider(UniformRandomProvider rng) {
                return new CompositeSharedStateContinuousSampler((SharedStateDiscreteSampler)((SharedStateDiscreteSampler)this.discreteSampler).withUniformRandomProvider(rng), CompositeSamplers.copy(this.samplers, rng));
            }
        }
    }

    private static class ContinuousSamplerFactory
    implements SamplerBuilder.SamplerFactory<ContinuousSampler> {
        static final ContinuousSamplerFactory INSTANCE = new ContinuousSamplerFactory();

        private ContinuousSamplerFactory() {
        }

        @Override
        public ContinuousSampler createSampler(DiscreteSampler discreteSampler, List<ContinuousSampler> samplers) {
            return new CompositeContinuousSampler(discreteSampler, samplers);
        }

        private static class CompositeContinuousSampler
        extends CompositeSampler<ContinuousSampler>
        implements ContinuousSampler {
            CompositeContinuousSampler(DiscreteSampler discreteSampler, List<ContinuousSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public double sample() {
                return ((ContinuousSampler)this.nextSampler()).sample();
            }
        }
    }

    private static class SharedStateDiscreteSamplerFactory
    implements SamplerBuilder.SamplerFactory<SharedStateDiscreteSampler> {
        static final SharedStateDiscreteSamplerFactory INSTANCE = new SharedStateDiscreteSamplerFactory();

        private SharedStateDiscreteSamplerFactory() {
        }

        @Override
        public SharedStateDiscreteSampler createSampler(DiscreteSampler discreteSampler, List<SharedStateDiscreteSampler> samplers) {
            return new CompositeSharedStateDiscreteSampler((SharedStateDiscreteSampler)discreteSampler, samplers);
        }

        private static class CompositeSharedStateDiscreteSampler
        extends CompositeSampler<SharedStateDiscreteSampler>
        implements SharedStateDiscreteSampler {
            CompositeSharedStateDiscreteSampler(SharedStateDiscreteSampler discreteSampler, List<SharedStateDiscreteSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public int sample() {
                return ((SharedStateDiscreteSampler)this.nextSampler()).sample();
            }

            @Override
            public CompositeSharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
                return new CompositeSharedStateDiscreteSampler((SharedStateDiscreteSampler)((SharedStateDiscreteSampler)this.discreteSampler).withUniformRandomProvider(rng), CompositeSamplers.copy(this.samplers, rng));
            }
        }
    }

    private static class DiscreteSamplerFactory
    implements SamplerBuilder.SamplerFactory<DiscreteSampler> {
        static final DiscreteSamplerFactory INSTANCE = new DiscreteSamplerFactory();

        private DiscreteSamplerFactory() {
        }

        @Override
        public DiscreteSampler createSampler(DiscreteSampler discreteSampler, List<DiscreteSampler> samplers) {
            return new CompositeDiscreteSampler(discreteSampler, samplers);
        }

        private static class CompositeDiscreteSampler
        extends CompositeSampler<DiscreteSampler>
        implements DiscreteSampler {
            CompositeDiscreteSampler(DiscreteSampler discreteSampler, List<DiscreteSampler> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public int sample() {
                return ((DiscreteSampler)this.nextSampler()).sample();
            }
        }
    }

    private static class SharedStateObjectSamplerFactory<T>
    implements SamplerBuilder.SamplerFactory<SharedStateObjectSampler<T>> {
        private static final SharedStateObjectSamplerFactory INSTANCE = new SharedStateObjectSamplerFactory();

        private SharedStateObjectSamplerFactory() {
        }

        static <T> SharedStateObjectSamplerFactory<T> instance() {
            return INSTANCE;
        }

        @Override
        public SharedStateObjectSampler<T> createSampler(DiscreteSampler discreteSampler, List<SharedStateObjectSampler<T>> samplers) {
            return new CompositeSharedStateObjectSampler<T>((SharedStateDiscreteSampler)discreteSampler, samplers);
        }

        private static class CompositeSharedStateObjectSampler<T>
        extends CompositeSampler<SharedStateObjectSampler<T>>
        implements SharedStateObjectSampler<T> {
            CompositeSharedStateObjectSampler(SharedStateDiscreteSampler discreteSampler, List<SharedStateObjectSampler<T>> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public T sample() {
                return ((SharedStateObjectSampler)this.nextSampler()).sample();
            }

            @Override
            public CompositeSharedStateObjectSampler<T> withUniformRandomProvider(UniformRandomProvider rng) {
                return new CompositeSharedStateObjectSampler<T>((SharedStateDiscreteSampler)((SharedStateDiscreteSampler)this.discreteSampler).withUniformRandomProvider(rng), CompositeSamplers.copy(this.samplers, rng));
            }
        }
    }

    private static class ObjectSamplerFactory<T>
    implements SamplerBuilder.SamplerFactory<ObjectSampler<T>> {
        private static final ObjectSamplerFactory INSTANCE = new ObjectSamplerFactory();

        private ObjectSamplerFactory() {
        }

        static <T> ObjectSamplerFactory<T> instance() {
            return INSTANCE;
        }

        @Override
        public ObjectSampler<T> createSampler(DiscreteSampler discreteSampler, List<ObjectSampler<T>> samplers) {
            return new CompositeObjectSampler<T>(discreteSampler, samplers);
        }

        private static class CompositeObjectSampler<T>
        extends CompositeSampler<ObjectSampler<T>>
        implements ObjectSampler<T> {
            CompositeObjectSampler(DiscreteSampler discreteSampler, List<ObjectSampler<T>> samplers) {
                super(discreteSampler, samplers);
            }

            @Override
            public T sample() {
                return ((ObjectSampler)this.nextSampler()).sample();
            }
        }
    }

    private static class CompositeSampler<S> {
        protected final DiscreteSampler discreteSampler;
        protected final List<S> samplers;

        CompositeSampler(DiscreteSampler discreteSampler, List<S> samplers) {
            this.discreteSampler = discreteSampler;
            this.samplers = samplers;
        }

        S nextSampler() {
            return this.samplers.get(this.discreteSampler.sample());
        }
    }

    private static class SamplerBuilder<S>
    implements Builder<S> {
        private final Specialisation specialisation;
        private final List<WeightedSampler<S>> weightedSamplers;
        private DiscreteProbabilitySamplerFactory factory;
        private final SamplerFactory<S> compositeFactory;

        SamplerBuilder(Specialisation specialisation, SamplerFactory<S> compositeFactory) {
            this.specialisation = specialisation;
            this.compositeFactory = compositeFactory;
            this.weightedSamplers = new ArrayList<WeightedSampler<S>>();
            this.factory = DiscreteProbabilitySampler.GUIDE_TABLE;
        }

        @Override
        public int size() {
            return this.weightedSamplers.size();
        }

        @Override
        public Builder<S> add(S sampler, double weight) {
            if (weight != 0.0) {
                this.weightedSamplers.add(new WeightedSampler<S>(weight, sampler));
            }
            return this;
        }

        @Override
        public Builder<S> setFactory(DiscreteProbabilitySamplerFactory samplerFactory) {
            this.factory = Objects.requireNonNull(samplerFactory, "factory");
            return this;
        }

        @Override
        public S build(UniformRandomProvider rng) {
            List<WeightedSampler<S>> list = this.weightedSamplers;
            int n = list.size();
            if (n == 0) {
                throw new IllegalStateException("No samplers to build the composite");
            }
            if (n == 1) {
                Object sampler = ((WeightedSampler)list.get(0)).sampler;
                this.reset();
                return (S)sampler;
            }
            double[] weights = new double[n];
            ArrayList<S> samplers = new ArrayList<S>(n);
            for (int i = 0; i < n; ++i) {
                WeightedSampler<S> weightedItem = list.get(i);
                weights[i] = weightedItem.getWeight();
                samplers.add(weightedItem.getSampler());
            }
            this.reset();
            DiscreteSampler discreteSampler = this.createDiscreteSampler(rng, weights);
            return this.compositeFactory.createSampler(discreteSampler, samplers);
        }

        private void reset() {
            this.weightedSamplers.clear();
        }

        private DiscreteSampler createDiscreteSampler(UniformRandomProvider rng, double[] weights) {
            int n = weights.length;
            if (SamplerBuilder.uniform(weights)) {
                return DiscreteUniformSampler.of(rng, 0, n - 1);
            }
            double sum = SamplerBuilder.sum(weights);
            if (sum < Double.POSITIVE_INFINITY) {
                int i = 0;
                while (i < n) {
                    int n2 = i++;
                    weights[n2] = weights[n2] / sum;
                }
            } else {
                double mean = SamplerBuilder.mean(weights);
                for (int i = 0; i < n; ++i) {
                    weights[i] = weights[i] / mean / (double)n;
                }
            }
            if (this.specialisation == Specialisation.SHARED_STATE_SAMPLER && !(this.factory instanceof DiscreteProbabilitySampler)) {
                DiscreteSampler sampler = this.factory.create(rng, (double[])weights.clone());
                return sampler instanceof SharedStateDiscreteSampler ? sampler : new SharedStateDiscreteProbabilitySampler(sampler, this.factory, weights);
            }
            return this.factory.create(rng, weights);
        }

        private static boolean uniform(double[] values) {
            double value = values[0];
            for (int i = 1; i < values.length; ++i) {
                if (value == values[i]) continue;
                return false;
            }
            return true;
        }

        private static double sum(double[] values) {
            double sum = 0.0;
            for (double value : values) {
                sum += value;
            }
            return sum;
        }

        private static double mean(double[] values) {
            double mean = values[0];
            int i = 1;
            while (i < values.length) {
                double dev = values[i] - mean;
                mean += dev / (double)(++i);
            }
            return mean;
        }

        private static class WeightedSampler<S> {
            private final double weight;
            private final S sampler;

            WeightedSampler(double weight, S sampler) {
                this.weight = WeightedSampler.requirePositiveFinite(weight, "weight");
                this.sampler = Objects.requireNonNull(sampler, "sampler");
            }

            double getWeight() {
                return this.weight;
            }

            S getSampler() {
                return this.sampler;
            }

            private static double requirePositiveFinite(double value, String message) {
                if (!(value >= 0.0) || !(value < Double.POSITIVE_INFINITY)) {
                    throw new IllegalArgumentException(message + " is not positive finite: " + value);
                }
                return value;
            }
        }

        static interface SamplerFactory<S> {
            public S createSampler(DiscreteSampler var1, List<S> var2);
        }

        static enum Specialisation {
            SHARED_STATE_SAMPLER,
            NONE;

        }
    }

    public static interface Builder<S> {
        public int size();

        public Builder<S> add(S var1, double var2);

        public Builder<S> setFactory(DiscreteProbabilitySamplerFactory var1);

        public S build(UniformRandomProvider var1);
    }

    private static class SharedStateDiscreteProbabilitySampler
    implements SharedStateDiscreteSampler {
        private final DiscreteSampler sampler;
        private final DiscreteProbabilitySamplerFactory factory;
        private final double[] probabilities;

        SharedStateDiscreteProbabilitySampler(DiscreteSampler sampler, DiscreteProbabilitySamplerFactory factory, double[] probabilities) {
            this.sampler = Objects.requireNonNull(sampler, "discrete sampler");
            this.factory = factory;
            this.probabilities = probabilities;
        }

        @Override
        public int sample() {
            return this.sampler.sample();
        }

        @Override
        public SharedStateDiscreteSampler withUniformRandomProvider(UniformRandomProvider rng) {
            return new SharedStateDiscreteProbabilitySampler(this.factory.create(rng, (double[])this.probabilities.clone()), this.factory, this.probabilities);
        }
    }

    public static enum DiscreteProbabilitySampler implements DiscreteProbabilitySamplerFactory
    {
        GUIDE_TABLE{

            @Override
            public SharedStateDiscreteSampler create(UniformRandomProvider rng, double[] probabilities) {
                return GuideTableDiscreteSampler.of(rng, probabilities);
            }
        }
        ,
        ALIAS_METHOD{

            @Override
            public SharedStateDiscreteSampler create(UniformRandomProvider rng, double[] probabilities) {
                return AliasMethodDiscreteSampler.of(rng, probabilities);
            }
        }
        ,
        LOOKUP_TABLE{

            @Override
            public SharedStateDiscreteSampler create(UniformRandomProvider rng, double[] probabilities) {
                return MarsagliaTsangWangDiscreteSampler.Enumerated.of(rng, probabilities);
            }
        };

    }

    public static interface DiscreteProbabilitySamplerFactory {
        public DiscreteSampler create(UniformRandomProvider var1, double[] var2);
    }
}

