/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.netcdf;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.ndarray.ArrayStructure;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Section;
import org.meteoinfo.ndarray.math.ArrayUtil;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.Range;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;

public class NCUtil {
    public static org.meteoinfo.ndarray.DataType convertDataType(DataType ncDataType) {
        org.meteoinfo.ndarray.DataType dataType = org.meteoinfo.ndarray.DataType.getType((String)ncDataType.toString());
        return dataType;
    }

    public static DataType convertDataType(org.meteoinfo.ndarray.DataType dataType) {
        DataType ncDataType = DataType.getType((String)dataType.toString());
        return ncDataType;
    }

    public static org.meteoinfo.ndarray.Array convertArray(Array ncArray) {
        if (ncArray == null) {
            return null;
        }
        org.meteoinfo.ndarray.DataType dt = NCUtil.convertDataType(ncArray.getDataType());
        if (dt == org.meteoinfo.ndarray.DataType.OBJECT && ncArray.getObject(0).getClass() == String.class) {
            dt = org.meteoinfo.ndarray.DataType.STRING;
        }
        ArrayStructure array = null;
        switch (dt) {
            case STRUCTURE: 
            case SEQUENCE: {
                array = new ArrayStructure(ncArray.getShape());
                array.setArrayObject((Object)ncArray);
                break;
            }
            default: {
                array = org.meteoinfo.ndarray.Array.factory((org.meteoinfo.ndarray.DataType)dt, (int[])ncArray.getShape(), (Object)ncArray.getStorage());
            }
        }
        return array;
    }

    public static Array convertArray(org.meteoinfo.ndarray.Array array) {
        Array ncArray = null;
        switch (array.getDataType()) {
            case STRUCTURE: 
            case SEQUENCE: {
                ncArray = (Array)((ArrayStructure)array).getArrayObject();
                break;
            }
            default: {
                array = array.copyIfView();
                ncArray = Array.factory((DataType)NCUtil.convertDataType(array.getDataType()), (int[])array.getShape(), (Object)array.getStorage());
            }
        }
        return ncArray;
    }

    public static org.meteoinfo.data.dimarray.Dimension convertDimension(Dimension ncDim) {
        org.meteoinfo.data.dimarray.Dimension dim = new org.meteoinfo.data.dimarray.Dimension();
        dim.setShortName(ncDim.getShortName());
        dim.setLength(ncDim.getLength());
        dim.setUnlimited(ncDim.isUnlimited());
        dim.setShared(ncDim.isShared());
        dim.setVariableLength(ncDim.isVariableLength());
        return dim;
    }

    public static List<org.meteoinfo.data.dimarray.Dimension> convertDimensions(List<Dimension> ncDims) {
        ArrayList<org.meteoinfo.data.dimarray.Dimension> dims = new ArrayList<org.meteoinfo.data.dimarray.Dimension>();
        for (Dimension ncDim : ncDims) {
            dims.add(NCUtil.convertDimension(ncDim));
        }
        return dims;
    }

    public static Attribute convertAttribute(ucar.nc2.Attribute ncAttr) {
        Attribute attr = new Attribute(ncAttr.getShortName());
        attr.setStringValue(ncAttr.getStringValue());
        attr.setValues(NCUtil.convertArray(ncAttr.getValues()));
        return attr;
    }

    public static ucar.nc2.Attribute convertAttribute(Attribute attr) {
        ucar.nc2.Attribute ncAttr = new ucar.nc2.Attribute(attr.getShortName(), NCUtil.convertArray(attr.getValues()));
        return ncAttr;
    }

    public static Variable convertVariable(ucar.nc2.Variable ncVar) throws IOException {
        Variable var = new Variable();
        var.setName(ncVar.getFullName());
        var.setShortName(ncVar.getShortName());
        var.setDataType(NCUtil.convertDataType(ncVar.getDataType()));
        var.setDescription(ncVar.getDescription());
        var.setMemberOfStructure(ncVar.isMemberOfStructure());
        var.setDimensions(NCUtil.convertDimensions((List<Dimension>)ncVar.getDimensions()));
        for (ucar.nc2.Attribute ncAttr : ncVar.getAttributes()) {
            var.addAttribute(NCUtil.convertAttribute(ncAttr));
        }
        var.setUnits(ncVar.getUnitsString());
        var.setDimVar(ncVar.isCoordinateVariable());
        if (ncVar.hasCachedData()) {
            var.setCachedData(NCUtil.convertArray(ncVar.read()));
        }
        return var;
    }

    public static Section convertSection(ucar.ma2.Section ncSection) {
        try {
            ArrayList<org.meteoinfo.ndarray.Range> ranges = new ArrayList<org.meteoinfo.ndarray.Range>();
            for (Range range : ncSection.getRanges()) {
                ranges.add(new org.meteoinfo.ndarray.Range(range.getName(), range.first(), range.last(), range.stride()));
            }
            Section section = new Section(ranges);
            return section;
        }
        catch (InvalidRangeException ex) {
            Logger.getLogger(NCUtil.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public static double[] getPackData(ucar.nc2.Variable var) {
        double add_offset = 0.0;
        double scale_factor = 1.0;
        double missingValue = Double.NaN;
        for (int i = 0; i < var.getAttributes().size(); ++i) {
            ucar.nc2.Attribute att = (ucar.nc2.Attribute)var.getAttributes().get(i);
            String attName = att.getShortName();
            if (attName.equals("add_offset")) {
                add_offset = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("scale_factor")) {
                scale_factor = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("missing_value")) {
                try {
                    missingValue = Double.parseDouble(att.getValue(0).toString());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (!attName.equals("_FillValue")) continue;
            try {
                missingValue = Double.parseDouble(att.getValue(0).toString());
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return new double[]{add_offset, scale_factor, missingValue};
    }

    public static double[] getPackData(Variable var) {
        double add_offset = 0.0;
        double scale_factor = 1.0;
        double missingValue = Double.NaN;
        for (int i = 0; i < var.getAttributes().size(); ++i) {
            Attribute att = var.getAttributes().get(i);
            String attName = att.getShortName();
            if (attName.equals("add_offset")) {
                add_offset = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("scale_factor")) {
                scale_factor = Double.parseDouble(att.getValue(0).toString());
            }
            if (attName.equals("missing_value")) {
                try {
                    missingValue = Double.parseDouble(att.getValue(0).toString());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (!attName.equals("_FillValue")) continue;
            try {
                missingValue = Double.parseDouble(att.getValue(0).toString());
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return new double[]{add_offset, scale_factor, missingValue};
    }

    public static double getMissingValue(Variable var) {
        double missingValue = Double.NaN;
        for (int i = 0; i < var.getAttributes().size(); ++i) {
            Attribute att = var.getAttributes().get(i);
            String attName = att.getShortName();
            if (attName.equals("missing_value")) {
                try {
                    missingValue = Double.parseDouble(att.getValue(0).toString());
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (!attName.equals("_FillValue")) continue;
            try {
                missingValue = Double.parseDouble(att.getValue(0).toString());
                continue;
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return missingValue;
    }

    public static org.meteoinfo.ndarray.Array readSequence(ucar.ma2.ArrayStructure parentArray, String memberName) throws IOException {
        StructureMembers.Member member = parentArray.findMember(memberName);
        Array r = parentArray.extractMemberArray(member);
        return NCUtil.convertArray(r);
    }

    public static org.meteoinfo.ndarray.Array readSequenceRecord(ArrayObject parentArray, String memberName, int index, double missingValue) throws IOException {
        int n = (int)parentArray.getSize();
        IndexIterator pIter = parentArray.getIndexIterator();
        StructureMembers.Member member = null;
        while (pIter.hasNext()) {
            ucar.ma2.ArrayStructure sArray = (ucar.ma2.ArrayStructure)pIter.getObjectNext();
            if (sArray == null) continue;
            member = sArray.findMember(memberName);
            break;
        }
        org.meteoinfo.ndarray.DataType dataType = NCUtil.convertDataType(member.getDataType());
        org.meteoinfo.ndarray.Array r = org.meteoinfo.ndarray.Array.factory((org.meteoinfo.ndarray.DataType)dataType, (int[])new int[]{n});
        pIter = parentArray.getIndexIterator();
        org.meteoinfo.ndarray.IndexIterator rIter = r.getIndexIterator();
        while (pIter.hasNext()) {
            ucar.ma2.ArrayStructure sArray = (ucar.ma2.ArrayStructure)pIter.getObjectNext();
            if (sArray == null) {
                rIter.setObjectNext((Object)missingValue);
                continue;
            }
            member = sArray.findMember(memberName);
            Array a = sArray.extractMemberArray(member);
            if (a.getSize() > (long)index) {
                rIter.setObjectNext(a.getObject(index));
                continue;
            }
            rIter.setObjectNext((Object)missingValue);
        }
        return r;
    }

    public static org.meteoinfo.ndarray.Array readSequenceRecord(ArrayObject parentArray, String memberName, int index) throws IOException {
        return NCUtil.readSequenceRecord(parentArray, memberName, index, Double.NaN);
    }

    public static org.meteoinfo.ndarray.Array readSequence(ArrayObject parentArray, String memberName, int index) throws IOException {
        int n = (int)parentArray.getSize();
        ucar.ma2.ArrayStructure sArray = (ucar.ma2.ArrayStructure)parentArray.getObject(index);
        if (sArray == null) {
            return null;
        }
        StructureMembers.Member member = sArray.findMember(memberName);
        Array r = sArray.extractMemberArray(member);
        return NCUtil.convertArray(r);
    }

    public static org.meteoinfo.ndarray.Array arrayUnPack(org.meteoinfo.ndarray.Array a, Variable variable) {
        double[] packValues = NCUtil.getPackData(variable);
        double addOffset = packValues[0];
        double scaleFactor = packValues[1];
        double missingValue = packValues[2];
        return ArrayUtil.unPack((org.meteoinfo.ndarray.Array)a, (double)missingValue, (double)scaleFactor, (double)addOffset);
    }
}

