/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata.micaps;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.Extent;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.dimarray.Dimension;
import org.meteoinfo.data.dimarray.DimensionType;
import org.meteoinfo.data.meteodata.Attribute;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.dataframe.Column;
import org.meteoinfo.dataframe.ColumnIndex;
import org.meteoinfo.dataframe.DataFrame;
import org.meteoinfo.dataframe.Index;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.ArrayString;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.ndarray.math.ArrayMath;

public class MICAPS3DataInfo
extends DataInfo
implements IStationDataInfo {
    private String _description;
    private List<String> _varList = new ArrayList<String>();
    private List<String> _fieldList = new ArrayList<String>();
    private List<List<String>> _dataList = new ArrayList<List<String>>();
    private int stNum;

    public MICAPS3DataInfo() {
        this.setMissingValue(9999.0);
        this.setDataType(MeteoDataType.MICAPS_3);
    }

    @Override
    public boolean isValidFile(RandomAccessFile raf) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readDataInfo(String fileName) {
        BufferedReader sr = null;
        try {
            int i;
            String bLine;
            String aLine;
            this.setFileName(fileName);
            sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "gbk"));
            ArrayList<String> dataList = new ArrayList<String>();
            this.addAttribute(new Attribute("data_format", "MICAPS 3"));
            this._description = aLine = sr.readLine().trim();
            aLine = sr.readLine().trim();
            while ((bLine = sr.readLine()) != null) {
                aLine = aLine + " " + bLine.trim();
            }
            sr.close();
            String[] dataArray = aLine.split("\\s+");
            dataList.clear();
            for (i = 0; i < dataArray.length; ++i) {
                if (dataArray[i].isEmpty()) continue;
                dataList.add(dataArray[i]);
            }
            int year = Integer.parseInt((String)dataList.get(0));
            if (year < 100) {
                year = year < 50 ? 2000 + year : 1900 + year;
            }
            LocalDateTime time = LocalDateTime.of(year, Integer.parseInt((String)dataList.get(1)), Integer.parseInt((String)dataList.get(2)), Integer.parseInt((String)dataList.get(3)), 0, 0);
            int level = Integer.parseInt((String)dataList.get(4));
            int contourNum = Integer.parseInt((String)dataList.get(5));
            ArrayList<Float> contours = new ArrayList<Float>();
            for (i = 0; i < contourNum; ++i) {
                contours.add(Float.valueOf(Float.parseFloat((String)dataList.get(6 + i))));
            }
            int idx = 6 + contourNum + 2;
            int pNum = Integer.parseInt((String)dataList.get(idx));
            int varNum = Integer.parseInt((String)dataList.get(idx += pNum * 2 + 1));
            this.stNum = Integer.parseInt((String)dataList.get(++idx));
            ++idx;
            for (i = 0; i < varNum; ++i) {
                this._varList.add("Var" + String.valueOf(i + 1));
            }
            this._fieldList.add("Stid");
            this._fieldList.add("Longitude");
            this._fieldList.add("Latitude");
            this._fieldList.add("Altitude");
            this._fieldList.addAll(this._varList);
            while (idx + 3 + varNum < dataList.size()) {
                ArrayList<String> aData = new ArrayList<String>();
                for (int j = 0; j < 4 + varNum; ++j) {
                    aData.add((String)dataList.get(idx));
                    ++idx;
                }
                this._dataList.add(aData);
            }
            this.addAttribute(new Attribute("time", time));
            this.addAttribute(new Attribute("level", level));
            this.stNum = this._dataList.size();
            Dimension stdim = new Dimension(DimensionType.OTHER);
            stdim.setShortName("station");
            double[] values = new double[this.stNum];
            for (i = 0; i < this.stNum; ++i) {
                values[i] = i;
            }
            stdim.setValues(values);
            this.addDimension(stdim);
            Dimension tdim = new Dimension(DimensionType.T);
            tdim.setValue(time);
            this.setTimeDimension(tdim);
            ArrayList<Variable> variables = new ArrayList<Variable>();
            for (String vName : this._fieldList) {
                Variable var = new Variable();
                var.setName(vName);
                if (vName.equals("Stid")) {
                    var.setDataType(DataType.STRING);
                }
                var.setStation(true);
                var.setDimension(stdim);
                variables.add(var);
            }
            this.setVariables(variables);
            for (Dimension dim : this.dimensions) {
                Variable variable = new Variable(dim.getName());
                variable.setDimVar(true);
                variable.setCachedData(dim.getDimValue());
                variable.addDimension(dim);
                this.addCoordinate(variable);
            }
        }
        catch (FileNotFoundException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedEncodingException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IOException ex) {
            Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
        }
        finally {
            try {
                sr.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MICAPS3DataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public List<Attribute> getGlobalAttributes() {
        return new ArrayList<Attribute>();
    }

    @Override
    public String generateInfoText() {
        String dataInfo = "Description: " + this._description;
        DateTimeFormatter format = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:00");
        dataInfo = dataInfo + System.getProperty("line.separator") + "Time: " + format.format(this.getTimes().getDate(0));
        dataInfo = dataInfo + System.getProperty("line.separator") + super.generateInfoText();
        return dataInfo;
    }

    @Override
    public Array realRead(String varName) {
        Variable var = this.getVariable(varName);
        int n = var.getDimNumber();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = 0;
            size[i] = var.getDimLength(i);
            stride[i] = 1;
        }
        Array r = this.realRead(varName, origin, size, stride);
        return r;
    }

    @Override
    public Array realRead(String varName, int[] origin, int[] size, int[] stride) {
        Array r;
        int varIdx = this._fieldList.indexOf(varName);
        if (varIdx < 0) {
            return null;
        }
        int[] shape = new int[]{this.stNum};
        DataType dt = DataType.FLOAT;
        if (varName.equals("Stid")) {
            dt = DataType.STRING;
            r = new ArrayString(shape);
        } else {
            r = Array.factory((DataType)dt, (int[])shape);
        }
        block3: for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            switch (dt) {
                case STRING: {
                    r.setObject(i, (Object)dataList.get(varIdx));
                    continue block3;
                }
                default: {
                    r.setFloat(i, Float.parseFloat(dataList.get(varIdx)));
                }
            }
        }
        if (r.getDataType().isNumeric()) {
            ArrayMath.missingToNaN((Array)r, (Number)this.missingValue);
        }
        return r;
    }

    public DataFrame readDataFrame() {
        ArrayList<Array> data = new ArrayList<Array>();
        ColumnIndex columns = new ColumnIndex();
        Iterator<String> iterator = this._fieldList.iterator();
        block11: while (iterator.hasNext()) {
            String vName;
            switch (vName = iterator.next()) {
                case "Stid": {
                    continue block11;
                }
            }
            DataType dtype = DataType.FLOAT;
            columns.add((Object)new Column(vName, dtype));
            data.add(Array.factory((DataType)dtype, (int[])new int[]{this._dataList.size()}));
        }
        ArrayList<String> idxList = new ArrayList<String>();
        for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            idxList.add(dataList.get(0));
            block13: for (int j = 0; j < data.size(); ++j) {
                Array dd = (Array)data.get(j);
                switch (dd.getDataType()) {
                    case FLOAT: {
                        try {
                            dd.setFloat(i, Float.parseFloat(dataList.get(j + 1)));
                            continue block13;
                        }
                        catch (Exception e) {
                            dd.setFloat(i, Float.NaN);
                        }
                    }
                }
            }
        }
        for (Array a : data) {
            ArrayMath.missingToNaN((Array)a, (Number)9999);
        }
        Index index = Index.factory(idxList);
        DataFrame df = new DataFrame(data, index, columns);
        return df;
    }

    @Override
    public StationData getStationData(int timeIdx, String varName, int levelIdx) {
        int varIdx = this.getVariableIndex(varName);
        double t = 0.0;
        double[][] discreteData = new double[this._dataList.size()][3];
        double minX = 0.0;
        double maxX = 0.0;
        double minY = 0.0;
        double maxY = 0.0;
        ArrayList<String> stations = new ArrayList<String>();
        for (int i = 0; i < this._dataList.size(); ++i) {
            List<String> dataList = this._dataList.get(i);
            String stName = dataList.get(0);
            double lon = Double.parseDouble(dataList.get(1));
            double lat = Double.parseDouble(dataList.get(2));
            t = Double.parseDouble(dataList.get(varIdx));
            stations.add(stName);
            discreteData[i][0] = lon;
            discreteData[i][1] = lat;
            discreteData[i][2] = t;
            if (i == 0) {
                maxX = minX = lon;
                maxY = minY = lat;
                continue;
            }
            if (minX > lon) {
                minX = lon;
            } else if (maxX < lon) {
                maxX = lon;
            }
            if (minY > lat) {
                minY = lat;
                continue;
            }
            if (!(maxY < lat)) continue;
            maxY = lat;
        }
        Extent dataExtent = new Extent();
        dataExtent.minX = minX;
        dataExtent.maxX = maxX;
        dataExtent.minY = minY;
        dataExtent.maxY = maxY;
        StationData stData = new StationData();
        stData.data = discreteData;
        stData.dataExtent = dataExtent;
        stData.missingValue = this.getMissingValue();
        stData.stations = stations;
        return stData;
    }

    @Override
    public StationInfoData getStationInfoData(int timeIdx, int levelIdx) {
        StationInfoData stInfoData = new StationInfoData();
        stInfoData.setDataList(this._dataList);
        stInfoData.setFields(this._fieldList);
        stInfoData.setVariables(this._varList);
        return stInfoData;
    }

    @Override
    public StationModelData getStationModelData(int timeIdx, int levelIdx) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

