/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.data.meteodata;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.InvocationTargetException;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.data.GridData;
import org.meteoinfo.data.StationData;
import org.meteoinfo.data.mathparser.MathParser;
import org.meteoinfo.data.mathparser.ParseException;
import org.meteoinfo.data.meteodata.DataInfo;
import org.meteoinfo.data.meteodata.DrawType2D;
import org.meteoinfo.data.meteodata.IGridDataInfo;
import org.meteoinfo.data.meteodata.IStationDataInfo;
import org.meteoinfo.data.meteodata.MeteoDataType;
import org.meteoinfo.data.meteodata.MeteoUVSet;
import org.meteoinfo.data.meteodata.PlotDimension;
import org.meteoinfo.data.meteodata.StationInfoData;
import org.meteoinfo.data.meteodata.StationModelData;
import org.meteoinfo.data.meteodata.Variable;
import org.meteoinfo.data.meteodata.arl.ARLDataInfo;
import org.meteoinfo.data.meteodata.ascii.ASCIIGridDataInfo;
import org.meteoinfo.data.meteodata.ascii.LonLatStationDataInfo;
import org.meteoinfo.data.meteodata.ascii.SurferGridDataInfo;
import org.meteoinfo.data.meteodata.awx.AWXDataInfo;
import org.meteoinfo.data.meteodata.bandraster.BILDataInfo;
import org.meteoinfo.data.meteodata.bandraster.GeoTiffDataInfo;
import org.meteoinfo.data.meteodata.grads.GrADSDataInfo;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITConcDataInfo;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITPartDataInfo;
import org.meteoinfo.data.meteodata.hysplit.HYSPLITTrajDataInfo;
import org.meteoinfo.data.meteodata.matlab.MatLabDataInfo;
import org.meteoinfo.data.meteodata.metar.METARDataInfo;
import org.meteoinfo.data.meteodata.micaps.MDFSDataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS11DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS120DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS131DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS13DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS1DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS2DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS3DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS4DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPS7DataInfo;
import org.meteoinfo.data.meteodata.micaps.MICAPSDataInfo;
import org.meteoinfo.data.meteodata.mm5.MM5DataInfo;
import org.meteoinfo.data.meteodata.mm5.MM5IMDataInfo;
import org.meteoinfo.data.meteodata.netcdf.NetCDFDataInfo;
import org.meteoinfo.data.meteodata.radar.RadarDataUtil;
import org.meteoinfo.data.meteodata.synop.SYNOPDataInfo;
import org.meteoinfo.ndarray.Array;
import org.meteoinfo.ndarray.IndexIterator;
import org.meteoinfo.ndarray.InvalidRangeException;
import org.meteoinfo.ndarray.Range;
import org.meteoinfo.ndarray.math.ArrayMath;
import org.meteoinfo.projection.ProjectionInfo;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFiles;

public class MeteoDataInfo {
    private PlotDimension _dimensionSet = PlotDimension.Lat_Lon;
    private String varName;
    private int _timeIdx;
    private int _levelIdx;
    private int _latIdx;
    private int _lonIdx;
    private DrawType2D drawType2D;
    public boolean IsLonLat = true;
    public boolean EarthWind = true;
    private DataInfo dataInfo = null;
    private String _infoText = "";
    private MeteoUVSet _meteoUVSet = new MeteoUVSet();
    public boolean xReserve = false;
    public boolean yReserve = false;

    public DataInfo getDataInfo() {
        return this.dataInfo;
    }

    public void setDataInfo(DataInfo value) {
        this.dataInfo = value;
        this._infoText = this.dataInfo.generateInfoText();
    }

    public ProjectionInfo getProjectionInfo() {
        return this.dataInfo.getProjectionInfo();
    }

    public MeteoDataType getDataType() {
        return this.dataInfo.getDataType();
    }

    public PlotDimension getDimensionSet() {
        return this._dimensionSet;
    }

    public void setDimensionSet(PlotDimension value) {
        this._dimensionSet = value;
    }

    public String getInfoText() {
        return this._infoText;
    }

    public int getTimeIndex() {
        return this._timeIdx;
    }

    public void setTimeIndex(int value) {
        this._timeIdx = value;
    }

    public int getLevelIndex() {
        return this._levelIdx;
    }

    public void setLevelIndex(int value) {
        this._levelIdx = value;
    }

    public String getVariableName() {
        if (this.varName == null && this.getDataInfo() != null) {
            return this.getDataInfo().getVariableNames().get(0);
        }
        return this.varName;
    }

    public void setVariableName(String value) {
        this.varName = value;
    }

    public int getLonIndex() {
        return this._lonIdx;
    }

    public void setLonIndex(int value) {
        this._lonIdx = value;
    }

    public int getLatIndex() {
        return this._latIdx;
    }

    public void setLatIndex(int value) {
        this._latIdx = value;
    }

    public DrawType2D getDrawType2D() {
        return this.drawType2D;
    }

    public void setDrawType2D(DrawType2D value) {
        this.drawType2D = value;
    }

    public MeteoUVSet getMeteoUVSet() {
        return this._meteoUVSet;
    }

    public void setMeteoUVSet(MeteoUVSet value) {
        this._meteoUVSet = value;
    }

    public double getMissingValue() {
        return this.dataInfo.getMissingValue();
    }

    public boolean isGridData() {
        switch (this.getDataType()) {
            case ARL_GRID: 
            case ASCII_GRID: 
            case GRADS_GRID: 
            case GRIB1: 
            case GRIB2: 
            case HYSPLIT_CONC: 
            case MICAPS_11: 
            case MICAPS_13: 
            case MICAPS_4: 
            case MICAPS_131: 
            case SURFER_GRID: 
            case MM5: 
            case MM5IM: {
                return true;
            }
            case NETCDF: {
                return !((NetCDFDataInfo)this.dataInfo).isSWATH();
            }
            case GEOTIFF: {
                return true;
            }
            case AWX: {
                switch (((AWXDataInfo)this.getDataInfo()).getProductType()) {
                    case 1: 
                    case 2: 
                    case 3: {
                        return true;
                    }
                }
                return false;
            }
            case MICAPS_MDFS: {
                switch (((MDFSDataInfo)this.dataInfo).getType()) {
                    case 4: 
                    case 11: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public boolean isStationData() {
        switch (this.getDataType()) {
            case GRADS_STATION: 
            case ISH: 
            case METAR: 
            case MICAPS_1: 
            case MICAPS_2: 
            case MICAPS_3: 
            case MICAPS_120: 
            case LON_LAT_STATION: 
            case SYNOP: 
            case HYSPLIT_PARTICLE: {
                return true;
            }
            case AWX: {
                return ((AWXDataInfo)this.getDataInfo()).getProductType() == 4;
            }
            case MICAPS_MDFS: {
                switch (((MDFSDataInfo)this.dataInfo).getType()) {
                    case 1: 
                    case 2: {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean isTrajData() {
        switch (this.getDataType()) {
            case HYSPLIT_TRAJ: 
            case MICAPS_7: {
                return true;
            }
        }
        return false;
    }

    public boolean isSWATHData() {
        switch (this.getDataType()) {
            case NETCDF: {
                if (!((NetCDFDataInfo)this.dataInfo).isSWATH()) break;
                return true;
            }
        }
        return false;
    }

    public int getDimensionNumber() {
        int dn = 2;
        switch (this._dimensionSet) {
            case Lat_Lon: 
            case Level_Lat: 
            case Level_Lon: 
            case Level_Time: 
            case Time_Lat: 
            case Time_Lon: {
                dn = 2;
                break;
            }
            case Level: 
            case Lon: 
            case Time: 
            case Lat: {
                dn = 1;
            }
        }
        return dn;
    }

    public DataInfo getDataInfo(String fileName) {
        DataInfo di = RadarDataUtil.getDataInfo(fileName);
        if (di == null) {
            try {
                RandomAccessFile raf = new RandomAccessFile(fileName, "r");
                di = ((GrADSDataInfo)GrADSDataInfo.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).isValidFile(raf) ? new GrADSDataInfo() : (NetcdfFiles.canOpen((String)fileName) ? new NetCDFDataInfo() : (((ARLDataInfo)ARLDataInfo.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).isValidFile(raf) ? new ARLDataInfo() : (((MatLabDataInfo)MatLabDataInfo.class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).isValidFile(raf) ? new MatLabDataInfo() : MICAPSDataInfo.getDataInfo(raf))));
                raf.close();
            }
            catch (IOException | NoSuchMethodException ex) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            catch (InstantiationException e) {
                return null;
            }
            catch (IllegalAccessException e) {
                return null;
            }
        }
        return di;
    }

    public void openData(String fileName) {
        this.openData(fileName, false);
    }

    public void openData(String fileName, boolean keepOpen) {
        this.dataInfo = this.getDataInfo(fileName);
        if (this.dataInfo != null) {
            if (this.dataInfo.getClass() == NetCDFDataInfo.class) {
                this.dataInfo.readDataInfo(fileName, keepOpen);
            } else {
                this.dataInfo.readDataInfo(fileName);
            }
            this._infoText = this.dataInfo.generateInfoText();
        }
    }

    public void openData(NetcdfFile ncfile, boolean keepOpen) {
        this.openNetCDFData(ncfile, keepOpen);
    }

    public void close() {
        if (this.dataInfo.getDataType() == MeteoDataType.NETCDF) {
            NetCDFDataInfo dinfo = (NetCDFDataInfo)this.dataInfo;
            try {
                dinfo.close();
            }
            catch (IOException ex) {
                Logger.getLogger(MeteoDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public void openGrADSData(String aFile) {
        this.dataInfo = new GrADSDataInfo();
        this.dataInfo.readDataInfo(aFile);
        this._infoText = this.dataInfo.generateInfoText();
        GrADSDataInfo aDataInfo = (GrADSDataInfo)this.dataInfo;
        if (aDataInfo.DTYPE.equals("Gridded")) {
            this.yReserve = aDataInfo.OPTIONS.yrev;
            if (!aDataInfo.isLatLon) {
                this.IsLonLat = false;
                this.EarthWind = aDataInfo.EarthWind;
            }
        }
    }

    public void openARLData(String aFile) {
        this.dataInfo = new ARLDataInfo();
        this.dataInfo.readDataInfo(aFile);
        this.IsLonLat = ((ARLDataInfo)this.dataInfo).isLatLon;
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openAWXData(String aFile) {
        AWXDataInfo aDataInfo = new AWXDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
        if (aDataInfo.getProductType() == 4) {
            this._meteoUVSet.setUV(false);
            this._meteoUVSet.setFixUVStr(true);
            this._meteoUVSet.setUStr("WindDirection");
            this._meteoUVSet.setVStr("WindSpeed");
        }
    }

    public void openSYNOPData(String aFile, String stFile) {
        SYNOPDataInfo aDataInfo = new SYNOPDataInfo();
        aDataInfo.setStationFileName(stFile);
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
        this._meteoUVSet.setUV(false);
        this._meteoUVSet.setFixUVStr(true);
        this._meteoUVSet.setUStr("WindDirection");
        this._meteoUVSet.setVStr("WindSpeed");
    }

    public void openMETARData(String aFile, String stFile) {
        METARDataInfo aDataInfo = new METARDataInfo();
        aDataInfo.setStationFileName(stFile);
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
        this._meteoUVSet.setUV(false);
        this._meteoUVSet.setFixUVStr(true);
        this._meteoUVSet.setUStr("WindDirection");
        this._meteoUVSet.setVStr("WindSpeed");
    }

    public void openASCIIGridData(String aFile) {
        ASCIIGridDataInfo aDataInfo = new ASCIIGridDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openGeoTiffData(String aFile) {
        GeoTiffDataInfo aDataInfo = new GeoTiffDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openBILData(String aFile) {
        BILDataInfo aDataInfo = new BILDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openHYSPLITConcData(String aFile) {
        HYSPLITConcDataInfo aDataInfo = new HYSPLITConcDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openHYSPLITConcData(String aFile, boolean bigendian) {
        HYSPLITConcDataInfo aDataInfo = new HYSPLITConcDataInfo(bigendian);
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openHYSPLITTrajData(String aFile) {
        HYSPLITTrajDataInfo aDataInfo = new HYSPLITTrajDataInfo();
        aDataInfo.readDataInfo(aFile);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openHYSPLITPartData(String fileName) {
        HYSPLITPartDataInfo aDataInfo = new HYSPLITPartDataInfo();
        aDataInfo.readDataInfo(fileName);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openHYSPLITPartData(String fileName, int skipNBytes) {
        HYSPLITPartDataInfo aDataInfo = new HYSPLITPartDataInfo();
        aDataInfo.setSkipNBytes(skipNBytes);
        aDataInfo.readDataInfo(fileName);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openNetCDFData(String fileName) {
        this.openNetCDFData(fileName, false);
    }

    public void openNetCDFData(String fileName, boolean keepOpen) {
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(fileName, keepOpen);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openNetCDFData(NetcdfFile ncfile, boolean keepOpen) {
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        aDataInfo.readDataInfo(ncfile, keepOpen);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openGRIBData(String fileName, int version) {
        NetCDFDataInfo aDataInfo = new NetCDFDataInfo();
        MeteoDataType mdt = MeteoDataType.GRIB2;
        if (version == 1) {
            mdt = MeteoDataType.GRIB1;
        }
        aDataInfo.readDataInfo(fileName, mdt);
        this.dataInfo = aDataInfo;
        this._infoText = aDataInfo.generateInfoText();
    }

    public void openLonLatData(String fileName) {
        this.dataInfo = new LonLatStationDataInfo();
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openSurferGridData(String fileName) {
        this.dataInfo = new SurferGridDataInfo();
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openMM5Data(String fileName) {
        this.dataInfo = new MM5DataInfo();
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openMM5Data(String fileName, String bigHeadFile) {
        this.dataInfo = new MM5DataInfo();
        ((MM5DataInfo)this.dataInfo).readDataInfo(fileName, bigHeadFile);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openMM5IMData(String fileName) {
        this.dataInfo = new MM5IMDataInfo();
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openMatLabData(String fileName) {
        this.dataInfo = new MatLabDataInfo();
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
    }

    public void openMICAPSData(String fileName) {
        MeteoDataType mdType = MICAPSDataInfo.getDataType(fileName);
        if (mdType == null) {
            return;
        }
        switch (mdType) {
            case MICAPS_1: {
                this.dataInfo = new MICAPS1DataInfo();
                this._meteoUVSet.setUV(false);
                this._meteoUVSet.setFixUVStr(true);
                this._meteoUVSet.setUStr("WindDirection");
                this._meteoUVSet.setVStr("WindSpeed");
                break;
            }
            case MICAPS_2: {
                this.dataInfo = new MICAPS2DataInfo();
                this._meteoUVSet.setUV(false);
                this._meteoUVSet.setFixUVStr(true);
                this._meteoUVSet.setUStr("WindDirection");
                this._meteoUVSet.setVStr("WindSpeed");
                break;
            }
            case MICAPS_3: {
                this.dataInfo = new MICAPS3DataInfo();
                this._meteoUVSet.setUV(false);
                this._meteoUVSet.setFixUVStr(true);
                this._meteoUVSet.setUStr("WindDirection");
                this._meteoUVSet.setVStr("WindSpeed");
                break;
            }
            case MICAPS_4: {
                this.dataInfo = new MICAPS4DataInfo();
                break;
            }
            case MICAPS_7: {
                this.dataInfo = new MICAPS7DataInfo();
                break;
            }
            case MICAPS_11: {
                this.dataInfo = new MICAPS11DataInfo();
                break;
            }
            case MICAPS_13: {
                this.dataInfo = new MICAPS13DataInfo();
                break;
            }
            case MICAPS_120: {
                this.dataInfo = new MICAPS120DataInfo();
                break;
            }
            case MICAPS_131: {
                this.dataInfo = new MICAPS131DataInfo();
                break;
            }
            case MICAPS_MDFS: {
                this.dataInfo = new MDFSDataInfo();
            }
        }
        this.dataInfo.readDataInfo(fileName);
        this._infoText = this.dataInfo.generateInfoText();
        if (mdType == MeteoDataType.MICAPS_MDFS) {
            switch (((MDFSDataInfo)this.dataInfo).getType()) {
                case 1: 
                case 2: {
                    this._meteoUVSet.setUV(false);
                    this._meteoUVSet.setFixUVStr(true);
                    this._meteoUVSet.setUStr("WindDirection");
                    this._meteoUVSet.setVStr("WindSpeed");
                }
            }
        }
    }

    public String getFileName() {
        return this.dataInfo.getFileName();
    }

    public Array read(String varName) {
        return this.dataInfo.read(varName);
    }

    public Array read(String varName, int[] origin, int[] size, int[] stride) {
        return this.dataInfo.read(varName, origin, size, stride);
    }

    public Array read(String varName, List<Range> ranges) {
        int n = ranges.size();
        int[] origin = new int[n];
        int[] size = new int[n];
        int[] stride = new int[n];
        for (int i = 0; i < n; ++i) {
            origin[i] = ranges.get(i).first();
            size[i] = ranges.get(i).last() - ranges.get(i).first() + 1;
            stride[i] = ranges.get(i).stride();
        }
        return this.read(varName, origin, size, stride);
    }

    public Array read(String varName, List<Integer> origin, List<Integer> size, List<Integer> stride) {
        int i;
        int n = origin.size();
        int[] origin_a = new int[n];
        int[] size_a = new int[n];
        int[] stride_a = new int[n];
        for (i = 0; i < n; ++i) {
            origin_a[i] = origin.get(i);
            size_a[i] = size.get(i);
        }
        if (stride == null) {
            for (i = 0; i < n; ++i) {
                stride_a[i] = 1;
            }
        } else {
            for (i = 0; i < n; ++i) {
                stride_a[i] = stride.get(i);
            }
        }
        return this.dataInfo.read(varName, origin_a, size_a, stride_a);
    }

    public Array read(String varName, List<Integer> origin, List<Integer> size) {
        return this.read(varName, origin, size, null);
    }

    public Array take(String varName, List<Object> ranges) throws InvalidRangeException {
        int n = ranges.size();
        ArrayList<Range> nranges = new ArrayList<Range>();
        ArrayList<Object> branges = new ArrayList<Object>();
        for (int i = 0; i < n; ++i) {
            int min;
            List<Integer> list;
            if (ranges.get(i) instanceof Range) {
                nranges.add((Range)ranges.get(i));
                branges.add(new Range(0, ((Range)ranges.get(i)).length() - 1, 1));
                continue;
            }
            if (ranges.get(i) instanceof Array) {
                list = new ArrayList();
                Array array = (Array)ranges.get(i);
                IndexIterator iter = array.getIndexIterator();
                if (array.getDataType().isBoolean()) {
                    int idx = 0;
                    while (iter.hasNext()) {
                        if (iter.getBooleanNext()) {
                            list.add(idx);
                        }
                        ++idx;
                    }
                } else {
                    while (iter.hasNext()) {
                        list.add(iter.getIntNext());
                    }
                }
            } else {
                list = (List)ranges.get(i);
            }
            int max = min = ((Integer)list.get(0)).intValue();
            if (list.size() > 1) {
                for (int j = 1; j < list.size(); ++j) {
                    if (min > (Integer)list.get(j)) {
                        min = (Integer)list.get(j);
                    }
                    if (max >= (Integer)list.get(j)) continue;
                    max = (Integer)list.get(j);
                }
            }
            Range range = new Range(min, max, 1);
            nranges.add(range);
            ArrayList<Integer> nlist = new ArrayList<Integer>();
            for (int j = 0; j < list.size(); ++j) {
                nlist.add((Integer)list.get(j) - min);
            }
            branges.add(nlist);
        }
        Array r = this.read(varName, nranges);
        r = ArrayMath.take((Array)r, branges);
        return r;
    }

    public GridData getGridData(String varName) {
        this.varName = varName;
        int varIdx = this.getVariableIndex(varName);
        if (varIdx < 0) {
            MathParser mathParser = new MathParser(this);
            try {
                GridData gridData = (GridData)mathParser.evaluate(varName);
                gridData.setProjInfo(this.getProjectionInfo());
                return gridData;
            }
            catch (IOException | ParseException ex) {
                Logger.getLogger(MeteoDataInfo.class.getName()).log(Level.SEVERE, null, ex);
                return null;
            }
        }
        GridData gridData = this.getGridData();
        gridData.setProjInfo(this.getProjectionInfo());
        gridData.setFieldName(varName);
        return gridData;
    }

    public GridData getGridData() {
        GridData gdata = null;
        switch (this._dimensionSet) {
            case Lat_Lon: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_LonLat(this._timeIdx, this.varName, this._levelIdx);
                break;
            }
            case Time_Lon: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_TimeLon(this._latIdx, this.varName, this._levelIdx);
                break;
            }
            case Time_Lat: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_TimeLat(this._lonIdx, this.varName, this._levelIdx);
                break;
            }
            case Level_Lon: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_LevelLon(this._latIdx, this.varName, this._timeIdx);
                break;
            }
            case Level_Lat: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_LevelLat(this._lonIdx, this.varName, this._timeIdx);
                break;
            }
            case Level_Time: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_LevelTime(this._latIdx, this.varName, this._lonIdx);
                break;
            }
            case Lat: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_Lat(this._timeIdx, this._lonIdx, this.varName, this._levelIdx);
                break;
            }
            case Level: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_Level(this._lonIdx, this._latIdx, this.varName, this._timeIdx);
                break;
            }
            case Lon: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_Lon(this._timeIdx, this._latIdx, this.varName, this._levelIdx);
                break;
            }
            case Time: {
                gdata = ((IGridDataInfo)((Object)this.dataInfo)).getGridData_Time(this._lonIdx, this._latIdx, this.varName, this._levelIdx);
            }
        }
        if (gdata != null) {
            gdata.setProjInfo(this.getProjectionInfo());
        }
        return gdata;
    }

    public StationData getStationData(String varName) {
        this.varName = varName;
        int varIdx = this.getVariableIndex(varName);
        if (varIdx >= 0) {
            return this.getStationData();
        }
        MathParser mathParser = new MathParser(this);
        try {
            StationData stationData = (StationData)mathParser.evaluate(varName);
            stationData.projInfo = this.getProjectionInfo();
            return stationData;
        }
        catch (ParseException ex) {
            Logger.getLogger(MeteoDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IOException ex) {
            Logger.getLogger(MeteoDataInfo.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
    }

    public StationData getStationData() {
        StationData stData = ((IStationDataInfo)((Object)this.dataInfo)).getStationData(this._timeIdx, this.varName, this._levelIdx);
        stData.projInfo = this.getProjectionInfo();
        return stData;
    }

    public StationModelData getStationModelData() {
        return ((IStationDataInfo)((Object)this.dataInfo)).getStationModelData(this._timeIdx, this._levelIdx);
    }

    public StationInfoData getStationInfoData() {
        return ((IStationDataInfo)((Object)this.dataInfo)).getStationInfoData(this._timeIdx, this._levelIdx);
    }

    public StationInfoData getStationInfoData(int timeIndex) {
        return ((IStationDataInfo)((Object)this.dataInfo)).getStationInfoData(timeIndex, this._levelIdx);
    }

    public int getVariableIndex(String varName) {
        List<String> varList = this.dataInfo.getVariableNames();
        int idx = varList.indexOf(varName);
        return idx;
    }

    public GridData getArrivalTimeData(String varName, double threshold) {
        int tnum = this.getDataInfo().getTimeNum();
        this.setTimeIndex(0);
        GridData gData = this.getGridData(varName);
        GridData tData = new GridData(gData);
        tData = tData.setValue(tData.getDoubleMissingValue());
        int xnum = gData.getXNum();
        int ynum = gData.getYNum();
        LocalDateTime date = this.getDataInfo().getTimes().getDate(0);
        List<Integer> hours = this.getDataInfo().getTimeValues(date, "hours");
        for (int t = 0; t < tnum; ++t) {
            int hour = hours.get(t);
            if (t >= 1) {
                this.setTimeIndex(t);
                gData = this.getGridData(varName);
            }
            for (int i = 0; i < ynum; ++i) {
                for (int j = 0; j < xnum; ++j) {
                    if (!(gData.getData()[i][j] >= threshold) || !MIMath.doubleEquals((double)tData.getDoubleValue(i, j), (double)tData.getDoubleMissingValue())) continue;
                    tData.setValue(i, j, hour);
                }
            }
        }
        return tData;
    }

    public double toStation(String varName, double x, double y, double z, LocalDateTime t) {
        Array times = this.getDataInfo().getTimes();
        int tnum = (int)times.getSize();
        if (t.isBefore(times.getDate(0)) || t.isAfter(times.getDate(tnum - 1))) {
            return this.getDataInfo().getMissingValue();
        }
        double ivalue = this.getDataInfo().getMissingValue();
        for (int i = 0; i < tnum; ++i) {
            if (t.equals(times.getDate(i))) {
                ivalue = this.toStation(varName, x, y, z, i);
                break;
            }
            if (!t.isBefore(times.getDate(i))) continue;
            double v_t1 = this.toStation(varName, x, y, z, i - 1);
            double v_t2 = this.toStation(varName, x, y, z, i);
            int h = (int)Duration.between(times.getDate(i - 1), t).toHours();
            int th = (int)Duration.between(times.getDate(i - 1), times.getDate(i)).toHours();
            ivalue = (v_t2 - v_t1) * (double)h / (double)th + v_t1;
            break;
        }
        return ivalue;
    }

    public double toStation(String varName, double x, double y, LocalDateTime t) {
        Array times = this.getDataInfo().getTimes();
        int tnum = (int)times.getSize();
        if (t.isBefore(times.getDate(0)) || t.isAfter(times.getDate(tnum - 1))) {
            return this.getDataInfo().getMissingValue();
        }
        double ivalue = this.getDataInfo().getMissingValue();
        for (int i = 0; i < tnum; ++i) {
            if (t.equals(times.getDate(i))) {
                ivalue = this.toStation(varName, x, y, i);
                break;
            }
            if (!t.isBefore(times.getDate(i))) continue;
            double v_t1 = this.toStation(varName, x, y, i - 1);
            double v_t2 = this.toStation(varName, x, y, i);
            int h = (int)Duration.between(times.getDate(i - 1), t).toHours();
            int th = (int)Duration.between(times.getDate(i - 1), times.getDate(i)).toHours();
            ivalue = (v_t2 - v_t1) * (double)h / (double)th + v_t1;
            break;
        }
        return ivalue;
    }

    public List<Double> toStation(List<String> varNames, double x, double y, double z, LocalDateTime t) {
        List<LocalDateTime> times = this.getDataInfo().getTimeList();
        int tnum = times.size();
        if (t.isBefore(times.get(0)) || t.isAfter(times.get(tnum - 1))) {
            return null;
        }
        List<Double> ivalues = new ArrayList<Double>();
        for (int i = 0; i < tnum; ++i) {
            if (t.equals(times.get(i))) {
                ivalues = this.toStation(varNames, x, y, z, i);
                break;
            }
            if (!t.isBefore(times.get(i))) continue;
            List<Double> v_t1s = this.toStation(varNames, x, y, z, i - 1);
            List<Double> v_t2s = this.toStation(varNames, x, y, z, i);
            int h = (int)Duration.between(times.get(i - 1), t).toHours();
            int th = (int)Duration.between(times.get(i - 1), times.get(i)).toHours();
            for (int j = 0; j < v_t1s.size(); ++j) {
                double v_t1 = v_t1s.get(j);
                double v_t2 = v_t2s.get(j);
                ivalues.add((v_t2 - v_t1) * (double)h / (double)th + v_t1);
            }
            break;
        }
        return ivalues;
    }

    public double toStation(String varName, double x, double y, double z, int tidx) {
        double ivalue = this.getDataInfo().getMissingValue();
        Variable var = this.getDataInfo().getVariable(varName);
        List<Double> levels = var.getZDimension().getDimValueList();
        int znum = levels.size();
        this.setTimeIndex(tidx);
        if (levels.get(1) - levels.get(0) > 0.0) {
            for (int j = 0; j < znum; ++j) {
                if (MIMath.doubleEquals((double)z, (double)levels.get(j))) {
                    this.setLevelIndex(j);
                    ivalue = this.getGridData(varName).toStation(x, y);
                } else {
                    if (!(z < levels.get(j))) continue;
                    if (j == 0) {
                        j = 1;
                    }
                    this.setLevelIndex(j - 1);
                    double v_z1 = this.getGridData(varName).toStation(x, y);
                    this.setLevelIndex(j);
                    double v_z2 = this.getGridData(varName).toStation(x, y);
                    ivalue = (v_z2 - v_z1) * (z - levels.get(j - 1)) / (levels.get(j) - levels.get(j - 1)) + v_z1;
                }
                break;
            }
        } else {
            for (int j = 0; j < znum; ++j) {
                if (MIMath.doubleEquals((double)z, (double)levels.get(j))) {
                    this.setLevelIndex(j);
                    ivalue = this.getGridData(varName).toStation(x, y);
                } else {
                    if (!(z > levels.get(j))) continue;
                    if (j == 0) {
                        j = 1;
                    }
                    this.setLevelIndex(j - 1);
                    double v_z1 = this.getGridData(varName).toStation(x, y);
                    this.setLevelIndex(j);
                    double v_z2 = this.getGridData(varName).toStation(x, y);
                    ivalue = (v_z2 - v_z1) * (z - levels.get(j - 1)) / (levels.get(j) - levels.get(j - 1)) + v_z1;
                }
                break;
            }
        }
        return ivalue;
    }

    public double toStation(String varName, double x, double y, int tidx) {
        this.setTimeIndex(tidx);
        this.setLevelIndex(0);
        double ivalue = this.getGridData(varName).toStation(x, y);
        return ivalue;
    }

    public List<Double> toStation(List<String> varNames, double x, double y, double z, int tidx) {
        ArrayList<Double> ivalues = new ArrayList<Double>();
        Variable var = this.getDataInfo().getVariable(varNames.get(0));
        List<Double> levels = var.getZDimension().getDimValueList();
        int znum = levels.size();
        this.setTimeIndex(tidx);
        block0: for (int j = 0; j < znum; ++j) {
            for (String varName : varNames) {
                double ivalue;
                if (MIMath.doubleEquals((double)z, (double)levels.get(j))) {
                    this.setLevelIndex(j);
                    ivalue = this.getGridData(varName).toStation(x, y);
                    ivalues.add(ivalue);
                    continue block0;
                }
                if (!(z < levels.get(j))) continue;
                this.setLevelIndex(j - 1);
                double v_z1 = this.getGridData(varName).toStation(x, y);
                this.setLevelIndex(j);
                double v_z2 = this.getGridData(varName).toStation(x, y);
                ivalue = (v_z2 - v_z1) * (z - levels.get(j - 1)) / (levels.get(j) - levels.get(j - 1)) + v_z1;
                ivalues.add(ivalue);
                continue block0;
            }
        }
        return ivalues;
    }

    public String toString() {
        return new File(this.getFileName()).getName();
    }
}

