/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import org.ojalgo.function.constant.BigMath;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access1D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public abstract class TypeUtils {
    public static final long HOURS_PER_CENTURY = 876582L;
    public static final long MILLIS_PER_HOUR = 3600000L;
    private static final String HEX = "#";
    private static final char START = '{';

    public static String format(String messagePattern, Object ... args) {
        if (messagePattern == null) {
            return null;
        }
        int patternLength = messagePattern.length();
        int argsCount = args.length;
        int first = 0;
        int limit = patternLength;
        StringBuilder retVal = new StringBuilder(patternLength + argsCount * 20);
        for (int a = 0; a < argsCount; ++a) {
            limit = messagePattern.indexOf(123, first);
            if (limit == -1) {
                retVal.append(' ');
                if (args[a] instanceof Access1D) {
                    retVal.append(Access1D.toString((Access1D)args[a]));
                    continue;
                }
                if (args[a] instanceof double[]) {
                    retVal.append(Arrays.toString((double[])args[a]));
                    continue;
                }
                retVal.append(args[a]);
                continue;
            }
            retVal.append(messagePattern.substring(first, limit));
            if (args[a] instanceof Access1D) {
                retVal.append(Access1D.toString((Access1D)args[a]));
            } else if (args[a] instanceof double[]) {
                retVal.append(Arrays.toString((double[])args[a]));
            } else if (args[a] instanceof float[]) {
                retVal.append(Arrays.toString((float[])args[a]));
            } else if (args[a] instanceof long[]) {
                retVal.append(Arrays.toString((long[])args[a]));
            } else if (args[a] instanceof int[]) {
                retVal.append(Arrays.toString((int[])args[a]));
            } else if (args[a] instanceof short[]) {
                retVal.append(Arrays.toString((short[])args[a]));
            } else if (args[a] instanceof byte[]) {
                retVal.append(Arrays.toString((byte[])args[a]));
            } else if (args[a] instanceof boolean[]) {
                retVal.append(Arrays.toString((boolean[])args[a]));
            } else if (args[a] instanceof char[]) {
                retVal.append(Arrays.toString((char[])args[a]));
            } else {
                retVal.append(args[a]);
            }
            first = limit + 2;
        }
        retVal.append(messagePattern.substring(first, patternLength));
        return retVal.toString();
    }

    public static final GregorianCalendar getHundredYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -100);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsAgo() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, -1000);
        return retVal;
    }

    public static final GregorianCalendar getThousandYearsFromNow() {
        GregorianCalendar retVal = new GregorianCalendar();
        retVal.add(1, 1000);
        return retVal;
    }

    public static BigDecimal toBigDecimal(Comparable<?> number) {
        if (number == null) {
            return BigMath.ZERO;
        }
        if (number instanceof BigDecimal) {
            return (BigDecimal)number;
        }
        if (number instanceof Scalar) {
            return ((Scalar)number).toBigDecimal();
        }
        try {
            return new BigDecimal(number.toString());
        }
        catch (NumberFormatException cause) {
            double value = Double.NaN;
            if (number instanceof NumberDefinition) {
                value = ((NumberDefinition)((Object)number)).doubleValue();
            } else if (number instanceof Number) {
                value = ((Number)((Object)number)).doubleValue();
            }
            if (Double.isNaN(value)) {
                return BigMath.ZERO;
            }
            if (value == Double.POSITIVE_INFINITY) {
                return BigMath.VERY_POSITIVE;
            }
            if (value == Double.NEGATIVE_INFINITY) {
                return BigMath.VERY_NEGATIVE;
            }
            return BigDecimal.valueOf(value);
        }
    }

    public static BigDecimal toBigDecimal(Comparable<?> number, NumberContext context) {
        return context.enforce(TypeUtils.toBigDecimal(number));
    }

    public static String toHexString(int colour) {
        return HEX + Integer.toHexString(colour).substring(2);
    }

    static boolean isSameDate(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(1) == aCal2.get(1);
        retVal = retVal && aCal1.get(2) == aCal2.get(2);
        return retVal && aCal1.get(5) == aCal2.get(5);
    }

    static boolean isSameTime(Calendar aCal1, Calendar aCal2) {
        boolean retVal = aCal1.get(11) == aCal2.get(11);
        retVal = retVal && aCal1.get(12) == aCal2.get(12);
        return retVal && aCal1.get(13) == aCal2.get(13);
    }

    protected TypeUtils() {
    }
}

