/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.type;

import java.util.Arrays;

public final class EnumPartition<E extends Enum<E>> {
    private final E[] myConstants;
    private final int[] myCounts;
    private final byte[] myValues;

    public EnumPartition(int size, E initialValue) {
        this.myValues = new byte[size];
        this.myConstants = (Enum[])((Enum)initialValue).getDeclaringClass().getEnumConstants();
        this.myCounts = new int[this.myConstants.length];
        this.fill(initialValue);
    }

    public int count(E value) {
        return this.count(value, false);
    }

    public int count(E value, boolean negate) {
        int count = this.myCounts[((Enum)value).ordinal()];
        if (negate) {
            return this.myValues.length - count;
        }
        return count;
    }

    public int[] extract(E value) {
        return this.extract(value, false);
    }

    public int[] extract(E value, boolean negate) {
        int count = this.count(value, negate);
        int[] retVal = new int[count];
        this.extract(value, negate, retVal);
        return retVal;
    }

    public void extract(E value, boolean negate, int[] receiver) {
        byte key = (byte)((Enum)value).ordinal();
        int j = 0;
        for (int i = 0; i < this.myValues.length && j < receiver.length; ++i) {
            if (this.myValues[i] == key == negate) continue;
            receiver[j] = i;
            ++j;
        }
    }

    public void fill(E value) {
        int index = ((Enum)value).ordinal();
        byte key = (byte)index;
        Arrays.fill(this.myValues, key);
        Arrays.fill(this.myCounts, 0);
        this.myCounts[index] = this.myValues.length;
    }

    public E get(int index) {
        return this.myConstants[this.myValues[index]];
    }

    public boolean is(int index, E value) {
        return this.myValues[index] == ((Enum)value).ordinal();
    }

    public void update(int index, E value) {
        byte oldKey = this.myValues[index];
        int newKey = ((Enum)value).ordinal();
        if (oldKey != newKey) {
            this.myValues[index] = (byte)newKey;
            byte by = oldKey;
            this.myCounts[by] = this.myCounts[by] - 1;
            int n = newKey;
            this.myCounts[n] = this.myCounts[n] + 1;
        }
    }
}

