/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.ArrayList;
import java.util.List;

public interface Structure1D {
    public static int index(long index) {
        return Math.toIntExact(index);
    }

    public static void loopMatching(Structure1D structureA, Structure1D structureB, IndexCallback callback) {
        long limit = Math.min(structureA.count(), structureB.count());
        Structure1D.loopRange(0L, limit, callback);
    }

    public static void loopRange(long first, long limit, IndexCallback callback) {
        for (long i = first; i < limit; ++i) {
            callback.call(i);
        }
    }

    public static <T> IndexMapper<T> mapper() {
        return new BasicMapper();
    }

    public static int[] newDecreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - i;
        }
        return retVal;
    }

    public static long[] newDecreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first - (long)i;
        }
        return retVal;
    }

    public static int[] newIncreasingRange(int first, int count) {
        int[] retVal = new int[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + i;
        }
        return retVal;
    }

    public static long[] newIncreasingRange(long first, int count) {
        long[] retVal = new long[count];
        for (int i = 0; i < count; ++i) {
            retVal[i] = first + (long)i;
        }
        return retVal;
    }

    public static long[] replaceNullOrEmptyWithFull(long[] suggested, int fullSize) {
        if (suggested != null && suggested.length > 0) {
            return suggested;
        }
        return Structure1D.newIncreasingRange(0L, fullSize);
    }

    public static int[] toIntIndexes(long[] indexes) {
        int[] retVal = new int[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = Math.toIntExact(indexes[i]);
        }
        return retVal;
    }

    public static long[] toLongIndexes(int[] indexes) {
        long[] retVal = new long[indexes.length];
        for (int i = 0; i < indexes.length; ++i) {
            retVal[i] = indexes[i];
        }
        return retVal;
    }

    public long count();

    default public void loopAll(IndexCallback callback) {
        Structure1D.loopRange(0L, this.count(), callback);
    }

    default public int size() {
        return Math.toIntExact(this.count());
    }

    @FunctionalInterface
    public static interface LoopCallback {
        public void call(long var1, long var3, long var5);
    }

    public static final class LongIndex
    implements Comparable<LongIndex> {
        public final long index;

        public static LongIndex of(long index) {
            return new LongIndex(index);
        }

        public LongIndex(long anIndex) {
            this.index = anIndex;
        }

        private LongIndex() {
            this(-1L);
        }

        @Override
        public int compareTo(LongIndex ref) {
            return Long.compare(this.index, ref.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof LongIndex)) {
                return false;
            }
            LongIndex other = (LongIndex)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            return Long.hashCode(this.index);
        }

        public String toString() {
            return Long.toString(this.index);
        }
    }

    public static interface Logical<S extends Structure1D, B extends Logical<S, B>>
    extends Structure1D {
        public B after(S var1);

        public B before(S var1);
    }

    public static final class IntIndex
    implements Comparable<IntIndex> {
        public final int index;

        public static IntIndex of(int index) {
            return new IntIndex(index);
        }

        public IntIndex(int anIndex) {
            this.index = anIndex;
        }

        private IntIndex() {
            this(-1);
        }

        @Override
        public int compareTo(IntIndex ref) {
            return Integer.compare(this.index, ref.index);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof IntIndex)) {
                return false;
            }
            IntIndex other = (IntIndex)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            return Integer.hashCode(this.index);
        }

        public String toString() {
            return Integer.toString(this.index);
        }
    }

    public static interface IndexMapper<T> {
        default public T next(T key) {
            return this.toKey(this.toIndex(key) + 1L);
        }

        default public T previous(T key) {
            return this.toKey(this.toIndex(key) - 1L);
        }

        public long toIndex(T var1);

        public T toKey(long var1);
    }

    @FunctionalInterface
    public static interface IndexCallback {
        public void call(long var1);
    }

    public static class BasicMapper<T>
    implements IndexMapper<T> {
        private final List<T> myKeys = new ArrayList<T>();

        BasicMapper() {
        }

        @Override
        public synchronized long toIndex(T key) {
            long retVal = this.myKeys.indexOf(key);
            if (retVal < 0L) {
                retVal = this.indexForNewKey(key);
            }
            return retVal;
        }

        @Override
        public final T toKey(long index) {
            return this.myKeys.get(Math.toIntExact(index));
        }

        final long indexForNewKey(T newKey) {
            long retVal = this.myKeys.size();
            this.myKeys.add(newKey);
            return retVal;
        }
    }
}

