/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.structure;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.ojalgo.ProgrammingError;
import org.ojalgo.function.VoidFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.structure.ElementView2D;
import org.ojalgo.structure.Factory2D;
import org.ojalgo.structure.Mutate1D;
import org.ojalgo.structure.Mutate2D;
import org.ojalgo.structure.Structure1D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

public interface Access2D<N extends Comparable<N>>
extends Structure2D,
Access1D<N> {
    public static Access2D<Double> asPrimitive2D(final Access2D<?> access) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return access.count();
            }

            @Override
            public long countColumns() {
                return access.countColumns();
            }

            @Override
            public long countRows() {
                return access.countRows();
            }

            @Override
            public double doubleValue(long index) {
                return access.doubleValue(index);
            }

            @Override
            public double doubleValue(long row, long col) {
                return access.doubleValue(row, col);
            }

            @Override
            public Double get(long index) {
                return access.doubleValue(index);
            }

            @Override
            public Double get(long row, long col) {
                return access.doubleValue(row, col);
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    public static boolean equals(Access2D<?> accessA, Access2D<?> accessB, NumberContext accuracy) {
        return accessA.countRows() == accessB.countRows() && accessA.countColumns() == accessB.countColumns() && Access1D.equals(accessA, accessB, accuracy);
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveColumnCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return 1L;
            }

            @Override
            public long countRows() {
                return anything1D.count();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(nz.index(), 0L, nz.doubleValue()));
            }
        };
    }

    public static <R extends Mutate2D.Receiver<Double>> Collectable<Double, R> newPrimitiveRowCollectable(final Access1D<?> anything1D) {
        return new Collectable<Double, R>(){

            @Override
            public long countColumns() {
                return anything1D.count();
            }

            @Override
            public long countRows() {
                return 1L;
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.reset();
                anything1D.nonzeros().forEach(nz -> receiver.set(0L, nz.index(), nz.doubleValue()));
            }
        };
    }

    public static String toString(Access2D<?> matrix) {
        StringBuilder builder = new StringBuilder();
        int numbRows = Math.toIntExact(matrix.countRows());
        int numbCols = Math.toIntExact(matrix.countColumns());
        builder.append(matrix.getClass().getName());
        builder.append(' ').append('<').append(' ').append(numbRows).append(' ').append('x').append(' ').append(numbCols).append(' ').append('>');
        if (numbRows > 0 && numbCols > 0 && numbRows <= 50 && numbCols <= 50 && numbRows * numbCols <= 200) {
            builder.append("\n{ { ").append(matrix.get(0L, 0L));
            for (int j = 1; j < numbCols; ++j) {
                builder.append(",\t").append(matrix.get(0L, j));
            }
            for (int i = 1; i < numbRows; ++i) {
                builder.append(" },\n{ ").append(matrix.get(i, 0L));
                for (int j = 1; j < numbCols; ++j) {
                    builder.append(",\t").append(matrix.get(i, j));
                }
            }
            builder.append(" } }");
        }
        return builder.toString();
    }

    public static Access2D<Double> wrap(final double[][] target) {
        return new Access2D<Double>(){

            @Override
            public long count() {
                return Structure2D.count(target.length, target[0].length);
            }

            @Override
            public long countColumns() {
                return target[0].length;
            }

            @Override
            public long countRows() {
                return target.length;
            }

            @Override
            public double doubleValue(long row, long col) {
                return target[(int)row][(int)col];
            }

            @Override
            public Double get(long row, long col) {
                return target[(int)row][(int)col];
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    public static <N extends Comparable<N>> Access2D<N> wrap(N[][] target) {
        return new Access2D<N>((Comparable[][])target){
            final /* synthetic */ Comparable[][] val$target;
            {
                this.val$target = comparableArray;
            }

            @Override
            public long count() {
                return Structure2D.count(this.val$target.length, this.val$target[0].length);
            }

            @Override
            public long countColumns() {
                return this.val$target[0].length;
            }

            @Override
            public long countRows() {
                return this.val$target.length;
            }

            @Override
            public double doubleValue(long index) {
                return NumberDefinition.doubleValue(this.get(index));
            }

            @Override
            public double doubleValue(long row, long col) {
                return NumberDefinition.doubleValue(this.get(row, col));
            }

            @Override
            public N get(long row, long col) {
                return this.val$target[(int)row][(int)col];
            }

            public String toString() {
                return Access2D.toString(this);
            }
        };
    }

    default public <NN extends Comparable<NN>, R extends Mutate2D.Receiver<NN>> Collectable<NN, R> asCollectable2D() {
        return new Collectable<NN, R>(){

            @Override
            public long countColumns() {
                return Access2D.this.countColumns();
            }

            @Override
            public long countRows() {
                return Access2D.this.countRows();
            }

            @Override
            public void supplyTo(R receiver) {
                receiver.accept(Access2D.this);
            }
        };
    }

    @Override
    default public byte byteValue(long index) {
        long structure = this.countRows();
        return this.byteValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public byte byteValue(long row, long col) {
        return (byte)this.shortValue(row, col);
    }

    default public ColumnView<N> columns() {
        return new ColumnView(this);
    }

    default public Access2D<N> columns(int ... columns) {
        return this.select((int[])null, columns);
    }

    default public Access2D<N> columns(long ... columns) {
        return this.select((long[])null, columns);
    }

    @Override
    default public double doubleValue(long index) {
        long structure = this.countRows();
        long row = Structure2D.row(index, structure);
        long col = Structure2D.column(index, structure);
        return this.doubleValue(row, col);
    }

    public double doubleValue(long var1, long var3);

    @Override
    default public ElementView2D<N, ?> elements() {
        return new ElementView(Access1D.super.elements(), this.countRows());
    }

    @Override
    default public float floatValue(long index) {
        long structure = this.countRows();
        return this.floatValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public float floatValue(long row, long col) {
        return (float)this.doubleValue(row, col);
    }

    @Override
    default public N get(long index) {
        long tmpStructure = this.countRows();
        return this.get(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure));
    }

    public N get(long var1, long var3);

    @Override
    default public int intValue(long index) {
        long structure = this.countRows();
        return this.intValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public int intValue(long row, long col) {
        return (int)this.longValue(row, col);
    }

    @Override
    default public long longValue(long index) {
        long structure = this.countRows();
        return this.longValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public long longValue(long row, long col) {
        return Math.round(this.doubleValue(row, col));
    }

    @Override
    default public ElementView2D<N, ?> nonzeros() {
        return new ElementView(Access1D.super.nonzeros(), this.countRows());
    }

    default public RowView<N> rows() {
        return new RowView(this);
    }

    default public Access2D<N> rows(int ... rows) {
        return this.select(rows, (int[])null);
    }

    default public Access2D<N> rows(long ... rows) {
        return this.select(rows, (long[])null);
    }

    default public Access2D<N> select(int[] rows, int[] columns) {
        return new SelectionView(this, Structure1D.toLongIndexes(rows), Structure1D.toLongIndexes(columns));
    }

    default public Access2D<N> select(long[] rows, long[] columns) {
        return new SelectionView(this, rows, columns);
    }

    @Override
    default public short shortValue(long index) {
        long structure = this.countRows();
        return this.shortValue(Structure2D.row(index, structure), Structure2D.column(index, structure));
    }

    default public short shortValue(long row, long col) {
        return (short)this.intValue(row, col);
    }

    default public double[][] toRawCopy2D() {
        int tmpRowDim = (int)this.countRows();
        int tmpColDim = (int)this.countColumns();
        double[][] retVal = new double[tmpRowDim][tmpColDim];
        for (int i = 0; i < tmpRowDim; ++i) {
            double[] tmpRow = retVal[i];
            for (int j = 0; j < tmpColDim; ++j) {
                tmpRow[j] = this.doubleValue(i, j);
            }
        }
        return retVal;
    }

    public static interface Visitable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Visitable<N> {
        default public void visitColumn(long row, long col, VoidFunction<N> visitor) {
            this.loopColumn(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitColumn(long col, VoidFunction<N> visitor) {
            this.visitColumn(0L, col, visitor);
        }

        default public void visitDiagonal(long row, long col, VoidFunction<N> visitor) {
            this.loopDiagonal(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitDiagonal(VoidFunction<N> visitor) {
            this.visitDiagonal(0L, 0L, visitor);
        }

        public void visitOne(long var1, long var3, VoidFunction<N> var5);

        @Override
        default public void visitOne(long index, VoidFunction<N> visitor) {
            long tmpStructure = this.countRows();
            this.visitOne(Structure2D.row(index, tmpStructure), Structure2D.column(index, tmpStructure), visitor);
        }

        default public void visitRow(long row, long col, VoidFunction<N> visitor) {
            this.loopRow(row, col, (r, c) -> this.visitOne(r, c, visitor));
        }

        default public void visitRow(long row, VoidFunction<N> visitor) {
            this.visitRow(row, 0L, visitor);
        }
    }

    public static interface Sliceable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Sliceable<N> {
        default public Access1D<N> sliceColumn(long col) {
            return this.sliceColumn(0L, col);
        }

        public Access1D<N> sliceColumn(long var1, long var3);

        default public Access1D<N> sliceDiagonal() {
            return this.sliceDiagonal(0L, 0L);
        }

        public Access1D<N> sliceDiagonal(long var1, long var3);

        default public Access1D<N> sliceRow(long row) {
            return this.sliceRow(row, 0L);
        }

        public Access1D<N> sliceRow(long var1, long var3);
    }

    public static final class SelectionView<N extends Comparable<N>>
    implements Access2D<N>,
    Collectable<N, Mutate2D> {
        private final long[] myColumns;
        private final Access2D<N> myFullData;
        private final long[] myRows;

        SelectionView(Access2D<N> fullData, long[] rows, long[] columns) {
            this.myFullData = fullData;
            this.myRows = Structure1D.replaceNullOrEmptyWithFull(rows, fullData.getRowDim());
            this.myColumns = Structure1D.replaceNullOrEmptyWithFull(columns, fullData.getColDim());
        }

        @Override
        public long countColumns() {
            return this.myColumns.length;
        }

        @Override
        public long countRows() {
            return this.myRows.length;
        }

        @Override
        public double doubleValue(long row, long col) {
            return this.myFullData.doubleValue(this.myRows[Math.toIntExact(row)], this.myColumns[Math.toIntExact(col)]);
        }

        @Override
        public N get(long row, long col) {
            return this.myFullData.get(this.myRows[Math.toIntExact(row)], this.myColumns[Math.toIntExact(col)]);
        }

        @Override
        public void supplyTo(Mutate2D receiver) {
            for (int j = 0; j < this.myColumns.length; ++j) {
                for (int i = 0; i < this.myRows.length; ++i) {
                    receiver.set((long)i, (long)j, (Comparable<?>)this.myFullData.get(this.myRows[i], this.myColumns[j]));
                }
            }
        }

        public String toString() {
            return Access2D.toString(this);
        }
    }

    public static class RowView<N extends Comparable<N>>
    implements Access1D<N>,
    Iterable<RowView<N>>,
    Iterator<RowView<N>>,
    Spliterator<RowView<N>>,
    Comparable<RowView<N>>,
    Access1D.Collectable<N, Mutate1D> {
        static final int CHARACTERISTICS = 21845;
        private final Access2D<N> myDelegate2D;
        private final long myLastRow;
        private long myRow = -1L;

        private RowView(Access2D<N> access, long row, long lastRow) {
            this.myDelegate2D = access;
            this.myLastRow = lastRow;
            this.myRow = row;
        }

        protected RowView(Access2D<N> access) {
            this(access, -1L, access.countRows() - 1L);
        }

        RowView(Access2D<N> access, long row) {
            this(access, row, access.countRows() - 1L);
        }

        @Override
        public int characteristics() {
            return 21845;
        }

        @Override
        public int compareTo(RowView<N> other) {
            return Long.compare(this.myRow, other.row());
        }

        @Override
        public long count() {
            return this.myDelegate2D.countColumns();
        }

        @Override
        public double doubleValue(long index) {
            return this.myDelegate2D.doubleValue(this.myRow, index);
        }

        @Override
        public long estimateSize() {
            return this.myLastRow - this.myRow;
        }

        @Override
        public void forEachRemaining(Consumer<? super RowView<N>> action) {
            Iterator.super.forEachRemaining(action);
        }

        @Override
        public N get(long index) {
            return this.myDelegate2D.get(this.myRow, index);
        }

        public void goToRow(long row) {
            this.myRow = row;
        }

        @Override
        public boolean hasNext() {
            return this.myRow < this.myLastRow;
        }

        public boolean hasPrevious() {
            return this.myRow > 0L;
        }

        @Override
        public RowView<N> iterator() {
            return new RowView<N>(this.myDelegate2D);
        }

        @Override
        public RowView<N> next() {
            ++this.myRow;
            return this;
        }

        public RowView<N> previous() {
            --this.myRow;
            return this;
        }

        @Override
        public void remove() {
            ProgrammingError.throwForUnsupportedOptionalOperation();
        }

        public long row() {
            return this.myRow;
        }

        public Stream<RowView<N>> stream() {
            return StreamSupport.stream(this, false);
        }

        @Override
        public void supplyTo(Mutate1D receiver) {
            long limit = Math.min(this.myDelegate2D.countColumns(), receiver.count());
            for (long j = 0L; j < limit; ++j) {
                receiver.set(j, (Comparable<?>)this.myDelegate2D.get(this.myRow, j));
            }
        }

        public String toString() {
            return Access1D.toString(this);
        }

        @Override
        public boolean tryAdvance(Consumer<? super RowView<N>> action) {
            if (this.hasNext()) {
                action.accept((RowView<N>)this.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<RowView<N>> trySplit() {
            long remaining = this.myLastRow - this.myRow;
            if (remaining > 1L) {
                long split = this.myRow + remaining / 2L;
                RowView<N> retVal = new RowView<N>(this.myDelegate2D, this.myRow, split);
                this.myRow = split;
                return retVal;
            }
            return null;
        }
    }

    public static class ElementView<N extends Comparable<N>>
    implements ElementView2D<N, ElementView<N>> {
        private final ElementView1D<N, ?> myDelegate1D;
        private final long myStructure;

        public ElementView(ElementView1D<N, ?> delegate, long structure) {
            this.myDelegate1D = delegate;
            this.myStructure = structure;
        }

        @Override
        public long column() {
            return Structure2D.column(this.myDelegate1D.index(), this.myStructure);
        }

        @Override
        public double doubleValue() {
            return this.myDelegate1D.doubleValue();
        }

        @Override
        public long estimateSize() {
            return this.myDelegate1D.estimateSize();
        }

        @Override
        public N get() {
            return (N)((Comparable)this.myDelegate1D.get());
        }

        @Override
        public boolean hasNext() {
            return this.myDelegate1D.hasNext();
        }

        @Override
        public boolean hasPrevious() {
            return this.myDelegate1D.hasPrevious();
        }

        @Override
        public long index() {
            return this.myDelegate1D.index();
        }

        @Override
        public ElementView<N> iterator() {
            return new ElementView<N>(this.myDelegate1D.iterator(), this.myStructure);
        }

        @Override
        public ElementView<N> next() {
            this.myDelegate1D.next();
            return this;
        }

        @Override
        public long nextIndex() {
            return this.myDelegate1D.nextIndex();
        }

        @Override
        public ElementView<N> previous() {
            this.myDelegate1D.previous();
            return this;
        }

        @Override
        public long previousIndex() {
            return this.myDelegate1D.previousIndex();
        }

        @Override
        public long row() {
            return Structure2D.row(this.myDelegate1D.index(), this.myStructure);
        }

        public String toString() {
            return this.myDelegate1D.toString();
        }

        @Override
        public ElementView<N> trySplit() {
            Spliterator delegateSpliterator = this.myDelegate1D.trySplit();
            if (delegateSpliterator != null) {
                return new ElementView<N>(delegateSpliterator, this.myStructure);
            }
            return null;
        }
    }

    public static class ColumnView<N extends Comparable<N>>
    implements Access1D<N>,
    Iterable<ColumnView<N>>,
    Iterator<ColumnView<N>>,
    Spliterator<ColumnView<N>>,
    Comparable<ColumnView<N>>,
    Access1D.Collectable<N, Mutate1D> {
        static final int CHARACTERISTICS = 21845;
        private long myColumn = -1L;
        private final Access2D<N> myDelegate2D;
        private final long myLastColumn;

        private ColumnView(Access2D<N> access, long column, long lastColumn) {
            this.myDelegate2D = access;
            this.myLastColumn = lastColumn;
            this.myColumn = column;
        }

        protected ColumnView(Access2D<N> access) {
            this(access, -1L, access.countColumns() - 1L);
        }

        ColumnView(Access2D<N> access, long column) {
            this(access, column, access.countColumns() - 1L);
        }

        @Override
        public int characteristics() {
            return 21845;
        }

        public long column() {
            return this.myColumn;
        }

        @Override
        public int compareTo(ColumnView<N> other) {
            return Long.compare(this.myColumn, other.column());
        }

        @Override
        public long count() {
            return this.myDelegate2D.countRows();
        }

        @Override
        public double doubleValue(long index) {
            return this.myDelegate2D.doubleValue(index, this.myColumn);
        }

        @Override
        public long estimateSize() {
            return this.myLastColumn - this.myColumn;
        }

        @Override
        public void forEachRemaining(Consumer<? super ColumnView<N>> action) {
            Iterator.super.forEachRemaining(action);
        }

        @Override
        public N get(long index) {
            return this.myDelegate2D.get(index, this.myColumn);
        }

        public void goToColumn(long column) {
            this.myColumn = column;
        }

        @Override
        public boolean hasNext() {
            return this.myColumn < this.myLastColumn;
        }

        public boolean hasPrevious() {
            return this.myColumn > 0L;
        }

        @Override
        public ColumnView<N> iterator() {
            return new ColumnView<N>(this.myDelegate2D);
        }

        @Override
        public ColumnView<N> next() {
            ++this.myColumn;
            return this;
        }

        public ColumnView<N> previous() {
            --this.myColumn;
            return this;
        }

        @Override
        public void remove() {
            ProgrammingError.throwForUnsupportedOptionalOperation();
        }

        public Stream<ColumnView<N>> stream() {
            return StreamSupport.stream(this, false);
        }

        @Override
        public void supplyTo(Mutate1D receiver) {
            long limit = Math.min(this.myDelegate2D.countRows(), receiver.count());
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.myDelegate2D.get(i, this.myColumn));
            }
        }

        public String toString() {
            return Access1D.toString(this);
        }

        @Override
        public boolean tryAdvance(Consumer<? super ColumnView<N>> action) {
            if (this.hasNext()) {
                action.accept((ColumnView<N>)this.next());
                return true;
            }
            return false;
        }

        @Override
        public Spliterator<ColumnView<N>> trySplit() {
            long remaining = this.myLastColumn - this.myColumn;
            if (remaining > 1L) {
                long split = this.myColumn + remaining / 2L;
                ColumnView<N> retVal = new ColumnView<N>(this.myDelegate2D, this.myColumn, split);
                this.myColumn = split;
                return retVal;
            }
            return null;
        }
    }

    public static interface Collectable<N extends Comparable<N>, R extends Mutate2D>
    extends Structure2D {
        default public <I extends R> I collect(Factory2D<I> factory) {
            Mutate2D retVal = (Mutate2D)factory.make(this.countRows(), this.countColumns());
            this.supplyTo(retVal);
            return (I)retVal;
        }

        public void supplyTo(R var1);
    }

    public static interface Aggregatable<N extends Comparable<N>>
    extends Structure2D,
    Access1D.Aggregatable<N> {
        default public N aggregateColumn(long col, Aggregator aggregator) {
            return this.aggregateColumn(0L, col, aggregator);
        }

        public N aggregateColumn(long var1, long var3, Aggregator var5);

        default public N aggregateDiagonal(Aggregator aggregator) {
            return this.aggregateDiagonal(0L, 0L, aggregator);
        }

        public N aggregateDiagonal(long var1, long var3, Aggregator var5);

        default public N aggregateRow(long row, Aggregator aggregator) {
            return this.aggregateRow(row, 0L, aggregator);
        }

        public N aggregateRow(long var1, long var3, Aggregator var5);

        default public void reduceColumns(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countColumns(), receiver.count());
            for (long j = 0L; j < limit; ++j) {
                receiver.set(j, (Comparable<?>)this.aggregateColumn(j, aggregator));
            }
        }

        default public void reduceRows(Aggregator aggregator, Mutate1D receiver) {
            long limit = Math.min(this.countRows(), receiver.count());
            for (long i = 0L; i < limit; ++i) {
                receiver.set(i, (Comparable<?>)this.aggregateRow(i, aggregator));
            }
        }
    }
}

