/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.scalar;

import org.ojalgo.scalar.ExactDecimal;
import org.ojalgo.scalar.Price;
import org.ojalgo.scalar.Quantity;
import org.ojalgo.scalar.Scalar;

public final class Amount
extends ExactDecimal<Amount> {
    public static final ExactDecimal.Descriptor DESCRIPTOR = new ExactDecimal.Descriptor(2);
    public static final Scalar.Factory<Amount> FACTORY = new ExactDecimal.Factory<Amount>(){

        @Override
        public Amount cast(double value) {
            return Amount.valueOf(value);
        }

        @Override
        public Amount cast(Comparable<?> number) {
            return Amount.valueOf(number);
        }

        public Amount convert(double value) {
            return Amount.valueOf(value);
        }

        public Amount convert(Comparable<?> number) {
            return Amount.valueOf(number);
        }

        @Override
        public ExactDecimal.Descriptor descriptor() {
            return DESCRIPTOR;
        }

        public Amount one() {
            return ONE;
        }

        public Amount zero() {
            return ZERO;
        }
    };
    private static final double DOUBLE_DENOMINATOR = 100.0;
    private static final long LONG_DENOMINATOR = 100L;
    public static final Amount NEG = new Amount(-100L);
    public static final Amount ONE = new Amount(100L);
    public static final Amount TWO = new Amount(200L);
    public static final Amount ZERO = new Amount();

    public static Amount valueOf(double value) {
        return new Amount(Math.round(value * 100.0));
    }

    public static Amount valueOf(Comparable<?> number) {
        if (number == null) {
            return ZERO;
        }
        if (number instanceof Amount) {
            return (Amount)number;
        }
        return Amount.valueOf(Scalar.doubleValue(number));
    }

    public Amount() {
        super(0L);
    }

    Amount(long numerator) {
        super(numerator);
    }

    @Override
    public Quantity divide(Price price) {
        return new Quantity(Quantity.DESCRIPTOR.multiply(this, price));
    }

    @Override
    public Price divide(Quantity quanntity) {
        return new Price(Price.DESCRIPTOR.multiply(this, quanntity));
    }

    @Override
    public Amount multiply(Price rate) {
        return new Amount(DESCRIPTOR.multiply(this, rate));
    }

    @Override
    protected ExactDecimal.Descriptor descriptor() {
        return DESCRIPTOR;
    }

    @Override
    protected Amount wrap(long numerator) {
        return new Amount(numerator);
    }
}

