/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.optimisation.linear;

import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.optimisation.Optimisation;
import org.ojalgo.optimisation.convex.ConvexSolver;
import org.ojalgo.optimisation.linear.Primitive1D;
import org.ojalgo.optimisation.linear.Primitive2D;
import org.ojalgo.optimisation.linear.SimplexTableau;
import org.ojalgo.optimisation.linear.SimplexTableauSolver;
import org.ojalgo.structure.Access1D;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.ElementView1D;
import org.ojalgo.type.context.NumberContext;

final class DualSimplex
extends SimplexTableauSolver {
    private static SimplexTableau buildAlt(ConvexSolver.Builder convex, Optimisation.Options options, boolean checkFeasibility) {
        int j;
        int nbVars = convex.countVariables();
        int nbEqus = convex.countEqualityConstraints();
        int nbInes = convex.countInequalityConstraints();
        int nbProblemVariables = nbEqus + nbEqus + nbInes;
        int nbConstraints = nbVars;
        SimplexTableau retVal = SimplexTableau.make(nbConstraints, nbProblemVariables, 0, 0, 0, true, options);
        SimplexTableau.MetaData meta = retVal.meta;
        Primitive2D constraintsBody = retVal.constraintsBody();
        Primitive1D constraintsRHS = retVal.constraintsRHS();
        Primitive1D objective = retVal.objective();
        MatrixStore convexC = convex.getC();
        MatrixStore<Double> convexAE = convex.getAE();
        MatrixStore<Double> convexBE = convex.getBE();
        double[] feasibilityC = new double[checkFeasibility ? nbConstraints : 0];
        if (checkFeasibility) {
            for (Access2D.RowView rowView : convex.getRowsAI()) {
                for (ElementView1D element : rowView.nonzeros()) {
                    int n = Math.toIntExact(element.index());
                    feasibilityC[n] = feasibilityC[n] + element.doubleValue();
                }
            }
        }
        for (int i = 0; i < nbConstraints; ++i) {
            double d = checkFeasibility ? (double)i : convexC.doubleValue(i);
            meta.negatedDual[i] = NumberContext.compare(d, PrimitiveMath.ZERO) < 0;
            boolean neg = meta.negatedDual[i];
            for (int j2 = 0; j2 < nbEqus; ++j2) {
                double valE = convexAE.doubleValue(j2, i);
                constraintsBody.set(i, j2, neg ? -valE : valE);
                constraintsBody.set(i, nbEqus + j2, neg ? valE : -valE);
            }
            constraintsRHS.set(i, neg ? -d : d);
        }
        for (Access2D.RowView rowView : convex.getRowsAI()) {
            int tabJ = Math.toIntExact(rowView.row());
            for (ElementView1D element : rowView.nonzeros()) {
                int tabI = Math.toIntExact(element.index());
                double tabVal = element.doubleValue();
                constraintsBody.set(tabI, nbEqus + nbEqus + tabJ, meta.negatedDual[tabI] ? -tabVal : tabVal);
            }
        }
        for (j = 0; j < nbEqus; ++j) {
            double d = convexBE.doubleValue(j);
            objective.set(j, d);
            objective.set(nbEqus + j, -d);
        }
        for (j = 0; j < nbInes; ++j) {
            double d = convex.getBI(j);
            objective.set(nbEqus + nbEqus + j, d);
        }
        return retVal;
    }

    static SimplexTableau build(ConvexSolver.Builder convex, Optimisation.Options options, boolean checkFeasibility) {
        int j;
        int nbVars = convex.countVariables();
        int nbEqus = convex.countEqualityConstraints();
        int nbInes = convex.countInequalityConstraints();
        SimplexTableau retVal = SimplexTableau.make(nbVars, nbEqus + nbEqus + nbInes, 0, 0, 0, true, options);
        SimplexTableau.MetaData meta = retVal.meta;
        Primitive2D constraintsBody = retVal.constraintsBody();
        Primitive1D constraintsRHS = retVal.constraintsRHS();
        Primitive1D objective = retVal.objective();
        MatrixStore convexC = convex.getC();
        MatrixStore<Double> convexAE = convex.getAE();
        MatrixStore<Double> convexBE = convex.getBE();
        for (int i = 0; i < nbVars; ++i) {
            double d = checkFeasibility ? PrimitiveMath.ZERO : convexC.doubleValue(i);
            meta.negatedDual[i] = NumberContext.compare(d, PrimitiveMath.ZERO) < 0;
            boolean neg = meta.negatedDual[i];
            for (int j2 = 0; j2 < nbEqus; ++j2) {
                double valE = convexAE.doubleValue(j2, i);
                constraintsBody.set(i, j2, neg ? -valE : valE);
                constraintsBody.set(i, nbEqus + j2, neg ? valE : -valE);
            }
            constraintsRHS.set(i, neg ? -d : d);
        }
        for (Access2D.RowView rowView : convex.getRowsAI()) {
            int tabJ = Math.toIntExact(rowView.row());
            for (ElementView1D element : rowView.nonzeros()) {
                int tabI = Math.toIntExact(element.index());
                double tabVal = element.doubleValue();
                constraintsBody.set(tabI, nbEqus + nbEqus + tabJ, meta.negatedDual[tabI] ? -tabVal : tabVal);
            }
        }
        for (j = 0; j < nbEqus; ++j) {
            double d = convexBE.doubleValue(j);
            objective.set(j, d);
            objective.set(nbEqus + j, -d);
        }
        for (j = 0; j < nbInes; ++j) {
            double d = convex.getBI(j);
            objective.set(nbEqus + nbEqus + j, d);
        }
        return retVal;
    }

    static Optimisation.Result doSolve(ConvexSolver.Builder convex, Optimisation.Options options, boolean zeroC) {
        SimplexTableau tableau = DualSimplex.build(convex, options, zeroC);
        DualSimplex solver = new DualSimplex(tableau, options);
        Optimisation.Result result = solver.solve();
        return DualSimplex.toConvexState(result, convex);
    }

    static int size(ConvexSolver.Builder convex) {
        int numbVars = convex.countVariables();
        int numbEqus = convex.countEqualityConstraints();
        int numbInes = convex.countInequalityConstraints();
        return SimplexTableau.size(numbVars, numbEqus + numbEqus + numbInes, 0, 0, true);
    }

    static Optimisation.Result toConvexState(Optimisation.Result result, ConvexSolver.Builder convex) {
        final int nbEqus = convex.countEqualityConstraints();
        final int nbInes = convex.countInequalityConstraints();
        final Access1D<?> multipliers = result.getMultipliers().get();
        Optimisation.Result retVal = new Optimisation.Result(result.getState(), result.getValue(), result);
        retVal.multipliers(new Primitive1D(){

            @Override
            public int size() {
                return nbEqus + nbInes;
            }

            @Override
            double doubleValue(int index) {
                if (index < nbEqus) {
                    return -(multipliers.doubleValue(index) - multipliers.doubleValue(nbEqus + index));
                }
                return -multipliers.doubleValue(nbEqus + index);
            }

            @Override
            void set(int index, double value) {
                throw new IllegalArgumentException();
            }
        });
        return retVal;
    }

    DualSimplex(SimplexTableau tableau, Optimisation.Options solverOptions) {
        super(tableau, solverOptions);
    }

    @Override
    protected double evaluateFunction(Access1D<?> solution) {
        return -super.evaluateFunction(solution);
    }

    @Override
    protected Access1D<?> extractMultipliers() {
        return super.extractSolution();
    }

    @Override
    protected Access1D<?> extractSolution() {
        return super.extractMultipliers();
    }

    @Override
    protected Optimisation.State getState() {
        Optimisation.State state = super.getState();
        if (state == Optimisation.State.UNBOUNDED) {
            return Optimisation.State.INFEASIBLE;
        }
        if (!state.isFeasible()) {
            return Optimisation.State.UNBOUNDED;
        }
        return state;
    }
}

