/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.netio;

import java.math.BigDecimal;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.ojalgo.ProgrammingError;
import org.ojalgo.netio.BasicParser;
import org.ojalgo.type.context.TypeContext;

public final class EnumeratedColumnsParser
implements BasicParser<LineView> {
    private final LineView myLineView;

    public static Builder make(Class<? extends Enum<?>> columns) {
        return new Builder(columns.getFields().length);
    }

    public static Builder make(int numberOfColumns) {
        return new Builder(numberOfColumns);
    }

    EnumeratedColumnsParser(int columns, char delimiter, ParseStrategy strategy) {
        this.myLineView = strategy.make(columns, delimiter);
    }

    @Override
    public LineView parse(String line) {
        return this.parseLine(line, null);
    }

    @Override
    public void parse(Supplier<String> reader, boolean skipHeader, Consumer<LineView> consumer) {
        String line = null;
        LineView item = null;
        if (skipHeader) {
            line = reader.get();
            line = null;
        }
        while ((line = reader.get()) != null) {
            if (line.length() <= 0 || line.startsWith("#") || (item = this.parseLine(line, reader)) == null) continue;
            consumer.accept(item);
        }
    }

    LineView parseLine(String line, Supplier<String> reader) {
        if (this.myLineView.index(line, reader)) {
            return this.myLineView;
        }
        return null;
    }

    static class RFC4180
    extends LineView {
        private static final char QUOTE = '\"';
        private final int[] myBegin;
        private final int[] myEnd;
        private boolean myEscaped;

        RFC4180(int numberOfColumns, char delimiter) {
            super(numberOfColumns, delimiter);
            this.myBegin = new int[numberOfColumns];
            this.myEnd = new int[numberOfColumns];
        }

        @Override
        public String get(int column) {
            if (this.myEscaped) {
                return this.line.substring(this.myBegin[column], this.myEnd[column]).replace("\"\"", "\"");
            }
            return this.line.substring(this.myBegin[column], this.myEnd[column]);
        }

        @Override
        boolean index(String line, Supplier<String> lineSupplier) {
            this.myEscaped = false;
            Object tmpLine = line;
            int c = 0;
            this.myBegin[0] = 0;
            int tmpMode = 0;
            int tmpNumberOfQuotes = 0;
            block4: for (int i = 0; i < ((String)tmpLine).length(); ++i) {
                char tmpCurChar = ((String)tmpLine).charAt(i);
                int tmpNextInd = i + 1;
                switch (tmpMode) {
                    case 1: {
                        if (tmpCurChar == '\"') {
                            if (++tmpNumberOfQuotes % 2 == 0 && (tmpNextInd == ((String)tmpLine).length() || ((String)tmpLine).charAt(tmpNextInd) != '\"')) {
                                this.myEnd[c++] = i;
                                tmpMode = 2;
                                continue block4;
                            }
                            this.myEscaped = true;
                            continue block4;
                        }
                        if (tmpNextInd != ((String)tmpLine).length()) continue block4;
                        if (lineSupplier == null) {
                            throw new ProgrammingError("Cant't handle line breaks within quotes when used this way!");
                        }
                        String nextPart = lineSupplier.get();
                        if (nextPart != null) {
                            tmpLine = (String)tmpLine + "\n" + nextPart;
                            continue block4;
                        }
                        return false;
                    }
                    case 2: {
                        if (tmpCurChar == this.delimiter) {
                            this.myBegin[c] = tmpNextInd;
                            if (tmpNextInd == ((String)tmpLine).length()) {
                                this.myEnd[c++] = tmpNextInd;
                            }
                            tmpMode = 0;
                            continue block4;
                        }
                        if (tmpNextInd != ((String)tmpLine).length()) continue block4;
                        this.myEnd[c++] = tmpNextInd;
                        continue block4;
                    }
                    default: {
                        if (tmpCurChar == '\"') {
                            ++tmpNumberOfQuotes;
                            this.myBegin[c] = tmpNextInd;
                            tmpMode = 1;
                            continue block4;
                        }
                        if (tmpCurChar == this.delimiter) {
                            this.myEnd[c++] = i;
                            this.myBegin[c] = tmpNextInd;
                            if (tmpNextInd != ((String)tmpLine).length()) continue block4;
                            this.myEnd[c++] = tmpNextInd;
                            continue block4;
                        }
                        if (tmpNextInd != ((String)tmpLine).length()) continue block4;
                        this.myEnd[c++] = tmpNextInd;
                    }
                }
            }
            this.line = tmpLine;
            return this.numberOfColumns == c;
        }
    }

    static class QuotedViewStrategy
    extends LineView {
        private final int[] myIndices;
        private final String mySplitter;

        QuotedViewStrategy(int numberOfColumns, char delimiter) {
            super(numberOfColumns, delimiter);
            this.myIndices = new int[numberOfColumns + 1];
            this.mySplitter = String.valueOf(new char[]{'\"', delimiter, '\"'});
        }

        @Override
        public String get(int column) {
            return this.line.substring(this.myIndices[column] + 3, this.myIndices[column + 1]);
        }

        @Override
        boolean index(String line, Supplier<String> lineSupplier) {
            int tmpPosition;
            int tmpIndex = 0;
            this.myIndices[tmpIndex] = tmpPosition = -2;
            while (true) {
                ++tmpPosition;
                if ((tmpPosition = line.indexOf(this.mySplitter, tmpPosition)) < 0) break;
                this.myIndices[++tmpIndex] = tmpPosition;
            }
            tmpPosition = line.length() - 1;
            this.myIndices[++tmpIndex] = tmpPosition;
            this.line = line;
            return tmpIndex == this.numberOfColumns;
        }
    }

    static class FastViewStrategy
    extends LineView {
        private final int[] myIndices;

        FastViewStrategy(int numberOfColumns, char delimiter) {
            super(numberOfColumns, delimiter);
            this.myIndices = new int[numberOfColumns + 1];
        }

        @Override
        public String get(int column) {
            return this.line.substring(this.myIndices[column] + 1, this.myIndices[column + 1]);
        }

        @Override
        boolean index(String line, Supplier<String> lineSupplier) {
            int tmpPosition;
            int tmpIndex = 0;
            this.myIndices[tmpIndex] = tmpPosition = -1;
            while (true) {
                ++tmpPosition;
                if ((tmpPosition = line.indexOf(this.delimiter, tmpPosition)) < 0) break;
                this.myIndices[++tmpIndex] = tmpPosition;
            }
            tmpPosition = line.length();
            this.myIndices[++tmpIndex] = tmpPosition;
            this.line = line;
            return tmpIndex == this.numberOfColumns;
        }
    }

    public static enum ParseStrategy {
        FAST{

            @Override
            public LineView make(int numberOfColumns, char delimiter) {
                return new FastViewStrategy(numberOfColumns, delimiter);
            }
        }
        ,
        QUOTED{

            @Override
            public LineView make(int numberOfColumns, char delimiter) {
                return new QuotedViewStrategy(numberOfColumns, delimiter);
            }
        }
        ,
        RFC4180{

            @Override
            public LineView make(int numberOfColumns, char delimiter) {
                return new RFC4180(numberOfColumns, delimiter);
            }
        };


        public abstract LineView make(int var1, char var2);
    }

    public static abstract class LineView {
        final char delimiter;
        transient String line = null;
        final int numberOfColumns;

        private LineView() {
            this(0, ',');
        }

        LineView(int numberOfColumns, char delimiter) {
            this.numberOfColumns = numberOfColumns;
            this.delimiter = delimiter;
        }

        public final double doubleValue(Enum<?> column) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return Double.parseDouble(tmpStringValue);
            }
            return Double.NaN;
        }

        public final double floatValue(Enum<?> column) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return Float.parseFloat(tmpStringValue);
            }
            return Double.NaN;
        }

        public final String get(Enum<?> column) {
            return this.get(column.ordinal());
        }

        public final <P> P get(Enum<?> column, TypeContext<P> typeContext) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return typeContext.parse(tmpStringValue);
            }
            return null;
        }

        public abstract String get(int var1);

        public final long intValue(Enum<?> column) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return Integer.parseInt(tmpStringValue);
            }
            return 0L;
        }

        public boolean isLineOK() {
            return this.line != null && this.line.length() > 0;
        }

        public final long longValue(Enum<?> column) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return Long.parseLong(tmpStringValue);
            }
            return 0L;
        }

        public final BigDecimal toBigDecimal(Enum<?> column) {
            String tmpStringValue = this.get(column.ordinal());
            if (tmpStringValue != null && tmpStringValue.length() > 0) {
                return new BigDecimal(tmpStringValue);
            }
            return null;
        }

        abstract boolean index(String var1, Supplier<String> var2);
    }

    public static class Builder
    implements Supplier<EnumeratedColumnsParser> {
        private char myDelimiter = (char)44;
        private final int myNumberOfColumns;
        private ParseStrategy myStrategy = ParseStrategy.RFC4180;

        Builder(int numberOfColumns) {
            this.myNumberOfColumns = numberOfColumns;
        }

        public Builder delimiter(char delimiter) {
            this.myDelimiter = delimiter;
            return this;
        }

        @Override
        public EnumeratedColumnsParser get() {
            return new EnumeratedColumnsParser(this.myNumberOfColumns, this.myDelimiter, this.myStrategy);
        }

        public Builder strategy(ParseStrategy quoted) {
            this.myStrategy = quoted;
            return this;
        }
    }
}

