/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.array.ArrayR064;
import org.ojalgo.array.BasicArray;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.TridiagonalDecomposition;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.structure.Access2D;

class SimultaneousTridiagonal
extends TridiagonalDecomposition<Double> {
    private BasicArray<Double> myDiagD;
    private BasicArray<Double> myDiagE;

    SimultaneousTridiagonal() {
        super(Primitive64Store.FACTORY);
    }

    @Override
    public boolean decompose(Access2D.Collectable<Double, ? super PhysicalStore<Double>> matrix) {
        this.setInPlace(matrix);
        int size = this.getMinDim();
        if (this.myDiagD == null || this.myDiagD.count() == (long)size) {
            this.myDiagD = ArrayR064.make(size);
            this.myDiagE = ArrayR064.make(size);
        }
        this.getInPlace().tred2(this.myDiagD, this.myDiagE, true);
        return this.computed(true);
    }

    @Override
    protected void supplyDiagonalTo(double[] d, double[] e) {
        this.myDiagD.supplyTo(d);
        this.myDiagE.supplyTo(e);
    }

    @Override
    MatrixStore<Double> makeD() {
        return this.makeDiagonal(this.myDiagD).superdiagonal(this.myDiagE).subdiagonal(this.myDiagE).get();
    }

    @Override
    DecompositionStore<Double> makeQ() {
        return this.getInPlace();
    }
}

