/*
 * Decompiled with CFR 0.152.
 */
package org.ojalgo.matrix.decomposition;

import org.ojalgo.RecoverableCondition;
import org.ojalgo.array.BasicArray;
import org.ojalgo.function.BinaryFunction;
import org.ojalgo.function.aggregator.Aggregator;
import org.ojalgo.function.aggregator.AggregatorFunction;
import org.ojalgo.function.constant.PrimitiveMath;
import org.ojalgo.matrix.decomposition.DecompositionStore;
import org.ojalgo.matrix.decomposition.InPlaceDecomposition;
import org.ojalgo.matrix.decomposition.LDL;
import org.ojalgo.matrix.decomposition.Pivot;
import org.ojalgo.matrix.store.GenericStore;
import org.ojalgo.matrix.store.MatrixStore;
import org.ojalgo.matrix.store.PhysicalStore;
import org.ojalgo.matrix.store.Primitive64Store;
import org.ojalgo.scalar.ComplexNumber;
import org.ojalgo.scalar.Quaternion;
import org.ojalgo.scalar.RationalNumber;
import org.ojalgo.scalar.Scalar;
import org.ojalgo.structure.Access2D;
import org.ojalgo.structure.Structure2D;
import org.ojalgo.type.NumberDefinition;
import org.ojalgo.type.context.NumberContext;

abstract class LDLDecomposition<N extends Comparable<N>>
extends InPlaceDecomposition<N>
implements LDL<N> {
    private final Pivot myPivot = new Pivot();

    protected LDLDecomposition(PhysicalStore.Factory<N, ? extends DecompositionStore<N>> factory) {
        super(factory);
    }

    @Override
    public N calculateDeterminant(Access2D<?> matrix) {
        this.decompose(this.wrap(matrix));
        return this.getDeterminant();
    }

    @Override
    public int countSignificant(double threshold) {
        DecompositionStore internal = this.getInPlace();
        int significant = 0;
        int limit = this.getMinDim();
        for (int ij = 0; ij < limit; ++ij) {
            if (!(Math.abs(internal.doubleValue(ij, ij)) > threshold)) continue;
            ++significant;
        }
        return significant;
    }

    @Override
    public boolean decompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.doDecompose(matrix, true);
    }

    @Override
    public boolean decomposeWithoutPivoting(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix) {
        return this.doDecompose(matrix, false);
    }

    @Override
    public MatrixStore<N> getD() {
        return this.getInPlace().diagonal();
    }

    @Override
    public N getDeterminant() {
        AggregatorFunction aggregator = this.aggregator().product();
        this.getInPlace().visitDiagonal(aggregator);
        if (this.myPivot.signum() == -1) {
            return (N)((Comparable)((Scalar)aggregator.toScalar().negate()).get());
        }
        return (N)((Comparable)aggregator.get());
    }

    @Override
    public MatrixStore<N> getInverse(PhysicalStore<N> preallocated) {
        int[] order = this.myPivot.getOrder();
        boolean modified = this.myPivot.isModified();
        if (modified) {
            preallocated.fillAll((Comparable)this.scalar().zero().get());
            for (int i = 0; i < order.length; ++i) {
                preallocated.set((long)i, (long)order[i], PrimitiveMath.ONE);
            }
        }
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, true, false, !modified);
        BinaryFunction<double> divide = this.function().divide();
        for (int i = 0; i < order.length; ++i) {
            preallocated.modifyRow(i, 0L, divide.by(body.doubleValue(i, i)));
        }
        preallocated.substituteBackwards(body, true, true, false);
        return preallocated.rows(this.myPivot.getInverseOrder());
    }

    @Override
    public MatrixStore<N> getL() {
        DecompositionStore tmpInPlace;
        DecompositionStore tmpBuilder = tmpInPlace = this.getInPlace();
        return tmpBuilder.triangular(false, true);
    }

    @Override
    public int[] getPivotOrder() {
        return this.myPivot.getOrder();
    }

    @Override
    public double getRankThreshold() {
        Object largest = this.getInPlace().aggregateDiagonal(Aggregator.LARGEST);
        double epsilon = this.getDimensionalEpsilon();
        return epsilon * Math.max(Double.MIN_NORMAL, NumberDefinition.doubleValue(largest));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs) {
        return this.getSolution(rhs, this.preallocate(this.getInPlace(), rhs));
    }

    @Override
    public MatrixStore<N> getSolution(Access2D.Collectable<N, ? super PhysicalStore<N>> rhs, PhysicalStore<N> preallocated) {
        int[] order = this.myPivot.getOrder();
        preallocated.fillMatching(this.collect(rhs).rows(order));
        DecompositionStore body = this.getInPlace();
        preallocated.substituteForwards(body, true, false, false);
        BinaryFunction divide = this.function().divide();
        for (int i = 0; i < order.length; ++i) {
            preallocated.modifyRow(i, divide.by(body.get(i, i)));
        }
        preallocated.substituteBackwards(body, true, true, false);
        return preallocated.rows(this.myPivot.getInverseOrder());
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse();
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public MatrixStore<N> invert(Access2D<?> original, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(original));
        if (this.isSolvable()) {
            return this.getInverse(preallocated);
        }
        throw RecoverableCondition.newMatrixNotInvertible();
    }

    @Override
    public boolean isPivoted() {
        return this.myPivot.isModified();
    }

    @Override
    public boolean isSolvable() {
        return super.isSolvable();
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D template) {
        long tmpCountRows = template.countRows();
        return this.allocate(tmpCountRows, tmpCountRows);
    }

    @Override
    public PhysicalStore<N> preallocate(Structure2D templateBody, Structure2D templateRHS) {
        return this.allocate(templateRHS.countRows(), templateRHS.countColumns());
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs));
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    @Override
    public MatrixStore<N> solve(Access2D<?> body, Access2D<?> rhs, PhysicalStore<N> preallocated) throws RecoverableCondition {
        this.decompose(this.wrap(body));
        if (this.isSolvable()) {
            return this.getSolution(this.wrap(rhs), preallocated);
        }
        throw RecoverableCondition.newEquationSystemNotSolvable();
    }

    private boolean doDecompose(Access2D.Collectable<N, ? super PhysicalStore<N>> matrix, boolean pivoting) {
        this.reset();
        DecompositionStore store = this.setInPlace(matrix);
        int dim = this.getMinDim();
        this.myPivot.reset(dim);
        BasicArray multipliers = this.makeArray(dim);
        for (int ij = 0; ij < dim; ++ij) {
            int pivotRow;
            if (pivoting && (pivotRow = store.indexOfLargestOnDiagonal(ij, ij)) != ij) {
                store.exchangeHermitian(pivotRow, ij);
                this.myPivot.change(pivotRow, ij);
            }
            if (NumberContext.compare(store.doubleValue(ij, ij), PrimitiveMath.ZERO) != 0) {
                store.divideAndCopyColumn(ij, ij, multipliers);
                store.applyLDL(ij, multipliers);
                continue;
            }
            store.set((long)ij, (long)ij, PrimitiveMath.ZERO);
        }
        return this.computed(true);
    }

    @Override
    protected boolean checkSolvability() {
        return this.isSquare() && this.isFullRank();
    }

    static final class Rational
    extends LDLDecomposition<RationalNumber> {
        Rational() {
            super(GenericStore.RATIONAL);
        }
    }

    static final class Quat
    extends LDLDecomposition<Quaternion> {
        Quat() {
            super(GenericStore.QUATERNION);
        }
    }

    static final class Primitive
    extends LDLDecomposition<Double> {
        Primitive() {
            super(Primitive64Store.FACTORY);
        }
    }

    static final class Complex
    extends LDLDecomposition<ComplexNumber> {
        Complex() {
            super(GenericStore.COMPLEX);
        }
    }
}

