/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.support.mode;

import bibliothek.gui.DockStation;
import bibliothek.gui.Dockable;
import bibliothek.gui.dock.action.AbstractDockActionSource;
import bibliothek.gui.dock.action.DockAction;
import bibliothek.gui.dock.action.DockActionSource;
import bibliothek.gui.dock.action.LocationHint;
import bibliothek.gui.dock.event.DockActionSourceListener;
import bibliothek.gui.dock.event.DockStationAdapter;
import bibliothek.gui.dock.event.DockStationListener;
import bibliothek.gui.dock.support.mode.Mode;
import bibliothek.gui.dock.support.mode.ModeManager;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class ModeForwardingActionSource<H>
extends AbstractDockActionSource {
    private DockStation station;
    private ModeManager<H, ? extends Mode<H>> manager;
    private DockActionSource delegate;
    private DockActionSourceListener delegateListener = new DockActionSourceListener(){

        public void actionsRemoved(DockActionSource source, int firstIndex, int lastIndex) {
            ModeForwardingActionSource.this.fireRemoved(firstIndex, lastIndex);
        }

        public void actionsAdded(DockActionSource source, int firstIndex, int lastIndex) {
            ModeForwardingActionSource.this.fireAdded(firstIndex, lastIndex);
        }
    };
    private DockStationListener stationListener = new DockStationAdapter(){

        public void dockableAdded(DockStation station, Dockable dockable) {
            ModeForwardingActionSource.this.rebuild();
        }

        public void dockableRemoved(DockStation station, Dockable dockable) {
            ModeForwardingActionSource.this.rebuild();
        }

        public void dockableSelected(DockStation station, Dockable oldSelection, Dockable newSelection) {
            ModeForwardingActionSource.this.rebuild();
        }
    };

    public ModeForwardingActionSource(DockStation station, ModeManager<H, ? extends Mode<H>> manager) {
        this.station = station;
        this.manager = manager;
        this.rebuild();
    }

    public void addDockActionSourceListener(DockActionSourceListener listener) {
        boolean empty = this.listeners.isEmpty();
        super.addDockActionSourceListener(listener);
        if (empty) {
            if (this.delegate != null) {
                this.delegate.addDockActionSourceListener(this.delegateListener);
            }
            this.station.addDockStationListener(this.stationListener);
        }
    }

    public void removeDockActionSourceListener(DockActionSourceListener listener) {
        super.removeDockActionSourceListener(listener);
        if (this.listeners.isEmpty()) {
            if (this.delegate != null) {
                this.delegate.removeDockActionSourceListener(this.delegateListener);
            }
            this.station.removeDockStationListener(this.stationListener);
        }
    }

    public DockAction getDockAction(int index) {
        return this.delegate.getDockAction(index);
    }

    public int getDockActionCount() {
        if (this.delegate == null) {
            return 0;
        }
        return this.delegate.getDockActionCount();
    }

    public LocationHint getLocationHint() {
        return new LocationHint(LocationHint.ACTION_GUARD, LocationHint.RIGHT);
    }

    public Iterator<DockAction> iterator() {
        if (this.delegate == null) {
            return new Iterator<DockAction>(){

                @Override
                public boolean hasNext() {
                    return false;
                }

                @Override
                public DockAction next() {
                    throw new NoSuchElementException();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }
        return this.delegate.iterator();
    }

    private void rebuild() {
        int size;
        if (this.delegate != null) {
            if (!this.listeners.isEmpty()) {
                this.delegate.removeDockActionSourceListener(this.delegateListener);
            }
            size = this.getDockActionCount();
            this.delegate = null;
            if (size > 0) {
                this.fireRemoved(0, size - 1);
            }
        }
        this.delegate = this.manager.getSharedActions(this.station);
        if (this.delegate != null) {
            if (!this.listeners.isEmpty()) {
                this.delegate.addDockActionSourceListener(this.delegateListener);
            }
            if ((size = this.getDockActionCount()) > 0) {
                this.fireAdded(0, size - 1);
            }
        }
    }
}

