/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.facile.menu;

import bibliothek.gui.dock.support.lookandfeel.ComponentCollector;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelList;
import bibliothek.gui.dock.support.lookandfeel.LookAndFeelListener;
import bibliothek.gui.dock.support.menu.BaseMenuPiece;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JRadioButtonMenuItem;

public class LookAndFeelMenuPiece
extends BaseMenuPiece {
    private JRadioButtonMenuItem defaultButton;
    private JRadioButtonMenuItem systemButton;
    private Map<LookAndFeelList.Info, JRadioButtonMenuItem> buttons = new HashMap<LookAndFeelList.Info, JRadioButtonMenuItem>();
    private LookAndFeelList list;
    private ListListener listListener = new ListListener();
    private boolean onChange = false;
    private ComponentCollector frameCollector;

    public LookAndFeelMenuPiece() {
        this(null, null);
    }

    public LookAndFeelMenuPiece(final JFrame frame, LookAndFeelList list) {
        if (list == null) {
            list = LookAndFeelList.getDefaultList();
        }
        this.list = list;
        this.defaultButton = new JRadioButtonMenuItem("Default: " + list.getDefault().getName());
        this.defaultButton.addItemListener(new SetListener(this.defaultButton, list.getDefault()));
        this.add(this.defaultButton);
        this.systemButton = new JRadioButtonMenuItem(list.getSystem().getName());
        this.systemButton.addItemListener(new SetListener(this.systemButton, list.getSystem()));
        this.add(this.systemButton);
        this.addSeparator();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            LookAndFeelList.Info info = list.get(i);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(info.getName());
            this.buttons.put(info, item);
            SetListener listener = new SetListener(item, info);
            item.addItemListener(listener);
            this.add(item);
        }
        if (frame != null) {
            this.frameCollector = new ComponentCollector(){

                @Override
                public Collection<Component> listComponents() {
                    ArrayList<Component> result = new ArrayList<Component>();
                    result.add(frame);
                    return result;
                }
            };
        }
        this.changed();
    }

    @Override
    public void bind() {
        if (!this.isBound()) {
            super.bind();
            this.install();
        }
    }

    @Override
    public void unbind() {
        if (this.isBound()) {
            super.unbind();
            this.uninstall();
        }
    }

    private void install() {
        if (this.frameCollector != null) {
            this.list.addComponentCollector(this.frameCollector);
        }
        this.list.addLookAndFeelListener(this.listListener);
        this.changed();
    }

    private void uninstall() {
        if (this.frameCollector != null) {
            this.list.removeComponentCollector(this.frameCollector);
        }
        this.list.removeLookAndFeelListener(this.listListener);
    }

    @Deprecated
    public void destroy() {
        this.list.removeLookAndFeelListener(this.listListener);
    }

    public LookAndFeelList getList() {
        return this.list;
    }

    private void changed() {
        this.onChange = true;
        LookAndFeelList.Info current = this.list.getLookAndFeel();
        this.defaultButton.setSelected(this.list.getDefault() == current);
        this.systemButton.setSelected(this.list.getSystem() == current);
        for (Map.Entry<LookAndFeelList.Info, JRadioButtonMenuItem> entry : this.buttons.entrySet()) {
            entry.getValue().setSelected(current == entry.getKey());
        }
        this.onChange = false;
    }

    private class SetListener
    implements ItemListener {
        private JRadioButtonMenuItem item;
        private LookAndFeelList.Info info;

        public SetListener(JRadioButtonMenuItem item, LookAndFeelList.Info info) {
            this.info = info;
            this.item = item;
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (!LookAndFeelMenuPiece.this.onChange) {
                if (this.item.isSelected()) {
                    LookAndFeelMenuPiece.this.list.setLookAndFeel(this.info);
                } else {
                    this.item.setSelected(true);
                }
            }
        }
    }

    private class ListListener
    implements LookAndFeelListener {
        private ListListener() {
        }

        @Override
        public void lookAndFeelChanged(LookAndFeelList list, LookAndFeelList.Info lookAndFeel) {
            LookAndFeelMenuPiece.this.changed();
        }

        @Override
        public void defaultLookAndFeelChanged(LookAndFeelList list, LookAndFeelList.Info lookAndFeel) {
            LookAndFeelMenuPiece.this.defaultButton.setText(lookAndFeel.getName());
        }

        @Override
        public void systemLookAndFeelChanged(LookAndFeelList list, LookAndFeelList.Info lookAndFeel) {
            LookAndFeelMenuPiece.this.systemButton.setText(lookAndFeel.getName());
        }

        @Override
        public void lookAndFeelAdded(LookAndFeelList list, LookAndFeelList.Info info) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(info.getName());
            LookAndFeelMenuPiece.this.buttons.put(info, item);
            SetListener listener = new SetListener(item, info);
            item.addItemListener(listener);
            LookAndFeelMenuPiece.this.add(item);
        }

        @Override
        public void lookAndFeelRemoved(LookAndFeelList list, LookAndFeelList.Info lookAndFeel) {
            JRadioButtonMenuItem item = (JRadioButtonMenuItem)LookAndFeelMenuPiece.this.buttons.remove(lookAndFeel);
            if (item != null) {
                LookAndFeelMenuPiece.this.remove(item);
            }
        }
    }
}

