/*
 * Decompiled with CFR 0.152.
 */
package bibliothek.gui.dock.common.layout;

import bibliothek.gui.dock.common.layout.RequestDimension;
import bibliothek.gui.dock.facile.station.split.DefaultConflictResolver;
import bibliothek.gui.dock.facile.station.split.ResizeElement;
import bibliothek.gui.dock.facile.station.split.ResizeLeaf;
import bibliothek.gui.dock.facile.station.split.ResizeNode;
import bibliothek.gui.dock.facile.station.split.ResizeRequest;

public class FullLockConflictResolver
extends DefaultConflictResolver<RequestDimension> {
    @Override
    public double resolveHorizontal(ResizeNode<RequestDimension> node, ResizeRequest left, double deltaLeft, ResizeRequest right, double deltaRight) {
        if (left.getFractionWidth() == 1 && right.getFractionWidth() == 1) {
            boolean leftLocked = this.checkHorizontalFullLock(node.getLeft());
            boolean rightLocked = this.checkHorizontalFullLock(node.getRight());
            if (!leftLocked && rightLocked) {
                return deltaRight;
            }
            if (leftLocked && !rightLocked) {
                return deltaLeft;
            }
        }
        return super.resolveHorizontal(node, left, deltaLeft, right, deltaRight);
    }

    @Override
    public double resolveVertical(ResizeNode<RequestDimension> node, ResizeRequest top, double deltaTop, ResizeRequest bottom, double deltaBottom) {
        if (top.getFractionWidth() == 1 && bottom.getFractionWidth() == 1) {
            boolean topLocked = this.checkVerticalFullLock(node.getLeft());
            boolean bottomLocked = this.checkVerticalFullLock(node.getRight());
            if (!topLocked && bottomLocked) {
                return deltaBottom;
            }
            if (topLocked && !bottomLocked) {
                return deltaTop;
            }
        }
        return super.resolveVertical(node, top, deltaTop, bottom, deltaBottom);
    }

    protected boolean checkHorizontalFullLock(ResizeElement<RequestDimension> element) {
        ResizeLeaf leaf;
        ResizeRequest request;
        if (element instanceof ResizeNode) {
            ResizeNode node = (ResizeNode)element;
            ResizeRequest leftRequest = node.getLeft().getRequest();
            ResizeRequest rightRequest = node.getRight().getRequest();
            if (leftRequest == null || leftRequest.getFractionWidth() == -1) {
                return false;
            }
            if (rightRequest == null || rightRequest.getFractionWidth() == -1) {
                return false;
            }
            if (!this.checkHorizontalFullLock(node.getLeft())) {
                return false;
            }
            if (!this.checkHorizontalFullLock(node.getRight())) {
                return false;
            }
        } else if (element instanceof ResizeLeaf && ((request = (leaf = (ResizeLeaf)element).getRequest()) == null || request.getFractionWidth() == -1)) {
            return false;
        }
        return true;
    }

    protected boolean checkVerticalFullLock(ResizeElement<RequestDimension> element) {
        ResizeLeaf leaf;
        ResizeRequest request;
        if (element instanceof ResizeNode) {
            ResizeNode node = (ResizeNode)element;
            ResizeRequest leftRequest = node.getLeft().getRequest();
            ResizeRequest rightRequest = node.getRight().getRequest();
            if (leftRequest == null || leftRequest.getFractionHeight() == -1) {
                return false;
            }
            if (rightRequest == null || rightRequest.getFractionHeight() == -1) {
                return false;
            }
            if (!this.checkVerticalFullLock(node.getLeft())) {
                return false;
            }
            if (!this.checkVerticalFullLock(node.getRight())) {
                return false;
            }
        } else if (element instanceof ResizeLeaf && ((request = (leaf = (ResizeLeaf)element).getRequest()) == null || request.getFractionHeight() == -1)) {
            return false;
        }
        return true;
    }
}

