/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.geotiff;

import java.awt.Color;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.IsMissingEvaluator;
import ucar.ma2.MAMath;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.ft2.coverage.CoverageCoordAxis1D;
import ucar.nc2.ft2.coverage.CoverageCoordSys;
import ucar.nc2.ft2.coverage.GeoReferencedArray;
import ucar.nc2.geotiff.FieldType;
import ucar.nc2.geotiff.GeoKey;
import ucar.nc2.geotiff.GeoTiff;
import ucar.nc2.geotiff.IFDEntry;
import ucar.nc2.geotiff.Tag;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.Projection;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.AlbersEqualArea;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.LatLonProjection;
import ucar.unidata.geoloc.projection.Mercator;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;
import ucar.unidata.geoloc.projection.proj4.AlbersEqualAreaEllipse;

public class GeotiffWriter
implements Closeable {
    protected GeoTiff geotiff;
    protected short pageNumber = 1;
    protected int[] colorTable;

    public GeotiffWriter(String fileOut) {
        this.geotiff = new GeoTiff(fileOut);
    }

    @Override
    public void close() throws IOException {
        this.geotiff.close();
    }

    public void writeGrid(GridDataset dataset, GridDatatype grid, Array data, boolean greyScale) throws IOException {
        this.writeGrid(dataset, grid, data, greyScale, greyScale ? DataType.UBYTE : DataType.FLOAT);
    }

    public void writeGrid(GridDataset dataset, GridDatatype grid, Array data, boolean greyScale, DataType dtype) throws IOException, IllegalArgumentException {
        if (greyScale && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When greyScale is true, dtype must be UBYTE");
        }
        if (this.colorTable != null && this.colorTable.length > 0 && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When using the color table, dtype must be UBYTE");
        }
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + grid.getFullName());
        }
        CoordinateAxis1D xaxis = (CoordinateAxis1D)gcs.getXHorizAxis();
        CoordinateAxis1D yaxis = (CoordinateAxis1D)gcs.getYHorizAxis();
        double scaler = xaxis.getUnitsString().equalsIgnoreCase("km") ? 1000.0 : 1.0;
        double xStart = xaxis.getCoordEdge(0) * scaler;
        double yStart = yaxis.getCoordEdge(0) * scaler;
        double xInc = xaxis.getIncrement() * scaler;
        double yInc = Math.abs(yaxis.getIncrement()) * scaler;
        if (yaxis.getCoordValue(0) < yaxis.getCoordValue(1)) {
            data = data.flip(0);
            yStart = yaxis.getCoordEdge((int)yaxis.getSize()) * scaler;
        }
        if (!xaxis.isRegular() || !yaxis.isRegular()) {
            throw new IllegalArgumentException("Must be evenly spaced grid = " + grid.getFullName());
        }
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        this.writeGrid(grid, data, greyScale, xStart, yStart, xInc, yInc, this.pageNumber, dtype);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    void writeGrid(GridDatatype grid, Array data, boolean greyScale, double xStart, double yStart, double xInc, double yInc, int imageNumber) throws IOException {
        this.writeGrid(grid, data, greyScale, xStart, yStart, xInc, yInc, imageNumber, greyScale ? DataType.UBYTE : DataType.FLOAT);
    }

    void writeGrid(GridDatatype grid, Array data, boolean greyScale, double xStart, double yStart, double xInc, double yInc, int imageNumber, DataType dtype) throws IOException, IllegalArgumentException {
        int nextStart;
        if (greyScale && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When greyScale is true, dtype must be UBYTE");
        }
        if (this.colorTable != null && this.colorTable.length > 0 && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When using the color table, dtype must be UBYTE");
        }
        GridCoordSystem gcs = grid.getCoordinateSystem();
        if (!(gcs.isLatLon() || gcs.getProjection() instanceof LambertConformal || gcs.getProjection() instanceof Stereographic || gcs.getProjection() instanceof Mercator || gcs.getProjection() instanceof AlbersEqualAreaEllipse || gcs.getProjection() instanceof AlbersEqualArea)) {
            throw new IllegalArgumentException("Unsupported projection = " + gcs.getProjection().getClass().getName());
        }
        if (dtype == null && (dtype = data.getDataType()) == DataType.DOUBLE) {
            dtype = DataType.FLOAT;
        }
        MAMath.MinMax dataMinMax = grid.getMinMaxSkipMissingData(data);
        if (greyScale) {
            data = this.replaceMissingValuesAndScale((IsMissingEvaluator)grid, data, dataMinMax);
            nextStart = this.writeData(data, DataType.UBYTE);
        } else if (dtype == DataType.FLOAT) {
            data = this.replaceMissingValues((IsMissingEvaluator)grid, data, dataMinMax);
            nextStart = this.writeData(data, dtype);
        } else {
            data = GeotiffWriter.coerceData(data, dtype);
            nextStart = this.writeData(data, dtype);
        }
        int height = data.getShape()[0];
        int width = data.getShape()[1];
        this.writeMetadata(greyScale, xStart, yStart, xInc, yInc, height, width, imageNumber, nextStart, dataMinMax, (Projection)gcs.getProjection(), dtype);
    }

    private void writeMetadata(boolean greyScale, double xStart, double yStart, double xInc, double yInc, int height, int width, int imageNumber, int nextStart, MAMath.MinMax dataMinMax, Projection proj, DataType dtype) throws IOException {
        if (dtype == null) {
            throw new IllegalArgumentException("dtype can't be null in writeMetadata()");
        }
        if (greyScale && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When greyScale is true, dtype must be UBYTE");
        }
        if (this.colorTable != null && this.colorTable.length > 0 && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When using the color table, the dtype must be UBYTE");
        }
        int elemSize = dtype.getSize();
        this.geotiff.addTag(new IFDEntry(Tag.ImageWidth, FieldType.SHORT).setValue(width));
        this.geotiff.addTag(new IFDEntry(Tag.ImageLength, FieldType.SHORT).setValue(height));
        int ff = 2;
        int page = imageNumber - 1;
        this.geotiff.addTag(new IFDEntry(Tag.NewSubfileType, FieldType.SHORT).setValue(ff));
        this.geotiff.addTag(new IFDEntry(Tag.PageNumber, FieldType.SHORT).setValue(page, 2));
        this.geotiff.addTag(new IFDEntry(Tag.RowsPerStrip, FieldType.SHORT).setValue(1));
        int[] soffset = new int[height];
        int[] sbytecount = new int[height];
        soffset[0] = imageNumber == 1 ? 8 : nextStart;
        sbytecount[0] = width * elemSize;
        for (int i = 1; i < height; ++i) {
            soffset[i] = soffset[i - 1] + width * elemSize;
            sbytecount[i] = width * elemSize;
        }
        this.geotiff.addTag(new IFDEntry(Tag.StripByteCounts, FieldType.LONG, width).setValue(sbytecount));
        this.geotiff.addTag(new IFDEntry(Tag.StripOffsets, FieldType.LONG, width).setValue(soffset));
        this.geotiff.addTag(new IFDEntry(Tag.Orientation, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Compression, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.Software, FieldType.ASCII).setValue("nc2geotiff"));
        this.geotiff.addTag(new IFDEntry(Tag.PlanarConfiguration, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.BitsPerSample, FieldType.SHORT).setValue(elemSize * 8));
        this.geotiff.addTag(new IFDEntry(Tag.SamplesPerPixel, FieldType.SHORT).setValue(1));
        this.geotiff.addTag(new IFDEntry(Tag.XResolution, FieldType.RATIONAL).setValue(1, 1));
        this.geotiff.addTag(new IFDEntry(Tag.YResolution, FieldType.RATIONAL).setValue(1, 1));
        this.geotiff.addTag(new IFDEntry(Tag.ResolutionUnit, FieldType.SHORT).setValue(1));
        if (this.colorTable != null && this.colorTable.length > 0) {
            this.geotiff.addTag(new IFDEntry(Tag.PhotometricInterpretation, FieldType.SHORT).setValue(3));
            this.geotiff.addTag(new IFDEntry(Tag.ColorMap, FieldType.SHORT, this.colorTable.length).setValue(this.colorTable));
        } else {
            this.geotiff.addTag(new IFDEntry(Tag.PhotometricInterpretation, FieldType.SHORT).setValue(1));
        }
        if (dtype.isIntegral() && !greyScale) {
            FieldType ftype;
            this.geotiff.addTag(new IFDEntry(Tag.SampleFormat, FieldType.SHORT).setValue(dtype.isUnsigned() ? 1 : 2));
            int min = (int)dataMinMax.min;
            int max = (int)dataMinMax.max;
            DataType sdtype = dtype.withSignedness(DataType.Signedness.SIGNED);
            if (sdtype == DataType.BYTE) {
                ftype = dtype.isUnsigned() ? FieldType.BYTE : FieldType.SBYTE;
            } else if (sdtype == DataType.SHORT) {
                ftype = dtype.isUnsigned() ? FieldType.SHORT : FieldType.SSHORT;
            } else if (sdtype == DataType.INT) {
                ftype = dtype.isUnsigned() ? FieldType.LONG : FieldType.SLONG;
            } else {
                throw new IllegalArgumentException("Unsupported dtype: " + dtype);
            }
            this.geotiff.addTag(new IFDEntry(Tag.SMinSampleValue, ftype).setValue(min));
            this.geotiff.addTag(new IFDEntry(Tag.SMaxSampleValue, ftype).setValue(max));
        } else if (dtype.isFloatingPoint()) {
            this.geotiff.addTag(new IFDEntry(Tag.SampleFormat, FieldType.SHORT).setValue(3));
            float min = (float)dataMinMax.min;
            float max = (float)dataMinMax.max;
            this.geotiff.addTag(new IFDEntry(Tag.SMinSampleValue, FieldType.FLOAT).setValue(min));
            this.geotiff.addTag(new IFDEntry(Tag.SMaxSampleValue, FieldType.FLOAT).setValue(max));
            this.geotiff.addTag(new IFDEntry(Tag.GDALNoData, FieldType.ASCII).setValue(String.valueOf(min - 1.0f)));
        }
        this.geotiff.setTransform(xStart, yStart, xInc, yInc);
        if (proj instanceof LatLonProjection) {
            this.addLatLonTags();
        } else if (proj instanceof LambertConformal) {
            this.addLambertConformalTags((LambertConformal)proj, xStart, yStart);
        } else if (proj instanceof Stereographic) {
            this.addPolarStereographicTags((Stereographic)proj, xStart, yStart);
        } else if (proj instanceof Mercator) {
            this.addMercatorTags((Mercator)proj);
        } else if (proj instanceof TransverseMercator) {
            this.addTransverseMercatorTags((TransverseMercator)proj);
        } else if (proj instanceof AlbersEqualArea) {
            this.addAlbersEqualAreaTags((AlbersEqualArea)proj);
        } else if (proj instanceof AlbersEqualAreaEllipse) {
            this.addAlbersEqualAreaEllipseTags((AlbersEqualAreaEllipse)proj);
        } else {
            throw new IllegalArgumentException("Unsupported projection = " + proj.getClass().getName());
        }
        this.geotiff.writeMetadata(imageNumber);
    }

    public int[] getColorTable() {
        if (this.colorTable == null) {
            return null;
        }
        return (int[])this.colorTable.clone();
    }

    public void setColorTable(Map<Integer, Color> colorMap) {
        this.setColorTable(colorMap, new Color(0, 0, 0));
    }

    public void setColorTable(Map<Integer, Color> colorMap, Color defaultRGB) {
        if (colorMap == null) {
            this.colorTable = null;
            return;
        }
        this.colorTable = new int[768];
        for (int i = 0; i < 256; ++i) {
            this.colorTable[i] = (colorMap.getOrDefault(i, defaultRGB).getRed() + 1) * 256 - 1;
            this.colorTable[256 + i] = (colorMap.getOrDefault(i, defaultRGB).getGreen() + 1) * 256 - 1;
            this.colorTable[512 + i] = (colorMap.getOrDefault(i, defaultRGB).getBlue() + 1) * 256 - 1;
        }
    }

    public static HashMap<Integer, Color> createColorMap(int[] flag_values, String[] flag_colors) throws IllegalArgumentException, NumberFormatException {
        if (flag_values.length != flag_colors.length) {
            throw new IllegalArgumentException("flag_values and flag_colors must be of equal length");
        }
        HashMap<Integer, Color> colorMap = new HashMap<Integer, Color>();
        for (int i = 0; i < flag_values.length; ++i) {
            colorMap.put(flag_values[i], Color.decode(flag_colors[i]));
        }
        return colorMap;
    }

    static ArrayByte coerceByte(Array data, boolean isUnsigned) {
        ArrayByte array = (ArrayByte)Array.factory((DataType)(isUnsigned ? DataType.UBYTE : DataType.BYTE), (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = array.getIndexIterator();
        while (dataIter.hasNext()) {
            resultIter.setByteNext(dataIter.getByteNext());
        }
        return array;
    }

    static ArrayShort coerceShort(Array data, boolean isUnsigned) {
        ArrayShort array = (ArrayShort)Array.factory((DataType)(isUnsigned ? DataType.USHORT : DataType.SHORT), (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = array.getIndexIterator();
        while (dataIter.hasNext()) {
            resultIter.setShortNext(dataIter.getShortNext());
        }
        return array;
    }

    static ArrayInt coerceInt(Array data, boolean isUnsigned) {
        ArrayInt array = (ArrayInt)Array.factory((DataType)(isUnsigned ? DataType.UINT : DataType.INT), (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = array.getIndexIterator();
        while (dataIter.hasNext()) {
            resultIter.setIntNext(dataIter.getIntNext());
        }
        return array;
    }

    static ArrayFloat coerceFloat(Array data) {
        ArrayFloat array = (ArrayFloat)Array.factory((DataType)DataType.FLOAT, (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = array.getIndexIterator();
        while (dataIter.hasNext()) {
            resultIter.setFloatNext(dataIter.getFloatNext());
        }
        return array;
    }

    private ArrayFloat replaceMissingValues(IsMissingEvaluator grid, Array data, MAMath.MinMax dataMinMax) {
        float minValue = (float)(dataMinMax.min - 1.0);
        ArrayFloat floatArray = (ArrayFloat)Array.factory((DataType)DataType.FLOAT, (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator floatIter = floatArray.getIndexIterator();
        while (dataIter.hasNext()) {
            float v = dataIter.getFloatNext();
            if (grid.isMissing((double)v)) {
                v = minValue;
            }
            floatIter.setFloatNext(v);
        }
        return floatArray;
    }

    private ArrayByte replaceMissingValuesAndScale(IsMissingEvaluator grid, Array data, MAMath.MinMax dataMinMax) {
        double scale = 254.0 / (dataMinMax.max - dataMinMax.min);
        ArrayByte byteArray = (ArrayByte)Array.factory((DataType)DataType.BYTE, (int[])data.getShape());
        IndexIterator dataIter = data.getIndexIterator();
        IndexIterator resultIter = byteArray.getIndexIterator();
        while (dataIter.hasNext()) {
            byte bv;
            double v = dataIter.getDoubleNext();
            if (grid.isMissing(v)) {
                bv = 0;
            } else {
                int iv = (int)((v - dataMinMax.min) * scale + 1.0);
                bv = (byte)(iv & 0xFF);
            }
            resultIter.setByteNext(bv);
        }
        return byteArray;
    }

    private void addLatLonTags1() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogGeodeticDatumGeoKey, GeoKey.TagValue.GeogGeodeticDatum6267));
    }

    private void addLatLonTags() {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Geographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogPrimeMeridianGeoKey, GeoKey.TagValue.GeogPrimeMeridian_GREENWICH));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
    }

    private void addPolarStereographicTags(Stereographic proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Stereographic));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, 90.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addLambertConformalTags(LambertConformal proj, double FalseEasting, double FalseNorthing) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Snyder"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_LambertConfConic_2SP));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCenterLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addMercatorTags(Mercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_Mercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getParallel()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addTransverseMercatorTags(TransverseMercator proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Transvers Mercator"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_TransverseMercator));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getTangentLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, proj.getScale()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjScaleAtNatOriginGeoKey, 1.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addAlbersEqualAreaEllipseTags(AlbersEqualAreaEllipse proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogSemiMajorAxisGeoKey, proj.getEarth().getMajor()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogSemiMinorAxisGeoKey, proj.getEarth().getMinor()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Albers Conial Equal Area"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_AlbersEqualAreaEllipse));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void addAlbersEqualAreaTags(AlbersEqualArea proj) {
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTModelTypeGeoKey, GeoKey.TagValue.ModelType_Projected));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GTRasterTypeGeoKey, GeoKey.TagValue.RasterType_Area));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeographicTypeGeoKey, GeoKey.TagValue.GeographicType_WGS_84));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.GeogAngularUnitsGeoKey, GeoKey.TagValue.GeogAngularUnits_DEGREE));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectedCSTypeGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.PCSCitationGeoKey, "Albers Conial Equal Area"));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjectionGeoKey, GeoKey.TagValue.ProjectedCSType_UserDefined));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjLinearUnitsGeoKey, GeoKey.TagValue.ProjLinearUnits_METER));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjCoordTransGeoKey, GeoKey.TagValue.ProjCoordTrans_AlbersConicalEqualArea));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLatGeoKey, proj.getOriginLat()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjNatOriginLongGeoKey, proj.getOriginLon()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel1GeoKey, proj.getParallelOne()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjStdParallel2GeoKey, proj.getParallelTwo()));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseEastingGeoKey, 0.0));
        this.geotiff.addGeoKey(new GeoKey(GeoKey.Tag.ProjFalseNorthingGeoKey, 0.0));
    }

    private void dump(Array data, int col) {
        int[] shape = data.getShape();
        Index ima = data.getIndex();
        for (int j = 0; j < shape[0]; ++j) {
            float dd = data.getFloat(ima.set(j, col));
            System.out.println(j + " value= " + dd);
        }
    }

    private double geoShiftGetXstart(Array lon, double inc) {
        Index ilon = lon.getIndex();
        int[] lonShape = lon.getShape();
        IndexIterator lonIter = lon.getIndexIterator();
        LatLonPoint p0 = LatLonPoint.create((double)0.0, (double)lon.getFloat(ilon.set(0)));
        LatLonPoint pN = LatLonPoint.create((double)0.0, (double)lon.getFloat(ilon.set(lonShape[0] - 1)));
        double xlon = p0.getLongitude();
        while (lonIter.hasNext()) {
            float l = lonIter.getFloatNext();
            LatLonPoint pn = LatLonPoint.create((double)0.0, (double)l);
            if (!(pn.getLongitude() < xlon)) continue;
            xlon = pn.getLongitude();
        }
        if (p0.getLongitude() == pN.getLongitude()) {
            xlon -= inc;
        }
        return xlon;
    }

    public void writeGrid(GeoReferencedArray array, boolean greyScale) throws IOException {
        this.writeGrid(array, greyScale, greyScale ? DataType.UBYTE : DataType.FLOAT);
    }

    public void writeGrid(GeoReferencedArray array, boolean greyScale, DataType dtype) throws IOException, IllegalArgumentException {
        int nextStart;
        if (greyScale && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When greyScale is true, dtype must be UBYTE");
        }
        if (this.colorTable != null && this.colorTable.length > 0 && dtype != DataType.UBYTE) {
            throw new IllegalArgumentException("When using the colorTable, the dtype must be UBYTE");
        }
        CoverageCoordSys gcs = array.getCoordSysForData();
        if (!gcs.isRegularSpatial()) {
            throw new IllegalArgumentException("Must have 1D x and y axes for " + array.getCoverageName());
        }
        ProjectionImpl proj = gcs.getProjection();
        CoverageCoordAxis1D xaxis = (CoverageCoordAxis1D)gcs.getXAxis();
        CoverageCoordAxis1D yaxis = (CoverageCoordAxis1D)gcs.getYAxis();
        double scaler = xaxis.getUnits().equalsIgnoreCase("km") ? 1000.0 : 1.0;
        double xStart = xaxis.getCoordEdge1(0) * scaler;
        double yStart = yaxis.getCoordEdge1(0) * scaler;
        double xInc = xaxis.getResolution() * scaler;
        double yInc = Math.abs(yaxis.getResolution()) * scaler;
        Array data = array.getData().reduce();
        if (yaxis.getCoordMidpoint(0) < yaxis.getCoordMidpoint(1)) {
            data = data.flip(0);
            yStart = yaxis.getCoordEdgeLast() * scaler;
        }
        if (dtype == null && (dtype = data.getDataType()) == DataType.DOUBLE) {
            dtype = DataType.FLOAT;
        }
        if (this.pageNumber > 1) {
            this.geotiff.initTags();
        }
        MAMath.MinMax dataMinMax = MAMath.getMinMaxSkipMissingData((Array)data, (IsMissingEvaluator)array);
        if (greyScale) {
            data = this.replaceMissingValuesAndScale((IsMissingEvaluator)array, data, dataMinMax);
            nextStart = this.writeData(data, DataType.UBYTE);
        } else if (dtype == DataType.FLOAT) {
            data = this.replaceMissingValues((IsMissingEvaluator)array, data, dataMinMax);
            nextStart = this.writeData(data, dtype);
        } else {
            data = GeotiffWriter.coerceData(data, dtype);
            nextStart = this.writeData(data, dtype);
        }
        int height = data.getShape()[0];
        int width = data.getShape()[1];
        this.writeMetadata(greyScale, xStart, yStart, xInc, yInc, height, width, this.pageNumber, nextStart, dataMinMax, (Projection)proj, dtype);
        this.pageNumber = (short)(this.pageNumber + 1);
    }

    static Array coerceData(Array data, DataType dtype) {
        if (dtype == DataType.BYTE || dtype == DataType.UBYTE) {
            data = GeotiffWriter.coerceByte(data, dtype.isUnsigned());
        } else if (dtype == DataType.SHORT || dtype == DataType.USHORT) {
            data = GeotiffWriter.coerceShort(data, dtype.isUnsigned());
        } else if (dtype == DataType.INT || dtype == DataType.UINT) {
            data = GeotiffWriter.coerceInt(data, dtype.isUnsigned());
        } else if (dtype.isFloatingPoint()) {
            data = GeotiffWriter.coerceFloat(data);
        }
        return data;
    }

    private int writeData(Array data, DataType dtype) throws IOException {
        int nextStart = dtype == DataType.BYTE || dtype == DataType.UBYTE ? this.geotiff.writeData((byte[])data.getStorage(), (int)this.pageNumber) : (dtype == DataType.SHORT || dtype == DataType.USHORT ? this.geotiff.writeData((short[])data.getStorage(), (int)this.pageNumber) : (dtype == DataType.INT || dtype == DataType.UINT ? this.geotiff.writeData((int[])data.getStorage(), (int)this.pageNumber) : this.geotiff.writeData((float[])data.getStorage(), (int)this.pageNumber)));
        return nextStart;
    }
}

