/*
 * Decompiled with CFR 0.152.
 */
package org.meteoinfo.map.forms;

import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;
import org.meteoinfo.common.GenericFileFilter;
import org.meteoinfo.common.MIMath;
import org.meteoinfo.common.PointD;
import org.meteoinfo.common.util.GlobalUtil;
import org.meteoinfo.geo.layer.LayerDrawType;
import org.meteoinfo.geo.layer.MapLayer;
import org.meteoinfo.geo.layer.VectorLayer;
import org.meteoinfo.geo.legend.LegendManage;
import org.meteoinfo.geometry.shape.PointShape;
import org.meteoinfo.geometry.shape.Shape;
import org.meteoinfo.geometry.shape.ShapeTypes;
import org.meteoinfo.map.forms.FrmMain;
import org.meteoinfo.ndarray.DataType;
import org.meteoinfo.table.Field;

public class FrmAddXYData
extends JDialog {
    private FrmMain _parent;
    private String separator = null;
    private List<Field> fields = new ArrayList<Field>();
    private JButton jButton_AddData;
    private JButton jButton_Close;
    private JButton jButton_InputFile;
    private JComboBox jComboBox_LatField;
    private JComboBox jComboBox_LonField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel_SelFields;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextField_InputFile;

    public FrmAddXYData(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jPanel_SelFields.setEnabled(false);
        this._parent = (FrmMain)parent;
        this.jComboBox_LonField.removeAllItems();
        this.jComboBox_LatField.removeAllItems();
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jButton_InputFile = new JButton();
        this.jTextField_InputFile = new JTextField();
        this.jPanel_SelFields = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBox_LonField = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jComboBox_LatField = new JComboBox();
        this.jButton_AddData = new JButton();
        this.jButton_Close = new JButton();
        this.setDefaultCloseOperation(2);
        this.jScrollPane1.setBackground(new Color(255, 255, 204));
        this.jScrollPane1.setWheelScrollingEnabled(false);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText("This tool will create a station layer from a ASCII file with comma, simicolon or space separator. The file must contain column titles as the first row.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jButton_InputFile.setText("Input File");
        this.jButton_InputFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddXYData.this.jButton_InputFileActionPerformed(evt);
            }
        });
        this.jPanel_SelFields.setBorder(BorderFactory.createTitledBorder("Select Fields From Input File"));
        this.jLabel1.setText("Lon Field:");
        this.jComboBox_LonField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.jLabel2.setText("Lat Field:");
        this.jComboBox_LatField.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        GroupLayout jPanel_SelFieldsLayout = new GroupLayout(this.jPanel_SelFields);
        this.jPanel_SelFields.setLayout(jPanel_SelFieldsLayout);
        jPanel_SelFieldsLayout.setHorizontalGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_LonField, 0, 248, Short.MAX_VALUE)).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jComboBox_LatField, 0, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanel_SelFieldsLayout.setVerticalGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel_SelFieldsLayout.createSequentialGroup().addContainerGap().addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jComboBox_LonField, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel_SelFieldsLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jComboBox_LatField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jButton_AddData.setText("Add Data");
        this.jButton_AddData.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddXYData.this.jButton_AddDataActionPerformed(evt);
            }
        });
        this.jButton_Close.setText("Close");
        this.jButton_Close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FrmAddXYData.this.jButton_CloseActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel_SelFields, -1, -1, Short.MAX_VALUE).addComponent(this.jScrollPane1).addGroup(layout.createSequentialGroup().addComponent(this.jButton_InputFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextField_InputFile))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButton_AddData).addGap(67, 67, 67).addComponent(this.jButton_Close).addGap(75, 75, 75)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_InputFile).addComponent(this.jTextField_InputFile, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jPanel_SelFields, -2, -1, -2).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton_AddData).addComponent(this.jButton_Close)).addContainerGap(22, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButton_InputFileActionPerformed(ActionEvent evt) {
        String path = System.getProperty("user.dir");
        File pathDir = new File(path);
        JFileChooser aDlg = new JFileChooser();
        aDlg.setAcceptAllFileFilterUsed(false);
        aDlg.setCurrentDirectory(pathDir);
        String[] fileExts = new String[]{"csv", "txt"};
        GenericFileFilter allFileFilter = new GenericFileFilter(fileExts, "Supported Formats");
        aDlg.addChoosableFileFilter((FileFilter)allFileFilter);
        fileExts = new String[]{"csv"};
        GenericFileFilter mapFileFilter = new GenericFileFilter(fileExts, "CSV File (*.csv)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        fileExts = new String[]{"txt"};
        mapFileFilter = new GenericFileFilter(fileExts, "Text File (*.txt)");
        aDlg.addChoosableFileFilter((FileFilter)mapFileFilter);
        aDlg.setFileFilter((FileFilter)allFileFilter);
        if (0 == aDlg.showOpenDialog(this)) {
            File aFile = aDlg.getSelectedFile();
            System.setProperty("user.dir", aFile.getParent());
            this.jTextField_InputFile.setText(aFile.getAbsolutePath());
            try {
                BufferedReader sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
                String title = sr.readLine().trim();
                this.separator = GlobalUtil.getDelimiter((String)title);
                String[] titleArray = GlobalUtil.split((String)title, (String)this.separator);
                if (titleArray.length <= 2) {
                    JOptionPane.showMessageDialog(null, "File Format Error!");
                    sr.close();
                } else {
                    int i;
                    String aLine = sr.readLine().trim();
                    String[] dataArray = GlobalUtil.split((String)aLine, (String)this.separator);
                    if (dataArray.length != titleArray.length) {
                        JOptionPane.showMessageDialog(null, "File Format Error!");
                        sr.close();
                        return;
                    }
                    for (i = 0; i < dataArray.length; ++i) {
                        String fieldName = titleArray[i];
                        DataType dataType = MIMath.isNumeric((String)dataArray[i]) ? DataType.DOUBLE : DataType.STRING;
                        this.fields.add(new Field(fieldName, dataType));
                    }
                    sr.close();
                    this.jPanel_SelFields.setEnabled(true);
                    this.jComboBox_LonField.removeAllItems();
                    this.jComboBox_LatField.removeAllItems();
                    for (i = 0; i < titleArray.length; ++i) {
                        this.jComboBox_LonField.addItem(titleArray[i]);
                        this.jComboBox_LatField.addItem(titleArray[i]);
                    }
                }
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IOException ex) {
                Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void jButton_AddDataActionPerformed(ActionEvent evt) {
        String lonField = this.jComboBox_LonField.getSelectedItem().toString();
        String latField = this.jComboBox_LatField.getSelectedItem().toString();
        if (lonField.isEmpty() || latField.isEmpty()) {
            JOptionPane.showMessageDialog(null, "All fields should be set!");
            return;
        }
        JFileChooser aDlg = new JFileChooser();
        String curDir = System.getProperty("user.dir");
        aDlg.setCurrentDirectory(new File(curDir));
        String[] fileExts = new String[]{"shp"};
        GenericFileFilter pFileFilter = new GenericFileFilter(fileExts, "Shape File (*.shp)");
        aDlg.setFileFilter((FileFilter)pFileFilter);
        aDlg.setAcceptAllFileFilterUsed(false);
        if (0 == aDlg.showSaveDialog(null)) {
            BufferedReader sr = null;
            try {
                File aFile = aDlg.getSelectedFile();
                System.setProperty("user.dir", aFile.getParent());
                String extent = ((GenericFileFilter)aDlg.getFileFilter()).getFileExtent();
                String fileName = aFile.getAbsolutePath();
                if (!fileName.substring(fileName.length() - extent.length()).equals(extent)) {
                    fileName = fileName + "." + extent;
                }
                VectorLayer aLayer = new VectorLayer(ShapeTypes.POINT);
                aLayer.setLayerDrawType(LayerDrawType.MAP);
                aLayer.setLayerName(aFile.getName());
                aLayer.setFileName(fileName);
                aLayer.setLegendScheme(LegendManage.createSingleSymbolLegendScheme((ShapeTypes)ShapeTypes.POINT, (Color)Color.black, (float)5.0f));
                aLayer.setVisible(true);
                for (Field field : this.fields) {
                    aLayer.editAddField(field);
                }
                int lonIdx = this.jComboBox_LonField.getSelectedIndex();
                int latIdx = this.jComboBox_LatField.getSelectedIndex();
                String inFile = this.jTextField_InputFile.getText();
                sr = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(inFile), "UTF-8"));
                sr.readLine();
                String aLine = sr.readLine();
                while (aLine != null) {
                    String[] dataArray = GlobalUtil.split((String)(aLine = aLine.trim()), (String)this.separator);
                    if (dataArray.length < 2) {
                        aLine = sr.readLine();
                        continue;
                    }
                    PointD aPoint = new PointD();
                    double lon = Double.parseDouble(dataArray[lonIdx].trim());
                    double lat = Double.parseDouble(dataArray[latIdx].trim());
                    aPoint.X = lon;
                    aPoint.Y = lat;
                    PointShape aPS = new PointShape();
                    aPS.setPoint(aPoint);
                    int shapeNum = aLayer.getShapeNum();
                    if (aLayer.editInsertShape((Shape)aPS, shapeNum)) {
                        block25: for (int j = 0; j < aLayer.getFieldNumber(); ++j) {
                            Field field = aLayer.getField(j);
                            switch (field.getDataType()) {
                                case DOUBLE: {
                                    aLayer.editCellValue(j, shapeNum, (Object)Double.parseDouble(dataArray[j].trim()));
                                    continue block25;
                                }
                                case STRING: {
                                    aLayer.editCellValue(j, shapeNum, (Object)dataArray[j].trim());
                                }
                            }
                        }
                    }
                    aLine = sr.readLine();
                }
                aLayer.saveFile(fileName);
                this._parent.getMapDocument().getActiveMapFrame().addLayer((MapLayer)aLayer);
            }
            catch (FileNotFoundException ex) {
                Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
            catch (IOException ex) {
                Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
            catch (Exception ex) {
                Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
                ex.printStackTrace();
            }
            finally {
                try {
                    sr.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
                    ex.printStackTrace();
                }
            }
        }
    }

    private void jButton_CloseActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FrmAddXYData.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                FrmAddXYData dialog = new FrmAddXYData((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

